/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.SymbolicPage;
import fitnesse.wiki.WikiPage;
import java.util.List;
import junit.framework.TestCase;
import util.FileUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class SymbolicPageTest
extends TestCase {
    private PageCrawler crawler;
    private WikiPage root;
    private WikiPage pageOne;
    private WikiPage pageTwo;
    private SymbolicPage symPage;
    private String pageOnePath = "PageOne";
    private String pageTwoPath = "PageTwo";
    private String pageOneContent = "page one";
    private String pageTwoContent = "page two";
    private WikiPage externalRoot;

    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.pageOne = this.crawler.addPage(this.root, PathParser.parse((String)this.pageOnePath), this.pageOneContent);
        this.pageTwo = this.crawler.addPage(this.root, PathParser.parse((String)this.pageTwoPath), this.pageTwoContent);
        this.symPage = new SymbolicPage("SymPage", this.pageTwo, this.pageOne);
    }

    public void tearDown() throws Exception {
        FileUtil.deleteFileSystemDirectory((String)"testDir");
    }

    public void testCreation() throws Exception {
        SymbolicPageTest.assertEquals((String)"SymPage", (String)this.symPage.getName());
    }

    public void testLinkage() throws Exception {
        SymbolicPageTest.assertSame((Object)this.pageTwo, (Object)this.symPage.getRealPage());
    }

    public void testInternalData() throws Exception {
        PageData data = this.symPage.getData();
        SymbolicPageTest.assertEquals((String)this.pageTwoContent, (String)data.getContent());
        SymbolicPageTest.assertSame((Object)this.symPage, (Object)data.getWikiPage());
    }

    public void testCommitInternal() throws Exception {
        this.commitNewContent((WikiPage)this.symPage);
        PageData data = this.pageTwo.getData();
        SymbolicPageTest.assertEquals((String)"new content", (String)data.getContent());
        data = this.symPage.getData();
        SymbolicPageTest.assertEquals((String)"new content", (String)data.getContent());
    }

    public void testGetChild() throws Exception {
        WikiPage childPage = this.crawler.addPage(this.pageTwo, PathParser.parse((String)"ChildPage"), "child page");
        WikiPage page = this.symPage.getChildPage("ChildPage");
        SymbolicPageTest.assertNotNull((Object)page);
        SymbolicPageTest.assertEquals(SymbolicPage.class, page.getClass());
        SymbolicPage symChild = (SymbolicPage)page;
        SymbolicPageTest.assertSame((Object)childPage, (Object)symChild.getRealPage());
    }

    public void testGetChildren() throws Exception {
        this.crawler.addPage(this.pageTwo, PathParser.parse((String)"ChildOne"), "child one");
        this.crawler.addPage(this.pageTwo, PathParser.parse((String)"ChildTwo"), "child two");
        List children = this.symPage.getChildren();
        SymbolicPageTest.assertEquals((int)2, (int)children.size());
        SymbolicPageTest.assertEquals(SymbolicPage.class, children.get(0).getClass());
        SymbolicPageTest.assertEquals(SymbolicPage.class, children.get(1).getClass());
    }

    public void testCyclicSymbolicLinks() throws Exception {
        PageData data = this.pageOne.getData();
        data.getProperties().set("SymbolicLinks").set("SymOne", this.pageTwoPath);
        this.pageOne.commit(data);
        data = this.pageTwo.getData();
        data.getProperties().set("SymbolicLinks").set("SymTwo", this.pageOnePath);
        this.pageTwo.commit(data);
        WikiPage deepPage = this.crawler.getPage(this.root, PathParser.parse((String)(this.pageOnePath + ".SymOne.SymTwo.SymOne.SymTwo.SymOne")));
        List children = deepPage.getChildren();
        SymbolicPageTest.assertEquals((int)1, (int)children.size());
        deepPage = this.crawler.getPage(this.root, PathParser.parse((String)(this.pageTwoPath + ".SymTwo.SymOne.SymTwo.SymOne.SymTwo")));
        children = deepPage.getChildren();
        SymbolicPageTest.assertEquals((int)1, (int)children.size());
    }

    public void testSymbolicPageUsingExternalDirectory() throws Exception {
        this.CreateExternalRoot();
        SymbolicPageTest.assertEquals((int)2, (int)this.symPage.getChildren().size());
        WikiPage symPageOne = this.symPage.getChildPage("ExternalPageOne");
        SymbolicPageTest.assertNotNull((Object)symPageOne);
        SymbolicPageTest.assertEquals((String)"external page one", (String)symPageOne.getData().getContent());
        WikiPage symPageTwo = this.symPage.getChildPage("ExternalPageTwo");
        SymbolicPageTest.assertNotNull((Object)symPageTwo);
        SymbolicPageTest.assertEquals((String)"external page two", (String)symPageTwo.getData().getContent());
        WikiPage symChild = symPageOne.getChildPage("ExternalChild");
        SymbolicPageTest.assertNotNull((Object)symChild);
        SymbolicPageTest.assertEquals((String)"external child", (String)symChild.getData().getContent());
    }

    private void CreateExternalRoot() throws Exception {
        FileUtil.createDir((String)"testDir");
        FileUtil.createDir((String)"testDir/ExternalRoot");
        this.externalRoot = new FileSystemPage("testDir/ExternalRoot", "ExternalRoot");
        PageCrawler externalCrawler = this.externalRoot.getPageCrawler();
        WikiPage externalPageOne = externalCrawler.addPage(this.externalRoot, PathParser.parse((String)"ExternalPageOne"), "external page one");
        externalCrawler.addPage(externalPageOne, PathParser.parse((String)"ExternalChild"), "external child");
        externalCrawler.addPage(this.externalRoot, PathParser.parse((String)"ExternalPageTwo"), "external page two");
        this.symPage = new SymbolicPage("SymPage", this.externalRoot, this.pageOne);
    }

    public void testCommittingToExternalRoot() throws Exception {
        this.CreateExternalRoot();
        this.commitNewContent((WikiPage)this.symPage);
        SymbolicPageTest.assertEquals((String)"new content", (String)this.externalRoot.getData().getContent());
        this.commitNewContent(this.symPage.getChildPage("ExternalPageOne"));
        SymbolicPageTest.assertEquals((String)"new content", (String)this.externalRoot.getChildPage("ExternalPageOne").getData().getContent());
    }

    private void commitNewContent(WikiPage wikiPage) throws Exception {
        PageData data = wikiPage.getData();
        data.setContent("new content");
        wikiPage.commit(data);
    }
}

