/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.WikiPageProperty;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import util.Clock;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class WikiPagePropertiesTest
extends RegexTestCase {
    private WikiPageProperties properties;
    static final String endl = System.getProperty("line.separator");
    static final String tab = "\t";
    static final String sampleXml = "<?xml version=\"1.0\"?>" + endl + "<properties>" + endl + "\t" + "<Edit/>" + endl + "\t" + "<ParentOne>" + endl + "\t" + "\t" + "<ChildOne>child one value</ChildOne>" + endl + "\t" + "</ParentOne>" + endl + "\t" + "<ParentTwo value=\"parent 2 value\">" + endl + "\t" + "\t" + "<ChildTwo>child two value</ChildTwo>" + endl + "\t" + "</ParentTwo>" + endl + "\t" + "<SymbolicLinks>" + endl + "\t" + "\t" + "<BackLink>&lt;BackWard.SymLink</BackLink>" + endl + "\t" + "\t" + "<RelLink>RelaTive.SymLink</RelLink>" + endl + "\t" + "\t" + "<AbsLink>.AbsoLute.SymLink</AbsLink>" + endl + "\t" + "\t" + "<SubLink>&gt;SubChild.SymLink</SubLink>" + endl + "\t" + "</SymbolicLinks>" + endl + "\t" + "<Test/>" + endl + "\t" + "<VirtualWiki>http://someurl</VirtualWiki>" + endl + "</properties>" + endl;
    static final String[] sampleXmlFragments = sampleXml.split("\t*" + endl);

    public void setUp() throws Exception {
        this.installPropertiesFrom(sampleXml);
    }

    private void installPropertiesFrom(String xmlSample) throws Exception {
        ByteArrayInputStream sampleInputStream = new ByteArrayInputStream(sampleXml.getBytes());
        this.properties = new WikiPageProperties((InputStream)sampleInputStream);
    }

    public void tearDown() throws Exception {
    }

    public void testLoadingOfXmlWithoutAddedSpaces() throws Exception {
        this.validateLoading();
    }

    private void validateLoading() throws Exception {
        WikiPagePropertiesTest.assertTrue((boolean)this.properties.has("Edit"));
        WikiPagePropertiesTest.assertTrue((boolean)this.properties.has("Test"));
        WikiPagePropertiesTest.assertFalse((boolean)this.properties.has("Suite"));
        WikiPagePropertiesTest.assertEquals((String)"http://someurl", (String)this.properties.get("VirtualWiki"));
        WikiPageProperty parentOne = this.properties.getProperty("ParentOne");
        WikiPagePropertiesTest.assertEquals(null, (String)parentOne.getValue());
        WikiPagePropertiesTest.assertEquals((String)"child one value", (String)parentOne.get("ChildOne"));
        WikiPageProperty parentTwo = this.properties.getProperty("ParentTwo");
        WikiPagePropertiesTest.assertEquals((String)"parent 2 value", (String)parentTwo.getValue());
        WikiPagePropertiesTest.assertEquals((String)"child two value", (String)parentTwo.get("ChildTwo"));
        WikiPageProperty symbolics = this.properties.getProperty("SymbolicLinks");
        WikiPagePropertiesTest.assertEquals((String)"<BackWard.SymLink", (String)symbolics.get("BackLink"));
        WikiPagePropertiesTest.assertEquals((String)"RelaTive.SymLink", (String)symbolics.get("RelLink"));
        WikiPagePropertiesTest.assertEquals((String)".AbsoLute.SymLink", (String)symbolics.get("AbsLink"));
        WikiPagePropertiesTest.assertEquals((String)">SubChild.SymLink", (String)symbolics.get("SubLink"));
    }

    public void testSave() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(1000);
        this.properties.save((OutputStream)os);
        String xml = os.toString();
        for (String fragment : sampleXmlFragments) {
            WikiPagePropertiesTest.assertTrue((String)fragment, (boolean)xml.contains(fragment));
        }
    }

    public void testKeySet() throws Exception {
        this.properties = new WikiPageProperties();
        this.properties.set("one");
        this.properties.set("two");
        this.properties.set("three");
        Set keys = this.properties.keySet();
        WikiPagePropertiesTest.assertTrue((boolean)keys.contains("one"));
        WikiPagePropertiesTest.assertTrue((boolean)keys.contains("two"));
        WikiPagePropertiesTest.assertTrue((boolean)keys.contains("three"));
        WikiPagePropertiesTest.assertFalse((boolean)keys.contains("four"));
    }

    public void testIsSerializable() throws Exception {
        try {
            new ObjectOutputStream(new ByteArrayOutputStream()).writeObject(this.properties);
        }
        catch (NotSerializableException e) {
            WikiPagePropertiesTest.fail((String)("its not serializable: " + e));
        }
    }

    public void testLastModificationTime() throws Exception {
        SimpleDateFormat format = WikiPageProperty.getTimeFormat();
        WikiPageProperties props = new WikiPageProperties();
        WikiPagePropertiesTest.assertEquals((String)format.format(Clock.currentDate()), (String)format.format(props.getLastModificationTime()));
        Date date = format.parse("20040101000001");
        props.setLastModificationTime(date);
        WikiPagePropertiesTest.assertEquals((String)"20040101000001", (String)props.get("LastModified"));
        WikiPagePropertiesTest.assertEquals((Object)date, (Object)props.getLastModificationTime());
    }

    public void testShouldRemoveSpacesFromPropertyValues() throws Exception {
        String sampleXmlWithSpaces = sampleXml.replaceAll("</", " </");
        this.installPropertiesFrom(sampleXmlWithSpaces);
        this.validateLoading();
    }
}

