/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.html.HtmlTag;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.ScanString;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import util.Maybe;

public class Define
extends SymbolType
implements Rule,
Translation {
    public Define() {
        super("Define");
        this.wikiMatcher(new Matcher().startLineOrCell().string("!define"));
        this.wikiRule((Rule)this);
        this.htmlTranslation((Translation)this);
    }

    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        Maybe valueString;
        if (!parser.isMoveNext(SymbolType.Whitespace)) {
            return Symbol.nothing;
        }
        Maybe name = parser.parseToAsString(SymbolType.Whitespace);
        if (name.isNothing()) {
            return Symbol.nothing;
        }
        String variableName = (String)name.getValue();
        if (!ScanString.isVariableName((String)variableName)) {
            return Symbol.nothing;
        }
        Symbol next = parser.moveNext(1);
        Maybe maybe = valueString = next.isType(SymbolType.Text) ? this.copyVariableValue(parser, next) : this.parseVariableValue(parser, next);
        if (valueString.isNothing()) {
            return Symbol.nothing;
        }
        String variableValue = (String)valueString.getValue();
        parser.getPage().putVariable(variableName, variableValue);
        return new Maybe((Object)current.add(variableName).add(variableValue));
    }

    private Maybe<String> copyVariableValue(Parser parser, Symbol next) {
        String fromVariableName = next.getContent();
        if (!ScanString.isVariableName((String)fromVariableName)) {
            return Maybe.noString;
        }
        return parser.getVariableSource().findVariable(fromVariableName);
    }

    private Maybe<String> parseVariableValue(Parser parser, Symbol next) {
        SymbolType close = next.closeType();
        if (close == SymbolType.Empty) {
            return Maybe.noString;
        }
        return parser.parseToAsString(close);
    }

    public String toTarget(Translator translator, Symbol symbol) {
        HtmlTag result = new HtmlTag("span", "variable defined: " + translator.translate(symbol.childAt(0)) + "=" + translator.translate(symbol.childAt(1)));
        result.addAttribute("class", "meta");
        return result.html();
    }
}

