/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.html.HtmlElement;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wikitext.parser.Contents;
import fitnesse.wikitext.parser.ContentsItemBuilder;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.VariableSource;
import fitnesse.wikitext.parser.WikiSourcePage;
import fitnesse.wikitext.test.TestRoot;
import fitnesse.wikitext.test.TestVariableSource;
import org.junit.Assert;
import org.junit.Test;

public class ContentsItemTest {
    @Test
    public void buildsPlain() throws Exception {
        this.assertBuilds("PlainItem", new String[0], "", "", "<a href=\"PlainItem\">PlainItem</a>");
    }

    @Test
    public void buildsWithHelp() throws Exception {
        this.assertBuilds("PlainItem", new String[]{"Help=help"}, "", "", "<a href=\"PlainItem\" title=\"help\">PlainItem</a>");
    }

    @Test
    public void buildsFilter() throws Exception {
        this.assertBuildsOption("PlainItem", new String[]{"Suites=F1"}, "-f", "FILTER_TOC", "<a href=\"PlainItem\">PlainItem (F1)</a>");
    }

    @Test
    public void buildsHelp() throws Exception {
        this.assertBuildsOption("PlainItem", new String[]{"Help=help"}, "-h", "HELP_TOC", "<a href=\"PlainItem\">PlainItem</a><span class=\"pageHelp\">: help</span>");
    }

    @Test
    public void buildsProperties() throws Exception {
        this.assertBuildsOption("PlainItem", new String[]{"Suite=true", "Test=true", "WikiImport=true", "Prune=true"}, "-p", "PROPERTY_TOC", "<a href=\"PlainItem\">PlainItem *+@-</a>");
    }

    @Test
    public void buildsRegraced() throws Exception {
        this.assertBuildsOption("PlainItem", new String[0], "-g", "REGRACE_TOC", "<a href=\"PlainItem\">Plain Item</a>");
    }

    private void assertBuildsOption(String page, String[] properties, String option, String variable, String result) throws Exception {
        this.assertBuilds(page, properties, option, "", result);
        this.assertBuilds(page, properties, "", variable, result);
    }

    private void assertBuilds(String page, String[] properties, String option, String variable, String result) throws Exception {
        Symbol contents = new Symbol((SymbolType)new Contents());
        contents.add(new Symbol(SymbolType.Text, option));
        contents.evaluateVariables(new String[]{variable}, (VariableSource)new TestVariableSource(variable, "true"));
        ContentsItemBuilder builder = new ContentsItemBuilder(contents, 1);
        Assert.assertEquals((Object)(result + HtmlElement.endl), (Object)builder.buildItem((SourcePage)new WikiSourcePage(this.withProperties(new TestRoot().makePage(page), properties))).html());
    }

    private WikiPage withProperties(WikiPage page, String[] propList) throws Exception {
        PageData data = page.getData();
        WikiPageProperties props = data.getProperties();
        for (String aPropList : propList) {
            String[] parts = aPropList.split("=");
            if (parts.length == 1) {
                props.set(parts[0]);
                continue;
            }
            props.set(parts[0], parts[1]);
        }
        page.commit(data);
        return page;
    }
}

