/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.html.HtmlElement;
import fitnesse.wikitext.test.ParserTestHelper;
import org.junit.Test;

public class HashTableTest {
    @Test
    public void scansHashTables() {
        ParserTestHelper.assertScansTokenType((String)"!{a:b,c:d}", (String)"HashTable", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!{a:b,c:d}", (String)"Colon", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!{a:b,c:d}", (String)"Comma", (boolean)true);
    }

    @Test
    public void translatesHashTables() {
        ParserTestHelper.assertTranslatesTo((String)"!{a:b,c:d}", (String)this.hashTable());
        ParserTestHelper.assertTranslatesTo((String)"!{a:b, c:d}", (String)this.hashTable());
    }

    @Test
    public void invalidHashInTableIsIgnored() {
        ParserTestHelper.assertTranslatesTo((String)"|!{a:}|\n", (String)ParserTestHelper.tableWithCell((String)"!{a:}"));
    }

    private String hashTable() {
        return "<table class=\"hash_table\">" + HtmlElement.endl + "\t<tr class=\"hash_row\">" + HtmlElement.endl + "\t\t<td class=\"hash_key\">a</td>" + HtmlElement.endl + "\t\t<td class=\"hash_value\">b</td>" + HtmlElement.endl + "\t</tr>" + HtmlElement.endl + "\t<tr class=\"hash_row\">" + HtmlElement.endl + "\t\t<td class=\"hash_key\">c</td>" + HtmlElement.endl + "\t\t<td class=\"hash_value\">d</td>" + HtmlElement.endl + "\t</tr>" + HtmlElement.endl + "</table>" + HtmlElement.endl;
    }
}

