/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.html.HtmlElement;
import fitnesse.wikitext.parser.HtmlWriter;
import org.junit.Assert;
import org.junit.Test;

public class HtmlWriterTest {
    @Test
    public void writesSimpleTag() {
        HtmlWriter writer = new HtmlWriter();
        writer.putTag("simple");
        Assert.assertEquals((Object)("<simple />" + HtmlElement.endl), (Object)writer.toHtml());
    }

    @Test
    public void startsAndEndsSimpleTag() {
        HtmlWriter writer = new HtmlWriter();
        writer.startTag("simple");
        writer.endTag();
        Assert.assertEquals((Object)("<simple />" + HtmlElement.endl), (Object)writer.toHtml());
    }

    @Test
    public void writesSimpleTagWithAttribute() {
        HtmlWriter writer = new HtmlWriter();
        writer.startTag("simple");
        writer.putAttribute("name", "value");
        writer.endTag();
        Assert.assertEquals((Object)("<simple name=\"value\" />" + HtmlElement.endl), (Object)writer.toHtml());
    }

    @Test
    public void writesSimpleTagWithText() {
        HtmlWriter writer = new HtmlWriter();
        writer.startTag("simple");
        writer.putText("stuff");
        writer.endTag();
        Assert.assertEquals((Object)("<simple>stuff</simple>" + HtmlElement.endl), (Object)writer.toHtml());
    }

    @Test
    public void writesNestedTag() {
        HtmlWriter writer = new HtmlWriter();
        writer.startTag("parent");
        writer.putTag("child");
        writer.endTag();
        Assert.assertEquals((Object)("<parent>" + HtmlElement.endl + "\t<child />" + HtmlElement.endl + "</parent>" + HtmlElement.endl), (Object)writer.toHtml());
    }

    @Test
    public void writesMultipleNestedTags() {
        HtmlWriter writer = new HtmlWriter();
        writer.startTag("parent");
        writer.putTag("child");
        writer.putTag("child");
        writer.endTag();
        Assert.assertEquals((Object)("<parent>" + HtmlElement.endl + "\t<child />" + HtmlElement.endl + "\t<child />" + HtmlElement.endl + "</parent>" + HtmlElement.endl), (Object)writer.toHtml());
    }

    @Test
    public void writesNestedTagInline() {
        HtmlWriter writer = new HtmlWriter();
        writer.startTag("parent");
        writer.putTagInline("child");
        writer.endTag();
        Assert.assertEquals((Object)("<parent><child /></parent>" + HtmlElement.endl), (Object)writer.toHtml());
    }

    @Test
    public void writesNestedTagWithAttribute() {
        HtmlWriter writer = new HtmlWriter();
        writer.startTag("parent");
        writer.putAttribute("name", "value");
        writer.putTag("child");
        writer.endTag();
        Assert.assertEquals((Object)("<parent name=\"value\">" + HtmlElement.endl + "\t<child />" + HtmlElement.endl + "</parent>" + HtmlElement.endl), (Object)writer.toHtml());
    }
}

