/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.wikitext.parser.VariableSource;
import fitnesse.wikitext.test.ParserTestHelper;
import fitnesse.wikitext.test.TestVariableSource;
import org.junit.Test;

public class LinkTest {
    @Test
    public void scansLinks() {
        ParserTestHelper.assertScansTokenType((String)"http://mysite.org", (String)"Link", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"https://mysite.org", (String)"Link", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"http:/mysite.org", (String)"Link", (boolean)false);
        ParserTestHelper.assertScansTokenType((String)"httpx://mysite.org", (String)"Link", (boolean)false);
    }

    @Test
    public void parsesLinks() throws Exception {
        ParserTestHelper.assertParses((String)"http://mysite.org", (String)"SymbolList[Link[SymbolList[Text]]]");
    }

    @Test
    public void translatesLinks() {
        ParserTestHelper.assertTranslatesTo((String)"http://mysite.org", (String)"<a href=\"http://mysite.org\">http://mysite.org</a>");
        ParserTestHelper.assertTranslatesTo((String)"http://files/myfile", (String)"<a href=\"/files/myfile\">http://files/myfile</a>");
        ParserTestHelper.assertTranslatesTo((String)"''http://files/myfile''", (String)"<i><a href=\"/files/myfile\">http://files/myfile</a></i>");
    }

    @Test
    public void translatesLinkWithVariable() {
        ParserTestHelper.assertTranslatesTo((String)"http://${site}", (VariableSource)new TestVariableSource("site", "mysite.org"), (String)"<a href=\"http://mysite.org\">http://mysite.org</a>");
    }

    @Test
    public void translatesImageLinks() {
        ParserTestHelper.assertTranslatesTo((String)"http://some.jpg", (String)"<img src=\"http://some.jpg\"/>");
    }
}

