/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner.notification;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runner.notification.SynchronizedRunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunNotifier {
    private final List<RunListener> fListeners = new CopyOnWriteArrayList();
    private volatile boolean fPleaseStop = false;

    public void addListener(RunListener listener) {
        if (listener == null) {
            throw new NullPointerException("Cannot add a null listener");
        }
        this.fListeners.add(this.wrapIfNotThreadSafe(listener));
    }

    public void removeListener(RunListener listener) {
        if (listener == null) {
            throw new NullPointerException("Cannot remove a null listener");
        }
        this.fListeners.remove(this.wrapIfNotThreadSafe(listener));
    }

    RunListener wrapIfNotThreadSafe(RunListener listener) {
        return listener.getClass().isAnnotationPresent(RunListener.ThreadSafe.class) ? listener : new SynchronizedRunListener(listener, (Object)this);
    }

    public void fireTestRunStarted(Description description) {
        new /* Unavailable Anonymous Inner Class!! */.run();
    }

    public void fireTestRunFinished(Result result) {
        new /* Unavailable Anonymous Inner Class!! */.run();
    }

    public void fireTestStarted(Description description) throws StoppedByUserException {
        if (this.fPleaseStop) {
            throw new StoppedByUserException();
        }
        new /* Unavailable Anonymous Inner Class!! */.run();
    }

    public void fireTestFailure(Failure failure) {
        this.fireTestFailures(this.fListeners, Arrays.asList(failure));
    }

    private void fireTestFailures(List<RunListener> listeners, List<Failure> failures) {
        if (!failures.isEmpty()) {
            new /* Unavailable Anonymous Inner Class!! */.run();
        }
    }

    public void fireTestAssumptionFailed(Failure failure) {
        new /* Unavailable Anonymous Inner Class!! */.run();
    }

    public void fireTestIgnored(Description description) {
        new /* Unavailable Anonymous Inner Class!! */.run();
    }

    public void fireTestFinished(Description description) {
        new /* Unavailable Anonymous Inner Class!! */.run();
    }

    public void pleaseStop() {
        this.fPleaseStop = true;
    }

    public void addFirstListener(RunListener listener) {
        if (listener == null) {
            throw new NullPointerException("Cannot add a null listener");
        }
        this.fListeners.add(0, this.wrapIfNotThreadSafe(listener));
    }

    static /* synthetic */ List access$000(RunNotifier x0) {
        return x0.fListeners;
    }

    static /* synthetic */ void access$100(RunNotifier x0, List x1, List x2) {
        x0.fireTestFailures(x1, x2);
    }
}

