/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner.notification;

import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

@RunListener.ThreadSafe
final class SynchronizedRunListener
extends RunListener {
    private final RunListener fListener;
    private final Object fMonitor;

    SynchronizedRunListener(RunListener listener, Object monitor) {
        this.fListener = listener;
        this.fMonitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRunStarted(Description description) throws Exception {
        Object object = this.fMonitor;
        synchronized (object) {
            this.fListener.testRunStarted(description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRunFinished(Result result) throws Exception {
        Object object = this.fMonitor;
        synchronized (object) {
            this.fListener.testRunFinished(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted(Description description) throws Exception {
        Object object = this.fMonitor;
        synchronized (object) {
            this.fListener.testStarted(description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFinished(Description description) throws Exception {
        Object object = this.fMonitor;
        synchronized (object) {
            this.fListener.testFinished(description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailure(Failure failure) throws Exception {
        Object object = this.fMonitor;
        synchronized (object) {
            this.fListener.testFailure(failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAssumptionFailure(Failure failure) {
        Object object = this.fMonitor;
        synchronized (object) {
            this.fListener.testAssumptionFailure(failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIgnored(Description description) throws Exception {
        Object object = this.fMonitor;
        synchronized (object) {
            this.fListener.testIgnored(description);
        }
    }

    public int hashCode() {
        return this.fListener.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SynchronizedRunListener)) {
            return false;
        }
        SynchronizedRunListener that = (SynchronizedRunListener)other;
        return this.fListener.equals(that.fListener);
    }

    public String toString() {
        return this.fListener.toString() + " (with synchronization wrapper)";
    }
}

