/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.junit.Assert;
import org.junit.Test;
import util.FileUtil;
import util.RegexTestCase;

public class FileUtilTest {
    @Test
    public void testCreateDir() throws Exception {
        File dir = FileUtil.createDir((String)"temp1");
        Assert.assertTrue((boolean)dir.exists());
        Assert.assertTrue((boolean)dir.isDirectory());
        FileUtil.deleteFileSystemDirectory((File)dir);
    }

    @Test
    public void createFileWithComplexPath() throws Exception {
        File file = FileUtil.createFile((String)"temp/sub1/sub2/sub3/file", (String)"");
        Assert.assertTrue((boolean)file.exists());
        FileUtil.deleteFileSystemDirectory((String)"temp");
    }

    @Test
    public void testGetDirectoryListingEmpty() throws Exception {
        File dir = FileUtil.createDir((String)"temp2");
        Assert.assertEquals((long)0L, (long)FileUtil.getDirectoryListing((File)dir).length);
        FileUtil.deleteFileSystemDirectory((File)dir);
    }

    @Test
    public void testOrganizeFilesOneFile() throws Exception {
        File dir = FileUtil.createDir((String)"temp3");
        File file = this.createFileInDir(dir, "file.txt");
        Assert.assertEquals((long)1L, (long)FileUtil.getDirectoryListing((File)dir).length);
        Assert.assertEquals((Object)file, (Object)FileUtil.getDirectoryListing((File)dir)[0]);
        FileUtil.deleteFileSystemDirectory((File)dir);
    }

    @Test
    public void testOrganizeFilesFiveFiles() throws Exception {
        File dir = FileUtil.createDir((String)"temp4");
        File file3 = this.createFileInDir(dir, "dFile.txt");
        File file1 = this.createFileInDir(dir, "bFile.txt");
        File file4 = this.createFileInDir(dir, "eFile.txt");
        File file0 = this.createFileInDir(dir, "aFile.txt");
        File file2 = this.createFileInDir(dir, "cFile.txt");
        Assert.assertEquals((long)5L, (long)FileUtil.getDirectoryListing((File)dir).length);
        Assert.assertEquals((Object)file0, (Object)FileUtil.getDirectoryListing((File)dir)[0]);
        Assert.assertEquals((Object)file1, (Object)FileUtil.getDirectoryListing((File)dir)[1]);
        Assert.assertEquals((Object)file2, (Object)FileUtil.getDirectoryListing((File)dir)[2]);
        Assert.assertEquals((Object)file3, (Object)FileUtil.getDirectoryListing((File)dir)[3]);
        Assert.assertEquals((Object)file4, (Object)FileUtil.getDirectoryListing((File)dir)[4]);
        FileUtil.deleteFileSystemDirectory((File)dir);
    }

    @Test
    public void testOrganizeFilesOneSubDir() throws Exception {
        File dir = FileUtil.createDir((String)"temp5");
        File subDir = this.createSubDir(dir, "subDir");
        Assert.assertEquals((long)1L, (long)FileUtil.getDirectoryListing((File)dir).length);
        Assert.assertEquals((Object)subDir, (Object)FileUtil.getDirectoryListing((File)dir)[0]);
        FileUtil.deleteFileSystemDirectory((File)dir);
    }

    @Test
    public void testOrganizeFilesFiveSubDirs() throws Exception {
        File dir = FileUtil.createDir((String)"temp6");
        File dir3 = this.createSubDir(dir, "dDir");
        File dir1 = this.createSubDir(dir, "bDir");
        File dir4 = this.createSubDir(dir, "eDir");
        File dir0 = this.createSubDir(dir, "aDir");
        File dir2 = this.createSubDir(dir, "cDir");
        Assert.assertEquals((long)5L, (long)FileUtil.getDirectoryListing((File)dir).length);
        Assert.assertEquals((Object)dir0, (Object)FileUtil.getDirectoryListing((File)dir)[0]);
        Assert.assertEquals((Object)dir1, (Object)FileUtil.getDirectoryListing((File)dir)[1]);
        Assert.assertEquals((Object)dir2, (Object)FileUtil.getDirectoryListing((File)dir)[2]);
        Assert.assertEquals((Object)dir3, (Object)FileUtil.getDirectoryListing((File)dir)[3]);
        Assert.assertEquals((Object)dir4, (Object)FileUtil.getDirectoryListing((File)dir)[4]);
        FileUtil.deleteFileSystemDirectory((File)dir);
    }

    @Test
    public void testOrganizeFilesMixOfFilesAndDirs() {
        File dir = FileUtil.createDir((String)"temp7");
        File dir3 = this.createSubDir(dir, "dDir");
        File file3 = this.createFileInDir(dir, "dFile.txt");
        File file0 = this.createFileInDir(dir, "aFile.txt");
        File dir1 = this.createSubDir(dir, "bDir");
        File file4 = this.createFileInDir(dir, "eFile.txt");
        File dir4 = this.createSubDir(dir, "eDir");
        File dir0 = this.createSubDir(dir, "aDir");
        File file1 = this.createFileInDir(dir, "bFile.txt");
        File dir2 = this.createSubDir(dir, "cDir");
        File file2 = this.createFileInDir(dir, "cFile.txt");
        Assert.assertEquals((long)10L, (long)FileUtil.getDirectoryListing((File)dir).length);
        Assert.assertEquals((Object)dir0, (Object)FileUtil.getDirectoryListing((File)dir)[0]);
        Assert.assertEquals((Object)dir1, (Object)FileUtil.getDirectoryListing((File)dir)[1]);
        Assert.assertEquals((Object)dir2, (Object)FileUtil.getDirectoryListing((File)dir)[2]);
        Assert.assertEquals((Object)dir3, (Object)FileUtil.getDirectoryListing((File)dir)[3]);
        Assert.assertEquals((Object)dir4, (Object)FileUtil.getDirectoryListing((File)dir)[4]);
        Assert.assertEquals((Object)file0, (Object)FileUtil.getDirectoryListing((File)dir)[5]);
        Assert.assertEquals((Object)file1, (Object)FileUtil.getDirectoryListing((File)dir)[6]);
        Assert.assertEquals((Object)file2, (Object)FileUtil.getDirectoryListing((File)dir)[7]);
        Assert.assertEquals((Object)file3, (Object)FileUtil.getDirectoryListing((File)dir)[8]);
        Assert.assertEquals((Object)file4, (Object)FileUtil.getDirectoryListing((File)dir)[9]);
        FileUtil.deleteFileSystemDirectory((File)dir);
    }

    private File createFileInDir(File dir, String fileName) {
        return FileUtil.createFile((String)FileUtil.buildPath((String[])new String[]{dir.getPath(), fileName}), (String)"");
    }

    private File createSubDir(File dir, String subDirName) {
        return FileUtil.createDir((String)FileUtil.buildPath((String[])new String[]{dir.getPath(), subDirName}));
    }

    @Test
    public void testBuildPathEmpty() throws Exception {
        Assert.assertEquals((Object)"", (Object)FileUtil.buildPath((String[])new String[0]));
    }

    @Test
    public void testBuildPathOneElement() throws Exception {
        Assert.assertEquals((Object)"a", (Object)FileUtil.buildPath((String[])new String[]{"a"}));
    }

    @Test
    public void testBuildPathThreeElements() throws Exception {
        String separator = System.getProperty("file.separator");
        Assert.assertEquals((Object)("a" + separator + "b" + separator + "c"), (Object)FileUtil.buildPath((String[])new String[]{"a", "b", "c"}));
    }

    @Test
    public void testAddUrlToClasspath() throws Exception {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        Assert.assertTrue((boolean)(systemClassLoader instanceof URLClassLoader));
        URLClassLoader classLoader = (URLClassLoader)systemClassLoader;
        URL sampleUrl = new File("src").toURI().toURL();
        String classpath = this.classpathAsString(classLoader);
        RegexTestCase.assertNotSubString((String)sampleUrl.toString(), (String)classpath);
        FileUtil.addUrlToClasspath((URL)sampleUrl);
        classpath = this.classpathAsString(classLoader);
        RegexTestCase.assertSubString((String)sampleUrl.toString(), (String)classpath);
    }

    @Test
    public void testAddMultipleUrlsToClasspath() throws Exception {
        String separator = System.getProperty("path.separator");
        String paths = "/blah/blah" + separator + "C" + this.otherSeperator(separator) + "\\foo\\bar";
        FileUtil.addItemsToClasspath((String)paths);
        URLClassLoader classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        String classpath = this.classpathAsString(classLoader);
        RegexTestCase.assertSubString((String)"/blah/blah", (String)classpath);
        RegexTestCase.assertMatches((String)("[C" + this.otherSeperator(separator) + "?foo?bar]"), (String)classpath);
    }

    private String otherSeperator(String separator) {
        return separator.equals(";") ? ":" : ";";
    }

    private String classpathAsString(URLClassLoader classLoader) {
        URL[] urls = classLoader.getURLs();
        StringBuffer urlString = new StringBuffer();
        for (int i = 0; i < urls.length; ++i) {
            urlString.append(urls[i].toString()).append(":");
        }
        return urlString.toString();
    }
}

