/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;

public class StandardOutAndErrorRecorder {
    private PrintStream originalErrStream;
    private PrintStream originalOutStream;
    private ByteArrayOutputStream recordedErrStream;
    private ByteArrayOutputStream recordedOutStream;

    public StandardOutAndErrorRecorder() {
        this.beginRecording();
    }

    private void beginRecording() {
        this.recordOriginalStreams();
        this.redirectStreams();
    }

    private void redirectStreams() {
        this.recordedErrStream = new ByteArrayOutputStream();
        System.setErr(new PrintStream(this.recordedErrStream));
        this.recordedOutStream = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.recordedOutStream));
    }

    private void recordOriginalStreams() {
        this.originalErrStream = System.err;
        this.originalOutStream = System.out;
    }

    public void stopRecording(boolean report) {
        this.closeAllStreams();
        this.replaceOriginalStreams();
        this.reportStreams(report);
        this.nullAllStreams();
    }

    private void reportStreams(boolean report) {
        if (report) {
            System.out.print(this.recordedOutStream.toString());
            System.err.print(this.recordedErrStream.toString());
        }
    }

    private void replaceOriginalStreams() {
        System.setErr(this.originalErrStream);
        System.setOut(this.originalOutStream);
    }

    private void closeAllStreams() {
        this.closeStream((Closeable)this.recordedOutStream);
        this.closeStream((Closeable)this.recordedErrStream);
        this.closeStream((Closeable)System.err);
        this.closeStream((Closeable)System.out);
    }

    private void nullAllStreams() {
        this.originalErrStream = null;
        this.originalOutStream = null;
        this.recordedErrStream = null;
        this.recordedOutStream = null;
    }

    private void closeStream(Closeable stream) {
        try {
            this.recordedOutStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

