/*
 * Decompiled with CFR 0.152.
 */
package util;

import fitnesse.http.MockRequest;
import fitnesse.responders.editing.EditResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.TemplateUtil;

public class TemplateUtilTest {
    private static final String REGULAR_PARENT_PATH = ".LibraryParent.TemplateLibrary.TemplateOne";
    private static final String ROOT_PARENT_PATH = ".TemplateLibrary.TemplateFromRoot";
    private WikiPage root;
    private MockRequest request;
    private EditResponder responder;
    private PageCrawler crawler;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"root");
        FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.crawler = this.root.getPageCrawler();
        this.request = new MockRequest();
        this.responder = new EditResponder();
    }

    @Test
    public void testGetTemplatesFromUncles() {
        this.crawler.addPage(this.root, PathParser.parse((String)".TemplateLibrary"), "template library");
        this.crawler.addPage(this.root, PathParser.parse((String)ROOT_PARENT_PATH), "template from root");
        this.crawler.addPage(this.root, PathParser.parse((String)".LibraryParent"), "library parent");
        this.crawler.addPage(this.root, PathParser.parse((String)".LibraryParent.TemplateLibrary"), "template library 2");
        this.crawler.addPage(this.root, PathParser.parse((String)REGULAR_PARENT_PATH), "template 1");
        WikiPage childPage = this.crawler.addPage(this.root, PathParser.parse((String)".LibraryParent.ChildPage"), "library parent");
        List pathList = TemplateUtil.getTemplatesFromUncles((WikiPage)childPage);
        Assert.assertTrue((boolean)pathList.contains(REGULAR_PARENT_PATH));
        Assert.assertTrue((boolean)pathList.contains(ROOT_PARENT_PATH));
    }

    @Test
    public void testGetTemplatesFromUnclesDoesntTakeTemplatesChildren() {
        this.crawler.addPage(this.root, PathParser.parse((String)".TemplateLibrary"), "template library");
        this.crawler.addPage(this.root, PathParser.parse((String)ROOT_PARENT_PATH), "template from root");
        this.crawler.addPage(this.root, PathParser.parse((String)".TemplateLibrary.TemplateFromRoot.TemplateFromRootChild"), "template from root child");
        this.crawler.addPage(this.root, PathParser.parse((String)".LibraryParent"), "library parent");
        WikiPage childPage = this.crawler.addPage(this.root, PathParser.parse((String)".LibraryParent.ChildPage"), "library parent");
        List pathList = TemplateUtil.getTemplatesFromUncles((WikiPage)childPage);
        Assert.assertTrue((boolean)pathList.contains(ROOT_PARENT_PATH));
        Assert.assertFalse((boolean)pathList.contains(".TemplateLibrary.TemplateFromRoot.TemplateFromRootChild"));
    }

    @Test
    public void testGetShortTemplateName() {
        String parsed = TemplateUtil.getShortTemplateName((String)REGULAR_PARENT_PATH);
        Assert.assertEquals((Object)"LibraryParent._.TemplateOne", (Object)parsed);
        String parsed2 = TemplateUtil.getShortTemplateName((String)ROOT_PARENT_PATH);
        Assert.assertEquals((Object)"._.TemplateFromRoot", (Object)parsed2);
    }

    @Test
    public void testGetShortTemplateNames() {
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(REGULAR_PARENT_PATH);
        pathList.add(ROOT_PARENT_PATH);
        Map pathMap = TemplateUtil.getShortTemplateNames(pathList);
        Assert.assertEquals((Object)"LibraryParent._.TemplateOne", pathMap.get(REGULAR_PARENT_PATH));
        Assert.assertEquals((Object)"._.TemplateFromRoot", pathMap.get(ROOT_PARENT_PATH));
    }
}

