/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.enforcer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jdepend.framework.JDepend;
import jdepend.framework.PackageFilter;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.scijava.maven.plugin.enforcer.DirectoriesWithClasses;

public abstract class AbstractPackageEnforcementRule
implements EnforcerRule {
    private List<String> excludedPackages = new ArrayList<String>();
    private List<String> includedPackages = new ArrayList<String>();
    private boolean includeTests = true;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            this.executePackageCycleCheckIfNecessary(helper);
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new EnforcerRuleException("Unable to access target directory " + e.getLocalizedMessage(), (Exception)e);
        }
    }

    public String getCacheId() {
        return "";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule arg0) {
        return false;
    }

    public void setExcludedPackages(List<String> excludedPackages) {
        this.excludedPackages = excludedPackages;
    }

    public void setIncludedPackages(List<String> includedPackages) {
        this.includedPackages = includedPackages;
    }

    public void setIncludeTests(boolean includeTests) {
        this.includeTests = includeTests;
    }

    private void executePackageCheck(EnforcerRuleHelper helper, Iterable<File> directories) throws IOException, EnforcerRuleException {
        JDepend jdepend = this.createJDepend(helper);
        for (File directory : directories) {
            jdepend.addDirectory(directory.getAbsolutePath());
        }
        jdepend.analyze();
        this.enforceRule(jdepend);
    }

    private void executePackageCycleCheckIfNecessary(EnforcerRuleHelper helper) throws ExpressionEvaluationException, IOException, EnforcerRuleException {
        DirectoriesWithClasses directories = new DirectoriesWithClasses(helper, "package cycles", this.includeTests);
        if (directories.directoriesWithClassesFound()) {
            this.executePackageCheck(helper, directories);
        } else {
            helper.getLog().info((CharSequence)"No directories with classes to check for cycles found.");
        }
    }

    protected JDepend createJDepend(EnforcerRuleHelper helper) {
        if (!this.includedPackages.isEmpty()) {
            helper.getLog().warn((CharSequence)("Package cycles rule check is restricted to check only these packages: " + this.includedPackages));
        }
        if (!this.excludedPackages.isEmpty()) {
            helper.getLog().warn((CharSequence)("These packages were excluded from package cycle rule check: " + this.excludedPackages));
        }
        return new JDepend(PackageFilter.all().including(this.includedPackages).excluding(this.excludedPackages));
    }

    abstract void enforceRule(JDepend var1) throws EnforcerRuleException;
}

