/*-
 * #%L
 * The public API of SciJava Ops.
 * %%
 * Copyright (C) 2021 - 2024 SciJava developers.
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */
/*
 * This is autogenerated source code -- DO NOT EDIT. Instead, edit the
 * corresponding template in templates/ and rerun bin/generate.groovy.
 */

package org.scijava.ops.api;

import java.lang.reflect.Type;
import java.util.function.BiFunction;
import java.util.function.Function;

import org.scijava.function.Computers;
import org.scijava.function.Functions;
import org.scijava.function.Inplaces;
import org.scijava.function.Producer;
import org.scijava.common3.Any;
import org.scijava.types.Nil;
import org.scijava.common3.Types;

/**
 * Convenience class for looking up and/or executing ops using a builder
 * pattern. Typical entry point is through {@link OpEnvironment#op(String)},
 * which contains full usage information.
 * <p>
 * Note that the intermediate builder steps use the following acronyms:
 * </p>
 * <ul>
 *   <li><b>IV/OV:</b> Input/Output Value. Indicates instances will be used for matching; ideal if you want to directly run the matched Op, e.g. via <code>apply</code>, <code>compute</code>, <code>mutate</code> or <code>create</code> methods.</li>
 *   <li><b>IT/OT:</b> Input/Output Types. Indicates {@code Classes} will be used for matching; matching will produce an Op instance that can then be (re)used. There are two "Type" options: raw types or {@code Nil}s. If you are matching using a parameterized type use the {@code Nil} option to preserve the type parameter.</li>
 *   <li><b>OU:</b> Output Unknown. Indicates an output type/value has not been specified to the builder yet. The output, if any, will simply be an {@code Object}</li>
 * </ul>
 *
 * @author Curtis Rueden
 * @author Gabriel Selzer
 * @author Mark Hiner
 */
public class OpBuilder {

	private final OpEnvironment env;
	private final String opName;
	private Hints hints;

	public OpBuilder(final OpEnvironment env, final String opName) {
		this(env, opName, env.getDefaultHints());
	}

	public OpBuilder(final OpEnvironment env, final String opName, final Hints hints) {
		this.env = env;
		this.opName = opName;
		this.hints = hints;
	}

	/**
	 * Matches with this builder will use the given pre-allocated output instance.
	 *
	 * @see #create() To match then immediately run a Producer Op without specifying its type, creating an Object.
	 * @see #outType(Class) To specify the output type without providing a concrete instance.
	 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
	 * @see #producer() For a reusable Op to create naively-typed Objects without re-matching.
	 */
	public <O> Arity0_OV<O> output(final O out) {
		return new Arity0_OV<>(out);
	}

	/**
	 * Matches with this builder will use the indicated output class.
	 *
	 * @see #create() To match then immediately run a Producer Op without specifying its type, creating an Object.
	 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
	 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
	 * @see #producer() For a reusable Op to create naively-typed Objects without re-matching.
	 */
	public <O> Arity0_OT<O> outType(final Class<O> outType) {
		return outType(Nil.of(outType));
	}

	/**
	 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
	 *
	 * @see #create() To match then immediately run a Producer Op without specifying its type, creating an Object.
	 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
	 * @see #outType(Class) To specify the output type without providing a concrete instance.
	 * @see #producer() For a reusable Op to create naively-typed Objects without re-matching.
	 */
	public <O> Arity0_OT<O> outType(final Nil<O> outType) {
		return new Arity0_OT<>(outType);
	}

	/**
	 * Match a {@link Producer} op, based on the choices made with this builder, for creating {@code Object} instances.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #create() To match then immediately run a Producer Op without specifying its type, creating an Object.
	 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
	 * @see #outType(Class) To specify the output type without providing a concrete instance.
	 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
	 */
	public Producer<?> producer() {
		final Nil<Producer<Object>> specialType = new Nil<>() {

			@Override
			public Type type() {
				return Types.parameterize(Producer.class, new Type[] {
					Object.class });
			}
		};
		return env.op(opName, specialType, new Nil<?>[0], Nil.of(
			Object.class), OpBuilder.this.hints);
	}

	/**
	 * Match then immediately run a type-unsafe {@link Producer} op and get its output.
	 *
	 * @return The {@code Object} created by this op
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
	 * @see #outType(Class) To specify the output type without providing a concrete instance.
	 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
	 * @see #producer() For a reusable Op to create naively-typed Objects without re-matching.
	 */
	public Object create() {
		return producer().create();
	}

	/**
	 * Finds all Ops matching the current partial OpBuilder request
	 * @return a {@link String} with a simple entry for each Op satisfying the partial request
	 */
	public String help() {
		return env.help(new PartialOpRequest(opName, null));
	}

	/**
	 * Finds all Ops matching the current partial OpBuilder request
	 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
	 */
	public String helpVerbose() {
		return env.helpVerbose(new PartialOpRequest(opName, null));
	}

	/** Set the Hints instance for this builder */
	public void setHints(Hints hints) { this.hints = hints; }

	/** Get the Hints instance for this builder */
	public Hints hints() { return hints; }

	/** Specifies 1 input by value. */
	public <I1> Arity1_IV_OU<I1> input(final I1 in1)
	{
		return new Arity1_IV_OU<>(in1);
	}

	/** Specifies 1 input by raw type. */
	public <I1> Arity1_IT_OU<I1> inType(final Class<I1> in1Class)
	{
		return inType(Nil.of(in1Class));
	}

	/** Specifies 1 input by generic type. */
	public <I1> Arity1_IT_OU<I1> inType(final Nil<I1> in1Type)
	{
		return new Arity1_IT_OU<>(in1Type);
	}
	/** Specifies 2 input by value. */
	public <I1, I2> Arity2_IV_OU<I1, I2> input(final I1 in1, final I2 in2)
	{
		return new Arity2_IV_OU<>(in1, in2);
	}

	/** Specifies 2 input by raw type. */
	public <I1, I2> Arity2_IT_OU<I1, I2> inType(final Class<I1> in1Class, final Class<I2> in2Class)
	{
		return inType(Nil.of(in1Class), Nil.of(in2Class));
	}

	/** Specifies 2 input by generic type. */
	public <I1, I2> Arity2_IT_OU<I1, I2> inType(final Nil<I1> in1Type, final Nil<I2> in2Type)
	{
		return new Arity2_IT_OU<>(in1Type, in2Type);
	}
	/** Specifies 3 input by value. */
	public <I1, I2, I3> Arity3_IV_OU<I1, I2, I3> input(final I1 in1, final I2 in2, final I3 in3)
	{
		return new Arity3_IV_OU<>(in1, in2, in3);
	}

	/** Specifies 3 input by raw type. */
	public <I1, I2, I3> Arity3_IT_OU<I1, I2, I3> inType(final Class<I1> in1Class, final Class<I2> in2Class, final Class<I3> in3Class)
	{
		return inType(Nil.of(in1Class), Nil.of(in2Class), Nil.of(in3Class));
	}

	/** Specifies 3 input by generic type. */
	public <I1, I2, I3> Arity3_IT_OU<I1, I2, I3> inType(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type)
	{
		return new Arity3_IT_OU<>(in1Type, in2Type, in3Type);
	}
	/** Specifies 4 input by value. */
	public <I1, I2, I3, I4> Arity4_IV_OU<I1, I2, I3, I4> input(final I1 in1, final I2 in2, final I3 in3, final I4 in4)
	{
		return new Arity4_IV_OU<>(in1, in2, in3, in4);
	}

	/** Specifies 4 input by raw type. */
	public <I1, I2, I3, I4> Arity4_IT_OU<I1, I2, I3, I4> inType(final Class<I1> in1Class, final Class<I2> in2Class, final Class<I3> in3Class, final Class<I4> in4Class)
	{
		return inType(Nil.of(in1Class), Nil.of(in2Class), Nil.of(in3Class), Nil.of(in4Class));
	}

	/** Specifies 4 input by generic type. */
	public <I1, I2, I3, I4> Arity4_IT_OU<I1, I2, I3, I4> inType(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type)
	{
		return new Arity4_IT_OU<>(in1Type, in2Type, in3Type, in4Type);
	}
	/** Specifies 5 input by value. */
	public <I1, I2, I3, I4, I5> Arity5_IV_OU<I1, I2, I3, I4, I5> input(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5)
	{
		return new Arity5_IV_OU<>(in1, in2, in3, in4, in5);
	}

	/** Specifies 5 input by raw type. */
	public <I1, I2, I3, I4, I5> Arity5_IT_OU<I1, I2, I3, I4, I5> inType(final Class<I1> in1Class, final Class<I2> in2Class, final Class<I3> in3Class, final Class<I4> in4Class, final Class<I5> in5Class)
	{
		return inType(Nil.of(in1Class), Nil.of(in2Class), Nil.of(in3Class), Nil.of(in4Class), Nil.of(in5Class));
	}

	/** Specifies 5 input by generic type. */
	public <I1, I2, I3, I4, I5> Arity5_IT_OU<I1, I2, I3, I4, I5> inType(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type)
	{
		return new Arity5_IT_OU<>(in1Type, in2Type, in3Type, in4Type, in5Type);
	}
	/** Specifies 6 input by value. */
	public <I1, I2, I3, I4, I5, I6> Arity6_IV_OU<I1, I2, I3, I4, I5, I6> input(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6)
	{
		return new Arity6_IV_OU<>(in1, in2, in3, in4, in5, in6);
	}

	/** Specifies 6 input by raw type. */
	public <I1, I2, I3, I4, I5, I6> Arity6_IT_OU<I1, I2, I3, I4, I5, I6> inType(final Class<I1> in1Class, final Class<I2> in2Class, final Class<I3> in3Class, final Class<I4> in4Class, final Class<I5> in5Class, final Class<I6> in6Class)
	{
		return inType(Nil.of(in1Class), Nil.of(in2Class), Nil.of(in3Class), Nil.of(in4Class), Nil.of(in5Class), Nil.of(in6Class));
	}

	/** Specifies 6 input by generic type. */
	public <I1, I2, I3, I4, I5, I6> Arity6_IT_OU<I1, I2, I3, I4, I5, I6> inType(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type)
	{
		return new Arity6_IT_OU<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type);
	}
	/** Specifies 7 input by value. */
	public <I1, I2, I3, I4, I5, I6, I7> Arity7_IV_OU<I1, I2, I3, I4, I5, I6, I7> input(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7)
	{
		return new Arity7_IV_OU<>(in1, in2, in3, in4, in5, in6, in7);
	}

	/** Specifies 7 input by raw type. */
	public <I1, I2, I3, I4, I5, I6, I7> Arity7_IT_OU<I1, I2, I3, I4, I5, I6, I7> inType(final Class<I1> in1Class, final Class<I2> in2Class, final Class<I3> in3Class, final Class<I4> in4Class, final Class<I5> in5Class, final Class<I6> in6Class, final Class<I7> in7Class)
	{
		return inType(Nil.of(in1Class), Nil.of(in2Class), Nil.of(in3Class), Nil.of(in4Class), Nil.of(in5Class), Nil.of(in6Class), Nil.of(in7Class));
	}

	/** Specifies 7 input by generic type. */
	public <I1, I2, I3, I4, I5, I6, I7> Arity7_IT_OU<I1, I2, I3, I4, I5, I6, I7> inType(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type)
	{
		return new Arity7_IT_OU<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type);
	}
	/** Specifies 8 input by value. */
	public <I1, I2, I3, I4, I5, I6, I7, I8> Arity8_IV_OU<I1, I2, I3, I4, I5, I6, I7, I8> input(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8)
	{
		return new Arity8_IV_OU<>(in1, in2, in3, in4, in5, in6, in7, in8);
	}

	/** Specifies 8 input by raw type. */
	public <I1, I2, I3, I4, I5, I6, I7, I8> Arity8_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8> inType(final Class<I1> in1Class, final Class<I2> in2Class, final Class<I3> in3Class, final Class<I4> in4Class, final Class<I5> in5Class, final Class<I6> in6Class, final Class<I7> in7Class, final Class<I8> in8Class)
	{
		return inType(Nil.of(in1Class), Nil.of(in2Class), Nil.of(in3Class), Nil.of(in4Class), Nil.of(in5Class), Nil.of(in6Class), Nil.of(in7Class), Nil.of(in8Class));
	}

	/** Specifies 8 input by generic type. */
	public <I1, I2, I3, I4, I5, I6, I7, I8> Arity8_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8> inType(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type)
	{
		return new Arity8_IT_OU<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type);
	}
	/** Specifies 9 input by value. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9> Arity9_IV_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9> input(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9)
	{
		return new Arity9_IV_OU<>(in1, in2, in3, in4, in5, in6, in7, in8, in9);
	}

	/** Specifies 9 input by raw type. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9> Arity9_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9> inType(final Class<I1> in1Class, final Class<I2> in2Class, final Class<I3> in3Class, final Class<I4> in4Class, final Class<I5> in5Class, final Class<I6> in6Class, final Class<I7> in7Class, final Class<I8> in8Class, final Class<I9> in9Class)
	{
		return inType(Nil.of(in1Class), Nil.of(in2Class), Nil.of(in3Class), Nil.of(in4Class), Nil.of(in5Class), Nil.of(in6Class), Nil.of(in7Class), Nil.of(in8Class), Nil.of(in9Class));
	}

	/** Specifies 9 input by generic type. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9> Arity9_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9> inType(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type)
	{
		return new Arity9_IT_OU<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type);
	}
	/** Specifies 10 input by value. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> Arity10_IV_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> input(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10)
	{
		return new Arity10_IV_OU<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
	}

	/** Specifies 10 input by raw type. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> Arity10_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inType(final Class<I1> in1Class, final Class<I2> in2Class, final Class<I3> in3Class, final Class<I4> in4Class, final Class<I5> in5Class, final Class<I6> in6Class, final Class<I7> in7Class, final Class<I8> in8Class, final Class<I9> in9Class, final Class<I10> in10Class)
	{
		return inType(Nil.of(in1Class), Nil.of(in2Class), Nil.of(in3Class), Nil.of(in4Class), Nil.of(in5Class), Nil.of(in6Class), Nil.of(in7Class), Nil.of(in8Class), Nil.of(in9Class), Nil.of(in10Class));
	}

	/** Specifies 10 input by generic type. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> Arity10_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inType(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type)
	{
		return new Arity10_IT_OU<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type);
	}
	/** Specifies 11 input by value. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> Arity11_IV_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> input(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11)
	{
		return new Arity11_IV_OU<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
	}

	/** Specifies 11 input by raw type. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> Arity11_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inType(final Class<I1> in1Class, final Class<I2> in2Class, final Class<I3> in3Class, final Class<I4> in4Class, final Class<I5> in5Class, final Class<I6> in6Class, final Class<I7> in7Class, final Class<I8> in8Class, final Class<I9> in9Class, final Class<I10> in10Class, final Class<I11> in11Class)
	{
		return inType(Nil.of(in1Class), Nil.of(in2Class), Nil.of(in3Class), Nil.of(in4Class), Nil.of(in5Class), Nil.of(in6Class), Nil.of(in7Class), Nil.of(in8Class), Nil.of(in9Class), Nil.of(in10Class), Nil.of(in11Class));
	}

	/** Specifies 11 input by generic type. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> Arity11_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inType(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type)
	{
		return new Arity11_IT_OU<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type);
	}
	/** Specifies 12 input by value. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> Arity12_IV_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> input(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12)
	{
		return new Arity12_IV_OU<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
	}

	/** Specifies 12 input by raw type. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> Arity12_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inType(final Class<I1> in1Class, final Class<I2> in2Class, final Class<I3> in3Class, final Class<I4> in4Class, final Class<I5> in5Class, final Class<I6> in6Class, final Class<I7> in7Class, final Class<I8> in8Class, final Class<I9> in9Class, final Class<I10> in10Class, final Class<I11> in11Class, final Class<I12> in12Class)
	{
		return inType(Nil.of(in1Class), Nil.of(in2Class), Nil.of(in3Class), Nil.of(in4Class), Nil.of(in5Class), Nil.of(in6Class), Nil.of(in7Class), Nil.of(in8Class), Nil.of(in9Class), Nil.of(in10Class), Nil.of(in11Class), Nil.of(in12Class));
	}

	/** Specifies 12 input by generic type. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> Arity12_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inType(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type)
	{
		return new Arity12_IT_OU<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type);
	}
	/** Specifies 13 input by value. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> Arity13_IV_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> input(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13)
	{
		return new Arity13_IV_OU<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
	}

	/** Specifies 13 input by raw type. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> Arity13_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inType(final Class<I1> in1Class, final Class<I2> in2Class, final Class<I3> in3Class, final Class<I4> in4Class, final Class<I5> in5Class, final Class<I6> in6Class, final Class<I7> in7Class, final Class<I8> in8Class, final Class<I9> in9Class, final Class<I10> in10Class, final Class<I11> in11Class, final Class<I12> in12Class, final Class<I13> in13Class)
	{
		return inType(Nil.of(in1Class), Nil.of(in2Class), Nil.of(in3Class), Nil.of(in4Class), Nil.of(in5Class), Nil.of(in6Class), Nil.of(in7Class), Nil.of(in8Class), Nil.of(in9Class), Nil.of(in10Class), Nil.of(in11Class), Nil.of(in12Class), Nil.of(in13Class));
	}

	/** Specifies 13 input by generic type. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> Arity13_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inType(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type)
	{
		return new Arity13_IT_OU<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type);
	}
	/** Specifies 14 input by value. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> Arity14_IV_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> input(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13, final I14 in14)
	{
		return new Arity14_IV_OU<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
	}

	/** Specifies 14 input by raw type. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> Arity14_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inType(final Class<I1> in1Class, final Class<I2> in2Class, final Class<I3> in3Class, final Class<I4> in4Class, final Class<I5> in5Class, final Class<I6> in6Class, final Class<I7> in7Class, final Class<I8> in8Class, final Class<I9> in9Class, final Class<I10> in10Class, final Class<I11> in11Class, final Class<I12> in12Class, final Class<I13> in13Class, final Class<I14> in14Class)
	{
		return inType(Nil.of(in1Class), Nil.of(in2Class), Nil.of(in3Class), Nil.of(in4Class), Nil.of(in5Class), Nil.of(in6Class), Nil.of(in7Class), Nil.of(in8Class), Nil.of(in9Class), Nil.of(in10Class), Nil.of(in11Class), Nil.of(in12Class), Nil.of(in13Class), Nil.of(in14Class));
	}

	/** Specifies 14 input by generic type. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> Arity14_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inType(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type)
	{
		return new Arity14_IT_OU<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type);
	}
	/** Specifies 15 input by value. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> Arity15_IV_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> input(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13, final I14 in14, final I15 in15)
	{
		return new Arity15_IV_OU<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
	}

	/** Specifies 15 input by raw type. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> Arity15_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inType(final Class<I1> in1Class, final Class<I2> in2Class, final Class<I3> in3Class, final Class<I4> in4Class, final Class<I5> in5Class, final Class<I6> in6Class, final Class<I7> in7Class, final Class<I8> in8Class, final Class<I9> in9Class, final Class<I10> in10Class, final Class<I11> in11Class, final Class<I12> in12Class, final Class<I13> in13Class, final Class<I14> in14Class, final Class<I15> in15Class)
	{
		return inType(Nil.of(in1Class), Nil.of(in2Class), Nil.of(in3Class), Nil.of(in4Class), Nil.of(in5Class), Nil.of(in6Class), Nil.of(in7Class), Nil.of(in8Class), Nil.of(in9Class), Nil.of(in10Class), Nil.of(in11Class), Nil.of(in12Class), Nil.of(in13Class), Nil.of(in14Class), Nil.of(in15Class));
	}

	/** Specifies 15 input by generic type. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> Arity15_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inType(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type)
	{
		return new Arity15_IT_OU<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type);
	}
	/** Specifies 16 input by value. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> Arity16_IV_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> input(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13, final I14 in14, final I15 in15, final I16 in16)
	{
		return new Arity16_IV_OU<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
	}

	/** Specifies 16 input by raw type. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> Arity16_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inType(final Class<I1> in1Class, final Class<I2> in2Class, final Class<I3> in3Class, final Class<I4> in4Class, final Class<I5> in5Class, final Class<I6> in6Class, final Class<I7> in7Class, final Class<I8> in8Class, final Class<I9> in9Class, final Class<I10> in10Class, final Class<I11> in11Class, final Class<I12> in12Class, final Class<I13> in13Class, final Class<I14> in14Class, final Class<I15> in15Class, final Class<I16> in16Class)
	{
		return inType(Nil.of(in1Class), Nil.of(in2Class), Nil.of(in3Class), Nil.of(in4Class), Nil.of(in5Class), Nil.of(in6Class), Nil.of(in7Class), Nil.of(in8Class), Nil.of(in9Class), Nil.of(in10Class), Nil.of(in11Class), Nil.of(in12Class), Nil.of(in13Class), Nil.of(in14Class), Nil.of(in15Class), Nil.of(in16Class));
	}

	/** Specifies 16 input by generic type. */
	public <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> Arity16_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inType(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type)
	{
		return new Arity16_IT_OU<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type);
	}

	// -- Helper methods --

	@SuppressWarnings({ "unchecked" })
	private <T> Nil<T> type(Object obj) {
		// FIXME: This vacuous T and unsafe cast is wrong.
		return (Nil<T>) Nil.of(env.genericType(obj));
	}

	private void checkComputerRefs(Object... objects) {
		checkRefs(objects.length - 1, "Output", objects);
	}

	private void checkInplaceRefs(int inplaceNo, Object... objects) {
		checkRefs(inplaceNo - 1, "Mutable input " + inplaceNo, objects);
	}

	private void checkRefs(int mutableIndex, String label, Object... objects) {
		for (int i = 0; i < objects.length; i++) {
			if (i == mutableIndex) continue;
			if (objects[mutableIndex] == objects[i]) {
				throw new IllegalArgumentException(label +
					" cannot be same reference as input #" + (i + 1));
			}
		}
	}

	// @formatter:off
	/*
	 * -- HELPER CLASSES --
	 * 
	 * For each arity, there are multiple conditions:
	 * * Input TYPES are given (IT) 
	 * 	1) The output is unspecified (OU): 
	 * 		a) matchable: Function, Inplace
	 * 		b) runnable: none
	 * 	2) The output type is given (OT): 
	 * 		a) matchable: Function, Computer
	 * 		b) runnable: none
	 *  
	 * * Input VALUES are given (IV) (N.B. this case applies for Arity0):
	 * 	1) The output is unspecified (OU): 
	 * 		a) matchable: Function, Inplace
	 * 		b) runnable: apply, mutate
	 * 	2) The output type is given (OT): 
	 * 		a) matchable: Function, Computer
	 * 		b) runnable: apply
	 * 	3) The output value is given (OV): 
	 * 		a) matchable: Computer
	 *  	b) runnable: compute
	 */
	// @formatter:on


	/**
	 * Abstract superclasses for all Arities.
	 */
	private abstract class Arity {
		/** Get the Hints instance for this builder */
		public void setHints(Hints hints) { OpBuilder.this.setHints(hints); }

		/** Get the Hints instance for this builder */
		public Hints hints() { return OpBuilder.this.hints(); }
	}

	/**
	 * Builder with arity 0, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <O> The type of the output.
	 */
	public final class Arity0_OT<O> extends Arity {

		private final Nil<O> outType;

		public Arity0_OT(final Nil<O> outType) {
			this.outType = outType;
		}

		/**
		 * Match a {@link Producer} op, based on the choices made with this builder, for creating {@code O}-typed instances.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 * @see #create() To match then immediately run a Producer Op, creating an instance of this builder's output type.
		 */
		public Producer<O> producer() {
			final Nil<Producer<O>> specialType = new Nil<>() {

				@Override
				public Type type() {
					return Types.parameterize(Producer.class, new Type[] { outType.type() });
				}
			};
			return env.op(opName, specialType, new Nil<?>[0], outType, OpBuilder.this.hints);
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #create() To match then immediately run a Producer Op, creating an instance of this builder's output type.
		 * @see #producer() For a reusable Op to create objects of this builder's output type without re-matching.
		 */
		public Computers.Arity0<O> computer() {
			return matchComputer(env, opName, outType, OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Producer} op and get its output.
		 *
		 * @return The {@code O} created by this op
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 * @see #producer() For a reusable Op to create objects of this builder's output type without re-matching.
		 */
		public O create() {
			return producer().create();
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {}, outType));
		}
	}

	/**
	 * Builder with arity 0, output value given.
	 *
	 * @author Curtis Rueden
	 * @param <O> The type of the output.
	 */
	public final class Arity0_OV<O> extends Arity {

		private final O out;

		public Arity0_OV(final O out) {
			this.out = out;
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #compute() To match then immediately run a Computer Op using this builder's pre-allocated output.
		 */
		public Computers.Arity0<O> computer() {
			return matchComputer(env, opName, type(out), OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Computers} op on the provided output container.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public void compute() {
			computer().compute(out);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {}, type(out)));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {}, type(out)));
		}
	}

	/**
	 * Builder with arity 1, input type given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <O> The type of the output.
	 */
	public final class Arity1_IT_OT<I1, O> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<O> outType;

		public Arity1_IT_OT(final Nil<I1> in1Type, final Nil<O> outType)
		{
			this.in1Type = in1Type;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op, based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Function<I1, O> function() {
			return matchFunction(env, opName, in1Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity1<I1, O> computer() {
			return matchComputer(env, opName, in1Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type}, outType));
		}
	}

	/**
	 * Builder with arity 1, input type given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 */
	public final class Arity1_IT_OU<I1> extends Arity {

		private final Nil<I1> in1Type;

		public Arity1_IT_OU(final Nil<I1> in1Type)
		{
			this.in1Type = in1Type;
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity1_IT_OT<I1, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity1_IT_OT<I1, O> outType(final Nil<O> outType) {
			return new Arity1_IT_OT<>(in1Type, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 * @see #inplace() For a reusable Op that modifies a provided input parameter in-place.
		 */
		public Function<I1, ?> function() {
			return matchFunction(env, opName, in1Type, Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity1<I1> inplace() {
			return matchInplace(env, opName, in1Type, hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type}));
		}
	}

	/**
	 * Builder with arity 1, input value given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <O> The type of the output.
	 */
	public final class Arity1_IV_OT<I1, O> extends Arity {

		private final I1 in1;
		private final Nil<O> outType;

		public Arity1_IV_OT(final I1 in1, final Nil<O> outType)
		{
			this.in1 = in1;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Function<I1, O> function() {
			return matchFunction(env, opName, type(in1), outType, OpBuilder.this.hints);
		}
	
		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity1<I1, O> computer() {
			return matchComputer(env, opName, type(in1), outType, OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public O apply() {
			return function().apply(in1);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1)}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1)}, outType));
		}
	}

	/**
	 * Builder with arity 1, input value given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 */
	public final class Arity1_IV_OU<I1> extends Arity {

		private final I1 in1;

		public Arity1_IV_OU(final I1 in1)
		{
			this.in1 = in1;
		}

		/**
		 * Matches with this builder will use the given pre-allocated output instance.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity1_IV_OV<I1, O> output(final O out) {
			checkComputerRefs(in1, out);
			return new Arity1_IV_OV<>(in1, out);
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity1_IV_OT<I1, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity1_IV_OT<I1, O> outType(final Nil<O> outType) {
			return new Arity1_IV_OT<>(in1, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #inplace() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Function<I1, ?> function() {
			return matchFunction(env, opName, type(in1), Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity1<I1> inplace() {
			checkInplaceRefs(1, in1);
			return matchInplace(env, opName, type(in1), hints);
		}

		/**
		 * Match then immediately run a type-unsafe {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Object apply() {
			return function().apply(in1);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 1st parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate() {
			inplace().mutate(in1);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1)}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1)}));
		}
	}

	/**
	 * Builder with arity 1, input value given, output value given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 */
	public final class Arity1_IV_OV<I1, O> extends Arity {

		private final I1 in1;
		private final O out;

		public Arity1_IV_OV(final I1 in1, final O out)
		{
			this.in1 = in1;
			this.out = out;
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #compute() To match then immediately run a Computer Op using this builder's pre-allocated output.
		 */
		public Computers.Arity1<I1, O> computer() {
			return matchComputer(env, opName, type(in1), type(out), OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Computers} op using the provided pre-allocated output.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public void compute() {
			computer().compute(in1, out);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1)}, type(out)));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1)}, type(out)));
		}
	}
	/**
	 * Builder with arity 2, input type given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <O> The type of the output.
	 */
	public final class Arity2_IT_OT<I1, I2, O> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<O> outType;

		public Arity2_IT_OT(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<O> outType)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op, based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public BiFunction<I1, I2, O> function() {
			return matchFunction(env, opName, in1Type, in2Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity2<I1, I2, O> computer() {
			return matchComputer(env, opName, in1Type, in2Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type}, outType));
		}
	}

	/**
	 * Builder with arity 2, input type given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 */
	public final class Arity2_IT_OU<I1, I2> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;

		public Arity2_IT_OU(final Nil<I1> in1Type, final Nil<I2> in2Type)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity2_IT_OT<I1, I2, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity2_IT_OT<I1, I2, O> outType(final Nil<O> outType) {
			return new Arity2_IT_OT<>(in1Type, in2Type, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 */
		public BiFunction<I1, I2, ?> function() {
			return matchFunction(env, opName, in1Type, in2Type, Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity2_1<I1, I2> inplace1() {
			return matchInplace2_1(env, opName, in1Type, in2Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity2_2<I1, I2> inplace2() {
			return matchInplace2_2(env, opName, in1Type, in2Type, hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type}));
		}
	}

	/**
	 * Builder with arity 2, input value given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <O> The type of the output.
	 */
	public final class Arity2_IV_OT<I1, I2, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final Nil<O> outType;

		public Arity2_IV_OT(final I1 in1, final I2 in2, final Nil<O> outType)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public BiFunction<I1, I2, O> function() {
			return matchFunction(env, opName, type(in1), type(in2), outType, OpBuilder.this.hints);
		}
	
		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity2<I1, I2, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), outType, OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public O apply() {
			return function().apply(in1, in2);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2)}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2)}, outType));
		}
	}

	/**
	 * Builder with arity 2, input value given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 */
	public final class Arity2_IV_OU<I1, I2> extends Arity {

		private final I1 in1;
		private final I2 in2;

		public Arity2_IV_OU(final I1 in1, final I2 in2)
		{
			this.in1 = in1;
			this.in2 = in2;
		}

		/**
		 * Matches with this builder will use the given pre-allocated output instance.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity2_IV_OV<I1, I2, O> output(final O out) {
			checkComputerRefs(in1, in2, out);
			return new Arity2_IV_OV<>(in1, in2, out);
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity2_IV_OT<I1, I2, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity2_IV_OT<I1, I2, O> outType(final Nil<O> outType) {
			return new Arity2_IV_OT<>(in1, in2, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public BiFunction<I1, I2, ?> function() {
			return matchFunction(env, opName, type(in1), type(in2), Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity2_1<I1, I2> inplace1() {
			checkInplaceRefs(1, in1, in2);
			return matchInplace2_1(env, opName, type(in1), type(in2), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity2_2<I1, I2> inplace2() {
			checkInplaceRefs(2, in1, in2);
			return matchInplace2_2(env, opName, type(in1), type(in2), hints);
		}

		/**
		 * Match then immediately run a type-unsafe {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Object apply() {
			return function().apply(in1, in2);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 1st parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate1() {
			inplace1().mutate(in1, in2);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 2nd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate2() {
			inplace2().mutate(in1, in2);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2)}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2)}));
		}
	}

	/**
	 * Builder with arity 2, input value given, output value given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 */
	public final class Arity2_IV_OV<I1, I2, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final O out;

		public Arity2_IV_OV(final I1 in1, final I2 in2, final O out)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.out = out;
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #compute() To match then immediately run a Computer Op using this builder's pre-allocated output.
		 */
		public Computers.Arity2<I1, I2, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(out), OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Computers} op using the provided pre-allocated output.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public void compute() {
			computer().compute(in1, in2, out);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2)}, type(out)));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2)}, type(out)));
		}
	}
	/**
	 * Builder with arity 3, input type given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <O> The type of the output.
	 */
	public final class Arity3_IT_OT<I1, I2, I3, O> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<O> outType;

		public Arity3_IT_OT(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<O> outType)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op, based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity3<I1, I2, I3, O> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity3<I1, I2, I3, O> computer() {
			return matchComputer(env, opName, in1Type, in2Type, in3Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type}, outType));
		}
	}

	/**
	 * Builder with arity 3, input type given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 */
	public final class Arity3_IT_OU<I1, I2, I3> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;

		public Arity3_IT_OU(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity3_IT_OT<I1, I2, I3, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity3_IT_OT<I1, I2, I3, O> outType(final Nil<O> outType) {
			return new Arity3_IT_OT<>(in1Type, in2Type, in3Type, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 */
		public Functions.Arity3<I1, I2, I3, ?> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity3_1<I1, I2, I3> inplace1() {
			return matchInplace3_1(env, opName, in1Type, in2Type, in3Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity3_2<I1, I2, I3> inplace2() {
			return matchInplace3_2(env, opName, in1Type, in2Type, in3Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity3_3<I1, I2, I3> inplace3() {
			return matchInplace3_3(env, opName, in1Type, in2Type, in3Type, hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type}));
		}
	}

	/**
	 * Builder with arity 3, input value given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <O> The type of the output.
	 */
	public final class Arity3_IV_OT<I1, I2, I3, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final Nil<O> outType;

		public Arity3_IV_OT(final I1 in1, final I2 in2, final I3 in3, final Nil<O> outType)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity3<I1, I2, I3, O> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), outType, OpBuilder.this.hints);
		}
	
		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity3<I1, I2, I3, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), outType, OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public O apply() {
			return function().apply(in1, in2, in3);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3)}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3)}, outType));
		}
	}

	/**
	 * Builder with arity 3, input value given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 */
	public final class Arity3_IV_OU<I1, I2, I3> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;

		public Arity3_IV_OU(final I1 in1, final I2 in2, final I3 in3)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
		}

		/**
		 * Matches with this builder will use the given pre-allocated output instance.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity3_IV_OV<I1, I2, I3, O> output(final O out) {
			checkComputerRefs(in1, in2, in3, out);
			return new Arity3_IV_OV<>(in1, in2, in3, out);
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity3_IV_OT<I1, I2, I3, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity3_IV_OT<I1, I2, I3, O> outType(final Nil<O> outType) {
			return new Arity3_IV_OT<>(in1, in2, in3, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Functions.Arity3<I1, I2, I3, ?> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity3_1<I1, I2, I3> inplace1() {
			checkInplaceRefs(1, in1, in2, in3);
			return matchInplace3_1(env, opName, type(in1), type(in2), type(in3), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity3_2<I1, I2, I3> inplace2() {
			checkInplaceRefs(2, in1, in2, in3);
			return matchInplace3_2(env, opName, type(in1), type(in2), type(in3), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity3_3<I1, I2, I3> inplace3() {
			checkInplaceRefs(3, in1, in2, in3);
			return matchInplace3_3(env, opName, type(in1), type(in2), type(in3), hints);
		}

		/**
		 * Match then immediately run a type-unsafe {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Object apply() {
			return function().apply(in1, in2, in3);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 1st parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate1() {
			inplace1().mutate(in1, in2, in3);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 2nd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate2() {
			inplace2().mutate(in1, in2, in3);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 3rd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate3() {
			inplace3().mutate(in1, in2, in3);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3)}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3)}));
		}
	}

	/**
	 * Builder with arity 3, input value given, output value given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 */
	public final class Arity3_IV_OV<I1, I2, I3, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final O out;

		public Arity3_IV_OV(final I1 in1, final I2 in2, final I3 in3, final O out)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.out = out;
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #compute() To match then immediately run a Computer Op using this builder's pre-allocated output.
		 */
		public Computers.Arity3<I1, I2, I3, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(out), OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Computers} op using the provided pre-allocated output.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public void compute() {
			computer().compute(in1, in2, in3, out);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3)}, type(out)));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3)}, type(out)));
		}
	}
	/**
	 * Builder with arity 4, input type given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <O> The type of the output.
	 */
	public final class Arity4_IT_OT<I1, I2, I3, I4, O> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<O> outType;

		public Arity4_IT_OT(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<O> outType)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op, based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity4<I1, I2, I3, I4, O> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity4<I1, I2, I3, I4, O> computer() {
			return matchComputer(env, opName, in1Type, in2Type, in3Type, in4Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type}, outType));
		}
	}

	/**
	 * Builder with arity 4, input type given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 */
	public final class Arity4_IT_OU<I1, I2, I3, I4> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;

		public Arity4_IT_OU(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity4_IT_OT<I1, I2, I3, I4, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity4_IT_OT<I1, I2, I3, I4, O> outType(final Nil<O> outType) {
			return new Arity4_IT_OT<>(in1Type, in2Type, in3Type, in4Type, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 */
		public Functions.Arity4<I1, I2, I3, I4, ?> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity4_1<I1, I2, I3, I4> inplace1() {
			return matchInplace4_1(env, opName, in1Type, in2Type, in3Type, in4Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity4_2<I1, I2, I3, I4> inplace2() {
			return matchInplace4_2(env, opName, in1Type, in2Type, in3Type, in4Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity4_3<I1, I2, I3, I4> inplace3() {
			return matchInplace4_3(env, opName, in1Type, in2Type, in3Type, in4Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity4_4<I1, I2, I3, I4> inplace4() {
			return matchInplace4_4(env, opName, in1Type, in2Type, in3Type, in4Type, hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type}));
		}
	}

	/**
	 * Builder with arity 4, input value given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <O> The type of the output.
	 */
	public final class Arity4_IV_OT<I1, I2, I3, I4, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final Nil<O> outType;

		public Arity4_IV_OT(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final Nil<O> outType)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity4<I1, I2, I3, I4, O> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), outType, OpBuilder.this.hints);
		}
	
		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity4<I1, I2, I3, I4, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), outType, OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public O apply() {
			return function().apply(in1, in2, in3, in4);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4)}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4)}, outType));
		}
	}

	/**
	 * Builder with arity 4, input value given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 */
	public final class Arity4_IV_OU<I1, I2, I3, I4> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;

		public Arity4_IV_OU(final I1 in1, final I2 in2, final I3 in3, final I4 in4)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
		}

		/**
		 * Matches with this builder will use the given pre-allocated output instance.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity4_IV_OV<I1, I2, I3, I4, O> output(final O out) {
			checkComputerRefs(in1, in2, in3, in4, out);
			return new Arity4_IV_OV<>(in1, in2, in3, in4, out);
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity4_IV_OT<I1, I2, I3, I4, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity4_IV_OT<I1, I2, I3, I4, O> outType(final Nil<O> outType) {
			return new Arity4_IV_OT<>(in1, in2, in3, in4, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Functions.Arity4<I1, I2, I3, I4, ?> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity4_1<I1, I2, I3, I4> inplace1() {
			checkInplaceRefs(1, in1, in2, in3, in4);
			return matchInplace4_1(env, opName, type(in1), type(in2), type(in3), type(in4), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity4_2<I1, I2, I3, I4> inplace2() {
			checkInplaceRefs(2, in1, in2, in3, in4);
			return matchInplace4_2(env, opName, type(in1), type(in2), type(in3), type(in4), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity4_3<I1, I2, I3, I4> inplace3() {
			checkInplaceRefs(3, in1, in2, in3, in4);
			return matchInplace4_3(env, opName, type(in1), type(in2), type(in3), type(in4), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity4_4<I1, I2, I3, I4> inplace4() {
			checkInplaceRefs(4, in1, in2, in3, in4);
			return matchInplace4_4(env, opName, type(in1), type(in2), type(in3), type(in4), hints);
		}

		/**
		 * Match then immediately run a type-unsafe {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Object apply() {
			return function().apply(in1, in2, in3, in4);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 1st parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate1() {
			inplace1().mutate(in1, in2, in3, in4);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 2nd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate2() {
			inplace2().mutate(in1, in2, in3, in4);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 3rd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate3() {
			inplace3().mutate(in1, in2, in3, in4);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 4th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate4() {
			inplace4().mutate(in1, in2, in3, in4);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4)}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4)}));
		}
	}

	/**
	 * Builder with arity 4, input value given, output value given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 */
	public final class Arity4_IV_OV<I1, I2, I3, I4, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final O out;

		public Arity4_IV_OV(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final O out)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.out = out;
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #compute() To match then immediately run a Computer Op using this builder's pre-allocated output.
		 */
		public Computers.Arity4<I1, I2, I3, I4, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(out), OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Computers} op using the provided pre-allocated output.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public void compute() {
			computer().compute(in1, in2, in3, in4, out);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4)}, type(out)));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4)}, type(out)));
		}
	}
	/**
	 * Builder with arity 5, input type given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <O> The type of the output.
	 */
	public final class Arity5_IT_OT<I1, I2, I3, I4, I5, O> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<O> outType;

		public Arity5_IT_OT(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<O> outType)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op, based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity5<I1, I2, I3, I4, I5, O> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity5<I1, I2, I3, I4, I5, O> computer() {
			return matchComputer(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type}, outType));
		}
	}

	/**
	 * Builder with arity 5, input type given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 */
	public final class Arity5_IT_OU<I1, I2, I3, I4, I5> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;

		public Arity5_IT_OU(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity5_IT_OT<I1, I2, I3, I4, I5, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity5_IT_OT<I1, I2, I3, I4, I5, O> outType(final Nil<O> outType) {
			return new Arity5_IT_OT<>(in1Type, in2Type, in3Type, in4Type, in5Type, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 */
		public Functions.Arity5<I1, I2, I3, I4, I5, ?> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity5_1<I1, I2, I3, I4, I5> inplace1() {
			return matchInplace5_1(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity5_2<I1, I2, I3, I4, I5> inplace2() {
			return matchInplace5_2(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity5_3<I1, I2, I3, I4, I5> inplace3() {
			return matchInplace5_3(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity5_4<I1, I2, I3, I4, I5> inplace4() {
			return matchInplace5_4(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity5_5<I1, I2, I3, I4, I5> inplace5() {
			return matchInplace5_5(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type}));
		}
	}

	/**
	 * Builder with arity 5, input value given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <O> The type of the output.
	 */
	public final class Arity5_IV_OT<I1, I2, I3, I4, I5, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final Nil<O> outType;

		public Arity5_IV_OT(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final Nil<O> outType)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity5<I1, I2, I3, I4, I5, O> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), outType, OpBuilder.this.hints);
		}
	
		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity5<I1, I2, I3, I4, I5, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), outType, OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public O apply() {
			return function().apply(in1, in2, in3, in4, in5);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5)}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5)}, outType));
		}
	}

	/**
	 * Builder with arity 5, input value given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 */
	public final class Arity5_IV_OU<I1, I2, I3, I4, I5> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;

		public Arity5_IV_OU(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
		}

		/**
		 * Matches with this builder will use the given pre-allocated output instance.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity5_IV_OV<I1, I2, I3, I4, I5, O> output(final O out) {
			checkComputerRefs(in1, in2, in3, in4, in5, out);
			return new Arity5_IV_OV<>(in1, in2, in3, in4, in5, out);
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity5_IV_OT<I1, I2, I3, I4, I5, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity5_IV_OT<I1, I2, I3, I4, I5, O> outType(final Nil<O> outType) {
			return new Arity5_IV_OT<>(in1, in2, in3, in4, in5, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Functions.Arity5<I1, I2, I3, I4, I5, ?> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity5_1<I1, I2, I3, I4, I5> inplace1() {
			checkInplaceRefs(1, in1, in2, in3, in4, in5);
			return matchInplace5_1(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity5_2<I1, I2, I3, I4, I5> inplace2() {
			checkInplaceRefs(2, in1, in2, in3, in4, in5);
			return matchInplace5_2(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity5_3<I1, I2, I3, I4, I5> inplace3() {
			checkInplaceRefs(3, in1, in2, in3, in4, in5);
			return matchInplace5_3(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity5_4<I1, I2, I3, I4, I5> inplace4() {
			checkInplaceRefs(4, in1, in2, in3, in4, in5);
			return matchInplace5_4(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity5_5<I1, I2, I3, I4, I5> inplace5() {
			checkInplaceRefs(5, in1, in2, in3, in4, in5);
			return matchInplace5_5(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), hints);
		}

		/**
		 * Match then immediately run a type-unsafe {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Object apply() {
			return function().apply(in1, in2, in3, in4, in5);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 1st parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate1() {
			inplace1().mutate(in1, in2, in3, in4, in5);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 2nd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate2() {
			inplace2().mutate(in1, in2, in3, in4, in5);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 3rd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate3() {
			inplace3().mutate(in1, in2, in3, in4, in5);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 4th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate4() {
			inplace4().mutate(in1, in2, in3, in4, in5);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 5th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate5() {
			inplace5().mutate(in1, in2, in3, in4, in5);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5)}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5)}));
		}
	}

	/**
	 * Builder with arity 5, input value given, output value given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 */
	public final class Arity5_IV_OV<I1, I2, I3, I4, I5, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final O out;

		public Arity5_IV_OV(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final O out)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.out = out;
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #compute() To match then immediately run a Computer Op using this builder's pre-allocated output.
		 */
		public Computers.Arity5<I1, I2, I3, I4, I5, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(out), OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Computers} op using the provided pre-allocated output.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public void compute() {
			computer().compute(in1, in2, in3, in4, in5, out);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5)}, type(out)));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5)}, type(out)));
		}
	}
	/**
	 * Builder with arity 6, input type given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <O> The type of the output.
	 */
	public final class Arity6_IT_OT<I1, I2, I3, I4, I5, I6, O> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<O> outType;

		public Arity6_IT_OT(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<O> outType)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op, based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity6<I1, I2, I3, I4, I5, I6, O> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity6<I1, I2, I3, I4, I5, I6, O> computer() {
			return matchComputer(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type}, outType));
		}
	}

	/**
	 * Builder with arity 6, input type given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 */
	public final class Arity6_IT_OU<I1, I2, I3, I4, I5, I6> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;

		public Arity6_IT_OU(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity6_IT_OT<I1, I2, I3, I4, I5, I6, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity6_IT_OT<I1, I2, I3, I4, I5, I6, O> outType(final Nil<O> outType) {
			return new Arity6_IT_OT<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 */
		public Functions.Arity6<I1, I2, I3, I4, I5, I6, ?> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity6_1<I1, I2, I3, I4, I5, I6> inplace1() {
			return matchInplace6_1(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity6_2<I1, I2, I3, I4, I5, I6> inplace2() {
			return matchInplace6_2(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity6_3<I1, I2, I3, I4, I5, I6> inplace3() {
			return matchInplace6_3(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity6_4<I1, I2, I3, I4, I5, I6> inplace4() {
			return matchInplace6_4(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity6_5<I1, I2, I3, I4, I5, I6> inplace5() {
			return matchInplace6_5(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity6_6<I1, I2, I3, I4, I5, I6> inplace6() {
			return matchInplace6_6(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type}));
		}
	}

	/**
	 * Builder with arity 6, input value given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <O> The type of the output.
	 */
	public final class Arity6_IV_OT<I1, I2, I3, I4, I5, I6, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final Nil<O> outType;

		public Arity6_IV_OT(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final Nil<O> outType)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity6<I1, I2, I3, I4, I5, I6, O> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), outType, OpBuilder.this.hints);
		}
	
		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity6<I1, I2, I3, I4, I5, I6, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), outType, OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public O apply() {
			return function().apply(in1, in2, in3, in4, in5, in6);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6)}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6)}, outType));
		}
	}

	/**
	 * Builder with arity 6, input value given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 */
	public final class Arity6_IV_OU<I1, I2, I3, I4, I5, I6> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;

		public Arity6_IV_OU(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
		}

		/**
		 * Matches with this builder will use the given pre-allocated output instance.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity6_IV_OV<I1, I2, I3, I4, I5, I6, O> output(final O out) {
			checkComputerRefs(in1, in2, in3, in4, in5, in6, out);
			return new Arity6_IV_OV<>(in1, in2, in3, in4, in5, in6, out);
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity6_IV_OT<I1, I2, I3, I4, I5, I6, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity6_IV_OT<I1, I2, I3, I4, I5, I6, O> outType(final Nil<O> outType) {
			return new Arity6_IV_OT<>(in1, in2, in3, in4, in5, in6, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Functions.Arity6<I1, I2, I3, I4, I5, I6, ?> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity6_1<I1, I2, I3, I4, I5, I6> inplace1() {
			checkInplaceRefs(1, in1, in2, in3, in4, in5, in6);
			return matchInplace6_1(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity6_2<I1, I2, I3, I4, I5, I6> inplace2() {
			checkInplaceRefs(2, in1, in2, in3, in4, in5, in6);
			return matchInplace6_2(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity6_3<I1, I2, I3, I4, I5, I6> inplace3() {
			checkInplaceRefs(3, in1, in2, in3, in4, in5, in6);
			return matchInplace6_3(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity6_4<I1, I2, I3, I4, I5, I6> inplace4() {
			checkInplaceRefs(4, in1, in2, in3, in4, in5, in6);
			return matchInplace6_4(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity6_5<I1, I2, I3, I4, I5, I6> inplace5() {
			checkInplaceRefs(5, in1, in2, in3, in4, in5, in6);
			return matchInplace6_5(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity6_6<I1, I2, I3, I4, I5, I6> inplace6() {
			checkInplaceRefs(6, in1, in2, in3, in4, in5, in6);
			return matchInplace6_6(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), hints);
		}

		/**
		 * Match then immediately run a type-unsafe {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Object apply() {
			return function().apply(in1, in2, in3, in4, in5, in6);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 1st parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate1() {
			inplace1().mutate(in1, in2, in3, in4, in5, in6);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 2nd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate2() {
			inplace2().mutate(in1, in2, in3, in4, in5, in6);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 3rd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate3() {
			inplace3().mutate(in1, in2, in3, in4, in5, in6);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 4th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate4() {
			inplace4().mutate(in1, in2, in3, in4, in5, in6);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 5th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate5() {
			inplace5().mutate(in1, in2, in3, in4, in5, in6);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 6th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate6() {
			inplace6().mutate(in1, in2, in3, in4, in5, in6);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6)}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6)}));
		}
	}

	/**
	 * Builder with arity 6, input value given, output value given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 */
	public final class Arity6_IV_OV<I1, I2, I3, I4, I5, I6, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final O out;

		public Arity6_IV_OV(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final O out)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.out = out;
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #compute() To match then immediately run a Computer Op using this builder's pre-allocated output.
		 */
		public Computers.Arity6<I1, I2, I3, I4, I5, I6, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(out), OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Computers} op using the provided pre-allocated output.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public void compute() {
			computer().compute(in1, in2, in3, in4, in5, in6, out);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6)}, type(out)));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6)}, type(out)));
		}
	}
	/**
	 * Builder with arity 7, input type given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <O> The type of the output.
	 */
	public final class Arity7_IT_OT<I1, I2, I3, I4, I5, I6, I7, O> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;
		private final Nil<O> outType;

		public Arity7_IT_OT(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<O> outType)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op, based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity7<I1, I2, I3, I4, I5, I6, I7, O> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity7<I1, I2, I3, I4, I5, I6, I7, O> computer() {
			return matchComputer(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type}, outType));
		}
	}

	/**
	 * Builder with arity 7, input type given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 */
	public final class Arity7_IT_OU<I1, I2, I3, I4, I5, I6, I7> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;

		public Arity7_IT_OU(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity7_IT_OT<I1, I2, I3, I4, I5, I6, I7, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity7_IT_OT<I1, I2, I3, I4, I5, I6, I7, O> outType(final Nil<O> outType) {
			return new Arity7_IT_OT<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 */
		public Functions.Arity7<I1, I2, I3, I4, I5, I6, I7, ?> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity7_1<I1, I2, I3, I4, I5, I6, I7> inplace1() {
			return matchInplace7_1(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity7_2<I1, I2, I3, I4, I5, I6, I7> inplace2() {
			return matchInplace7_2(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity7_3<I1, I2, I3, I4, I5, I6, I7> inplace3() {
			return matchInplace7_3(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity7_4<I1, I2, I3, I4, I5, I6, I7> inplace4() {
			return matchInplace7_4(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity7_5<I1, I2, I3, I4, I5, I6, I7> inplace5() {
			return matchInplace7_5(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity7_6<I1, I2, I3, I4, I5, I6, I7> inplace6() {
			return matchInplace7_6(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity7_7<I1, I2, I3, I4, I5, I6, I7> inplace7() {
			return matchInplace7_7(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type}));
		}
	}

	/**
	 * Builder with arity 7, input value given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <O> The type of the output.
	 */
	public final class Arity7_IV_OT<I1, I2, I3, I4, I5, I6, I7, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final Nil<O> outType;

		public Arity7_IV_OT(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final Nil<O> outType)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity7<I1, I2, I3, I4, I5, I6, I7, O> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), outType, OpBuilder.this.hints);
		}
	
		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity7<I1, I2, I3, I4, I5, I6, I7, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), outType, OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public O apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7)}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7)}, outType));
		}
	}

	/**
	 * Builder with arity 7, input value given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 */
	public final class Arity7_IV_OU<I1, I2, I3, I4, I5, I6, I7> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;

		public Arity7_IV_OU(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
		}

		/**
		 * Matches with this builder will use the given pre-allocated output instance.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity7_IV_OV<I1, I2, I3, I4, I5, I6, I7, O> output(final O out) {
			checkComputerRefs(in1, in2, in3, in4, in5, in6, in7, out);
			return new Arity7_IV_OV<>(in1, in2, in3, in4, in5, in6, in7, out);
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity7_IV_OT<I1, I2, I3, I4, I5, I6, I7, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity7_IV_OT<I1, I2, I3, I4, I5, I6, I7, O> outType(final Nil<O> outType) {
			return new Arity7_IV_OT<>(in1, in2, in3, in4, in5, in6, in7, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Functions.Arity7<I1, I2, I3, I4, I5, I6, I7, ?> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity7_1<I1, I2, I3, I4, I5, I6, I7> inplace1() {
			checkInplaceRefs(1, in1, in2, in3, in4, in5, in6, in7);
			return matchInplace7_1(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity7_2<I1, I2, I3, I4, I5, I6, I7> inplace2() {
			checkInplaceRefs(2, in1, in2, in3, in4, in5, in6, in7);
			return matchInplace7_2(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity7_3<I1, I2, I3, I4, I5, I6, I7> inplace3() {
			checkInplaceRefs(3, in1, in2, in3, in4, in5, in6, in7);
			return matchInplace7_3(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity7_4<I1, I2, I3, I4, I5, I6, I7> inplace4() {
			checkInplaceRefs(4, in1, in2, in3, in4, in5, in6, in7);
			return matchInplace7_4(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity7_5<I1, I2, I3, I4, I5, I6, I7> inplace5() {
			checkInplaceRefs(5, in1, in2, in3, in4, in5, in6, in7);
			return matchInplace7_5(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity7_6<I1, I2, I3, I4, I5, I6, I7> inplace6() {
			checkInplaceRefs(6, in1, in2, in3, in4, in5, in6, in7);
			return matchInplace7_6(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity7_7<I1, I2, I3, I4, I5, I6, I7> inplace7() {
			checkInplaceRefs(7, in1, in2, in3, in4, in5, in6, in7);
			return matchInplace7_7(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), hints);
		}

		/**
		 * Match then immediately run a type-unsafe {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Object apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 1st parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate1() {
			inplace1().mutate(in1, in2, in3, in4, in5, in6, in7);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 2nd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate2() {
			inplace2().mutate(in1, in2, in3, in4, in5, in6, in7);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 3rd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate3() {
			inplace3().mutate(in1, in2, in3, in4, in5, in6, in7);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 4th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate4() {
			inplace4().mutate(in1, in2, in3, in4, in5, in6, in7);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 5th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate5() {
			inplace5().mutate(in1, in2, in3, in4, in5, in6, in7);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 6th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate6() {
			inplace6().mutate(in1, in2, in3, in4, in5, in6, in7);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 7th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate7() {
			inplace7().mutate(in1, in2, in3, in4, in5, in6, in7);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7)}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7)}));
		}
	}

	/**
	 * Builder with arity 7, input value given, output value given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 */
	public final class Arity7_IV_OV<I1, I2, I3, I4, I5, I6, I7, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final O out;

		public Arity7_IV_OV(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final O out)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.out = out;
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #compute() To match then immediately run a Computer Op using this builder's pre-allocated output.
		 */
		public Computers.Arity7<I1, I2, I3, I4, I5, I6, I7, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(out), OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Computers} op using the provided pre-allocated output.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public void compute() {
			computer().compute(in1, in2, in3, in4, in5, in6, in7, out);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7)}, type(out)));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7)}, type(out)));
		}
	}
	/**
	 * Builder with arity 8, input type given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <O> The type of the output.
	 */
	public final class Arity8_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, O> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;
		private final Nil<I8> in8Type;
		private final Nil<O> outType;

		public Arity8_IT_OT(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<O> outType)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
			this.in8Type = in8Type;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op, based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity8<I1, I2, I3, I4, I5, I6, I7, I8, O> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity8<I1, I2, I3, I4, I5, I6, I7, I8, O> computer() {
			return matchComputer(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type}, outType));
		}
	}

	/**
	 * Builder with arity 8, input type given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 */
	public final class Arity8_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;
		private final Nil<I8> in8Type;

		public Arity8_IT_OU(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
			this.in8Type = in8Type;
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity8_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity8_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, O> outType(final Nil<O> outType) {
			return new Arity8_IT_OT<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 */
		public Functions.Arity8<I1, I2, I3, I4, I5, I6, I7, I8, ?> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity8_1<I1, I2, I3, I4, I5, I6, I7, I8> inplace1() {
			return matchInplace8_1(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity8_2<I1, I2, I3, I4, I5, I6, I7, I8> inplace2() {
			return matchInplace8_2(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity8_3<I1, I2, I3, I4, I5, I6, I7, I8> inplace3() {
			return matchInplace8_3(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity8_4<I1, I2, I3, I4, I5, I6, I7, I8> inplace4() {
			return matchInplace8_4(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity8_5<I1, I2, I3, I4, I5, I6, I7, I8> inplace5() {
			return matchInplace8_5(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity8_6<I1, I2, I3, I4, I5, I6, I7, I8> inplace6() {
			return matchInplace8_6(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity8_7<I1, I2, I3, I4, I5, I6, I7, I8> inplace7() {
			return matchInplace8_7(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 8th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity8_8<I1, I2, I3, I4, I5, I6, I7, I8> inplace8() {
			return matchInplace8_8(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type}));
		}
	}

	/**
	 * Builder with arity 8, input value given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <O> The type of the output.
	 */
	public final class Arity8_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final Nil<O> outType;

		public Arity8_IV_OT(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final Nil<O> outType)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity8<I1, I2, I3, I4, I5, I6, I7, I8, O> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), outType, OpBuilder.this.hints);
		}
	
		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity8<I1, I2, I3, I4, I5, I6, I7, I8, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), outType, OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public O apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7, in8);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8)}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8)}, outType));
		}
	}

	/**
	 * Builder with arity 8, input value given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 */
	public final class Arity8_IV_OU<I1, I2, I3, I4, I5, I6, I7, I8> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;

		public Arity8_IV_OU(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
		}

		/**
		 * Matches with this builder will use the given pre-allocated output instance.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity8_IV_OV<I1, I2, I3, I4, I5, I6, I7, I8, O> output(final O out) {
			checkComputerRefs(in1, in2, in3, in4, in5, in6, in7, in8, out);
			return new Arity8_IV_OV<>(in1, in2, in3, in4, in5, in6, in7, in8, out);
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity8_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity8_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, O> outType(final Nil<O> outType) {
			return new Arity8_IV_OT<>(in1, in2, in3, in4, in5, in6, in7, in8, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Functions.Arity8<I1, I2, I3, I4, I5, I6, I7, I8, ?> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity8_1<I1, I2, I3, I4, I5, I6, I7, I8> inplace1() {
			checkInplaceRefs(1, in1, in2, in3, in4, in5, in6, in7, in8);
			return matchInplace8_1(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity8_2<I1, I2, I3, I4, I5, I6, I7, I8> inplace2() {
			checkInplaceRefs(2, in1, in2, in3, in4, in5, in6, in7, in8);
			return matchInplace8_2(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity8_3<I1, I2, I3, I4, I5, I6, I7, I8> inplace3() {
			checkInplaceRefs(3, in1, in2, in3, in4, in5, in6, in7, in8);
			return matchInplace8_3(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity8_4<I1, I2, I3, I4, I5, I6, I7, I8> inplace4() {
			checkInplaceRefs(4, in1, in2, in3, in4, in5, in6, in7, in8);
			return matchInplace8_4(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity8_5<I1, I2, I3, I4, I5, I6, I7, I8> inplace5() {
			checkInplaceRefs(5, in1, in2, in3, in4, in5, in6, in7, in8);
			return matchInplace8_5(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity8_6<I1, I2, I3, I4, I5, I6, I7, I8> inplace6() {
			checkInplaceRefs(6, in1, in2, in3, in4, in5, in6, in7, in8);
			return matchInplace8_6(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity8_7<I1, I2, I3, I4, I5, I6, I7, I8> inplace7() {
			checkInplaceRefs(7, in1, in2, in3, in4, in5, in6, in7, in8);
			return matchInplace8_7(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 8th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity8_8<I1, I2, I3, I4, I5, I6, I7, I8> inplace8() {
			checkInplaceRefs(8, in1, in2, in3, in4, in5, in6, in7, in8);
			return matchInplace8_8(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), hints);
		}

		/**
		 * Match then immediately run a type-unsafe {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Object apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7, in8);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 1st parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate1() {
			inplace1().mutate(in1, in2, in3, in4, in5, in6, in7, in8);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 2nd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate2() {
			inplace2().mutate(in1, in2, in3, in4, in5, in6, in7, in8);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 3rd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate3() {
			inplace3().mutate(in1, in2, in3, in4, in5, in6, in7, in8);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 4th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate4() {
			inplace4().mutate(in1, in2, in3, in4, in5, in6, in7, in8);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 5th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate5() {
			inplace5().mutate(in1, in2, in3, in4, in5, in6, in7, in8);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 6th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate6() {
			inplace6().mutate(in1, in2, in3, in4, in5, in6, in7, in8);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 7th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate7() {
			inplace7().mutate(in1, in2, in3, in4, in5, in6, in7, in8);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 8th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate8() {
			inplace8().mutate(in1, in2, in3, in4, in5, in6, in7, in8);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8)}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8)}));
		}
	}

	/**
	 * Builder with arity 8, input value given, output value given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 */
	public final class Arity8_IV_OV<I1, I2, I3, I4, I5, I6, I7, I8, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final O out;

		public Arity8_IV_OV(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final O out)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.out = out;
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #compute() To match then immediately run a Computer Op using this builder's pre-allocated output.
		 */
		public Computers.Arity8<I1, I2, I3, I4, I5, I6, I7, I8, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(out), OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Computers} op using the provided pre-allocated output.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public void compute() {
			computer().compute(in1, in2, in3, in4, in5, in6, in7, in8, out);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8)}, type(out)));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8)}, type(out)));
		}
	}
	/**
	 * Builder with arity 9, input type given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <O> The type of the output.
	 */
	public final class Arity9_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;
		private final Nil<I8> in8Type;
		private final Nil<I9> in9Type;
		private final Nil<O> outType;

		public Arity9_IT_OT(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<O> outType)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
			this.in8Type = in8Type;
			this.in9Type = in9Type;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op, based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity9<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity9<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> computer() {
			return matchComputer(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type}, outType));
		}
	}

	/**
	 * Builder with arity 9, input type given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 */
	public final class Arity9_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;
		private final Nil<I8> in8Type;
		private final Nil<I9> in9Type;

		public Arity9_IT_OU(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
			this.in8Type = in8Type;
			this.in9Type = in9Type;
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity9_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity9_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> outType(final Nil<O> outType) {
			return new Arity9_IT_OT<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 */
		public Functions.Arity9<I1, I2, I3, I4, I5, I6, I7, I8, I9, ?> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity9_1<I1, I2, I3, I4, I5, I6, I7, I8, I9> inplace1() {
			return matchInplace9_1(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity9_2<I1, I2, I3, I4, I5, I6, I7, I8, I9> inplace2() {
			return matchInplace9_2(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity9_3<I1, I2, I3, I4, I5, I6, I7, I8, I9> inplace3() {
			return matchInplace9_3(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity9_4<I1, I2, I3, I4, I5, I6, I7, I8, I9> inplace4() {
			return matchInplace9_4(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity9_5<I1, I2, I3, I4, I5, I6, I7, I8, I9> inplace5() {
			return matchInplace9_5(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity9_6<I1, I2, I3, I4, I5, I6, I7, I8, I9> inplace6() {
			return matchInplace9_6(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity9_7<I1, I2, I3, I4, I5, I6, I7, I8, I9> inplace7() {
			return matchInplace9_7(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 8th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity9_8<I1, I2, I3, I4, I5, I6, I7, I8, I9> inplace8() {
			return matchInplace9_8(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 9th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity9_9<I1, I2, I3, I4, I5, I6, I7, I8, I9> inplace9() {
			return matchInplace9_9(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type}));
		}
	}

	/**
	 * Builder with arity 9, input value given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <O> The type of the output.
	 */
	public final class Arity9_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final Nil<O> outType;

		public Arity9_IV_OT(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final Nil<O> outType)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity9<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), outType, OpBuilder.this.hints);
		}
	
		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity9<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), outType, OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public O apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7, in8, in9);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9)}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9)}, outType));
		}
	}

	/**
	 * Builder with arity 9, input value given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 */
	public final class Arity9_IV_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;

		public Arity9_IV_OU(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
		}

		/**
		 * Matches with this builder will use the given pre-allocated output instance.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity9_IV_OV<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> output(final O out) {
			checkComputerRefs(in1, in2, in3, in4, in5, in6, in7, in8, in9, out);
			return new Arity9_IV_OV<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, out);
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity9_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity9_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> outType(final Nil<O> outType) {
			return new Arity9_IV_OT<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Functions.Arity9<I1, I2, I3, I4, I5, I6, I7, I8, I9, ?> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity9_1<I1, I2, I3, I4, I5, I6, I7, I8, I9> inplace1() {
			checkInplaceRefs(1, in1, in2, in3, in4, in5, in6, in7, in8, in9);
			return matchInplace9_1(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity9_2<I1, I2, I3, I4, I5, I6, I7, I8, I9> inplace2() {
			checkInplaceRefs(2, in1, in2, in3, in4, in5, in6, in7, in8, in9);
			return matchInplace9_2(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity9_3<I1, I2, I3, I4, I5, I6, I7, I8, I9> inplace3() {
			checkInplaceRefs(3, in1, in2, in3, in4, in5, in6, in7, in8, in9);
			return matchInplace9_3(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity9_4<I1, I2, I3, I4, I5, I6, I7, I8, I9> inplace4() {
			checkInplaceRefs(4, in1, in2, in3, in4, in5, in6, in7, in8, in9);
			return matchInplace9_4(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity9_5<I1, I2, I3, I4, I5, I6, I7, I8, I9> inplace5() {
			checkInplaceRefs(5, in1, in2, in3, in4, in5, in6, in7, in8, in9);
			return matchInplace9_5(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity9_6<I1, I2, I3, I4, I5, I6, I7, I8, I9> inplace6() {
			checkInplaceRefs(6, in1, in2, in3, in4, in5, in6, in7, in8, in9);
			return matchInplace9_6(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity9_7<I1, I2, I3, I4, I5, I6, I7, I8, I9> inplace7() {
			checkInplaceRefs(7, in1, in2, in3, in4, in5, in6, in7, in8, in9);
			return matchInplace9_7(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 8th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity9_8<I1, I2, I3, I4, I5, I6, I7, I8, I9> inplace8() {
			checkInplaceRefs(8, in1, in2, in3, in4, in5, in6, in7, in8, in9);
			return matchInplace9_8(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 9th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity9_9<I1, I2, I3, I4, I5, I6, I7, I8, I9> inplace9() {
			checkInplaceRefs(9, in1, in2, in3, in4, in5, in6, in7, in8, in9);
			return matchInplace9_9(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), hints);
		}

		/**
		 * Match then immediately run a type-unsafe {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Object apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7, in8, in9);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 1st parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate1() {
			inplace1().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 2nd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate2() {
			inplace2().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 3rd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate3() {
			inplace3().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 4th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate4() {
			inplace4().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 5th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate5() {
			inplace5().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 6th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate6() {
			inplace6().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 7th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate7() {
			inplace7().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 8th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate8() {
			inplace8().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 9th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate9() {
			inplace9().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9)}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9)}));
		}
	}

	/**
	 * Builder with arity 9, input value given, output value given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 */
	public final class Arity9_IV_OV<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final O out;

		public Arity9_IV_OV(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final O out)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.out = out;
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #compute() To match then immediately run a Computer Op using this builder's pre-allocated output.
		 */
		public Computers.Arity9<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(out), OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Computers} op using the provided pre-allocated output.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public void compute() {
			computer().compute(in1, in2, in3, in4, in5, in6, in7, in8, in9, out);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9)}, type(out)));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9)}, type(out)));
		}
	}
	/**
	 * Builder with arity 10, input type given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <O> The type of the output.
	 */
	public final class Arity10_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;
		private final Nil<I8> in8Type;
		private final Nil<I9> in9Type;
		private final Nil<I10> in10Type;
		private final Nil<O> outType;

		public Arity10_IT_OT(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<O> outType)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
			this.in8Type = in8Type;
			this.in9Type = in9Type;
			this.in10Type = in10Type;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op, based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> computer() {
			return matchComputer(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type}, outType));
		}
	}

	/**
	 * Builder with arity 10, input type given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 */
	public final class Arity10_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;
		private final Nil<I8> in8Type;
		private final Nil<I9> in9Type;
		private final Nil<I10> in10Type;

		public Arity10_IT_OU(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
			this.in8Type = in8Type;
			this.in9Type = in9Type;
			this.in10Type = in10Type;
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity10_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity10_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> outType(final Nil<O> outType) {
			return new Arity10_IT_OT<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 */
		public Functions.Arity10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, ?> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_1<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace1() {
			return matchInplace10_1(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_2<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace2() {
			return matchInplace10_2(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_3<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace3() {
			return matchInplace10_3(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_4<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace4() {
			return matchInplace10_4(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_5<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace5() {
			return matchInplace10_5(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_6<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace6() {
			return matchInplace10_6(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_7<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace7() {
			return matchInplace10_7(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 8th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_8<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace8() {
			return matchInplace10_8(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 9th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_9<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace9() {
			return matchInplace10_9(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 10th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace10() {
			return matchInplace10_10(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type}));
		}
	}

	/**
	 * Builder with arity 10, input value given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <O> The type of the output.
	 */
	public final class Arity10_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final Nil<O> outType;

		public Arity10_IV_OT(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final Nil<O> outType)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), outType, OpBuilder.this.hints);
		}
	
		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), outType, OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public O apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10)}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10)}, outType));
		}
	}

	/**
	 * Builder with arity 10, input value given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 */
	public final class Arity10_IV_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;

		public Arity10_IV_OU(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
		}

		/**
		 * Matches with this builder will use the given pre-allocated output instance.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity10_IV_OV<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> output(final O out) {
			checkComputerRefs(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, out);
			return new Arity10_IV_OV<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, out);
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity10_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity10_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> outType(final Nil<O> outType) {
			return new Arity10_IV_OT<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Functions.Arity10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, ?> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_1<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace1() {
			checkInplaceRefs(1, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
			return matchInplace10_1(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_2<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace2() {
			checkInplaceRefs(2, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
			return matchInplace10_2(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_3<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace3() {
			checkInplaceRefs(3, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
			return matchInplace10_3(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_4<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace4() {
			checkInplaceRefs(4, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
			return matchInplace10_4(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_5<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace5() {
			checkInplaceRefs(5, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
			return matchInplace10_5(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_6<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace6() {
			checkInplaceRefs(6, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
			return matchInplace10_6(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_7<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace7() {
			checkInplaceRefs(7, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
			return matchInplace10_7(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 8th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_8<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace8() {
			checkInplaceRefs(8, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
			return matchInplace10_8(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 9th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_9<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace9() {
			checkInplaceRefs(9, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
			return matchInplace10_9(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 10th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity10_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10> inplace10() {
			checkInplaceRefs(10, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
			return matchInplace10_10(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), hints);
		}

		/**
		 * Match then immediately run a type-unsafe {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Object apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 1st parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate1() {
			inplace1().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 2nd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate2() {
			inplace2().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 3rd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate3() {
			inplace3().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 4th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate4() {
			inplace4().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 5th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate5() {
			inplace5().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 6th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate6() {
			inplace6().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 7th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate7() {
			inplace7().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 8th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate8() {
			inplace8().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 9th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate9() {
			inplace9().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 10th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate10() {
			inplace10().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10)}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10)}));
		}
	}

	/**
	 * Builder with arity 10, input value given, output value given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 */
	public final class Arity10_IV_OV<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final O out;

		public Arity10_IV_OV(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final O out)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.out = out;
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #compute() To match then immediately run a Computer Op using this builder's pre-allocated output.
		 */
		public Computers.Arity10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(out), OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Computers} op using the provided pre-allocated output.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public void compute() {
			computer().compute(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, out);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10)}, type(out)));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10)}, type(out)));
		}
	}
	/**
	 * Builder with arity 11, input type given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <O> The type of the output.
	 */
	public final class Arity11_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;
		private final Nil<I8> in8Type;
		private final Nil<I9> in9Type;
		private final Nil<I10> in10Type;
		private final Nil<I11> in11Type;
		private final Nil<O> outType;

		public Arity11_IT_OT(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<O> outType)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
			this.in8Type = in8Type;
			this.in9Type = in9Type;
			this.in10Type = in10Type;
			this.in11Type = in11Type;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op, based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> computer() {
			return matchComputer(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type}, outType));
		}
	}

	/**
	 * Builder with arity 11, input type given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 */
	public final class Arity11_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;
		private final Nil<I8> in8Type;
		private final Nil<I9> in9Type;
		private final Nil<I10> in10Type;
		private final Nil<I11> in11Type;

		public Arity11_IT_OU(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
			this.in8Type = in8Type;
			this.in9Type = in9Type;
			this.in10Type = in10Type;
			this.in11Type = in11Type;
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity11_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity11_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> outType(final Nil<O> outType) {
			return new Arity11_IT_OT<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 */
		public Functions.Arity11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, ?> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_1<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace1() {
			return matchInplace11_1(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_2<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace2() {
			return matchInplace11_2(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_3<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace3() {
			return matchInplace11_3(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_4<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace4() {
			return matchInplace11_4(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_5<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace5() {
			return matchInplace11_5(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_6<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace6() {
			return matchInplace11_6(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_7<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace7() {
			return matchInplace11_7(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 8th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_8<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace8() {
			return matchInplace11_8(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 9th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_9<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace9() {
			return matchInplace11_9(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 10th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace10() {
			return matchInplace11_10(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 11th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace11() {
			return matchInplace11_11(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type}));
		}
	}

	/**
	 * Builder with arity 11, input value given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <O> The type of the output.
	 */
	public final class Arity11_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final I11 in11;
		private final Nil<O> outType;

		public Arity11_IV_OT(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final Nil<O> outType)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.in11 = in11;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), outType, OpBuilder.this.hints);
		}
	
		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), outType, OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public O apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11)}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11)}, outType));
		}
	}

	/**
	 * Builder with arity 11, input value given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 */
	public final class Arity11_IV_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final I11 in11;

		public Arity11_IV_OU(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.in11 = in11;
		}

		/**
		 * Matches with this builder will use the given pre-allocated output instance.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity11_IV_OV<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> output(final O out) {
			checkComputerRefs(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, out);
			return new Arity11_IV_OV<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, out);
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity11_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity11_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> outType(final Nil<O> outType) {
			return new Arity11_IV_OT<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Functions.Arity11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, ?> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_1<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace1() {
			checkInplaceRefs(1, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
			return matchInplace11_1(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_2<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace2() {
			checkInplaceRefs(2, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
			return matchInplace11_2(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_3<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace3() {
			checkInplaceRefs(3, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
			return matchInplace11_3(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_4<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace4() {
			checkInplaceRefs(4, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
			return matchInplace11_4(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_5<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace5() {
			checkInplaceRefs(5, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
			return matchInplace11_5(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_6<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace6() {
			checkInplaceRefs(6, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
			return matchInplace11_6(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_7<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace7() {
			checkInplaceRefs(7, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
			return matchInplace11_7(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 8th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_8<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace8() {
			checkInplaceRefs(8, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
			return matchInplace11_8(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 9th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_9<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace9() {
			checkInplaceRefs(9, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
			return matchInplace11_9(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 10th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace10() {
			checkInplaceRefs(10, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
			return matchInplace11_10(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 11th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity11_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> inplace11() {
			checkInplaceRefs(11, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
			return matchInplace11_11(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), hints);
		}

		/**
		 * Match then immediately run a type-unsafe {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Object apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 1st parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate1() {
			inplace1().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 2nd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate2() {
			inplace2().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 3rd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate3() {
			inplace3().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 4th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate4() {
			inplace4().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 5th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate5() {
			inplace5().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 6th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate6() {
			inplace6().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 7th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate7() {
			inplace7().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 8th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate8() {
			inplace8().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 9th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate9() {
			inplace9().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 10th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate10() {
			inplace10().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 11th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate11() {
			inplace11().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11)}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11)}));
		}
	}

	/**
	 * Builder with arity 11, input value given, output value given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 */
	public final class Arity11_IV_OV<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final I11 in11;
		private final O out;

		public Arity11_IV_OV(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final O out)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.in11 = in11;
			this.out = out;
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #compute() To match then immediately run a Computer Op using this builder's pre-allocated output.
		 */
		public Computers.Arity11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(out), OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Computers} op using the provided pre-allocated output.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public void compute() {
			computer().compute(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, out);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11)}, type(out)));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11)}, type(out)));
		}
	}
	/**
	 * Builder with arity 12, input type given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <O> The type of the output.
	 */
	public final class Arity12_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;
		private final Nil<I8> in8Type;
		private final Nil<I9> in9Type;
		private final Nil<I10> in10Type;
		private final Nil<I11> in11Type;
		private final Nil<I12> in12Type;
		private final Nil<O> outType;

		public Arity12_IT_OT(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<O> outType)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
			this.in8Type = in8Type;
			this.in9Type = in9Type;
			this.in10Type = in10Type;
			this.in11Type = in11Type;
			this.in12Type = in12Type;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op, based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> computer() {
			return matchComputer(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type}, outType));
		}
	}

	/**
	 * Builder with arity 12, input type given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 */
	public final class Arity12_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;
		private final Nil<I8> in8Type;
		private final Nil<I9> in9Type;
		private final Nil<I10> in10Type;
		private final Nil<I11> in11Type;
		private final Nil<I12> in12Type;

		public Arity12_IT_OU(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
			this.in8Type = in8Type;
			this.in9Type = in9Type;
			this.in10Type = in10Type;
			this.in11Type = in11Type;
			this.in12Type = in12Type;
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity12_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity12_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> outType(final Nil<O> outType) {
			return new Arity12_IT_OT<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 */
		public Functions.Arity12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, ?> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_1<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace1() {
			return matchInplace12_1(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_2<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace2() {
			return matchInplace12_2(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_3<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace3() {
			return matchInplace12_3(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_4<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace4() {
			return matchInplace12_4(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_5<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace5() {
			return matchInplace12_5(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_6<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace6() {
			return matchInplace12_6(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_7<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace7() {
			return matchInplace12_7(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 8th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_8<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace8() {
			return matchInplace12_8(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 9th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_9<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace9() {
			return matchInplace12_9(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 10th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace10() {
			return matchInplace12_10(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 11th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace11() {
			return matchInplace12_11(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 12th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace12() {
			return matchInplace12_12(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type}));
		}
	}

	/**
	 * Builder with arity 12, input value given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <O> The type of the output.
	 */
	public final class Arity12_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final I11 in11;
		private final I12 in12;
		private final Nil<O> outType;

		public Arity12_IV_OT(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final Nil<O> outType)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.in11 = in11;
			this.in12 = in12;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), outType, OpBuilder.this.hints);
		}
	
		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), outType, OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public O apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12)}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12)}, outType));
		}
	}

	/**
	 * Builder with arity 12, input value given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 */
	public final class Arity12_IV_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final I11 in11;
		private final I12 in12;

		public Arity12_IV_OU(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.in11 = in11;
			this.in12 = in12;
		}

		/**
		 * Matches with this builder will use the given pre-allocated output instance.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity12_IV_OV<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> output(final O out) {
			checkComputerRefs(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, out);
			return new Arity12_IV_OV<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, out);
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity12_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity12_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> outType(final Nil<O> outType) {
			return new Arity12_IV_OT<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Functions.Arity12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, ?> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_1<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace1() {
			checkInplaceRefs(1, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
			return matchInplace12_1(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_2<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace2() {
			checkInplaceRefs(2, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
			return matchInplace12_2(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_3<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace3() {
			checkInplaceRefs(3, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
			return matchInplace12_3(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_4<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace4() {
			checkInplaceRefs(4, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
			return matchInplace12_4(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_5<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace5() {
			checkInplaceRefs(5, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
			return matchInplace12_5(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_6<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace6() {
			checkInplaceRefs(6, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
			return matchInplace12_6(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_7<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace7() {
			checkInplaceRefs(7, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
			return matchInplace12_7(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 8th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_8<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace8() {
			checkInplaceRefs(8, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
			return matchInplace12_8(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 9th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_9<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace9() {
			checkInplaceRefs(9, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
			return matchInplace12_9(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 10th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace10() {
			checkInplaceRefs(10, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
			return matchInplace12_10(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 11th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace11() {
			checkInplaceRefs(11, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
			return matchInplace12_11(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 12th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity12_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> inplace12() {
			checkInplaceRefs(12, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
			return matchInplace12_12(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), hints);
		}

		/**
		 * Match then immediately run a type-unsafe {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Object apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 1st parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate1() {
			inplace1().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 2nd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate2() {
			inplace2().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 3rd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate3() {
			inplace3().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 4th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate4() {
			inplace4().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 5th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate5() {
			inplace5().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 6th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate6() {
			inplace6().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 7th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate7() {
			inplace7().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 8th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate8() {
			inplace8().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 9th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate9() {
			inplace9().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 10th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate10() {
			inplace10().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 11th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate11() {
			inplace11().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 12th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate12() {
			inplace12().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12)}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12)}));
		}
	}

	/**
	 * Builder with arity 12, input value given, output value given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 */
	public final class Arity12_IV_OV<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final I11 in11;
		private final I12 in12;
		private final O out;

		public Arity12_IV_OV(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final O out)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.in11 = in11;
			this.in12 = in12;
			this.out = out;
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #compute() To match then immediately run a Computer Op using this builder's pre-allocated output.
		 */
		public Computers.Arity12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(out), OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Computers} op using the provided pre-allocated output.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public void compute() {
			computer().compute(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, out);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12)}, type(out)));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12)}, type(out)));
		}
	}
	/**
	 * Builder with arity 13, input type given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 * @param <O> The type of the output.
	 */
	public final class Arity13_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;
		private final Nil<I8> in8Type;
		private final Nil<I9> in9Type;
		private final Nil<I10> in10Type;
		private final Nil<I11> in11Type;
		private final Nil<I12> in12Type;
		private final Nil<I13> in13Type;
		private final Nil<O> outType;

		public Arity13_IT_OT(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<O> outType)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
			this.in8Type = in8Type;
			this.in9Type = in9Type;
			this.in10Type = in10Type;
			this.in11Type = in11Type;
			this.in12Type = in12Type;
			this.in13Type = in13Type;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op, based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> computer() {
			return matchComputer(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type}, outType));
		}
	}

	/**
	 * Builder with arity 13, input type given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 */
	public final class Arity13_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;
		private final Nil<I8> in8Type;
		private final Nil<I9> in9Type;
		private final Nil<I10> in10Type;
		private final Nil<I11> in11Type;
		private final Nil<I12> in12Type;
		private final Nil<I13> in13Type;

		public Arity13_IT_OU(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
			this.in8Type = in8Type;
			this.in9Type = in9Type;
			this.in10Type = in10Type;
			this.in11Type = in11Type;
			this.in12Type = in12Type;
			this.in13Type = in13Type;
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity13_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity13_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> outType(final Nil<O> outType) {
			return new Arity13_IT_OT<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 */
		public Functions.Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, ?> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_1<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace1() {
			return matchInplace13_1(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_2<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace2() {
			return matchInplace13_2(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_3<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace3() {
			return matchInplace13_3(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_4<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace4() {
			return matchInplace13_4(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_5<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace5() {
			return matchInplace13_5(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_6<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace6() {
			return matchInplace13_6(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_7<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace7() {
			return matchInplace13_7(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 8th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_8<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace8() {
			return matchInplace13_8(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 9th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_9<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace9() {
			return matchInplace13_9(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 10th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace10() {
			return matchInplace13_10(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 11th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace11() {
			return matchInplace13_11(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 12th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace12() {
			return matchInplace13_12(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 13th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace13() {
			return matchInplace13_13(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type}));
		}
	}

	/**
	 * Builder with arity 13, input value given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 * @param <O> The type of the output.
	 */
	public final class Arity13_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final I11 in11;
		private final I12 in12;
		private final I13 in13;
		private final Nil<O> outType;

		public Arity13_IV_OT(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13, final Nil<O> outType)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.in11 = in11;
			this.in12 = in12;
			this.in13 = in13;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), outType, OpBuilder.this.hints);
		}
	
		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), outType, OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public O apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13)}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13)}, outType));
		}
	}

	/**
	 * Builder with arity 13, input value given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 */
	public final class Arity13_IV_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final I11 in11;
		private final I12 in12;
		private final I13 in13;

		public Arity13_IV_OU(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.in11 = in11;
			this.in12 = in12;
			this.in13 = in13;
		}

		/**
		 * Matches with this builder will use the given pre-allocated output instance.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity13_IV_OV<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> output(final O out) {
			checkComputerRefs(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, out);
			return new Arity13_IV_OV<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, out);
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity13_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity13_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> outType(final Nil<O> outType) {
			return new Arity13_IV_OT<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Functions.Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, ?> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_1<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace1() {
			checkInplaceRefs(1, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
			return matchInplace13_1(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_2<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace2() {
			checkInplaceRefs(2, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
			return matchInplace13_2(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_3<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace3() {
			checkInplaceRefs(3, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
			return matchInplace13_3(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_4<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace4() {
			checkInplaceRefs(4, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
			return matchInplace13_4(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_5<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace5() {
			checkInplaceRefs(5, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
			return matchInplace13_5(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_6<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace6() {
			checkInplaceRefs(6, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
			return matchInplace13_6(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_7<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace7() {
			checkInplaceRefs(7, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
			return matchInplace13_7(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 8th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_8<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace8() {
			checkInplaceRefs(8, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
			return matchInplace13_8(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 9th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_9<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace9() {
			checkInplaceRefs(9, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
			return matchInplace13_9(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 10th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace10() {
			checkInplaceRefs(10, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
			return matchInplace13_10(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 11th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace11() {
			checkInplaceRefs(11, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
			return matchInplace13_11(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 12th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace12() {
			checkInplaceRefs(12, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
			return matchInplace13_12(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 13th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity13_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> inplace13() {
			checkInplaceRefs(13, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
			return matchInplace13_13(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), hints);
		}

		/**
		 * Match then immediately run a type-unsafe {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Object apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 1st parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate1() {
			inplace1().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 2nd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate2() {
			inplace2().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 3rd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate3() {
			inplace3().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 4th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate4() {
			inplace4().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 5th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate5() {
			inplace5().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 6th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate6() {
			inplace6().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 7th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate7() {
			inplace7().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 8th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate8() {
			inplace8().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 9th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate9() {
			inplace9().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 10th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate10() {
			inplace10().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 11th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate11() {
			inplace11().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 12th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate12() {
			inplace12().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 13th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate13() {
			inplace13().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13)}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13)}));
		}
	}

	/**
	 * Builder with arity 13, input value given, output value given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 */
	public final class Arity13_IV_OV<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final I11 in11;
		private final I12 in12;
		private final I13 in13;
		private final O out;

		public Arity13_IV_OV(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13, final O out)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.in11 = in11;
			this.in12 = in12;
			this.in13 = in13;
			this.out = out;
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #compute() To match then immediately run a Computer Op using this builder's pre-allocated output.
		 */
		public Computers.Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(out), OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Computers} op using the provided pre-allocated output.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public void compute() {
			computer().compute(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, out);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13)}, type(out)));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13)}, type(out)));
		}
	}
	/**
	 * Builder with arity 14, input type given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 * @param <I14> The type of input 14.
	 * @param <O> The type of the output.
	 */
	public final class Arity14_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;
		private final Nil<I8> in8Type;
		private final Nil<I9> in9Type;
		private final Nil<I10> in10Type;
		private final Nil<I11> in11Type;
		private final Nil<I12> in12Type;
		private final Nil<I13> in13Type;
		private final Nil<I14> in14Type;
		private final Nil<O> outType;

		public Arity14_IT_OT(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<O> outType)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
			this.in8Type = in8Type;
			this.in9Type = in9Type;
			this.in10Type = in10Type;
			this.in11Type = in11Type;
			this.in12Type = in12Type;
			this.in13Type = in13Type;
			this.in14Type = in14Type;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op, based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> computer() {
			return matchComputer(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type}, outType));
		}
	}

	/**
	 * Builder with arity 14, input type given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 * @param <I14> The type of input 14.
	 */
	public final class Arity14_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;
		private final Nil<I8> in8Type;
		private final Nil<I9> in9Type;
		private final Nil<I10> in10Type;
		private final Nil<I11> in11Type;
		private final Nil<I12> in12Type;
		private final Nil<I13> in13Type;
		private final Nil<I14> in14Type;

		public Arity14_IT_OU(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
			this.in8Type = in8Type;
			this.in9Type = in9Type;
			this.in10Type = in10Type;
			this.in11Type = in11Type;
			this.in12Type = in12Type;
			this.in13Type = in13Type;
			this.in14Type = in14Type;
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity14_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity14_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> outType(final Nil<O> outType) {
			return new Arity14_IT_OT<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 */
		public Functions.Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, ?> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_1<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace1() {
			return matchInplace14_1(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_2<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace2() {
			return matchInplace14_2(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_3<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace3() {
			return matchInplace14_3(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_4<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace4() {
			return matchInplace14_4(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_5<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace5() {
			return matchInplace14_5(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_6<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace6() {
			return matchInplace14_6(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_7<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace7() {
			return matchInplace14_7(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 8th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_8<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace8() {
			return matchInplace14_8(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 9th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_9<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace9() {
			return matchInplace14_9(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 10th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace10() {
			return matchInplace14_10(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 11th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace11() {
			return matchInplace14_11(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 12th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace12() {
			return matchInplace14_12(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 13th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace13() {
			return matchInplace14_13(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 14th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace14() {
			return matchInplace14_14(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type}));
		}
	}

	/**
	 * Builder with arity 14, input value given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 * @param <I14> The type of input 14.
	 * @param <O> The type of the output.
	 */
	public final class Arity14_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final I11 in11;
		private final I12 in12;
		private final I13 in13;
		private final I14 in14;
		private final Nil<O> outType;

		public Arity14_IV_OT(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13, final I14 in14, final Nil<O> outType)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.in11 = in11;
			this.in12 = in12;
			this.in13 = in13;
			this.in14 = in14;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), outType, OpBuilder.this.hints);
		}
	
		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), outType, OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public O apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14)}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14)}, outType));
		}
	}

	/**
	 * Builder with arity 14, input value given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 * @param <I14> The type of input 14.
	 */
	public final class Arity14_IV_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final I11 in11;
		private final I12 in12;
		private final I13 in13;
		private final I14 in14;

		public Arity14_IV_OU(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13, final I14 in14)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.in11 = in11;
			this.in12 = in12;
			this.in13 = in13;
			this.in14 = in14;
		}

		/**
		 * Matches with this builder will use the given pre-allocated output instance.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity14_IV_OV<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> output(final O out) {
			checkComputerRefs(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, out);
			return new Arity14_IV_OV<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, out);
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity14_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity14_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> outType(final Nil<O> outType) {
			return new Arity14_IV_OT<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Functions.Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, ?> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_1<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace1() {
			checkInplaceRefs(1, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
			return matchInplace14_1(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_2<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace2() {
			checkInplaceRefs(2, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
			return matchInplace14_2(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_3<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace3() {
			checkInplaceRefs(3, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
			return matchInplace14_3(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_4<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace4() {
			checkInplaceRefs(4, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
			return matchInplace14_4(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_5<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace5() {
			checkInplaceRefs(5, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
			return matchInplace14_5(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_6<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace6() {
			checkInplaceRefs(6, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
			return matchInplace14_6(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_7<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace7() {
			checkInplaceRefs(7, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
			return matchInplace14_7(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 8th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_8<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace8() {
			checkInplaceRefs(8, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
			return matchInplace14_8(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 9th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_9<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace9() {
			checkInplaceRefs(9, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
			return matchInplace14_9(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 10th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace10() {
			checkInplaceRefs(10, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
			return matchInplace14_10(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 11th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace11() {
			checkInplaceRefs(11, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
			return matchInplace14_11(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 12th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace12() {
			checkInplaceRefs(12, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
			return matchInplace14_12(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 13th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace13() {
			checkInplaceRefs(13, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
			return matchInplace14_13(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 14th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity14_14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> inplace14() {
			checkInplaceRefs(14, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
			return matchInplace14_14(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), hints);
		}

		/**
		 * Match then immediately run a type-unsafe {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Object apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 1st parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate1() {
			inplace1().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 2nd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate2() {
			inplace2().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 3rd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate3() {
			inplace3().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 4th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate4() {
			inplace4().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 5th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate5() {
			inplace5().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 6th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate6() {
			inplace6().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 7th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate7() {
			inplace7().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 8th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate8() {
			inplace8().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 9th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate9() {
			inplace9().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 10th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate10() {
			inplace10().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 11th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate11() {
			inplace11().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 12th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate12() {
			inplace12().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 13th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate13() {
			inplace13().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 14th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate14() {
			inplace14().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14)}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14)}));
		}
	}

	/**
	 * Builder with arity 14, input value given, output value given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 * @param <I14> The type of input 14.
	 */
	public final class Arity14_IV_OV<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final I11 in11;
		private final I12 in12;
		private final I13 in13;
		private final I14 in14;
		private final O out;

		public Arity14_IV_OV(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13, final I14 in14, final O out)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.in11 = in11;
			this.in12 = in12;
			this.in13 = in13;
			this.in14 = in14;
			this.out = out;
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #compute() To match then immediately run a Computer Op using this builder's pre-allocated output.
		 */
		public Computers.Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(out), OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Computers} op using the provided pre-allocated output.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public void compute() {
			computer().compute(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, out);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14)}, type(out)));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14)}, type(out)));
		}
	}
	/**
	 * Builder with arity 15, input type given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 * @param <I14> The type of input 14.
	 * @param <I15> The type of input 15.
	 * @param <O> The type of the output.
	 */
	public final class Arity15_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;
		private final Nil<I8> in8Type;
		private final Nil<I9> in9Type;
		private final Nil<I10> in10Type;
		private final Nil<I11> in11Type;
		private final Nil<I12> in12Type;
		private final Nil<I13> in13Type;
		private final Nil<I14> in14Type;
		private final Nil<I15> in15Type;
		private final Nil<O> outType;

		public Arity15_IT_OT(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<O> outType)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
			this.in8Type = in8Type;
			this.in9Type = in9Type;
			this.in10Type = in10Type;
			this.in11Type = in11Type;
			this.in12Type = in12Type;
			this.in13Type = in13Type;
			this.in14Type = in14Type;
			this.in15Type = in15Type;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op, based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> computer() {
			return matchComputer(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type}, outType));
		}
	}

	/**
	 * Builder with arity 15, input type given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 * @param <I14> The type of input 14.
	 * @param <I15> The type of input 15.
	 */
	public final class Arity15_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;
		private final Nil<I8> in8Type;
		private final Nil<I9> in9Type;
		private final Nil<I10> in10Type;
		private final Nil<I11> in11Type;
		private final Nil<I12> in12Type;
		private final Nil<I13> in13Type;
		private final Nil<I14> in14Type;
		private final Nil<I15> in15Type;

		public Arity15_IT_OU(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
			this.in8Type = in8Type;
			this.in9Type = in9Type;
			this.in10Type = in10Type;
			this.in11Type = in11Type;
			this.in12Type = in12Type;
			this.in13Type = in13Type;
			this.in14Type = in14Type;
			this.in15Type = in15Type;
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity15_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity15_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> outType(final Nil<O> outType) {
			return new Arity15_IT_OT<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 */
		public Functions.Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, ?> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_1<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace1() {
			return matchInplace15_1(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_2<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace2() {
			return matchInplace15_2(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_3<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace3() {
			return matchInplace15_3(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_4<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace4() {
			return matchInplace15_4(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_5<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace5() {
			return matchInplace15_5(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_6<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace6() {
			return matchInplace15_6(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_7<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace7() {
			return matchInplace15_7(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 8th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_8<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace8() {
			return matchInplace15_8(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 9th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_9<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace9() {
			return matchInplace15_9(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 10th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace10() {
			return matchInplace15_10(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 11th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace11() {
			return matchInplace15_11(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 12th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace12() {
			return matchInplace15_12(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 13th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace13() {
			return matchInplace15_13(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 14th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace14() {
			return matchInplace15_14(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 15th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace15() {
			return matchInplace15_15(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type}));
		}
	}

	/**
	 * Builder with arity 15, input value given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 * @param <I14> The type of input 14.
	 * @param <I15> The type of input 15.
	 * @param <O> The type of the output.
	 */
	public final class Arity15_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final I11 in11;
		private final I12 in12;
		private final I13 in13;
		private final I14 in14;
		private final I15 in15;
		private final Nil<O> outType;

		public Arity15_IV_OT(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13, final I14 in14, final I15 in15, final Nil<O> outType)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.in11 = in11;
			this.in12 = in12;
			this.in13 = in13;
			this.in14 = in14;
			this.in15 = in15;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), outType, OpBuilder.this.hints);
		}
	
		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), outType, OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public O apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15)}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15)}, outType));
		}
	}

	/**
	 * Builder with arity 15, input value given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 * @param <I14> The type of input 14.
	 * @param <I15> The type of input 15.
	 */
	public final class Arity15_IV_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final I11 in11;
		private final I12 in12;
		private final I13 in13;
		private final I14 in14;
		private final I15 in15;

		public Arity15_IV_OU(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13, final I14 in14, final I15 in15)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.in11 = in11;
			this.in12 = in12;
			this.in13 = in13;
			this.in14 = in14;
			this.in15 = in15;
		}

		/**
		 * Matches with this builder will use the given pre-allocated output instance.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity15_IV_OV<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> output(final O out) {
			checkComputerRefs(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, out);
			return new Arity15_IV_OV<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, out);
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity15_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity15_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> outType(final Nil<O> outType) {
			return new Arity15_IV_OT<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Functions.Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, ?> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_1<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace1() {
			checkInplaceRefs(1, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
			return matchInplace15_1(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_2<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace2() {
			checkInplaceRefs(2, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
			return matchInplace15_2(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_3<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace3() {
			checkInplaceRefs(3, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
			return matchInplace15_3(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_4<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace4() {
			checkInplaceRefs(4, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
			return matchInplace15_4(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_5<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace5() {
			checkInplaceRefs(5, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
			return matchInplace15_5(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_6<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace6() {
			checkInplaceRefs(6, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
			return matchInplace15_6(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_7<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace7() {
			checkInplaceRefs(7, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
			return matchInplace15_7(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 8th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_8<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace8() {
			checkInplaceRefs(8, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
			return matchInplace15_8(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 9th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_9<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace9() {
			checkInplaceRefs(9, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
			return matchInplace15_9(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 10th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace10() {
			checkInplaceRefs(10, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
			return matchInplace15_10(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 11th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace11() {
			checkInplaceRefs(11, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
			return matchInplace15_11(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 12th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace12() {
			checkInplaceRefs(12, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
			return matchInplace15_12(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 13th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace13() {
			checkInplaceRefs(13, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
			return matchInplace15_13(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 14th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace14() {
			checkInplaceRefs(14, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
			return matchInplace15_14(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 15th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity15_15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> inplace15() {
			checkInplaceRefs(15, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
			return matchInplace15_15(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), hints);
		}

		/**
		 * Match then immediately run a type-unsafe {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Object apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 1st parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate1() {
			inplace1().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 2nd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate2() {
			inplace2().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 3rd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate3() {
			inplace3().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 4th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate4() {
			inplace4().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 5th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate5() {
			inplace5().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 6th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate6() {
			inplace6().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 7th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate7() {
			inplace7().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 8th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate8() {
			inplace8().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 9th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate9() {
			inplace9().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 10th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate10() {
			inplace10().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 11th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate11() {
			inplace11().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 12th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate12() {
			inplace12().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 13th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate13() {
			inplace13().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 14th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate14() {
			inplace14().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 15th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate15() {
			inplace15().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15)}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15)}));
		}
	}

	/**
	 * Builder with arity 15, input value given, output value given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 * @param <I14> The type of input 14.
	 * @param <I15> The type of input 15.
	 */
	public final class Arity15_IV_OV<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final I11 in11;
		private final I12 in12;
		private final I13 in13;
		private final I14 in14;
		private final I15 in15;
		private final O out;

		public Arity15_IV_OV(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13, final I14 in14, final I15 in15, final O out)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.in11 = in11;
			this.in12 = in12;
			this.in13 = in13;
			this.in14 = in14;
			this.in15 = in15;
			this.out = out;
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #compute() To match then immediately run a Computer Op using this builder's pre-allocated output.
		 */
		public Computers.Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(out), OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Computers} op using the provided pre-allocated output.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public void compute() {
			computer().compute(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, out);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15)}, type(out)));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15)}, type(out)));
		}
	}
	/**
	 * Builder with arity 16, input type given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 * @param <I14> The type of input 14.
	 * @param <I15> The type of input 15.
	 * @param <I16> The type of input 16.
	 * @param <O> The type of the output.
	 */
	public final class Arity16_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;
		private final Nil<I8> in8Type;
		private final Nil<I9> in9Type;
		private final Nil<I10> in10Type;
		private final Nil<I11> in11Type;
		private final Nil<I12> in12Type;
		private final Nil<I13> in13Type;
		private final Nil<I14> in14Type;
		private final Nil<I15> in15Type;
		private final Nil<I16> in16Type;
		private final Nil<O> outType;

		public Arity16_IT_OT(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type, final Nil<O> outType)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
			this.in8Type = in8Type;
			this.in9Type = in9Type;
			this.in10Type = in10Type;
			this.in11Type = in11Type;
			this.in12Type = in12Type;
			this.in13Type = in13Type;
			this.in14Type = in14Type;
			this.in15Type = in15Type;
			this.in16Type = in16Type;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op, based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> computer() {
			return matchComputer(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, outType, OpBuilder.this.hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type}, outType));
		}
	}

	/**
	 * Builder with arity 16, input type given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 * @param <I14> The type of input 14.
	 * @param <I15> The type of input 15.
	 * @param <I16> The type of input 16.
	 */
	public final class Arity16_IT_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> extends Arity {

		private final Nil<I1> in1Type;
		private final Nil<I2> in2Type;
		private final Nil<I3> in3Type;
		private final Nil<I4> in4Type;
		private final Nil<I5> in5Type;
		private final Nil<I6> in6Type;
		private final Nil<I7> in7Type;
		private final Nil<I8> in8Type;
		private final Nil<I9> in9Type;
		private final Nil<I10> in10Type;
		private final Nil<I11> in11Type;
		private final Nil<I12> in12Type;
		private final Nil<I13> in13Type;
		private final Nil<I14> in14Type;
		private final Nil<I15> in15Type;
		private final Nil<I16> in16Type;

		public Arity16_IT_OU(final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type)
		{
			this.in1Type = in1Type;
			this.in2Type = in2Type;
			this.in3Type = in3Type;
			this.in4Type = in4Type;
			this.in5Type = in5Type;
			this.in6Type = in6Type;
			this.in7Type = in7Type;
			this.in8Type = in8Type;
			this.in9Type = in9Type;
			this.in10Type = in10Type;
			this.in11Type = in11Type;
			this.in12Type = in12Type;
			this.in13Type = in13Type;
			this.in14Type = in14Type;
			this.in15Type = in15Type;
			this.in16Type = in16Type;
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity16_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity16_IT_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> outType(final Nil<O> outType) {
			return new Arity16_IT_OT<>(in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 */
		public Functions.Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, ?> function() {
			return matchFunction(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_1<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace1() {
			return matchInplace16_1(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_2<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace2() {
			return matchInplace16_2(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_3<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace3() {
			return matchInplace16_3(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_4<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace4() {
			return matchInplace16_4(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_5<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace5() {
			return matchInplace16_5(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_6<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace6() {
			return matchInplace16_6(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_7<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace7() {
			return matchInplace16_7(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 8th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_8<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace8() {
			return matchInplace16_8(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 9th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_9<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace9() {
			return matchInplace16_9(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 10th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace10() {
			return matchInplace16_10(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 11th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace11() {
			return matchInplace16_11(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 12th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace12() {
			return matchInplace16_12(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 13th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace13() {
			return matchInplace16_13(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 14th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace14() {
			return matchInplace16_14(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 15th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace15() {
			return matchInplace16_15(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 16th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace16() {
			return matchInplace16_16(env, opName, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type, hints);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type}));
		}
	}

	/**
	 * Builder with arity 16, input value given, output type given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 * @param <I14> The type of input 14.
	 * @param <I15> The type of input 15.
	 * @param <I16> The type of input 16.
	 * @param <O> The type of the output.
	 */
	public final class Arity16_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final I11 in11;
		private final I12 in12;
		private final I13 in13;
		private final I14 in14;
		private final I15 in15;
		private final I16 in16;
		private final Nil<O> outType;

		public Arity16_IV_OT(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13, final I14 in14, final I15 in15, final I16 in16, final Nil<O> outType)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.in11 = in11;
			this.in12 = in12;
			this.in13 = in13;
			this.in14 = in14;
			this.in15 = in15;
			this.in16 = in16;
			this.outType = outType;
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public Functions.Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), outType, OpBuilder.this.hints);
		}
	
		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public Computers.Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), outType, OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 */
		public O apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16)}, outType));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16)}, outType));
		}
	}

	/**
	 * Builder with arity 16, input value given, output unspecified.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 * @param <I14> The type of input 14.
	 * @param <I15> The type of input 15.
	 * @param <I16> The type of input 16.
	 */
	public final class Arity16_IV_OU<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final I11 in11;
		private final I12 in12;
		private final I13 in13;
		private final I14 in14;
		private final I15 in15;
		private final I16 in16;

		public Arity16_IV_OU(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13, final I14 in14, final I15 in15, final I16 in16)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.in11 = in11;
			this.in12 = in12;
			this.in13 = in13;
			this.in14 = in14;
			this.in15 = in15;
			this.in16 = in16;
		}

		/**
		 * Matches with this builder will use the given pre-allocated output instance.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity16_IV_OV<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> output(final O out) {
			checkComputerRefs(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16, out);
			return new Arity16_IV_OV<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16, out);
		}

		/**
		 * Matches with this builder will use the indicated output class.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public <O> Arity16_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> outType(final Class<O> outType) {
			return outType(Nil.of(outType));
		}

		/**
		 * Matches with this builder will use the output type of the indicated {@code Nil}'s generic parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 */
		public <O> Arity16_IV_OT<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> outType(final Nil<O> outType) {
			return new Arity16_IV_OT<>(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16, outType);
		}

		/**
		 * Match a {@link Functions} op based on the choices made with this builder.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Functions.Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, ?> function() {
			return matchFunction(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), Nil.of(Any.class), OpBuilder.this.hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 1st parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_1<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace1() {
			checkInplaceRefs(1, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
			return matchInplace16_1(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 2nd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_2<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace2() {
			checkInplaceRefs(2, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
			return matchInplace16_2(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 3rd parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_3<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace3() {
			checkInplaceRefs(3, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
			return matchInplace16_3(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 4th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_4<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace4() {
			checkInplaceRefs(4, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
			return matchInplace16_4(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 5th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_5<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace5() {
			checkInplaceRefs(5, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
			return matchInplace16_5(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 6th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_6<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace6() {
			checkInplaceRefs(6, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
			return matchInplace16_6(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 7th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_7<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace7() {
			checkInplaceRefs(7, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
			return matchInplace16_7(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 8th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_8<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace8() {
			checkInplaceRefs(8, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
			return matchInplace16_8(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 9th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_9<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace9() {
			checkInplaceRefs(9, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
			return matchInplace16_9(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 10th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace10() {
			checkInplaceRefs(10, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
			return matchInplace16_10(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 11th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace11() {
			checkInplaceRefs(11, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
			return matchInplace16_11(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 12th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace12() {
			checkInplaceRefs(12, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
			return matchInplace16_12(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 13th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace13() {
			checkInplaceRefs(13, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
			return matchInplace16_13(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 14th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace14() {
			checkInplaceRefs(14, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
			return matchInplace16_14(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 15th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace15() {
			checkInplaceRefs(15, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
			return matchInplace16_15(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), hints);
		}

		/**
		 * Match an {@link Inplaces} op, based on the choices made with this builder, to mutate the 16th parameter.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Inplaces.Arity16_16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> inplace16() {
			checkInplaceRefs(16, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
			return matchInplace16_16(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), hints);
		}

		/**
		 * Match then immediately run a type-unsafe {@link Functions} op and get its output.
		 *
		 * @return The output of this function
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #mutate1() To match then immediately run an Inplace Op modifying a provided input parameter.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public Object apply() {
			return function().apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 1st parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate1() {
			inplace1().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 2nd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate2() {
			inplace2().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 3rd parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate3() {
			inplace3().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 4th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate4() {
			inplace4().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 5th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate5() {
			inplace5().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 6th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate6() {
			inplace6().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 7th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate7() {
			inplace7().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 8th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate8() {
			inplace8().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 9th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate9() {
			inplace9().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 10th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate10() {
			inplace10().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 11th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate11() {
			inplace11().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 12th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate12() {
			inplace12().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 13th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate13() {
			inplace13().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 14th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate14() {
			inplace14().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 15th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate15() {
			inplace15().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
		}

		/**
		 * Match then immediately run an {@link Inplaces} op to mutate the 16th parameter.
		 *
		 * @see #apply() To match then immediately run a Function Op using the input values provided to this builder.
		 * @see #function() For a reusable Op that generates output instances based on its inputs.
		 * @see #inplace1() For a reusable Op that modifies a provided input parameter in-place.
		 * @see #output(Object) To specify a concrete output instance. (e.g. pre-allocated for Computers)
		 * @see #outType(Class) To specify the output type without providing a concrete instance.
		 * @see #outType(Nil) To specify the output type, preserving its generic parameters.
		 */
		public void mutate16() {
			inplace16().mutate(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16)}));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16)}));
		}
	}

	/**
	 * Builder with arity 16, input value given, output value given.
	 *
	 * @author Curtis Rueden
	 * @param <I1> The type of input 1.
	 * @param <I2> The type of input 2.
	 * @param <I3> The type of input 3.
	 * @param <I4> The type of input 4.
	 * @param <I5> The type of input 5.
	 * @param <I6> The type of input 6.
	 * @param <I7> The type of input 7.
	 * @param <I8> The type of input 8.
	 * @param <I9> The type of input 9.
	 * @param <I10> The type of input 10.
	 * @param <I11> The type of input 11.
	 * @param <I12> The type of input 12.
	 * @param <I13> The type of input 13.
	 * @param <I14> The type of input 14.
	 * @param <I15> The type of input 15.
	 * @param <I16> The type of input 16.
	 */
	public final class Arity16_IV_OV<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> extends Arity {

		private final I1 in1;
		private final I2 in2;
		private final I3 in3;
		private final I4 in4;
		private final I5 in5;
		private final I6 in6;
		private final I7 in7;
		private final I8 in8;
		private final I9 in9;
		private final I10 in10;
		private final I11 in11;
		private final I12 in12;
		private final I13 in13;
		private final I14 in14;
		private final I15 in15;
		private final I16 in16;
		private final O out;

		public Arity16_IV_OV(final I1 in1, final I2 in2, final I3 in3, final I4 in4, final I5 in5, final I6 in6, final I7 in7, final I8 in8, final I9 in9, final I10 in10, final I11 in11, final I12 in12, final I13 in13, final I14 in14, final I15 in15, final I16 in16, final O out)
		{
			this.in1 = in1;
			this.in2 = in2;
			this.in3 = in3;
			this.in4 = in4;
			this.in5 = in5;
			this.in6 = in6;
			this.in7 = in7;
			this.in8 = in8;
			this.in9 = in9;
			this.in10 = in10;
			this.in11 = in11;
			this.in12 = in12;
			this.in13 = in13;
			this.in14 = in14;
			this.in15 = in15;
			this.in16 = in16;
			this.out = out;
		}

		/**
		 * Match a {@link Computers} op, based on the choices made with this builder, for operating on pre-allocated output.
		 *
		 * @return An instance of the matched op, e.g. for reuse.
		 *
		 * @throws OpMatchingException if the Op request cannot be satisfied.
		 *
		 * @see #compute() To match then immediately run a Computer Op using this builder's pre-allocated output.
		 */
		public Computers.Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> computer() {
			return matchComputer(env, opName, type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16), type(out), OpBuilder.this.hints);
		}

		/**
		 * Match then immediately run a {@link Computers} op using the provided pre-allocated output.
		 *
		 * @see #computer() For a reusable Op to process pre-allocated outputs without re-matching.
		 */
		public void compute() {
			computer().compute(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16, out);
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a simple entry for each Op satisfying the partial request
		 */
		public String help() {
			return env.help(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16)}, type(out)));
		}

		/**
		 * Finds all Ops matching the current partial OpBuilder request
		 * @return a {@link String} with a verbose entry for each Op satisfying the partial request
		 */
		public String helpVerbose() {
			return env.helpVerbose(new PartialOpRequest(opName, new Nil<?>[] {type(in1), type(in2), type(in3), type(in4), type(in5), type(in6), type(in7), type(in8), type(in9), type(in10), type(in11), type(in12), type(in13), type(in14), type(in15), type(in16)}, type(out)));
		}
	}

	/**
	 * Static utility method to match a {@link Functions} op with 0 inputs.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <O> Producer<O> matchFunction(final OpEnvironment env, final String opName, final Nil<O> outType)
	{
		return matchFunctionHelper(env, opName, Producer.class, outType);
	}

	/**
	 * Static utility method to match a {@link Functions} op with 1 input.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchInplace(OpEnvironment, String, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, O> Function<I1, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<O> outType)
	{
		return matchFunctionHelper(env, opName, Function.class, outType, in1Type);
	}

	/**
	 * Static utility method to match a {@link Functions} op with 2 inputs.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchInplace2_1(OpEnvironment, String, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, O> BiFunction<I1, I2, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<O> outType)
	{
		return matchFunctionHelper(env, opName, BiFunction.class, outType, in1Type, in2Type);
	}

	/**
	 * Static utility method to match a {@link Functions} op with 3 inputs.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchInplace3_1(OpEnvironment, String, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, O> Functions.Arity3<I1, I2, I3, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<O> outType)
	{
		return matchFunctionHelper(env, opName, Functions.Arity3.class, outType, in1Type, in2Type, in3Type);
	}

	/**
	 * Static utility method to match a {@link Functions} op with 4 inputs.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchInplace4_1(OpEnvironment, String, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, O> Functions.Arity4<I1, I2, I3, I4, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<O> outType)
	{
		return matchFunctionHelper(env, opName, Functions.Arity4.class, outType, in1Type, in2Type, in3Type, in4Type);
	}

	/**
	 * Static utility method to match a {@link Functions} op with 5 inputs.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchInplace5_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, O> Functions.Arity5<I1, I2, I3, I4, I5, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<O> outType)
	{
		return matchFunctionHelper(env, opName, Functions.Arity5.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type);
	}

	/**
	 * Static utility method to match a {@link Functions} op with 6 inputs.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchInplace6_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, O> Functions.Arity6<I1, I2, I3, I4, I5, I6, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<O> outType)
	{
		return matchFunctionHelper(env, opName, Functions.Arity6.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type);
	}

	/**
	 * Static utility method to match a {@link Functions} op with 7 inputs.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchInplace7_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, O> Functions.Arity7<I1, I2, I3, I4, I5, I6, I7, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<O> outType)
	{
		return matchFunctionHelper(env, opName, Functions.Arity7.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type);
	}

	/**
	 * Static utility method to match a {@link Functions} op with 8 inputs.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchInplace8_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, O> Functions.Arity8<I1, I2, I3, I4, I5, I6, I7, I8, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<O> outType)
	{
		return matchFunctionHelper(env, opName, Functions.Arity8.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type);
	}

	/**
	 * Static utility method to match a {@link Functions} op with 9 inputs.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchInplace9_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, O> Functions.Arity9<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<O> outType)
	{
		return matchFunctionHelper(env, opName, Functions.Arity9.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type);
	}

	/**
	 * Static utility method to match a {@link Functions} op with 10 inputs.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchInplace10_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> Functions.Arity10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<O> outType)
	{
		return matchFunctionHelper(env, opName, Functions.Arity10.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type);
	}

	/**
	 * Static utility method to match a {@link Functions} op with 11 inputs.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchInplace11_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> Functions.Arity11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<O> outType)
	{
		return matchFunctionHelper(env, opName, Functions.Arity11.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type);
	}

	/**
	 * Static utility method to match a {@link Functions} op with 12 inputs.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchInplace12_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> Functions.Arity12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<O> outType)
	{
		return matchFunctionHelper(env, opName, Functions.Arity12.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type);
	}

	/**
	 * Static utility method to match a {@link Functions} op with 13 inputs.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchInplace13_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> Functions.Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<O> outType)
	{
		return matchFunctionHelper(env, opName, Functions.Arity13.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type);
	}

	/**
	 * Static utility method to match a {@link Functions} op with 14 inputs.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchInplace14_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> Functions.Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<O> outType)
	{
		return matchFunctionHelper(env, opName, Functions.Arity14.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type);
	}

	/**
	 * Static utility method to match a {@link Functions} op with 15 inputs.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchInplace15_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> Functions.Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<O> outType)
	{
		return matchFunctionHelper(env, opName, Functions.Arity15.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type);
	}

	/**
	 * Static utility method to match a {@link Functions} op with 16 inputs.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchInplace16_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> Functions.Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type, final Nil<O> outType)
	{
		return matchFunctionHelper(env, opName, Functions.Arity16.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type);
	}

	/**
	 * As {@link OpBuilder#matchFunction}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <O> Producer<O> matchFunction(final OpEnvironment env, final String opName, final Nil<O> outType, final Hints hints)
	{
		return matchFunctionHelper(env, opName, hints, Producer.class, outType);
	}

	/**
	 * As {@link OpBuilder#matchFunction}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, O> Function<I1, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<O> outType, final Hints hints)
	{
		return matchFunctionHelper(env, opName, hints, Function.class, outType, in1Type);
	}

	/**
	 * As {@link OpBuilder#matchFunction}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, O> BiFunction<I1, I2, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<O> outType, final Hints hints)
	{
		return matchFunctionHelper(env, opName, hints, BiFunction.class, outType, in1Type, in2Type);
	}

	/**
	 * As {@link OpBuilder#matchFunction}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, O> Functions.Arity3<I1, I2, I3, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<O> outType, final Hints hints)
	{
		return matchFunctionHelper(env, opName, hints, Functions.Arity3.class, outType, in1Type, in2Type, in3Type);
	}

	/**
	 * As {@link OpBuilder#matchFunction}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, O> Functions.Arity4<I1, I2, I3, I4, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<O> outType, final Hints hints)
	{
		return matchFunctionHelper(env, opName, hints, Functions.Arity4.class, outType, in1Type, in2Type, in3Type, in4Type);
	}

	/**
	 * As {@link OpBuilder#matchFunction}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, O> Functions.Arity5<I1, I2, I3, I4, I5, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<O> outType, final Hints hints)
	{
		return matchFunctionHelper(env, opName, hints, Functions.Arity5.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type);
	}

	/**
	 * As {@link OpBuilder#matchFunction}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, O> Functions.Arity6<I1, I2, I3, I4, I5, I6, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<O> outType, final Hints hints)
	{
		return matchFunctionHelper(env, opName, hints, Functions.Arity6.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type);
	}

	/**
	 * As {@link OpBuilder#matchFunction}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, O> Functions.Arity7<I1, I2, I3, I4, I5, I6, I7, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<O> outType, final Hints hints)
	{
		return matchFunctionHelper(env, opName, hints, Functions.Arity7.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type);
	}

	/**
	 * As {@link OpBuilder#matchFunction}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, O> Functions.Arity8<I1, I2, I3, I4, I5, I6, I7, I8, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<O> outType, final Hints hints)
	{
		return matchFunctionHelper(env, opName, hints, Functions.Arity8.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type);
	}

	/**
	 * As {@link OpBuilder#matchFunction}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, O> Functions.Arity9<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<O> outType, final Hints hints)
	{
		return matchFunctionHelper(env, opName, hints, Functions.Arity9.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type);
	}

	/**
	 * As {@link OpBuilder#matchFunction}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> Functions.Arity10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<O> outType, final Hints hints)
	{
		return matchFunctionHelper(env, opName, hints, Functions.Arity10.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type);
	}

	/**
	 * As {@link OpBuilder#matchFunction}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> Functions.Arity11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<O> outType, final Hints hints)
	{
		return matchFunctionHelper(env, opName, hints, Functions.Arity11.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type);
	}

	/**
	 * As {@link OpBuilder#matchFunction}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> Functions.Arity12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<O> outType, final Hints hints)
	{
		return matchFunctionHelper(env, opName, hints, Functions.Arity12.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type);
	}

	/**
	 * As {@link OpBuilder#matchFunction}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> Functions.Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<O> outType, final Hints hints)
	{
		return matchFunctionHelper(env, opName, hints, Functions.Arity13.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type);
	}

	/**
	 * As {@link OpBuilder#matchFunction}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> Functions.Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<O> outType, final Hints hints)
	{
		return matchFunctionHelper(env, opName, hints, Functions.Arity14.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type);
	}

	/**
	 * As {@link OpBuilder#matchFunction}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> Functions.Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<O> outType, final Hints hints)
	{
		return matchFunctionHelper(env, opName, hints, Functions.Arity15.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type);
	}

	/**
	 * As {@link OpBuilder#matchFunction}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> Functions.Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> matchFunction(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type, final Nil<O> outType, final Hints hints)
	{
		return matchFunctionHelper(env, opName, hints, Functions.Arity16.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type);
	}

	@SuppressWarnings({ "unchecked" })
	private static <T> T matchFunctionHelper(final OpEnvironment env, final String opName,
		final Class<T> opClass, final Nil<?> outType, final Nil<?>... inTypes)
	{
		final Type[] types = new Type[inTypes.length + 1];
		for (int i = 0; i < inTypes.length; i++)
			types[i] = inTypes[i].type();
		types[types.length - 1] = outType.type();
		final Type specialType = Types.parameterize(opClass, types);
		return (T) env.op(opName, Nil.of(specialType), inTypes, outType);
	}

	@SuppressWarnings({ "unchecked" })
	private static <T> T matchFunctionHelper(final OpEnvironment env, final String opName, final Hints hints,
		final Class<T> opClass, final Nil<?> outType, final Nil<?>... inTypes)
	{
		final Type[] types = new Type[inTypes.length + 1];
		for (int i = 0; i < inTypes.length; i++)
			types[i] = inTypes[i].type();
		types[types.length - 1] = outType.type();
		final Type specialType = Types.parameterize(opClass, types);
		return (T) env.op(opName, Nil.of(specialType), inTypes, outType, hints);
	}

	/**
	 * Static utility method to match a {@link Computers} op with 0 inputs for operating on pre-allocated output.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings("unchecked")
	public static <O> Computers.Arity0<O> matchComputer(final OpEnvironment env, final String opName, final Nil<O> outType)
	{
		return matchComputerHelper(env, opName, Computers.Arity0.class, outType);
	}

	/**
	 * Static utility method to match a {@link Computers} op with 1 input for operating on pre-allocated output.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 * @see #matchInplace(OpEnvironment, String, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, O> Computers.Arity1<I1, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<O> outType)
	{
		return matchComputerHelper(env, opName, Computers.Arity1.class, outType, in1Type);
	}

	/**
	 * Static utility method to match a {@link Computers} op with 2 inputs for operating on pre-allocated output.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 * @see #matchInplace2_1(OpEnvironment, String, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, O> Computers.Arity2<I1, I2, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<O> outType)
	{
		return matchComputerHelper(env, opName, Computers.Arity2.class, outType, in1Type, in2Type);
	}

	/**
	 * Static utility method to match a {@link Computers} op with 3 inputs for operating on pre-allocated output.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 * @see #matchInplace3_1(OpEnvironment, String, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, O> Computers.Arity3<I1, I2, I3, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<O> outType)
	{
		return matchComputerHelper(env, opName, Computers.Arity3.class, outType, in1Type, in2Type, in3Type);
	}

	/**
	 * Static utility method to match a {@link Computers} op with 4 inputs for operating on pre-allocated output.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 * @see #matchInplace4_1(OpEnvironment, String, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, O> Computers.Arity4<I1, I2, I3, I4, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<O> outType)
	{
		return matchComputerHelper(env, opName, Computers.Arity4.class, outType, in1Type, in2Type, in3Type, in4Type);
	}

	/**
	 * Static utility method to match a {@link Computers} op with 5 inputs for operating on pre-allocated output.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 * @see #matchInplace5_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, O> Computers.Arity5<I1, I2, I3, I4, I5, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<O> outType)
	{
		return matchComputerHelper(env, opName, Computers.Arity5.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type);
	}

	/**
	 * Static utility method to match a {@link Computers} op with 6 inputs for operating on pre-allocated output.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 * @see #matchInplace6_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, O> Computers.Arity6<I1, I2, I3, I4, I5, I6, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<O> outType)
	{
		return matchComputerHelper(env, opName, Computers.Arity6.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type);
	}

	/**
	 * Static utility method to match a {@link Computers} op with 7 inputs for operating on pre-allocated output.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 * @see #matchInplace7_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, O> Computers.Arity7<I1, I2, I3, I4, I5, I6, I7, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<O> outType)
	{
		return matchComputerHelper(env, opName, Computers.Arity7.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type);
	}

	/**
	 * Static utility method to match a {@link Computers} op with 8 inputs for operating on pre-allocated output.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 * @see #matchInplace8_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, I8, O> Computers.Arity8<I1, I2, I3, I4, I5, I6, I7, I8, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<O> outType)
	{
		return matchComputerHelper(env, opName, Computers.Arity8.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type);
	}

	/**
	 * Static utility method to match a {@link Computers} op with 9 inputs for operating on pre-allocated output.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 * @see #matchInplace9_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, O> Computers.Arity9<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<O> outType)
	{
		return matchComputerHelper(env, opName, Computers.Arity9.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type);
	}

	/**
	 * Static utility method to match a {@link Computers} op with 10 inputs for operating on pre-allocated output.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 * @see #matchInplace10_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> Computers.Arity10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<O> outType)
	{
		return matchComputerHelper(env, opName, Computers.Arity10.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type);
	}

	/**
	 * Static utility method to match a {@link Computers} op with 11 inputs for operating on pre-allocated output.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 * @see #matchInplace11_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> Computers.Arity11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<O> outType)
	{
		return matchComputerHelper(env, opName, Computers.Arity11.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type);
	}

	/**
	 * Static utility method to match a {@link Computers} op with 12 inputs for operating on pre-allocated output.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 * @see #matchInplace12_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> Computers.Arity12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<O> outType)
	{
		return matchComputerHelper(env, opName, Computers.Arity12.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type);
	}

	/**
	 * Static utility method to match a {@link Computers} op with 13 inputs for operating on pre-allocated output.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 * @see #matchInplace13_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> Computers.Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<O> outType)
	{
		return matchComputerHelper(env, opName, Computers.Arity13.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type);
	}

	/**
	 * Static utility method to match a {@link Computers} op with 14 inputs for operating on pre-allocated output.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 * @see #matchInplace14_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> Computers.Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<O> outType)
	{
		return matchComputerHelper(env, opName, Computers.Arity14.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type);
	}

	/**
	 * Static utility method to match a {@link Computers} op with 15 inputs for operating on pre-allocated output.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 * @see #matchInplace15_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> Computers.Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<O> outType)
	{
		return matchComputerHelper(env, opName, Computers.Arity15.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type);
	}

	/**
	 * Static utility method to match a {@link Computers} op with 16 inputs for operating on pre-allocated output.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 * @see #matchInplace16_1(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that modifies a provided input parameter in-place.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> Computers.Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type, final Nil<O> outType)
	{
		return matchComputerHelper(env, opName, Computers.Arity16.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type);
	}

	/**
	 * As {@link OpBuilder#matchComputer}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings("unchecked")
	public static <O> Computers.Arity0<O> matchComputer(final OpEnvironment env, final String opName, final Nil<O> outType, final Hints hints)
	{
		return matchComputerHelper(env, opName, hints, Computers.Arity0.class, outType);
	}

	/**
	 * As {@link OpBuilder#matchComputer}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, O> Computers.Arity1<I1, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<O> outType, final Hints hints)
	{
		return matchComputerHelper(env, opName, hints, Computers.Arity1.class, outType, in1Type);
	}

	/**
	 * As {@link OpBuilder#matchComputer}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, O> Computers.Arity2<I1, I2, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<O> outType, final Hints hints)
	{
		return matchComputerHelper(env, opName, hints, Computers.Arity2.class, outType, in1Type, in2Type);
	}

	/**
	 * As {@link OpBuilder#matchComputer}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, O> Computers.Arity3<I1, I2, I3, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<O> outType, final Hints hints)
	{
		return matchComputerHelper(env, opName, hints, Computers.Arity3.class, outType, in1Type, in2Type, in3Type);
	}

	/**
	 * As {@link OpBuilder#matchComputer}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, O> Computers.Arity4<I1, I2, I3, I4, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<O> outType, final Hints hints)
	{
		return matchComputerHelper(env, opName, hints, Computers.Arity4.class, outType, in1Type, in2Type, in3Type, in4Type);
	}

	/**
	 * As {@link OpBuilder#matchComputer}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, O> Computers.Arity5<I1, I2, I3, I4, I5, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<O> outType, final Hints hints)
	{
		return matchComputerHelper(env, opName, hints, Computers.Arity5.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type);
	}

	/**
	 * As {@link OpBuilder#matchComputer}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, O> Computers.Arity6<I1, I2, I3, I4, I5, I6, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<O> outType, final Hints hints)
	{
		return matchComputerHelper(env, opName, hints, Computers.Arity6.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type);
	}

	/**
	 * As {@link OpBuilder#matchComputer}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, O> Computers.Arity7<I1, I2, I3, I4, I5, I6, I7, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<O> outType, final Hints hints)
	{
		return matchComputerHelper(env, opName, hints, Computers.Arity7.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type);
	}

	/**
	 * As {@link OpBuilder#matchComputer}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, I8, O> Computers.Arity8<I1, I2, I3, I4, I5, I6, I7, I8, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<O> outType, final Hints hints)
	{
		return matchComputerHelper(env, opName, hints, Computers.Arity8.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type);
	}

	/**
	 * As {@link OpBuilder#matchComputer}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, O> Computers.Arity9<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<O> outType, final Hints hints)
	{
		return matchComputerHelper(env, opName, hints, Computers.Arity9.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type);
	}

	/**
	 * As {@link OpBuilder#matchComputer}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> Computers.Arity10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<O> outType, final Hints hints)
	{
		return matchComputerHelper(env, opName, hints, Computers.Arity10.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type);
	}

	/**
	 * As {@link OpBuilder#matchComputer}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> Computers.Arity11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<O> outType, final Hints hints)
	{
		return matchComputerHelper(env, opName, hints, Computers.Arity11.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type);
	}

	/**
	 * As {@link OpBuilder#matchComputer}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> Computers.Arity12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<O> outType, final Hints hints)
	{
		return matchComputerHelper(env, opName, hints, Computers.Arity12.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type);
	}

	/**
	 * As {@link OpBuilder#matchComputer}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> Computers.Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<O> outType, final Hints hints)
	{
		return matchComputerHelper(env, opName, hints, Computers.Arity13.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type);
	}

	/**
	 * As {@link OpBuilder#matchComputer}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> Computers.Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<O> outType, final Hints hints)
	{
		return matchComputerHelper(env, opName, hints, Computers.Arity14.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type);
	}

	/**
	 * As {@link OpBuilder#matchComputer}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> Computers.Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<O> outType, final Hints hints)
	{
		return matchComputerHelper(env, opName, hints, Computers.Arity15.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type);
	}

	/**
	 * As {@link OpBuilder#matchComputer}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings("unchecked")
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> Computers.Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> matchComputer(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type, final Nil<O> outType, final Hints hints)
	{
		return matchComputerHelper(env, opName, hints, Computers.Arity16.class, outType, in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type);
	}

	@SuppressWarnings({ "unchecked" })
	private static <T> T matchComputerHelper(final OpEnvironment env, final String opName, final Class<T> opClass, final Nil<?> outType, final Nil<?>... inTypes)
	{
		final Type[] types = new Type[inTypes.length + 1];
		for (int i = 0; i < inTypes.length; i++)
			types[i] = inTypes[i].type();
		types[types.length - 1] = outType.type();
		final Type specialType = Types.parameterize(opClass, types);
		final Nil<?>[] nils = new Nil[inTypes.length + 1];
		System.arraycopy(inTypes, 0, nils, 0, inTypes.length);
		nils[nils.length - 1] = outType;
		return (T) env.op(opName, Nil.of(specialType), nils, outType);
	}

	@SuppressWarnings({ "unchecked" })
	private static <T> T matchComputerHelper(final OpEnvironment env, final String opName, final Hints hints, final Class<T> opClass, final Nil<?> outType, final Nil<?>... inTypes)
	{
		final Type[] types = new Type[inTypes.length + 1];
		for (int i = 0; i < inTypes.length; i++)
			types[i] = inTypes[i].type();
		types[types.length - 1] = outType.type();
		final Type specialType = Types.parameterize(opClass, types);
		final Nil<?>[] nils = new Nil[inTypes.length + 1];
		System.arraycopy(inTypes, 0, nils, 0, inTypes.length);
		nils[nils.length - 1] = outType;
		return (T) env.op(opName, Nil.of(specialType), nils, outType, hints);
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 1 input, modifying the 1st input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO> Inplaces.Arity1<IO> matchInplace(final OpEnvironment env, final String opName, final Nil<IO> ioType)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity1.class, ioType, new Nil[] {ioType});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 2 inputs, modifying the 1st input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2> Inplaces.Arity2_1<IO, I2> matchInplace2_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity2_1.class, ioType, new Nil[] {ioType, in2Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 2 inputs, modifying the 2nd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO> Inplaces.Arity2_2<I1, IO> matchInplace2_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity2_2.class, ioType, new Nil[] {in1Type, ioType});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 3 inputs, modifying the 1st input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3> Inplaces.Arity3_1<IO, I2, I3> matchInplace3_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity3_1.class, ioType, new Nil[] {ioType, in2Type, in3Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 3 inputs, modifying the 2nd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3> Inplaces.Arity3_2<I1, IO, I3> matchInplace3_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity3_2.class, ioType, new Nil[] {in1Type, ioType, in3Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 3 inputs, modifying the 3rd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO> Inplaces.Arity3_3<I1, I2, IO> matchInplace3_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity3_3.class, ioType, new Nil[] {in1Type, in2Type, ioType});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 4 inputs, modifying the 1st input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3, I4> Inplaces.Arity4_1<IO, I2, I3, I4> matchInplace4_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity4_1.class, ioType, new Nil[] {ioType, in2Type, in3Type, in4Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 4 inputs, modifying the 2nd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3, I4> Inplaces.Arity4_2<I1, IO, I3, I4> matchInplace4_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Nil<I4> in4Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity4_2.class, ioType, new Nil[] {in1Type, ioType, in3Type, in4Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 4 inputs, modifying the 3rd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO, I4> Inplaces.Arity4_3<I1, I2, IO, I4> matchInplace4_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Nil<I4> in4Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity4_3.class, ioType, new Nil[] {in1Type, in2Type, ioType, in4Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 4 inputs, modifying the 4th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, IO> Inplaces.Arity4_4<I1, I2, I3, IO> matchInplace4_4(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<IO> ioType)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity4_4.class, ioType, new Nil[] {in1Type, in2Type, in3Type, ioType});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 5 inputs, modifying the 1st input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3, I4, I5> Inplaces.Arity5_1<IO, I2, I3, I4, I5> matchInplace5_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity5_1.class, ioType, new Nil[] {ioType, in2Type, in3Type, in4Type, in5Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 5 inputs, modifying the 2nd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3, I4, I5> Inplaces.Arity5_2<I1, IO, I3, I4, I5> matchInplace5_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity5_2.class, ioType, new Nil[] {in1Type, ioType, in3Type, in4Type, in5Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 5 inputs, modifying the 3rd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO, I4, I5> Inplaces.Arity5_3<I1, I2, IO, I4, I5> matchInplace5_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Nil<I4> in4Type, final Nil<I5> in5Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity5_3.class, ioType, new Nil[] {in1Type, in2Type, ioType, in4Type, in5Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 5 inputs, modifying the 4th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, IO, I5> Inplaces.Arity5_4<I1, I2, I3, IO, I5> matchInplace5_4(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<IO> ioType, final Nil<I5> in5Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity5_4.class, ioType, new Nil[] {in1Type, in2Type, in3Type, ioType, in5Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 5 inputs, modifying the 5th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, IO> Inplaces.Arity5_5<I1, I2, I3, I4, IO> matchInplace5_5(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<IO> ioType)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity5_5.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, ioType});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 6 inputs, modifying the 1st input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3, I4, I5, I6> Inplaces.Arity6_1<IO, I2, I3, I4, I5, I6> matchInplace6_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity6_1.class, ioType, new Nil[] {ioType, in2Type, in3Type, in4Type, in5Type, in6Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 6 inputs, modifying the 2nd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3, I4, I5, I6> Inplaces.Arity6_2<I1, IO, I3, I4, I5, I6> matchInplace6_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity6_2.class, ioType, new Nil[] {in1Type, ioType, in3Type, in4Type, in5Type, in6Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 6 inputs, modifying the 3rd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO, I4, I5, I6> Inplaces.Arity6_3<I1, I2, IO, I4, I5, I6> matchInplace6_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity6_3.class, ioType, new Nil[] {in1Type, in2Type, ioType, in4Type, in5Type, in6Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 6 inputs, modifying the 4th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, IO, I5, I6> Inplaces.Arity6_4<I1, I2, I3, IO, I5, I6> matchInplace6_4(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<IO> ioType, final Nil<I5> in5Type, final Nil<I6> in6Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity6_4.class, ioType, new Nil[] {in1Type, in2Type, in3Type, ioType, in5Type, in6Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 6 inputs, modifying the 5th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, IO, I6> Inplaces.Arity6_5<I1, I2, I3, I4, IO, I6> matchInplace6_5(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<IO> ioType, final Nil<I6> in6Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity6_5.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, ioType, in6Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 6 inputs, modifying the 6th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, IO> Inplaces.Arity6_6<I1, I2, I3, I4, I5, IO> matchInplace6_6(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<IO> ioType)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity6_6.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, ioType});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 7 inputs, modifying the 1st input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3, I4, I5, I6, I7> Inplaces.Arity7_1<IO, I2, I3, I4, I5, I6, I7> matchInplace7_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity7_1.class, ioType, new Nil[] {ioType, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 7 inputs, modifying the 2nd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3, I4, I5, I6, I7> Inplaces.Arity7_2<I1, IO, I3, I4, I5, I6, I7> matchInplace7_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity7_2.class, ioType, new Nil[] {in1Type, ioType, in3Type, in4Type, in5Type, in6Type, in7Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 7 inputs, modifying the 3rd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO, I4, I5, I6, I7> Inplaces.Arity7_3<I1, I2, IO, I4, I5, I6, I7> matchInplace7_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity7_3.class, ioType, new Nil[] {in1Type, in2Type, ioType, in4Type, in5Type, in6Type, in7Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 7 inputs, modifying the 4th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, IO, I5, I6, I7> Inplaces.Arity7_4<I1, I2, I3, IO, I5, I6, I7> matchInplace7_4(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<IO> ioType, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity7_4.class, ioType, new Nil[] {in1Type, in2Type, in3Type, ioType, in5Type, in6Type, in7Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 7 inputs, modifying the 5th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, IO, I6, I7> Inplaces.Arity7_5<I1, I2, I3, I4, IO, I6, I7> matchInplace7_5(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<IO> ioType, final Nil<I6> in6Type, final Nil<I7> in7Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity7_5.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, ioType, in6Type, in7Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 7 inputs, modifying the 6th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, IO, I7> Inplaces.Arity7_6<I1, I2, I3, I4, I5, IO, I7> matchInplace7_6(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<IO> ioType, final Nil<I7> in7Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity7_6.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, ioType, in7Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 7 inputs, modifying the 7th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, IO> Inplaces.Arity7_7<I1, I2, I3, I4, I5, I6, IO> matchInplace7_7(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<IO> ioType)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity7_7.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, ioType});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 8 inputs, modifying the 1st input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3, I4, I5, I6, I7, I8> Inplaces.Arity8_1<IO, I2, I3, I4, I5, I6, I7, I8> matchInplace8_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity8_1.class, ioType, new Nil[] {ioType, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 8 inputs, modifying the 2nd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3, I4, I5, I6, I7, I8> Inplaces.Arity8_2<I1, IO, I3, I4, I5, I6, I7, I8> matchInplace8_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity8_2.class, ioType, new Nil[] {in1Type, ioType, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 8 inputs, modifying the 3rd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO, I4, I5, I6, I7, I8> Inplaces.Arity8_3<I1, I2, IO, I4, I5, I6, I7, I8> matchInplace8_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity8_3.class, ioType, new Nil[] {in1Type, in2Type, ioType, in4Type, in5Type, in6Type, in7Type, in8Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 8 inputs, modifying the 4th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, IO, I5, I6, I7, I8> Inplaces.Arity8_4<I1, I2, I3, IO, I5, I6, I7, I8> matchInplace8_4(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<IO> ioType, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity8_4.class, ioType, new Nil[] {in1Type, in2Type, in3Type, ioType, in5Type, in6Type, in7Type, in8Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 8 inputs, modifying the 5th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, IO, I6, I7, I8> Inplaces.Arity8_5<I1, I2, I3, I4, IO, I6, I7, I8> matchInplace8_5(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<IO> ioType, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity8_5.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, ioType, in6Type, in7Type, in8Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 8 inputs, modifying the 6th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, IO, I7, I8> Inplaces.Arity8_6<I1, I2, I3, I4, I5, IO, I7, I8> matchInplace8_6(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<IO> ioType, final Nil<I7> in7Type, final Nil<I8> in8Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity8_6.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, ioType, in7Type, in8Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 8 inputs, modifying the 7th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, IO, I8> Inplaces.Arity8_7<I1, I2, I3, I4, I5, I6, IO, I8> matchInplace8_7(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<IO> ioType, final Nil<I8> in8Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity8_7.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, ioType, in8Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 8 inputs, modifying the 8th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, IO> Inplaces.Arity8_8<I1, I2, I3, I4, I5, I6, I7, IO> matchInplace8_8(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<IO> ioType)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity8_8.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, ioType});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 9 inputs, modifying the 1st input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3, I4, I5, I6, I7, I8, I9> Inplaces.Arity9_1<IO, I2, I3, I4, I5, I6, I7, I8, I9> matchInplace9_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity9_1.class, ioType, new Nil[] {ioType, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 9 inputs, modifying the 2nd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3, I4, I5, I6, I7, I8, I9> Inplaces.Arity9_2<I1, IO, I3, I4, I5, I6, I7, I8, I9> matchInplace9_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity9_2.class, ioType, new Nil[] {in1Type, ioType, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 9 inputs, modifying the 3rd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO, I4, I5, I6, I7, I8, I9> Inplaces.Arity9_3<I1, I2, IO, I4, I5, I6, I7, I8, I9> matchInplace9_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity9_3.class, ioType, new Nil[] {in1Type, in2Type, ioType, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 9 inputs, modifying the 4th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, IO, I5, I6, I7, I8, I9> Inplaces.Arity9_4<I1, I2, I3, IO, I5, I6, I7, I8, I9> matchInplace9_4(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<IO> ioType, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity9_4.class, ioType, new Nil[] {in1Type, in2Type, in3Type, ioType, in5Type, in6Type, in7Type, in8Type, in9Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 9 inputs, modifying the 5th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, IO, I6, I7, I8, I9> Inplaces.Arity9_5<I1, I2, I3, I4, IO, I6, I7, I8, I9> matchInplace9_5(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<IO> ioType, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity9_5.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, ioType, in6Type, in7Type, in8Type, in9Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 9 inputs, modifying the 6th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, IO, I7, I8, I9> Inplaces.Arity9_6<I1, I2, I3, I4, I5, IO, I7, I8, I9> matchInplace9_6(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<IO> ioType, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity9_6.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, ioType, in7Type, in8Type, in9Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 9 inputs, modifying the 7th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, IO, I8, I9> Inplaces.Arity9_7<I1, I2, I3, I4, I5, I6, IO, I8, I9> matchInplace9_7(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<IO> ioType, final Nil<I8> in8Type, final Nil<I9> in9Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity9_7.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, ioType, in8Type, in9Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 9 inputs, modifying the 8th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, IO, I9> Inplaces.Arity9_8<I1, I2, I3, I4, I5, I6, I7, IO, I9> matchInplace9_8(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<IO> ioType, final Nil<I9> in9Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity9_8.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, ioType, in9Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 9 inputs, modifying the 9th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, IO> Inplaces.Arity9_9<I1, I2, I3, I4, I5, I6, I7, I8, IO> matchInplace9_9(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<IO> ioType)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity9_9.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, ioType});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 10 inputs, modifying the 1st input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3, I4, I5, I6, I7, I8, I9, I10> Inplaces.Arity10_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10> matchInplace10_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity10_1.class, ioType, new Nil[] {ioType, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 10 inputs, modifying the 2nd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3, I4, I5, I6, I7, I8, I9, I10> Inplaces.Arity10_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10> matchInplace10_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity10_2.class, ioType, new Nil[] {in1Type, ioType, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 10 inputs, modifying the 3rd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO, I4, I5, I6, I7, I8, I9, I10> Inplaces.Arity10_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10> matchInplace10_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity10_3.class, ioType, new Nil[] {in1Type, in2Type, ioType, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 10 inputs, modifying the 4th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, IO, I5, I6, I7, I8, I9, I10> Inplaces.Arity10_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10> matchInplace10_4(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<IO> ioType, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity10_4.class, ioType, new Nil[] {in1Type, in2Type, in3Type, ioType, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 10 inputs, modifying the 5th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, IO, I6, I7, I8, I9, I10> Inplaces.Arity10_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10> matchInplace10_5(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<IO> ioType, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity10_5.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, ioType, in6Type, in7Type, in8Type, in9Type, in10Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 10 inputs, modifying the 6th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, IO, I7, I8, I9, I10> Inplaces.Arity10_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10> matchInplace10_6(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<IO> ioType, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity10_6.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, ioType, in7Type, in8Type, in9Type, in10Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 10 inputs, modifying the 7th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, IO, I8, I9, I10> Inplaces.Arity10_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10> matchInplace10_7(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<IO> ioType, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity10_7.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, ioType, in8Type, in9Type, in10Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 10 inputs, modifying the 8th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, IO, I9, I10> Inplaces.Arity10_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10> matchInplace10_8(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<IO> ioType, final Nil<I9> in9Type, final Nil<I10> in10Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity10_8.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, ioType, in9Type, in10Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 10 inputs, modifying the 9th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, IO, I10> Inplaces.Arity10_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10> matchInplace10_9(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<IO> ioType, final Nil<I10> in10Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity10_9.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, ioType, in10Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 10 inputs, modifying the 10th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, IO> Inplaces.Arity10_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO> matchInplace10_10(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<IO> ioType)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity10_10.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, ioType});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 11 inputs, modifying the 1st input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> Inplaces.Arity11_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> matchInplace11_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity11_1.class, ioType, new Nil[] {ioType, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 11 inputs, modifying the 2nd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11> Inplaces.Arity11_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11> matchInplace11_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity11_2.class, ioType, new Nil[] {in1Type, ioType, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 11 inputs, modifying the 3rd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11> Inplaces.Arity11_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11> matchInplace11_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity11_3.class, ioType, new Nil[] {in1Type, in2Type, ioType, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 11 inputs, modifying the 4th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11> Inplaces.Arity11_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11> matchInplace11_4(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<IO> ioType, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity11_4.class, ioType, new Nil[] {in1Type, in2Type, in3Type, ioType, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 11 inputs, modifying the 5th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11> Inplaces.Arity11_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11> matchInplace11_5(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<IO> ioType, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity11_5.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, ioType, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 11 inputs, modifying the 6th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11> Inplaces.Arity11_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11> matchInplace11_6(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<IO> ioType, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity11_6.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, ioType, in7Type, in8Type, in9Type, in10Type, in11Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 11 inputs, modifying the 7th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11> Inplaces.Arity11_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11> matchInplace11_7(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<IO> ioType, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity11_7.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, ioType, in8Type, in9Type, in10Type, in11Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 11 inputs, modifying the 8th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11> Inplaces.Arity11_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11> matchInplace11_8(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<IO> ioType, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity11_8.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, ioType, in9Type, in10Type, in11Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 11 inputs, modifying the 9th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11> Inplaces.Arity11_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11> matchInplace11_9(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<IO> ioType, final Nil<I10> in10Type, final Nil<I11> in11Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity11_9.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, ioType, in10Type, in11Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 11 inputs, modifying the 10th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11> Inplaces.Arity11_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11> matchInplace11_10(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<IO> ioType, final Nil<I11> in11Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity11_10.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, ioType, in11Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 11 inputs, modifying the 11th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO> Inplaces.Arity11_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO> matchInplace11_11(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<IO> ioType)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity11_11.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, ioType});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 12 inputs, modifying the 1st input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> Inplaces.Arity12_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> matchInplace12_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity12_1.class, ioType, new Nil[] {ioType, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 12 inputs, modifying the 2nd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> Inplaces.Arity12_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> matchInplace12_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity12_2.class, ioType, new Nil[] {in1Type, ioType, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 12 inputs, modifying the 3rd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12> Inplaces.Arity12_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12> matchInplace12_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity12_3.class, ioType, new Nil[] {in1Type, in2Type, ioType, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 12 inputs, modifying the 4th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12> Inplaces.Arity12_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12> matchInplace12_4(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<IO> ioType, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity12_4.class, ioType, new Nil[] {in1Type, in2Type, in3Type, ioType, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 12 inputs, modifying the 5th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12> Inplaces.Arity12_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12> matchInplace12_5(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<IO> ioType, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity12_5.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, ioType, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 12 inputs, modifying the 6th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12> Inplaces.Arity12_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12> matchInplace12_6(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<IO> ioType, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity12_6.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, ioType, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 12 inputs, modifying the 7th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12> Inplaces.Arity12_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12> matchInplace12_7(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<IO> ioType, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity12_7.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, ioType, in8Type, in9Type, in10Type, in11Type, in12Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 12 inputs, modifying the 8th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12> Inplaces.Arity12_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12> matchInplace12_8(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<IO> ioType, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity12_8.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, ioType, in9Type, in10Type, in11Type, in12Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 12 inputs, modifying the 9th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12> Inplaces.Arity12_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12> matchInplace12_9(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<IO> ioType, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity12_9.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, ioType, in10Type, in11Type, in12Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 12 inputs, modifying the 10th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12> Inplaces.Arity12_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12> matchInplace12_10(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<IO> ioType, final Nil<I11> in11Type, final Nil<I12> in12Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity12_10.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, ioType, in11Type, in12Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 12 inputs, modifying the 11th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12> Inplaces.Arity12_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12> matchInplace12_11(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<IO> ioType, final Nil<I12> in12Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity12_11.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, ioType, in12Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 12 inputs, modifying the 12th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO> Inplaces.Arity12_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO> matchInplace12_12(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<IO> ioType)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity12_12.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, ioType});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 13 inputs, modifying the 1st input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> Inplaces.Arity13_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> matchInplace13_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity13_1.class, ioType, new Nil[] {ioType, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 13 inputs, modifying the 2nd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> Inplaces.Arity13_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> matchInplace13_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity13_2.class, ioType, new Nil[] {in1Type, ioType, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 13 inputs, modifying the 3rd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> Inplaces.Arity13_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> matchInplace13_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity13_3.class, ioType, new Nil[] {in1Type, in2Type, ioType, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 13 inputs, modifying the 4th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13> Inplaces.Arity13_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13> matchInplace13_4(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<IO> ioType, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity13_4.class, ioType, new Nil[] {in1Type, in2Type, in3Type, ioType, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 13 inputs, modifying the 5th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13> Inplaces.Arity13_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13> matchInplace13_5(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<IO> ioType, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity13_5.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, ioType, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 13 inputs, modifying the 6th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13> Inplaces.Arity13_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13> matchInplace13_6(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<IO> ioType, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity13_6.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, ioType, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 13 inputs, modifying the 7th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13> Inplaces.Arity13_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13> matchInplace13_7(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<IO> ioType, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity13_7.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, ioType, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 13 inputs, modifying the 8th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13> Inplaces.Arity13_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13> matchInplace13_8(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<IO> ioType, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity13_8.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, ioType, in9Type, in10Type, in11Type, in12Type, in13Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 13 inputs, modifying the 9th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13> Inplaces.Arity13_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13> matchInplace13_9(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<IO> ioType, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity13_9.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, ioType, in10Type, in11Type, in12Type, in13Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 13 inputs, modifying the 10th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13> Inplaces.Arity13_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13> matchInplace13_10(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<IO> ioType, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity13_10.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, ioType, in11Type, in12Type, in13Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 13 inputs, modifying the 11th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13> Inplaces.Arity13_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13> matchInplace13_11(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<IO> ioType, final Nil<I12> in12Type, final Nil<I13> in13Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity13_11.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, ioType, in12Type, in13Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 13 inputs, modifying the 12th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13> Inplaces.Arity13_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13> matchInplace13_12(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<IO> ioType, final Nil<I13> in13Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity13_12.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, ioType, in13Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 13 inputs, modifying the 13th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO> Inplaces.Arity13_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO> matchInplace13_13(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<IO> ioType)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity13_13.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, ioType});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 14 inputs, modifying the 1st input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> Inplaces.Arity14_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> matchInplace14_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity14_1.class, ioType, new Nil[] {ioType, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 14 inputs, modifying the 2nd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> Inplaces.Arity14_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> matchInplace14_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity14_2.class, ioType, new Nil[] {in1Type, ioType, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 14 inputs, modifying the 3rd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> Inplaces.Arity14_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> matchInplace14_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity14_3.class, ioType, new Nil[] {in1Type, in2Type, ioType, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 14 inputs, modifying the 4th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> Inplaces.Arity14_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> matchInplace14_4(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<IO> ioType, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity14_4.class, ioType, new Nil[] {in1Type, in2Type, in3Type, ioType, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 14 inputs, modifying the 5th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13, I14> Inplaces.Arity14_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13, I14> matchInplace14_5(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<IO> ioType, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity14_5.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, ioType, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 14 inputs, modifying the 6th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13, I14> Inplaces.Arity14_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13, I14> matchInplace14_6(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<IO> ioType, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity14_6.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, ioType, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 14 inputs, modifying the 7th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13, I14> Inplaces.Arity14_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13, I14> matchInplace14_7(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<IO> ioType, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity14_7.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, ioType, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 14 inputs, modifying the 8th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13, I14> Inplaces.Arity14_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13, I14> matchInplace14_8(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<IO> ioType, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity14_8.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, ioType, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 14 inputs, modifying the 9th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13, I14> Inplaces.Arity14_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13, I14> matchInplace14_9(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<IO> ioType, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity14_9.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, ioType, in10Type, in11Type, in12Type, in13Type, in14Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 14 inputs, modifying the 10th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13, I14> Inplaces.Arity14_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13, I14> matchInplace14_10(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<IO> ioType, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity14_10.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, ioType, in11Type, in12Type, in13Type, in14Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 14 inputs, modifying the 11th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13, I14> Inplaces.Arity14_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13, I14> matchInplace14_11(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<IO> ioType, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity14_11.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, ioType, in12Type, in13Type, in14Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 14 inputs, modifying the 12th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13, I14> Inplaces.Arity14_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13, I14> matchInplace14_12(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<IO> ioType, final Nil<I13> in13Type, final Nil<I14> in14Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity14_12.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, ioType, in13Type, in14Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 14 inputs, modifying the 13th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO, I14> Inplaces.Arity14_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO, I14> matchInplace14_13(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<IO> ioType, final Nil<I14> in14Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity14_13.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, ioType, in14Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 14 inputs, modifying the 14th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, IO> Inplaces.Arity14_14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, IO> matchInplace14_14(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<IO> ioType)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity14_14.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, ioType});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 15 inputs, modifying the 1st input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> Inplaces.Arity15_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> matchInplace15_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity15_1.class, ioType, new Nil[] {ioType, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 15 inputs, modifying the 2nd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> Inplaces.Arity15_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> matchInplace15_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity15_2.class, ioType, new Nil[] {in1Type, ioType, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 15 inputs, modifying the 3rd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> Inplaces.Arity15_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> matchInplace15_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity15_3.class, ioType, new Nil[] {in1Type, in2Type, ioType, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 15 inputs, modifying the 4th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> Inplaces.Arity15_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> matchInplace15_4(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<IO> ioType, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity15_4.class, ioType, new Nil[] {in1Type, in2Type, in3Type, ioType, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 15 inputs, modifying the 5th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> Inplaces.Arity15_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> matchInplace15_5(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<IO> ioType, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity15_5.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, ioType, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 15 inputs, modifying the 6th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13, I14, I15> Inplaces.Arity15_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13, I14, I15> matchInplace15_6(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<IO> ioType, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity15_6.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, ioType, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 15 inputs, modifying the 7th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13, I14, I15> Inplaces.Arity15_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13, I14, I15> matchInplace15_7(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<IO> ioType, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity15_7.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, ioType, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 15 inputs, modifying the 8th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13, I14, I15> Inplaces.Arity15_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13, I14, I15> matchInplace15_8(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<IO> ioType, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity15_8.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, ioType, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 15 inputs, modifying the 9th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13, I14, I15> Inplaces.Arity15_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13, I14, I15> matchInplace15_9(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<IO> ioType, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity15_9.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, ioType, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 15 inputs, modifying the 10th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13, I14, I15> Inplaces.Arity15_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13, I14, I15> matchInplace15_10(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<IO> ioType, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity15_10.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, ioType, in11Type, in12Type, in13Type, in14Type, in15Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 15 inputs, modifying the 11th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13, I14, I15> Inplaces.Arity15_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13, I14, I15> matchInplace15_11(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<IO> ioType, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity15_11.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, ioType, in12Type, in13Type, in14Type, in15Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 15 inputs, modifying the 12th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13, I14, I15> Inplaces.Arity15_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13, I14, I15> matchInplace15_12(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<IO> ioType, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity15_12.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, ioType, in13Type, in14Type, in15Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 15 inputs, modifying the 13th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO, I14, I15> Inplaces.Arity15_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO, I14, I15> matchInplace15_13(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<IO> ioType, final Nil<I14> in14Type, final Nil<I15> in15Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity15_13.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, ioType, in14Type, in15Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 15 inputs, modifying the 14th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, IO, I15> Inplaces.Arity15_14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, IO, I15> matchInplace15_14(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<IO> ioType, final Nil<I15> in15Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity15_14.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, ioType, in15Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 15 inputs, modifying the 15th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, IO> Inplaces.Arity15_15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, IO> matchInplace15_15(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<IO> ioType)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity15_15.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, ioType});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 16 inputs, modifying the 1st input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> Inplaces.Arity16_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> matchInplace16_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity16_1.class, ioType, new Nil[] {ioType, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 16 inputs, modifying the 2nd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> Inplaces.Arity16_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> matchInplace16_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity16_2.class, ioType, new Nil[] {in1Type, ioType, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 16 inputs, modifying the 3rd input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> Inplaces.Arity16_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> matchInplace16_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity16_3.class, ioType, new Nil[] {in1Type, in2Type, ioType, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 16 inputs, modifying the 4th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> Inplaces.Arity16_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> matchInplace16_4(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<IO> ioType, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity16_4.class, ioType, new Nil[] {in1Type, in2Type, in3Type, ioType, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 16 inputs, modifying the 5th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> Inplaces.Arity16_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> matchInplace16_5(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<IO> ioType, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity16_5.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, ioType, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 16 inputs, modifying the 6th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> Inplaces.Arity16_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> matchInplace16_6(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<IO> ioType, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity16_6.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, ioType, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 16 inputs, modifying the 7th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13, I14, I15, I16> Inplaces.Arity16_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13, I14, I15, I16> matchInplace16_7(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<IO> ioType, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity16_7.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, ioType, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 16 inputs, modifying the 8th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13, I14, I15, I16> Inplaces.Arity16_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13, I14, I15, I16> matchInplace16_8(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<IO> ioType, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity16_8.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, ioType, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 16 inputs, modifying the 9th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13, I14, I15, I16> Inplaces.Arity16_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13, I14, I15, I16> matchInplace16_9(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<IO> ioType, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity16_9.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, ioType, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 16 inputs, modifying the 10th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13, I14, I15, I16> Inplaces.Arity16_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13, I14, I15, I16> matchInplace16_10(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<IO> ioType, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity16_10.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, ioType, in11Type, in12Type, in13Type, in14Type, in15Type, in16Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 16 inputs, modifying the 11th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13, I14, I15, I16> Inplaces.Arity16_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13, I14, I15, I16> matchInplace16_11(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<IO> ioType, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity16_11.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, ioType, in12Type, in13Type, in14Type, in15Type, in16Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 16 inputs, modifying the 12th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13, I14, I15, I16> Inplaces.Arity16_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13, I14, I15, I16> matchInplace16_12(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<IO> ioType, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity16_12.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, ioType, in13Type, in14Type, in15Type, in16Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 16 inputs, modifying the 13th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO, I14, I15, I16> Inplaces.Arity16_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO, I14, I15, I16> matchInplace16_13(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<IO> ioType, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<I16> in16Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity16_13.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, ioType, in14Type, in15Type, in16Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 16 inputs, modifying the 14th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, IO, I15, I16> Inplaces.Arity16_14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, IO, I15, I16> matchInplace16_14(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<IO> ioType, final Nil<I15> in15Type, final Nil<I16> in16Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity16_14.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, ioType, in15Type, in16Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 16 inputs, modifying the 15th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, IO, I16> Inplaces.Arity16_15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, IO, I16> matchInplace16_15(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<IO> ioType, final Nil<I16> in16Type)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity16_15.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, ioType, in16Type});
	}

	/**
	 * Static utility method to match an {@link Inplaces} op with 16 inputs, modifying the 16th input in-place.
	 *
	 * @return An instance of the matched op, e.g. for reuse.
	 *
	 * @throws OpMatchingException if the Op request cannot be satisfied.
	 *
	 * @see #matchComputer(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op to process pre-allocated outputs without re-matching.
	 * @see #matchFunction(OpEnvironment, String, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil) For a reusable Op that generates output instances based on its inputs.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, IO> Inplaces.Arity16_16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, IO> matchInplace16_16(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Nil<I10> in10Type, final Nil<I11> in11Type, final Nil<I12> in12Type, final Nil<I13> in13Type, final Nil<I14> in14Type, final Nil<I15> in15Type, final Nil<IO> ioType)
	{
		return matchInplaceHelper(env, opName, Inplaces.Arity16_16.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type, in10Type, in11Type, in12Type, in13Type, in14Type, in15Type, ioType});
	}


	/**
	 * As {@link OpBuilder#matchInplace}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO> Inplaces.Arity1<IO> matchInplace(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity1.class, ioType, new Nil[] {ioType});
	}

	/**
	 * As {@link OpBuilder#matchInplace2_1}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2> Inplaces.Arity2_1<IO, I2> matchInplace2_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity2_1.class, ioType, new Nil[] {ioType, in2Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace2_2}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO> Inplaces.Arity2_2<I1, IO> matchInplace2_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity2_2.class, ioType, new Nil[] {in1Type, ioType});
	}

	/**
	 * As {@link OpBuilder#matchInplace3_1}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3> Inplaces.Arity3_1<IO, I2, I3> matchInplace3_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity3_1.class, ioType, new Nil[] {ioType, in2Type, in3Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace3_2}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3> Inplaces.Arity3_2<I1, IO, I3> matchInplace3_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity3_2.class, ioType, new Nil[] {in1Type, ioType, in3Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace3_3}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO> Inplaces.Arity3_3<I1, I2, IO> matchInplace3_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity3_3.class, ioType, new Nil[] {in1Type, in2Type, ioType});
	}

	/**
	 * As {@link OpBuilder#matchInplace4_1}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3, I4> Inplaces.Arity4_1<IO, I2, I3, I4> matchInplace4_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity4_1.class, ioType, new Nil[] {ioType, in2Type, in3Type, in4Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace4_2}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3, I4> Inplaces.Arity4_2<I1, IO, I3, I4> matchInplace4_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Nil<I4> in4Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity4_2.class, ioType, new Nil[] {in1Type, ioType, in3Type, in4Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace4_3}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO, I4> Inplaces.Arity4_3<I1, I2, IO, I4> matchInplace4_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Nil<I4> in4Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity4_3.class, ioType, new Nil[] {in1Type, in2Type, ioType, in4Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace4_4}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, IO> Inplaces.Arity4_4<I1, I2, I3, IO> matchInplace4_4(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<IO> ioType, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity4_4.class, ioType, new Nil[] {in1Type, in2Type, in3Type, ioType});
	}

	/**
	 * As {@link OpBuilder#matchInplace5_1}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3, I4, I5> Inplaces.Arity5_1<IO, I2, I3, I4, I5> matchInplace5_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity5_1.class, ioType, new Nil[] {ioType, in2Type, in3Type, in4Type, in5Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace5_2}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3, I4, I5> Inplaces.Arity5_2<I1, IO, I3, I4, I5> matchInplace5_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity5_2.class, ioType, new Nil[] {in1Type, ioType, in3Type, in4Type, in5Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace5_3}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO, I4, I5> Inplaces.Arity5_3<I1, I2, IO, I4, I5> matchInplace5_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Nil<I4> in4Type, final Nil<I5> in5Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity5_3.class, ioType, new Nil[] {in1Type, in2Type, ioType, in4Type, in5Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace5_4}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, IO, I5> Inplaces.Arity5_4<I1, I2, I3, IO, I5> matchInplace5_4(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<IO> ioType, final Nil<I5> in5Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity5_4.class, ioType, new Nil[] {in1Type, in2Type, in3Type, ioType, in5Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace5_5}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, IO> Inplaces.Arity5_5<I1, I2, I3, I4, IO> matchInplace5_5(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<IO> ioType, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity5_5.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, ioType});
	}

	/**
	 * As {@link OpBuilder#matchInplace6_1}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3, I4, I5, I6> Inplaces.Arity6_1<IO, I2, I3, I4, I5, I6> matchInplace6_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity6_1.class, ioType, new Nil[] {ioType, in2Type, in3Type, in4Type, in5Type, in6Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace6_2}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3, I4, I5, I6> Inplaces.Arity6_2<I1, IO, I3, I4, I5, I6> matchInplace6_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity6_2.class, ioType, new Nil[] {in1Type, ioType, in3Type, in4Type, in5Type, in6Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace6_3}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO, I4, I5, I6> Inplaces.Arity6_3<I1, I2, IO, I4, I5, I6> matchInplace6_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity6_3.class, ioType, new Nil[] {in1Type, in2Type, ioType, in4Type, in5Type, in6Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace6_4}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, IO, I5, I6> Inplaces.Arity6_4<I1, I2, I3, IO, I5, I6> matchInplace6_4(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<IO> ioType, final Nil<I5> in5Type, final Nil<I6> in6Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity6_4.class, ioType, new Nil[] {in1Type, in2Type, in3Type, ioType, in5Type, in6Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace6_5}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, IO, I6> Inplaces.Arity6_5<I1, I2, I3, I4, IO, I6> matchInplace6_5(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<IO> ioType, final Nil<I6> in6Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity6_5.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, ioType, in6Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace6_6}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, IO> Inplaces.Arity6_6<I1, I2, I3, I4, I5, IO> matchInplace6_6(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<IO> ioType, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity6_6.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, ioType});
	}

	/**
	 * As {@link OpBuilder#matchInplace7_1}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3, I4, I5, I6, I7> Inplaces.Arity7_1<IO, I2, I3, I4, I5, I6, I7> matchInplace7_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity7_1.class, ioType, new Nil[] {ioType, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace7_2}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3, I4, I5, I6, I7> Inplaces.Arity7_2<I1, IO, I3, I4, I5, I6, I7> matchInplace7_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity7_2.class, ioType, new Nil[] {in1Type, ioType, in3Type, in4Type, in5Type, in6Type, in7Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace7_3}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO, I4, I5, I6, I7> Inplaces.Arity7_3<I1, I2, IO, I4, I5, I6, I7> matchInplace7_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity7_3.class, ioType, new Nil[] {in1Type, in2Type, ioType, in4Type, in5Type, in6Type, in7Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace7_4}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, IO, I5, I6, I7> Inplaces.Arity7_4<I1, I2, I3, IO, I5, I6, I7> matchInplace7_4(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<IO> ioType, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity7_4.class, ioType, new Nil[] {in1Type, in2Type, in3Type, ioType, in5Type, in6Type, in7Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace7_5}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, IO, I6, I7> Inplaces.Arity7_5<I1, I2, I3, I4, IO, I6, I7> matchInplace7_5(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<IO> ioType, final Nil<I6> in6Type, final Nil<I7> in7Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity7_5.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, ioType, in6Type, in7Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace7_6}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, IO, I7> Inplaces.Arity7_6<I1, I2, I3, I4, I5, IO, I7> matchInplace7_6(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<IO> ioType, final Nil<I7> in7Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity7_6.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, ioType, in7Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace7_7}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, IO> Inplaces.Arity7_7<I1, I2, I3, I4, I5, I6, IO> matchInplace7_7(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<IO> ioType, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity7_7.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, ioType});
	}

	/**
	 * As {@link OpBuilder#matchInplace8_1}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3, I4, I5, I6, I7, I8> Inplaces.Arity8_1<IO, I2, I3, I4, I5, I6, I7, I8> matchInplace8_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity8_1.class, ioType, new Nil[] {ioType, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace8_2}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3, I4, I5, I6, I7, I8> Inplaces.Arity8_2<I1, IO, I3, I4, I5, I6, I7, I8> matchInplace8_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity8_2.class, ioType, new Nil[] {in1Type, ioType, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace8_3}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO, I4, I5, I6, I7, I8> Inplaces.Arity8_3<I1, I2, IO, I4, I5, I6, I7, I8> matchInplace8_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity8_3.class, ioType, new Nil[] {in1Type, in2Type, ioType, in4Type, in5Type, in6Type, in7Type, in8Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace8_4}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, IO, I5, I6, I7, I8> Inplaces.Arity8_4<I1, I2, I3, IO, I5, I6, I7, I8> matchInplace8_4(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<IO> ioType, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity8_4.class, ioType, new Nil[] {in1Type, in2Type, in3Type, ioType, in5Type, in6Type, in7Type, in8Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace8_5}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, IO, I6, I7, I8> Inplaces.Arity8_5<I1, I2, I3, I4, IO, I6, I7, I8> matchInplace8_5(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<IO> ioType, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity8_5.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, ioType, in6Type, in7Type, in8Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace8_6}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, IO, I7, I8> Inplaces.Arity8_6<I1, I2, I3, I4, I5, IO, I7, I8> matchInplace8_6(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<IO> ioType, final Nil<I7> in7Type, final Nil<I8> in8Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity8_6.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, ioType, in7Type, in8Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace8_7}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, IO, I8> Inplaces.Arity8_7<I1, I2, I3, I4, I5, I6, IO, I8> matchInplace8_7(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<IO> ioType, final Nil<I8> in8Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity8_7.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, ioType, in8Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace8_8}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, I7, IO> Inplaces.Arity8_8<I1, I2, I3, I4, I5, I6, I7, IO> matchInplace8_8(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<IO> ioType, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity8_8.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, ioType});
	}

	/**
	 * As {@link OpBuilder#matchInplace9_1}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <IO, I2, I3, I4, I5, I6, I7, I8, I9> Inplaces.Arity9_1<IO, I2, I3, I4, I5, I6, I7, I8, I9> matchInplace9_1(final OpEnvironment env, final String opName, final Nil<IO> ioType, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity9_1.class, ioType, new Nil[] {ioType, in2Type, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace9_2}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, IO, I3, I4, I5, I6, I7, I8, I9> Inplaces.Arity9_2<I1, IO, I3, I4, I5, I6, I7, I8, I9> matchInplace9_2(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<IO> ioType, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity9_2.class, ioType, new Nil[] {in1Type, ioType, in3Type, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace9_3}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, IO, I4, I5, I6, I7, I8, I9> Inplaces.Arity9_3<I1, I2, IO, I4, I5, I6, I7, I8, I9> matchInplace9_3(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<IO> ioType, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity9_3.class, ioType, new Nil[] {in1Type, in2Type, ioType, in4Type, in5Type, in6Type, in7Type, in8Type, in9Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace9_4}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, IO, I5, I6, I7, I8, I9> Inplaces.Arity9_4<I1, I2, I3, IO, I5, I6, I7, I8, I9> matchInplace9_4(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<IO> ioType, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity9_4.class, ioType, new Nil[] {in1Type, in2Type, in3Type, ioType, in5Type, in6Type, in7Type, in8Type, in9Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace9_5}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, IO, I6, I7, I8, I9> Inplaces.Arity9_5<I1, I2, I3, I4, IO, I6, I7, I8, I9> matchInplace9_5(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<IO> ioType, final Nil<I6> in6Type, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity9_5.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, ioType, in6Type, in7Type, in8Type, in9Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace9_6}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, IO, I7, I8, I9> Inplaces.Arity9_6<I1, I2, I3, I4, I5, IO, I7, I8, I9> matchInplace9_6(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<IO> ioType, final Nil<I7> in7Type, final Nil<I8> in8Type, final Nil<I9> in9Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity9_6.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, ioType, in7Type, in8Type, in9Type});
	}

	/**
	 * As {@link OpBuilder#matchInplace9_7}, but match using the provided {@code Hints}.
	 */
	@SuppressWarnings({ "unchecked" })
	public static <I1, I2, I3, I4, I5, I6, IO, I8, I9> Inplaces.Arity9_7<I1, I2, I3, I4, I5, I6, IO, I8, I9> matchInplace9_7(final OpEnvironment env, final String opName, final Nil<I1> in1Type, final Nil<I2> in2Type, final Nil<I3> in3Type, final Nil<I4> in4Type, final Nil<I5> in5Type, final Nil<I6> in6Type, final Nil<IO> ioType, final Nil<I8> in8Type, final Nil<I9> in9Type, final Hints hints)
	{
		return matchInplaceHelper(env, opName, hints, Inplaces.Arity9_7.class, ioType, new Nil[] {in1Type, in2Type, in3Type, in4Type, in5Type, in6Type, ioType, in8Type, in9Type});
	}

	/**
	 * As 