/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.api;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import org.scijava.ops.api.Hints;
import org.scijava.struct.Member;
import org.scijava.struct.Struct;
import org.scijava.struct.StructInstance;

public interface OpInfo
extends Comparable<OpInfo> {
    public static final String IMPL_DECLARATION = "|Info:";

    public List<String> names();

    public Type opType();

    public Struct struct();

    public Hints declaredHints();

    default public List<Member<?>> inputs() {
        return this.struct().members().stream().filter(Member::isInput).collect(Collectors.toList());
    }

    default public List<Type> inputTypes() {
        return this.inputs().stream().map(Member::type).collect(Collectors.toList());
    }

    default public List<Member<?>> outputs() {
        return this.struct().members().stream().filter(Member::isOutput).collect(Collectors.toList());
    }

    default public Member<?> output() {
        List<Member<?>> outputs = this.outputs();
        if (outputs.size() == 0) {
            throw new IllegalStateException("No outputs in Struct " + this.struct());
        }
        if (outputs.size() == 1) {
            return outputs.get(0);
        }
        throw new IllegalStateException("Multiple outputs in Struct " + this.struct());
    }

    default public Type outputType() {
        return this.output().type();
    }

    public double priority();

    public String implementationName();

    public StructInstance<?> createOpInstance(List<?> var1);

    public AnnotatedElement getAnnotationBearer();

    @Override
    default public int compareTo(OpInfo that) {
        if (this.priority() < that.priority()) {
            return 1;
        }
        if (this.priority() > that.priority()) {
            return -1;
        }
        return this.implementationName().compareTo(that.implementationName());
    }

    public String version();

    public String id();

    default public String description() {
        return "";
    }
}

