/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.api;

import java.lang.reflect.Type;
import java.util.Objects;
import org.scijava.common3.GenericTyped;
import org.scijava.ops.api.InfoTree;

public class OpInstance<T>
implements GenericTyped {
    private final T op;
    private final InfoTree info;
    private final Type reifiedType;

    public OpInstance(T op, InfoTree backingInfo, Type reifiedType) {
        this.op = op;
        this.info = backingInfo;
        this.reifiedType = reifiedType;
    }

    public static <T> OpInstance<T> of(T op, InfoTree backingInfo, Type reifiedType) {
        return new OpInstance<T>(op, backingInfo, reifiedType);
    }

    public T op() {
        return this.op;
    }

    public InfoTree infoTree() {
        return this.info;
    }

    public boolean equals(Object that) {
        if (!(that instanceof OpInstance)) {
            return false;
        }
        OpInstance thatInstance = (OpInstance)that;
        boolean infosEqual = this.infoTree().equals(thatInstance.infoTree());
        boolean objectsEqual = this.op().equals(thatInstance.op());
        boolean typesEqual = this.type().equals(thatInstance.type());
        return infosEqual && objectsEqual && typesEqual;
    }

    public int hashCode() {
        return Objects.hash(this.infoTree(), this.op(), this.type());
    }

    public Type type() {
        return this.reifiedType;
    }

    public String toString() {
        return this.infoTree().info().toString();
    }
}

