/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.adapt.functional;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.function.Container;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.adapt.functional.ComputersToFunctionsViaFunction;
import org.scijava.ops.engine.create.CreateOpCollection;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpMethod;

public class PermutedComputerToFunctionAdaptTest
extends AbstractTestEnvironment
implements OpCollection {
    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new PermutedComputerToFunctionAdaptTest()});
        ops.register(new Object[]{new ComputersToFunctionsViaFunction.Computer2ToFunction2ViaFunction()});
        ops.register(new Object[]{new CreateOpCollection()});
    }

    @OpMethod(names="adapt.permuted", type=Computers.Arity2_1.class)
    public static void compute(@Container double[] out, double[] in1, double[] in2) {
        for (int i = 0; i < in1.length; ++i) {
            out[i] = in1[i] * in2[i];
        }
    }

    @Test
    public void testAdaptingPermutedComputer() {
        double[] result = (double[])ops.op("adapt.permuted").input((Object)new double[]{1.5}, (Object)new double[]{2.0}).outType(double[].class).apply();
        Assertions.assertEquals((double)3.0, (double)result[0]);
    }
}

