/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.common3.Any;
import org.scijava.function.Computers;
import org.scijava.function.Producer;
import org.scijava.ops.api.InfoTree;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.api.Ops;
import org.scijava.ops.api.RichOp;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.adapt.functional.ComputersToFunctionsViaSource;
import org.scijava.ops.engine.matcher.ExceptionalThing;
import org.scijava.ops.engine.matcher.NestedThing;
import org.scijava.ops.engine.matcher.StringContainer;
import org.scijava.ops.engine.matcher.Thing;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpDependency;
import org.scijava.ops.spi.OpField;
import org.scijava.ops.spi.OpMethod;

public class MatchingWithAnyTest
extends AbstractTestEnvironment
implements OpCollection {
    @OpField(names="test.functionAndLongToLong")
    public final BiFunction<Function<Long, Long>, Long, Long> funcAndLongToLong = (t, u) -> (Long)t.apply(u);
    @OpField(names="test.integerAndLongAndNotAnyComputer")
    public final Computers.Arity2<Integer, Long, StringContainer> integerAndLongAndNotAnyComputer = (in1, in2, out) -> out.setValue(Long.toString((long)in1.intValue() + in2));
    @OpField(names="engine.create, create.stringContainer")
    public final Producer<StringContainer> stringContainerCreator = StringContainer::new;
    @OpField(names="test.any")
    public final Function<Thing<String>, Double> thingFunction = t -> t.create("Hello");
    @OpField(names="test.exceptionalAny")
    public final Function<ExceptionalThing<String>, Double> exceptionalThingFunction = t -> {
        String s = (String)t.getU();
        return t.create("Hello");
    };
    @OpField(names="test.nestedAny")
    public final Function<NestedThing<String, Thing<String>>, Double> nestedThingFunction = t -> 5.0;

    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new MatchingWithAnyTest()});
        ops.register(new Object[]{new ComputersToFunctionsViaSource.Computer2ToFunction2ViaSource()});
    }

    @Test
    public void testAny() {
        NestedThing nthing = new NestedThing();
        Double e = (Double)ops.op("test.nestedAny").input(nthing).outType(Double.class).apply();
        Thing thing = new Thing();
        Double d = (Double)ops.op("test.any").input(thing).outType(Double.class).apply();
        assert (d == 5.0);
        assert (e == 5.0);
    }

    @Test
    public void testExceptionalThing() {
        ExceptionalThing<Double> ething = new ExceptionalThing<Double>(0.5);
        Assertions.assertThrows(ClassCastException.class, () -> {
            Double d = (Double)ops.op("test.exceptionalAny").input((Object)ething).outType(Double.class).apply();
        });
    }

    @Test
    public void testRunAnyFunction2FromComputer2() {
        int in1 = 11;
        long in2 = 31L;
        StringContainer out = (StringContainer)ops.op("test.integerAndLongAndNotAnyComputer").input((Object)11, (Object)31L).outType(StringContainer.class).apply();
        Assertions.assertEquals((Object)Long.toString(42L), (Object)out.getValue());
    }

    @Test
    public void testMatchingAnyWithDependencies() {
        Function op = ops.op("test.AnyWithDependencies").inType(Any.class).outType(Double.class).function();
        RichOp richOp = Ops.rich((Object)op);
        OpInfo info = Ops.info((Object)op);
        Assertions.assertTrue((boolean)info.toString().contains("dependentAnyOp"));
        InfoTree dInfo = (InfoTree)richOp.infoTree().dependencies().get(0);
        Assertions.assertTrue((boolean)dInfo.toString().contains("lowPriority"));
    }

    @OpMethod(names="test.AnyWithDependencies", type=Function.class)
    public static <N extends Number> Double dependentAnyOp(@OpDependency(name="test.AnyDependent") Function<N, Double> e, List<N> input) {
        return input.stream().map(e).reduce(0.0, Double::sum);
    }

    @OpMethod(names="test.AnyDependent", type=Function.class, priority=100.0)
    public static Double highPriorityDependingOp(String input) {
        throw new IllegalStateException("This should not be called!");
    }

    @OpMethod(names="test.AnyDependent", type=Function.class, priority=-100.0)
    public static Double lowPriorityDependingOp(Number input) {
        return input.doubleValue();
    }
}

