/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.convert;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.SortedSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.function.Container;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.api.Ops;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.conversionLoss.impl.IdentityLossReporter;
import org.scijava.ops.engine.conversionLoss.impl.PrimitiveLossReporters;
import org.scijava.ops.engine.copy.CopyOpCollection;
import org.scijava.ops.engine.create.CreateOpCollection;
import org.scijava.ops.engine.matcher.convert.ConvertedOpInfo;
import org.scijava.ops.engine.matcher.convert.IdentityCollection;
import org.scijava.ops.engine.matcher.convert.PrimitiveArrayConverters;
import org.scijava.ops.engine.matcher.convert.PrimitiveConverters;
import org.scijava.ops.engine.matcher.convert.UtilityConverters;
import org.scijava.ops.engine.matcher.impl.LossReporterWrapper;
import org.scijava.ops.spi.Op;
import org.scijava.ops.spi.OpClass;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;
import org.scijava.ops.spi.OpMethod;
import org.scijava.struct.Member;

public class ConversionTest
extends AbstractTestEnvironment
implements OpCollection {
    @OpField(names="test.math.powDouble", params={"base, exponent, result"})
    public final BiFunction<Double, Double, Double> powOp = Math::pow;
    @OpField(names="test.math.powDouble", params={"base, exponent, result"})
    public final BiFunction<Long, Long, Double> powOpL = Math::pow;
    @OpField(names="test.math.powDouble", params={"base, exponent, result"})
    public final BiFunction<Integer[], Double, Double> powOpArray = (b, e) -> Math.pow(b[0].intValue(), e);
    private static final String TEST_DESC = "This Op will be converted";

    @BeforeAll
    public static void AddNeededOps() {
        ops.register(new Object[]{new CopyOpCollection(), new CreateOpCollection(), new IdentityCollection(), new IdentityLossReporter(), new LossReporterWrapper(), new PrimitiveArrayConverters(), new PrimitiveConverters(), new PrimitiveLossReporters(), new ConversionTest(), new UtilityConverters(), new DivOp()});
    }

    @Test
    public void testConversion() {
        Integer number = 2;
        Integer exponent = 2;
        Double result = (Double)ops.op("test.math.powDouble").input((Object)number, (Object)exponent).outType(Double.class).apply();
        Assertions.assertEquals((double)4.0, (double)result, (double)0.0);
    }

    @Test
    public void testSomeConversion() {
        Integer number = 2;
        Double exponent = 2.0;
        Double result = (Double)ops.op("test.math.powDouble").input((Object)number, (Object)exponent).outType(Double.class).apply();
        Assertions.assertEquals((double)4.0, (double)result, (double)0.0);
    }

    @Test
    public void testArrayConversion() {
        byte[] number = new byte[]{2};
        Double exponent = 3.0;
        Double result = (Double)ops.op("test.math.powDouble").input((Object)number, (Object)exponent).outType(Double.class).apply();
        Assertions.assertEquals((double)8.0, (double)result, (double)0.0);
    }

    @Test
    public void testConvertedOp() {
        BiFunction numFunc = ops.op("test.math.powDouble").inType(Number.class, Number.class).outType(Double.class).function();
        Double result = (Double)numFunc.apply(3.0, 4.0);
        Assertions.assertEquals((double)81.0, (double)result, (double)0.0);
    }

    @OpMethod(names="test.differentOrder", type=Computers.Arity1_1.class)
    public static void foo(@Container Integer[] i1, Double[] i2) {
        for (int i = 0; i < i1.length; ++i) {
            i1[i] = i2[i].intValue() * i2[i].intValue();
        }
    }

    @Test
    public void testConvertedOpInfo() {
        Long[] i1 = new Long[]{1L};
        Byte[] i2 = new Byte[]{(byte)2};
        Computers.Arity1 op = ops.op("test.differentOrder").input((Object)i1).output((Object)i2).computer();
        OpInfo info = Ops.rich((Object)op).infoTree().info();
        Assertions.assertInstanceOf(ConvertedOpInfo.class, (Object)info);
        Object[] expected = new Type[]{Long[].class, Byte[].class};
        Assertions.assertArrayEquals((Object[])expected, (Object[])info.inputTypes().toArray());
        Assertions.assertEquals(Byte[].class, (Object)info.outputType());
        List members = info.struct().members();
        Assertions.assertEquals(Long[].class, (Object)((Member)members.get(0)).type());
        Assertions.assertEquals(Byte[].class, (Object)((Member)members.get(1)).type());
        String expImplName = "org.scijava.ops.engine.matcher.convert.ConversionTest.foo(java.lang.Integer[],java.lang.Double[])|converted_Long_Arr_Byte_Arr";
        String actImplName = info.implementationName();
        Assertions.assertEquals((Object)expImplName, (Object)actImplName);
    }

    @OpMethod(names="test.anyConversion", type=Function.class)
    public static Integer foo(Integer i1) {
        return i1 * i1;
    }

    @Test
    public void testConvertAnys() {
        Double in = 2.0;
        Object out = ops.op("test.anyConversion").input((Object)in).apply();
        Assertions.assertInstanceOf(Integer.class, (Object)out);
    }

    @OpMethod(names="test.maxNumberAndComparable", type=BiFunction.class)
    public static <T extends Number> T foo(T in1, T in2) {
        return ((Comparable)((Object)in1)).compareTo(in2) > 0 ? in1 : in2;
    }

    @Test
    public void testConvertMultipleBounds() {
        String name = "test.maxNumberAndComparable";
        SortedSet infos = ops.infos(name);
        Assertions.assertEquals((int)1, (int)infos.size());
        Type inType = (Type)((OpInfo)infos.first()).inputTypes().get(0);
        Assertions.assertInstanceOf(TypeVariable.class, (Object)inType);
        int numBounds = ((TypeVariable)inType).getBounds().length;
        Assertions.assertEquals((int)2, (int)numBounds);
        Integer i1 = 1;
        Double i2 = 2.0;
        Object result = ops.op(name).input((Object)i1, (Object)i2).apply();
        Assertions.assertInstanceOf(Integer.class, (Object)result);
        Integer intResult = (Integer)result;
        Assertions.assertEquals((int)2, (Integer)intResult);
    }

    @OpMethod(names="test.maxNumberIntegerNumber", type=BiFunction.class)
    public static Number max(Number in1, Integer in2) {
        return in2.compareTo(in1.intValue()) > 0 ? (Number)in1 : (Number)in2;
    }

    @Test
    public void testIdentityConversion() {
        ops.op("test.maxNumberIntegerNumber").inType(Double.class, Double.class).outType(Number.class).function();
    }

    @Test
    public void testConversionDescription() {
        BiFunction op = ops.op("math.div").input((Object)5.0, (Object)2.0).function();
        OpInfo info = Ops.info((Object)op);
        Assertions.assertInstanceOf(ConvertedOpInfo.class, (Object)info);
        Assertions.assertEquals((Object)TEST_DESC, (Object)info.description());
        Assertions.assertTrue((boolean)info.toString().contains(TEST_DESC));
    }

    @OpClass(names="math.div", description="This Op will be converted")
    private static class DivOp
    implements BiFunction<Integer, Integer, Integer>,
    Op {
        private DivOp() {
        }

        @Override
        public Integer apply(Integer i1, Integer i2) {
            return i1 / i2;
        }
    }
}

