/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.yaml.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.discovery.Discoverer;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.yaml.impl.YAMLOpInfoDiscoverer;

public class YAMLOpTest
extends AbstractTestEnvironment {
    @BeforeAll
    public static void setup() {
        ops.discoverUsing(new Discoverer[]{new YAMLOpInfoDiscoverer()});
    }

    @Test
    public void testYAMLClass() {
        Double sum = (Double)ops.op("example.add").input((Object)2.0, (Object)3.0).outType(Double.class).apply();
        Assertions.assertEquals((double)5.0, (double)sum, (double)1.0E-6);
    }

    @Test
    public void testYAMLInnerClass() {
        Double quot = (Double)ops.op("example.div").input((Object)24.0, (Object)8.0).outType(Double.class).apply();
        Assertions.assertEquals((double)3.0, (double)quot, (double)1.0E-6);
    }

    @Test
    public void testYAMLMethodFunction() {
        Double sum = (Double)ops.op("example.sub").input((Object)2.0, (Object)3.0).outType(Double.class).apply();
        Assertions.assertEquals((double)-1.0, (double)sum, (double)1.0E-6);
    }

    @Test
    public void testYAMLMethodFunctionNullable() {
        Double sum = (Double)ops.op("example.sub").input((Object)2.0).outType(Double.class).apply();
        Assertions.assertEquals((double)2.0, (double)sum, (double)1.0E-6);
    }

    @Test
    public void testYAMLMethodInplaceShortType() {
        List<Integer> l1 = Arrays.asList(1);
        List<Integer> l2 = Arrays.asList(3);
        ops.op("example.xor").input(l1, l2).mutate1();
        Assertions.assertEquals((double)2.0, (double)l1.get(0).intValue(), (double)1.0E-6);
    }

    @Test
    public void testYAMLMethodComputerShortType() {
        List<Integer> l1 = Arrays.asList(1);
        List<Integer> l2 = Arrays.asList(3);
        ArrayList out = new ArrayList();
        ops.op("example.and").input(l1, l2).output(out).compute();
        Assertions.assertEquals((double)1.0, (double)((Integer)out.get(0)).intValue(), (double)1.0E-6);
    }

    @Test
    public void testYAMLMethodExtraComputerShortType() {
        List<Integer> l1 = Arrays.asList(1);
        List<Integer> l2 = Arrays.asList(2);
        ArrayList out = new ArrayList();
        ops.op("example.or").input(l1, l2).output(out).compute();
        Assertions.assertEquals((double)3.0, (double)((Integer)out.get(0)).intValue(), (double)1.0E-6);
    }

    @Test
    public void testYAMLField() {
        Double sum = (Double)ops.op("example.mul").input((Object)2.0, (Object)3.0).outType(Double.class).apply();
        Assertions.assertEquals((double)6.0, (double)sum, (double)1.0E-6);
    }

    @Test
    public void testYAMLDescription() {
        String actual = ops.help("example.mul");
        String expected = "example.mul:\n\t- (Double, Double) -> Double";
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

