/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.impl;

import com.google.common.base.Strings;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.scijava.common3.Types;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.api.OpMatchingException;
import org.scijava.ops.api.OpRequest;
import org.scijava.ops.engine.OpDescriptionGenerator;
import org.scijava.ops.engine.matcher.convert.ConvertedOpInfo;
import org.scijava.ops.engine.matcher.reduce.ReducedOpInfo;
import org.scijava.ops.engine.util.Infos;
import org.scijava.struct.ItemIO;
import org.scijava.struct.Member;
import org.scijava.types.Nil;

public class DefaultOpDescriptionGenerator
implements OpDescriptionGenerator {
    @Override
    public double priority() {
        return 10000.0;
    }

    @Override
    public String simpleDescriptions(OpEnvironment env, OpRequest req) {
        return DefaultOpDescriptionGenerator.buildOpString(req, env, info -> DefaultOpDescriptionGenerator.describeUsingOps(info, env));
    }

    @Override
    public String verboseDescriptions(OpEnvironment env, OpRequest req) {
        return DefaultOpDescriptionGenerator.buildOpString(req, env, Infos::describe);
    }

    private static String buildOpString(OpRequest req, OpEnvironment env, Function<OpInfo, String> descriptionFunction) {
        String name = req.name();
        Optional<String> nsString = DefaultOpDescriptionGenerator.getNonOpString(env, name);
        if (nsString.isPresent()) {
            return nsString.get();
        }
        SortedSet infos = env.infos(name);
        List<OpInfo> filtered = DefaultOpDescriptionGenerator.filterInfos(infos, req);
        String opString = filtered.stream().map(descriptionFunction).map(s -> s.replaceAll("\n", "\n\t")).distinct().collect(Collectors.joining("\n\t- "));
        if (opString.isEmpty()) {
            return "No Ops found matching this request.";
        }
        return req.name() + ":\n\t- " + opString;
    }

    private static Optional<String> getNonOpString(OpEnvironment env, String name) {
        String prefix = null;
        Stream<String> nsStream = null;
        if (Strings.isNullOrEmpty((String)name)) {
            nsStream = DefaultOpDescriptionGenerator.publicOpStream(env);
            nsStream = nsStream.map(s -> s.substring(0, s.indexOf(46))).distinct();
            prefix = "Namespaces:\n\t> ";
        } else if (env.infos(name).isEmpty()) {
            nsStream = DefaultOpDescriptionGenerator.publicOpStream(env).filter(n -> n.startsWith(name));
            prefix = "Names:\n\t> ";
        }
        if (nsStream == null) {
            return Optional.empty();
        }
        String suffix = nsStream.collect(Collectors.joining("\n\t> "));
        if (Strings.isNullOrEmpty((String)suffix)) {
            return Optional.of("Not a valid Op name or namespace:\n\t> " + name);
        }
        return Optional.of(prefix + suffix);
    }

    private static Stream<String> publicOpStream(OpEnvironment env) {
        return env.infos().stream().flatMap(info -> info.names().stream()).distinct().sorted().filter(ns -> !ns.startsWith("engine"));
    }

    private static List<OpInfo> filterInfos(Iterable<? extends OpInfo> infos, OpRequest req) {
        ArrayList<OpInfo> filtered = new ArrayList<OpInfo>();
        for (OpInfo opInfo : infos) {
            if (opInfo instanceof ReducedOpInfo || opInfo instanceof ConvertedOpInfo && ((ConvertedOpInfo)opInfo).srcInfo() instanceof ReducedOpInfo) continue;
            long numPureInputs = opInfo.inputs().stream().filter(m -> !ItemIO.CONTAINER.equals((Object)m.getIOType())).count();
            Type[] args = req.argTypes();
            if (args != null && (long)args.length != numPureInputs) continue;
            filtered.add(opInfo);
        }
        return filtered;
    }

    private static String describeUsingOps(OpInfo info, OpEnvironment env) {
        StringBuilder sb = new StringBuilder("(");
        Iterator memberItr = info.inputs().iterator();
        while (memberItr.hasNext()) {
            Member m = (Member)memberItr.next();
            if (m.getIOType() == ItemIO.MUTABLE) {
                sb.append("@MUTABLE ");
            } else if (m.getIOType() == ItemIO.CONTAINER) {
                sb.append("@CONTAINER ");
            }
            sb.append(DefaultOpDescriptionGenerator.describeType(env, Nil.of((Type)m.type())));
            if (!m.isRequired()) {
                sb.append(" = null");
            }
            if (!memberItr.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        Member output = info.output();
        sb.append(" -> ");
        if (output.isInput()) {
            sb.append("None");
        } else {
            sb.append(DefaultOpDescriptionGenerator.describeType(env, Nil.of((Type)output.type())));
        }
        return sb.toString();
    }

    private static <T> String describeType(OpEnvironment env, Nil<T> from) {
        ParameterizedType specialType = Types.parameterize(Function.class, (Type[])new Type[]{Types.parameterize(Nil.class, (Type[])new Type[]{from.type()}), String.class});
        Nil specialTypeNil = Nil.of((Type)specialType);
        try {
            ParameterizedType nilFromType = Types.parameterize(Nil.class, (Type[])new Type[]{from.type()});
            Hints h = new Hints(new String[]{"adaptation.FORBIDDEN", "conversion.FORBIDDEN", "history.IGNORE"});
            Function op = (Function)env.op("engine.describe", specialTypeNil, new Nil[]{Nil.of((Type)nilFromType)}, Nil.of(String.class), h);
            return (String)op.apply(from);
        }
        catch (OpMatchingException e) {
            return Types.raw((Type)from.type()).getSimpleName();
        }
    }
}

