/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.scijava.common3.Types;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.OpDependencyMember;
import org.scijava.ops.engine.struct.ClassOpDependencyMemberParser;
import org.scijava.ops.engine.struct.ClassParameterMemberParser;
import org.scijava.ops.engine.util.Infos;
import org.scijava.struct.MemberParser;
import org.scijava.struct.Struct;
import org.scijava.struct.StructInstance;
import org.scijava.struct.Structs;

public class DefaultOpClassInfo
implements OpInfo {
    private final List<String> names;
    private final Class<?> opClass;
    private final String version;
    private final Struct struct;
    private final double priority;
    private final String description;
    private final Hints hints;

    public DefaultOpClassInfo(Class<?> opClass, String version, String description, Hints hints, double priority, String ... names) {
        this.opClass = opClass;
        this.version = version;
        this.names = Arrays.asList(names);
        this.description = description;
        this.priority = priority;
        this.hints = hints;
        this.struct = Structs.from(opClass, opClass, (MemberParser[])new MemberParser[]{new ClassParameterMemberParser(), new ClassOpDependencyMemberParser()});
        Infos.validate(this);
    }

    public String description() {
        return this.description;
    }

    public List<String> names() {
        return this.names;
    }

    public Type opType() {
        return Types.parameterize(this.opClass, (Type[])new Type[0]);
    }

    public Struct struct() {
        return this.struct;
    }

    public Hints declaredHints() {
        return this.hints;
    }

    public double priority() {
        return this.priority;
    }

    public String implementationName() {
        return this.opClass.getName();
    }

    public StructInstance<?> createOpInstance(List<?> dependencies) {
        Object op;
        try {
            Constructor<?> ctor = this.opClass.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            op = ctor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to instantiate op: '" + this.opClass.getName() + "' Ensure that the Op has a no-args constructor.", e);
        }
        List<OpDependencyMember<?>> dependencyMembers = Infos.dependencies(this);
        for (int i = 0; i < dependencyMembers.size(); ++i) {
            OpDependencyMember<?> dependencyMember = dependencyMembers.get(i);
            try {
                dependencyMember.createInstance(op).set(dependencies.get(i));
                continue;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Exception trying to inject Op dependency field.\n\tOp dependency field to resolve: " + dependencyMember.key() + "\n\tFound Op to inject: " + dependencies.get(i).getClass().getName() + "\n\tField signature: " + dependencyMember.type(), ex);
            }
        }
        return this.struct().createInstance(op);
    }

    public AnnotatedElement getAnnotationBearer() {
        return this.opClass;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultOpClassInfo)) {
            return false;
        }
        OpInfo that = (OpInfo)o;
        return this.struct().equals(that.struct());
    }

    public int hashCode() {
        return this.struct().hashCode();
    }

    public String toString() {
        return Infos.describe(this);
    }

    public String version() {
        return this.version;
    }

    public String id() {
        return "|Info:" + this.implementationName() + "@" + this.version();
    }
}

