/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.scijava.common3.Types;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.exceptions.impl.PrivateOpException;
import org.scijava.ops.engine.struct.FieldInstance;
import org.scijava.ops.engine.struct.FieldParameterMemberParser;
import org.scijava.ops.engine.util.Infos;
import org.scijava.struct.MemberParser;
import org.scijava.struct.Struct;
import org.scijava.struct.StructInstance;
import org.scijava.struct.Structs;

public class DefaultOpFieldInfo
implements OpInfo {
    private final Object instance;
    private final Field field;
    private final String version;
    private final String description;
    private final List<String> names;
    private final double priority;
    private final Struct struct;
    private final Hints hints;

    public DefaultOpFieldInfo(Object instance, Field field, String version, String description, Hints hints, double priority, String ... names) {
        this.instance = instance;
        this.version = version;
        this.description = description;
        this.field = field;
        this.names = Arrays.asList(names);
        this.priority = priority;
        this.hints = hints;
        if (Modifier.isStatic(field.getModifiers()) ? instance != null : !field.getDeclaringClass().isInstance(instance)) {
            // empty if block
        }
        if (!Modifier.isPublic(field.getModifiers())) {
            throw new PrivateOpException(field);
        }
        Type structType = Types.typeOf((Field)field, field.getDeclaringClass());
        FieldInstance fieldInstance = new FieldInstance(field, instance);
        this.struct = Structs.from((Object)fieldInstance, (Type)structType, (MemberParser[])new MemberParser[]{new FieldParameterMemberParser()});
        Infos.validate(this);
    }

    public List<String> names() {
        return this.names;
    }

    public String description() {
        return this.description;
    }

    public Type opType() {
        return this.field.getGenericType();
    }

    public Struct struct() {
        return this.struct;
    }

    public Hints declaredHints() {
        return this.hints;
    }

    public double priority() {
        return this.priority;
    }

    public String implementationName() {
        Object fullyQualifiedField = this.field.toGenericString();
        int lastDotPos = ((String)fullyQualifiedField).lastIndexOf(46);
        fullyQualifiedField = ((String)fullyQualifiedField).substring(0, lastDotPos) + "$" + ((String)fullyQualifiedField).substring(lastDotPos + 1);
        String packageName = this.field.getDeclaringClass().getPackageName();
        int classNameIndex = ((String)fullyQualifiedField).lastIndexOf(packageName);
        return ((String)fullyQualifiedField).substring(classNameIndex);
    }

    public StructInstance<?> createOpInstance(List<?> dependencies) {
        if (dependencies != null && !dependencies.isEmpty()) {
            throw new IllegalArgumentException("Op fields are not allowed to have any Op dependencies.");
        }
        try {
            Object object = this.field.get(this.instance);
            return this.struct().createInstance(object);
        }
        catch (IllegalAccessException exc) {
            exc.printStackTrace();
            throw new RuntimeException(exc);
        }
    }

    public AnnotatedElement getAnnotationBearer() {
        return this.field;
    }

    public String version() {
        return this.version;
    }

    public String id() {
        return "|Info:" + this.implementationName() + "@" + this.version();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultOpFieldInfo)) {
            return false;
        }
        OpInfo that = (OpInfo)o;
        return this.struct().equals(that.struct());
    }

    public int hashCode() {
        return this.struct().hashCode();
    }

    public String toString() {
        return Infos.describe(this);
    }
}

