/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.math;

import com.google.common.collect.Streams;
import java.math.BigInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.scijava.function.Computers;
import org.scijava.function.Inplaces;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;

public final class Add<M extends Number, I extends Iterable<M>>
implements OpCollection {
    public static final String NAMES = "math.add";
    @OpField(names="math.add")
    public static final BiFunction<Double, Double, Double> MathAddDoublesFunction = (t, u) -> t + u;
    @OpField(priority=100.0, names="math.add")
    public final BiFunction<I, I, Iterable<Double>> MathPointwiseAddIterablesFunction = (i1, i2) -> {
        Stream s1 = Streams.stream((Iterable)i1);
        Stream s2 = Streams.stream((Iterable)i2);
        return () -> Streams.zip((Stream)s1, (Stream)s2, (e1, e2) -> e1.doubleValue() + e2.doubleValue()).iterator();
    };
    @OpField(names="math.add")
    public static final BiFunction<BigInteger, BigInteger, BigInteger> MathAddBigIntegersComputer = (t, u) -> t.add((BigInteger)u);
    @OpField(names="math.add")
    public static final Computers.Arity2<double[], double[], double[]> MathPointwiseAddDoubleArraysComputer = (in1, in2, out) -> {
        for (int i = 0; i < ((double[])out).length; ++i) {
            out[i] = in1[i] + in2[i];
        }
    };
    @OpField(names="math.add")
    public static final Inplaces.Arity2_1<double[], double[]> MathPointwiseAddDoubleArraysInplace1 = (io, in2) -> {
        for (int i = 0; i < ((double[])io).length; ++i) {
            int n = i;
            io[n] = io[n] + in2[i];
        }
    };
    @OpField(names="math.add")
    public final BiFunction<M, M, Double> MathAddNumbersFunction = (in1, in2) -> in1.doubleValue() + in2.doubleValue();
    @OpField(names="math.add")
    public final Function<Iterable<M>, Double> MathReductionAdd = iterable -> StreamSupport.stream(iterable.spliterator(), false).mapToDouble(Number::doubleValue).sum();
}

