/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.struct;

import java.lang.reflect.Type;
import java.util.function.Supplier;
import org.scijava.ops.api.Hints;
import org.scijava.ops.engine.OpDependencyMember;
import org.scijava.ops.spi.OpDependency;
import org.scijava.struct.Member;
import org.scijava.struct.Structs;

public abstract class AnnotatedOpDependencyMember<T>
implements OpDependencyMember<T> {
    private final Supplier<String> keyGenerator;
    private String key;
    private boolean keyGenerated;
    private final Supplier<String> descriptionGenerator;
    private String description;
    private boolean descriptionGenerated;
    private final Type type;
    private final OpDependency annotation;
    private final Hints hints;

    public AnnotatedOpDependencyMember(String key, String description, Type type, OpDependency annotation) {
        this(() -> key, () -> description, type, annotation);
        this.key = key;
        this.keyGenerated = true;
        this.description = description;
        this.descriptionGenerated = true;
    }

    public AnnotatedOpDependencyMember(Supplier<String> keyGenerator, Supplier<String> descriptionGenerator, Type type, OpDependency annotation) {
        this.keyGenerator = keyGenerator;
        this.keyGenerated = false;
        this.descriptionGenerator = descriptionGenerator;
        this.descriptionGenerated = false;
        this.type = type;
        this.annotation = annotation;
        this.hints = new Hints(annotation.hints());
    }

    public OpDependency getAnnotation() {
        return this.annotation;
    }

    @Override
    public String getDependencyName() {
        return this.annotation.name();
    }

    @Override
    public Hints hints() {
        return this.hints;
    }

    public String key() {
        if (!this.keyGenerated) {
            this.generateKey();
        }
        return this.key;
    }

    private synchronized void generateKey() {
        if (this.keyGenerated) {
            return;
        }
        this.key = this.keyGenerator.get();
        this.keyGenerated = true;
    }

    public String description() {
        if (!this.descriptionGenerated) {
            this.generateDescription();
        }
        return this.description;
    }

    private synchronized void generateDescription() {
        if (this.descriptionGenerated) {
            return;
        }
        this.description = this.descriptionGenerator.get();
        this.descriptionGenerated = true;
    }

    public Type type() {
        return this.type;
    }

    public String toString() {
        return Structs.toString((Member)this);
    }
}

