/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.struct;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.scijava.common3.Annotations;
import org.scijava.ops.engine.exceptions.impl.FinalOpDependencyFieldException;
import org.scijava.ops.engine.struct.FieldOpDependencyMember;
import org.scijava.ops.spi.OpDependency;
import org.scijava.struct.MemberParser;
import org.scijava.struct.Structs;

public class ClassOpDependencyMemberParser
implements MemberParser<Class<?>, FieldOpDependencyMember<?>> {
    public List<FieldOpDependencyMember<?>> parse(Class<?> source, Type structType) {
        if (source == null) {
            return null;
        }
        ArrayList items = new ArrayList();
        Structs.checkModifiers((String)(source.getName() + ": "), (int)source.getModifiers(), (boolean)true, (int[])new int[]{1024});
        ClassOpDependencyMemberParser.parseFieldOpDependencies(items, source);
        return items;
    }

    private static void parseFieldOpDependencies(List<FieldOpDependencyMember<?>> items, Class<?> annotatedClass) {
        List fields = Annotations.annotatedFields(annotatedClass, OpDependency.class);
        for (Field f : fields) {
            f.setAccessible(true);
            if (Modifier.isFinal(f.getModifiers())) {
                throw new FinalOpDependencyFieldException(f);
            }
            FieldOpDependencyMember item = new FieldOpDependencyMember(f, annotatedClass);
            items.add(item);
        }
    }
}

