/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.yaml.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.scijava.common3.Annotations;
import org.scijava.common3.Classes;
import org.scijava.common3.Types;
import org.scijava.ops.engine.OpDependencyMember;
import org.scijava.ops.engine.exceptions.impl.FinalOpDependencyFieldException;
import org.scijava.ops.engine.struct.FieldOpDependencyMember;
import org.scijava.ops.engine.struct.FunctionalMethodType;
import org.scijava.ops.engine.struct.FunctionalParameters;
import org.scijava.ops.engine.struct.SynthesizedParameterMember;
import org.scijava.ops.engine.util.Infos;
import org.scijava.ops.engine.yaml.impl.AbstractYAMLOpInfo;
import org.scijava.ops.spi.OpDependency;
import org.scijava.struct.Struct;
import org.scijava.struct.StructInstance;

public class YAMLOpClassInfo
extends AbstractYAMLOpInfo {
    private final Class<?> cls;
    private final Struct struct;

    public YAMLOpClassInfo(Map<String, Object> yaml, String identifier) {
        super(yaml, identifier);
        this.cls = Classes.load((String)identifier);
        this.struct = this.createStruct(yaml);
        Infos.validate(this);
    }

    public Type opType() {
        return Types.parameterize(this.cls, (Type[])new Type[0]);
    }

    @Override
    public Struct struct() {
        return this.struct;
    }

    public String implementationName() {
        return this.cls.getName();
    }

    public AnnotatedElement getAnnotationBearer() {
        return this.cls;
    }

    public String id() {
        return "|Info:" + this.implementationName() + "@" + this.version();
    }

    private Struct createStruct(Map<String, Object> yaml) {
        ArrayList<Object> members = new ArrayList<Object>();
        List params = (List)yaml.get("parameters");
        List<FunctionalMethodType> fmts = FunctionalParameters.findFunctionalMethodTypes(this.cls);
        for (int i = 0; i < params.size(); ++i) {
            Map pMap = (Map)params.get(i);
            FunctionalMethodType fmt = fmts.get(i);
            String name = (String)pMap.get("name");
            String description = (String)pMap.get("description");
            boolean nullable = pMap.getOrDefault("nullable", false);
            members.add(new SynthesizedParameterMember(fmt, name, !nullable, description));
        }
        List fields = Annotations.annotatedFields(this.cls, OpDependency.class);
        for (Field f : fields) {
            f.setAccessible(true);
            if (Modifier.isFinal(f.getModifiers())) {
                throw new FinalOpDependencyFieldException(f);
            }
            FieldOpDependencyMember item = new FieldOpDependencyMember(f, this.cls);
            members.add(item);
        }
        return () -> members;
    }

    public StructInstance<?> createOpInstance(List<?> dependencies) {
        Object op;
        try {
            Constructor<?> ctor = this.cls.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            op = ctor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to instantiate op: '" + this.cls.getName() + "' Ensure that the Op has a no-args constructor.", e);
        }
        List<OpDependencyMember<?>> dependencyMembers = Infos.dependencies(this);
        for (int i = 0; i < dependencyMembers.size(); ++i) {
            OpDependencyMember<?> dependencyMember = dependencyMembers.get(i);
            try {
                dependencyMember.createInstance(op).set(dependencies.get(i));
                continue;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Exception trying to inject Op dependency field.\n\tOp dependency field to resolve: " + dependencyMember.key() + "\n\tFound Op to inject: " + dependencies.get(i).getClass().getName() + "\n\tField signature: " + dependencyMember.type(), ex);
            }
        }
        return this.struct().createInstance(op);
    }
}

