/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.yaml.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.scijava.common3.Classes;
import org.scijava.discovery.Discoverer;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.yaml.YAMLOpInfoCreator;
import org.scijava.ops.engine.yaml.YAMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class YAMLOpInfoDiscoverer
implements Discoverer {
    private final Yaml yaml = new Yaml();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<YAMLOpInfoCreator> creators = Discoverer.using(ServiceLoader::load).discover(YAMLOpInfoCreator.class);

    public <U> List<U> discover(Class<U> c) {
        if (!c.equals(OpInfo.class)) {
            return Collections.emptyList();
        }
        ArrayList opInfos = new ArrayList();
        this.getOpYAML().stream().distinct().forEach(opFile -> {
            try {
                this.parse(opInfos, (URL)opFile);
            }
            catch (IOException e) {
                this.log.warn("Could not read Op YAML file " + opFile + ": ", (Throwable)e);
            }
        });
        return opInfos;
    }

    private List<URL> getOpYAML() {
        try {
            Enumeration<URL> e = Classes.classLoader().getResources("ops.yaml");
            return Collections.list(e);
        }
        catch (IOException e) {
            this.log.error("Could not load Op YAML files!", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private void parse(List<OpInfo> infos, URL url) throws IOException {
        List yamlData;
        try {
            yamlData = (List)this.yaml.load(url.openStream());
        }
        catch (RuntimeException exc) {
            throw new IOException("Failed to parse Op YAML: " + url.getPath(), exc);
        }
        for (Map op : yamlData) {
            Map<String, Object> opData = YAMLUtils.subMap(op, "op");
            String identifier = YAMLUtils.value(opData, "source");
            try {
                URI uri = new URI(identifier);
                Optional<YAMLOpInfoCreator> c = this.creators.stream().filter(f -> f.canCreateFrom(uri)).findFirst();
                if (!c.isPresent()) continue;
                infos.add(c.get().create(uri, opData));
            }
            catch (Exception e) {
                this.log.warn("Could not add op " + identifier, (Throwable)e);
            }
        }
    }
}

