/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.yaml.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.scijava.common3.Classes;
import org.scijava.function.Computers;
import org.scijava.function.Functions;
import org.scijava.function.Inplaces;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.exceptions.impl.InstanceOpMethodException;
import org.scijava.ops.engine.exceptions.impl.PrivateOpException;
import org.scijava.ops.engine.exceptions.impl.UnreadableOpException;
import org.scijava.ops.engine.struct.FunctionalMethodType;
import org.scijava.ops.engine.struct.FunctionalParameters;
import org.scijava.ops.engine.struct.MethodParameterOpDependencyMember;
import org.scijava.ops.engine.struct.SynthesizedParameterMember;
import org.scijava.ops.engine.util.Infos;
import org.scijava.ops.engine.util.internal.OpMethodUtils;
import org.scijava.ops.engine.yaml.impl.AbstractYAMLOpInfo;
import org.scijava.ops.spi.OpDependency;
import org.scijava.struct.Struct;
import org.scijava.struct.StructInstance;

public class YAMLOpMethodInfo
extends AbstractYAMLOpInfo
implements OpInfo {
    private final Type opType;
    private final Method method;
    private final Struct struct;

    public YAMLOpMethodInfo(Map<String, Object> yaml, String identifier) throws NoSuchMethodException {
        super(yaml, identifier);
        this.method = YAMLOpMethodInfo.parseMethod(identifier);
        this.struct = this.createStruct(yaml);
        this.opType = OpMethodUtils.getOpMethodType(this.deriveOpType(), this.method);
        YAMLOpMethodInfo.checkModifiers(this.method);
        Infos.validate(this);
    }

    public Type opType() {
        return this.opType;
    }

    @Override
    public Struct struct() {
        return this.struct;
    }

    public String implementationName() {
        String fullyQualifiedMethod = this.method.toGenericString();
        String packageName = this.method.getDeclaringClass().getPackageName();
        int classNameIndex = fullyQualifiedMethod.indexOf(packageName);
        return fullyQualifiedMethod.substring(classNameIndex);
    }

    public StructInstance<?> createOpInstance(List<?> dependencies) {
        return OpMethodUtils.createOpInstance(this, this.method, dependencies);
    }

    public String id() {
        return "|Info:" + this.implementationName() + "@" + this.version();
    }

    public AnnotatedElement getAnnotationBearer() {
        return this.method;
    }

    private static Method parseMethod(String identifier) throws NoSuchMethodException {
        String rawIdentifier = YAMLOpMethodInfo.sanitizeGenerics(identifier);
        int clsIndex = rawIdentifier.lastIndexOf(46, rawIdentifier.indexOf(40));
        String clsString = rawIdentifier.substring(0, clsIndex);
        Class src = Classes.load((String)clsString);
        String methodString = rawIdentifier.substring(clsIndex + 1, rawIdentifier.indexOf(40));
        String[] paramStrings = rawIdentifier.substring(rawIdentifier.indexOf(40) + 1, rawIdentifier.indexOf(41)).split("\\s*,\\s*");
        Class[] paramClasses = new Class[paramStrings.length];
        for (int i = 0; i < paramStrings.length; ++i) {
            paramClasses[i] = YAMLOpMethodInfo.deriveType(identifier, paramStrings[i]);
        }
        return src.getMethod(methodString, paramClasses);
    }

    private Class<?> deriveOpType() {
        List params = (List)this.yaml.get("parameters");
        for (int i = params.size() - 1; i >= 0; --i) {
            Map pMap = (Map)params.get(i);
            switch ((String)pMap.get("parameter type")) {
                case "OUTPUT": {
                    return Functions.functionOfArity((int)(params.size() - 1));
                }
                case "MUTABLE": {
                    return Inplaces.inplaceOfArity((int)params.size(), (int)i);
                }
                case "CONTAINER": {
                    return Computers.computerOfArity((int)(params.size() - 1), (int)i);
                }
            }
        }
        throw new IllegalStateException("Could not determine functional type of Op " + this.method);
    }

    private static Class<?> deriveType(String identifier, String typeString) {
        try {
            return Classes.load((String)typeString, (boolean)false);
        }
        catch (Throwable t) {
            if (typeString.lastIndexOf(46) > -1) {
                int lastIndex = typeString.lastIndexOf(46);
                return YAMLOpMethodInfo.deriveType(identifier, typeString.substring(0, lastIndex) + "$" + typeString.substring(lastIndex + 1));
            }
            throw new RuntimeException("Op " + identifier + " could not be loaded: Could not load class " + typeString, t);
        }
    }

    private static String sanitizeGenerics(String method) {
        int nested = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < method.length(); ++i) {
            char c = method.charAt(i);
            if (c == '<') {
                ++nested;
            }
            if (nested == 0) {
                sb.append(c);
            }
            if (c != '>' || nested <= 0) continue;
            --nested;
        }
        return sb.toString();
    }

    private static void checkModifiers(Method method) {
        String packageName;
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new PrivateOpException(method);
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new InstanceOpMethodException(method);
        }
        Module methodModule = method.getDeclaringClass().getModule();
        if (methodModule != YAMLOpMethodInfo.class.getModule() && !methodModule.isOpen(packageName = method.getDeclaringClass().getPackageName(), methodModule)) {
            throw new UnreadableOpException(packageName);
        }
    }

    private Struct createStruct(Map<String, Object> yaml) {
        ArrayList<Object> members = new ArrayList<Object>();
        List params = (List)yaml.get("parameters");
        Parameter[] methodParams = this.method.getParameters();
        List<FunctionalMethodType> fmts = FunctionalParameters.findFunctionalMethodTypes(OpMethodUtils.getOpMethodType(this.deriveOpType(), this.method));
        for (int i = 0; i < params.size(); ++i) {
            Map pMap = (Map)params.get(i);
            FunctionalMethodType fmt = fmts.get(i);
            String name = (String)pMap.get("name");
            String description = (String)pMap.get("description");
            boolean nullable = pMap.getOrDefault("nullable", false);
            members.add(new SynthesizedParameterMember(fmt, name, !nullable, description));
        }
        for (Parameter methodParam : methodParams) {
            if (!methodParam.isAnnotationPresent(OpDependency.class)) break;
            members.add(new MethodParameterOpDependencyMember(methodParam.getName(), methodParam.getParameterizedType(), methodParam.getAnnotation(OpDependency.class)));
        }
        return () -> members;
    }
}

