/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.spring;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.support.JdbcUtils;
import org.sqlproc.engine.SqlProcessorException;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.jdbc.type.JdbcSqlType;
import org.sqlproc.engine.plugin.SqlFromToPlugin;
import org.sqlproc.engine.type.IdentitySetter;
import org.sqlproc.engine.type.OutValueSetter;
import org.sqlproc.engine.type.SqlProviderType;

public class SpringQuery
implements SqlQuery {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    JdbcTemplate jdbcTemplate;
    String queryString;
    List<String> scalars = new ArrayList<String>();
    Map<String, Object> scalarTypes = new HashMap<String, Object>();
    List<String> parameters = new ArrayList<String>();
    Map<String, Object> parameterValues = new HashMap<String, Object>();
    Map<String, Object> parameterTypes = new HashMap<String, Object>();
    Map<String, Object> parameterOutValueTypes = new HashMap<String, Object>();
    Map<String, OutValueSetter> parameterOutValueSetters = new HashMap<String, OutValueSetter>();
    Map<Integer, Integer> parameterOutValuesToPickup = new LinkedHashMap<Integer, Integer>();
    List<String> identities = new ArrayList<String>();
    Map<String, IdentitySetter> identitySetters = new HashMap<String, IdentitySetter>();
    Map<String, Object> identityTypes = new HashMap<String, Object>();
    Integer timeout;
    Integer firstResult;
    Integer maxResults;
    boolean ordered;
    static final Pattern CALL = Pattern.compile("\\s*\\{?\\s*(\\?)?\\s*=?\\s*call\\s*(.*?)\\s*}?\\s*");

    public SpringQuery(JdbcTemplate jdbcTemplate, String queryString) {
        this.jdbcTemplate = jdbcTemplate;
        this.queryString = queryString;
    }

    public Object getQuery() {
        return this.jdbcTemplate;
    }

    public SqlQuery setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public SqlQuery setFirstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    public SqlQuery setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public SqlQuery setOrdered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public List list() throws SqlProcessorException {
        String query;
        StringBuilder queryResult = this.maxResults != null ? new StringBuilder(this.queryString.length() + 100) : null;
        final SqlFromToPlugin.LimitType limitType = this.maxResults != null ? SqlProcessContext.getPluginFactory().getSqlFromToPlugin().limitQuery(this.queryString, queryResult, this.firstResult, this.maxResults, this.ordered) : null;
        String string = query = limitType != null ? queryResult.toString() : this.queryString;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("list, query=" + query);
        }
        PreparedStatementCreator psc = new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(query);
                if (SpringQuery.this.timeout != null) {
                    ps.setQueryTimeout(SpringQuery.this.timeout);
                }
                return ps;
            }
        };
        PreparedStatementSetter pss = new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                SpringQuery.this.setParameters(ps, limitType, 1);
            }
        };
        ResultSetExtractor<List> rse = new ResultSetExtractor<List>(){

            public List extractData(ResultSet rs) throws SQLException, DataAccessException {
                return SpringQuery.this.getResults(rs);
            }
        };
        try {
            List list = (List)this.jdbcTemplate.query(psc, pss, (ResultSetExtractor)rse);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("list, number of returned rows=" + (list != null ? Integer.valueOf(list.size()) : "null"));
            }
            return list;
        }
        catch (DataAccessException dae) {
            throw new SqlProcessorException((Throwable)dae);
        }
    }

    public Object unique() throws SqlProcessorException {
        List list = this.list();
        int size = list.size();
        if (size == 0) {
            return null;
        }
        Object first = list.get(0);
        for (int i = 1; i < size; ++i) {
            if (list.get(i) == first) continue;
            throw new SqlProcessorException("There's no unique result, the number of returned rows is " + list.size());
        }
        return first;
    }

    public int update() throws SqlProcessorException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("update, query=" + this.queryString);
        }
        PreparedStatementCreator psc = new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = SpringQuery.this.isSetJDBCIdentity() ? con.prepareStatement(SpringQuery.this.queryString, 1) : con.prepareStatement(SpringQuery.this.queryString);
                if (SpringQuery.this.timeout != null) {
                    ps.setQueryTimeout(SpringQuery.this.timeout);
                }
                return ps;
            }
        };
        PreparedStatementSetter pss = new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                SpringQuery.this.setParameters(ps, null, 1);
            }
        };
        try {
            int updated = 0;
            if (!this.identities.isEmpty()) {
                String identityName = this.identities.get(0);
                if (this.isSetJDBCIdentity()) {
                    updated = this.updateWithGenKeys(psc, pss, identityName);
                } else {
                    updated = this.updateWithoutGenKeys(psc, pss);
                    this.doIdentitySelect(identityName);
                }
            } else {
                updated = this.updateWithoutGenKeys(psc, pss);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("update, number of updated rows=" + updated);
            }
            return updated;
        }
        catch (DataAccessException dae) {
            throw new SqlProcessorException((Throwable)dae);
        }
    }

    private boolean isSetJDBCIdentity() {
        for (String identityName : this.identities) {
            IdentitySetter identitySetter = this.identitySetters.get(identityName);
            if (!identitySetter.getIdentitySelect().equals("JDBC")) continue;
            return true;
        }
        return false;
    }

    private void doIdentitySelect(final String identityName) {
        final IdentitySetter identitySetter = this.identitySetters.get(identityName);
        final Object identityType = this.identityTypes.get(identityName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("identity, name=" + identityName + ", select=" + identitySetter.getIdentitySelect() + ", identityType=" + identityType);
        }
        PreparedStatementCreator psc = new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(identitySetter.getIdentitySelect());
                return ps;
            }
        };
        ResultSetExtractor<Object> rse = new ResultSetExtractor<Object>(){

            public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
                Object identityValue = null;
                while (rs.next()) {
                    identityValue = identityType != null && identityType instanceof JdbcSqlType ? ((JdbcSqlType)identityType).get(rs, identityName) : rs.getObject(1);
                    if (!rs.wasNull()) continue;
                    identityValue = null;
                }
                return identityValue;
            }
        };
        try {
            Object identityValue = this.jdbcTemplate.query(psc, null, (ResultSetExtractor)rse);
            identitySetter.setIdentity(identityValue);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("identity, result=" + identityValue);
            }
        }
        catch (DataAccessException dae) {
            throw new SqlProcessorException("Identity select failed.", (Throwable)dae);
        }
    }

    private void getGeneratedKeys(String identityName, Statement statement) {
        IdentitySetter identitySetter = this.identitySetters.get(identityName);
        Object identityType = this.identityTypes.get(identityName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("identity, name=" + identityName + ", getGeneratedKeys(), identityType=" + identityType);
        }
        ResultSet rs = null;
        Object identityValue = null;
        try {
            rs = statement.getGeneratedKeys();
            while (rs.next()) {
                identityValue = identityType != null && identityType instanceof JdbcSqlType ? ((JdbcSqlType)identityType).get(rs, identityName) : rs.getObject(1);
                if (!rs.wasNull()) continue;
                identityValue = null;
            }
            identitySetter.setIdentity(identityValue);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("identity, result=" + identityValue);
            }
        }
        catch (SQLException he) {
            throw new SqlProcessorException("Statement.getGeneratedKeys() failed.", (Throwable)he);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ignore) {}
            }
        }
    }

    protected int updateWithGenKeys(PreparedStatementCreator psc, final PreparedStatementSetter pss, final String identityName) throws DataAccessException {
        this.logger.debug("Executing prepared SQL update with generated keys retrieval");
        return (Integer)this.jdbcTemplate.execute(psc, (PreparedStatementCallback)new PreparedStatementCallback<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer doInPreparedStatement(PreparedStatement ps) throws SQLException {
                try {
                    if (pss != null) {
                        pss.setValues(ps);
                    }
                    int rows = ps.executeUpdate();
                    if (SpringQuery.this.logger.isDebugEnabled()) {
                        SpringQuery.this.logger.debug("SQL update affected " + rows + " rows");
                    }
                    if (identityName != null) {
                        SpringQuery.this.getGeneratedKeys(identityName, ps);
                    }
                    Integer n = rows;
                    return n;
                }
                finally {
                    if (pss instanceof ParameterDisposer) {
                        ((ParameterDisposer)pss).cleanupParameters();
                    }
                }
            }
        });
    }

    protected int updateWithoutGenKeys(PreparedStatementCreator psc, final PreparedStatementSetter pss) throws DataAccessException {
        this.logger.debug("Executing prepared SQL update");
        return (Integer)this.jdbcTemplate.execute(psc, (PreparedStatementCallback)new PreparedStatementCallback<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer doInPreparedStatement(PreparedStatement ps) throws SQLException {
                try {
                    if (pss != null) {
                        pss.setValues(ps);
                    }
                    int rows = ps.executeUpdate();
                    if (SpringQuery.this.logger.isDebugEnabled()) {
                        SpringQuery.this.logger.debug("SQL update affected " + rows + " rows");
                    }
                    Integer n = rows;
                    return n;
                }
                finally {
                    if (pss instanceof ParameterDisposer) {
                        ((ParameterDisposer)pss).cleanupParameters();
                    }
                }
            }
        });
    }

    public List callList() throws SqlProcessorException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("callList, query=" + this.queryString);
        }
        CallableStatementCreator psc = new CallableStatementCreator(){

            public CallableStatement createCallableStatement(Connection con) throws SQLException {
                Matcher matcher = CALL.matcher(SpringQuery.this.queryString);
                if (!matcher.matches()) {
                    throw new SqlProcessorException("'" + SpringQuery.this.queryString + "' isn't the correct call statement");
                }
                String query = matcher.group(1) != null ? "{? = call " + matcher.group(2) + "}" : "{ call " + matcher.group(2) + "}";
                CallableStatement cs = con.prepareCall(query);
                if (SpringQuery.this.timeout != null) {
                    cs.setQueryTimeout(SpringQuery.this.timeout);
                }
                return cs;
            }
        };
        CallableStatementCallback<List> csc = new CallableStatementCallback<List>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List doInCallableStatement(CallableStatement cs) throws SQLException {
                List list;
                ResultSet rs;
                block5: {
                    rs = null;
                    list = null;
                    try {
                        SpringQuery.this.setParameters(cs, null, 1);
                        boolean hasResultSet = cs.execute();
                        if (hasResultSet || cs.getMoreResults()) {
                            ResultSet rsToUse = rs = cs.getResultSet();
                            if (SpringQuery.this.jdbcTemplate.getNativeJdbcExtractor() != null) {
                                rsToUse = SpringQuery.this.jdbcTemplate.getNativeJdbcExtractor().getNativeResultSet(rs);
                            }
                            list = SpringQuery.this.getResults(rsToUse);
                            SpringQuery.this.getParameters(cs, false);
                            break block5;
                        }
                        ResultSet rsToUse = rs = (ResultSet)SpringQuery.this.getParameters(cs, true);
                        if (SpringQuery.this.jdbcTemplate.getNativeJdbcExtractor() != null) {
                            rsToUse = SpringQuery.this.jdbcTemplate.getNativeJdbcExtractor().getNativeResultSet(rs);
                        }
                        list = SpringQuery.this.getResults(rsToUse);
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.closeResultSet(rs);
                        throw throwable;
                    }
                }
                JdbcUtils.closeResultSet((ResultSet)rs);
                return list;
            }
        };
        try {
            List list = (List)this.jdbcTemplate.execute(psc, (CallableStatementCallback)csc);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("callList, number of returned rows=" + (list != null ? Integer.valueOf(list.size()) : "null"));
            }
            return list;
        }
        catch (DataAccessException dae) {
            throw new SqlProcessorException((Throwable)dae);
        }
    }

    public Object callUnique() throws SqlProcessorException {
        List list = this.callList();
        int size = list.size();
        if (size == 0) {
            return null;
        }
        Object first = list.get(0);
        for (int i = 1; i < size; ++i) {
            if (list.get(i) == first) continue;
            throw new SqlProcessorException("There's no unique result, the number of returned rows is " + list.size());
        }
        return first;
    }

    public int callUpdate() throws SqlProcessorException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("callUpdate, query=" + this.queryString);
        }
        CallableStatementCreator psc = new CallableStatementCreator(){

            public CallableStatement createCallableStatement(Connection con) throws SQLException {
                Matcher matcher = CALL.matcher(SpringQuery.this.queryString);
                if (!matcher.matches()) {
                    throw new SqlProcessorException("'" + SpringQuery.this.queryString + "' isn't the correct call statement");
                }
                String query = matcher.group(1) != null ? "{? = call " + matcher.group(2) + "}" : "{ call " + matcher.group(2) + "}";
                CallableStatement cs = con.prepareCall(query);
                if (SpringQuery.this.timeout != null) {
                    cs.setQueryTimeout(SpringQuery.this.timeout);
                }
                return cs;
            }
        };
        CallableStatementCallback<Integer> csc = new CallableStatementCallback<Integer>(){

            public Integer doInCallableStatement(CallableStatement cs) throws SQLException {
                SpringQuery.this.setParameters(cs, null, 1);
                cs.execute();
                Integer updated = cs.getUpdateCount();
                SpringQuery.this.getParameters(cs, false);
                return updated;
            }
        };
        try {
            Integer updated = (Integer)this.jdbcTemplate.execute(psc, (CallableStatementCallback)csc);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("callUpdate, number of updated rows=" + updated);
            }
            return updated;
        }
        catch (DataAccessException dae) {
            throw new SqlProcessorException((Throwable)dae);
        }
    }

    public Object callFunction() throws SqlProcessorException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("callList, query=" + this.queryString);
        }
        CallableStatementCreator psc = new CallableStatementCreator(){

            public CallableStatement createCallableStatement(Connection con) throws SQLException {
                Matcher matcher = CALL.matcher(SpringQuery.this.queryString);
                if (!matcher.matches()) {
                    throw new SqlProcessorException("'" + SpringQuery.this.queryString + "' isn't the correct call statement");
                }
                String query = matcher.group(1) != null ? "{? = call " + matcher.group(2) + "}" : "{ call " + matcher.group(2) + "}";
                CallableStatement cs = con.prepareCall(query);
                if (SpringQuery.this.timeout != null) {
                    cs.setQueryTimeout(SpringQuery.this.timeout);
                }
                return cs;
            }
        };
        CallableStatementCallback<Object> csc = new CallableStatementCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInCallableStatement(CallableStatement cs) throws SQLException {
                Object result;
                ResultSet rs;
                block5: {
                    rs = null;
                    List list = null;
                    result = null;
                    try {
                        SpringQuery.this.setParameters(cs, null, 1);
                        boolean hasResultSet = cs.execute();
                        if (hasResultSet) {
                            ResultSet rsToUse = rs = cs.getResultSet();
                            if (SpringQuery.this.jdbcTemplate.getNativeJdbcExtractor() != null) {
                                rsToUse = SpringQuery.this.jdbcTemplate.getNativeJdbcExtractor().getNativeResultSet(rs);
                            }
                            if ((list = SpringQuery.this.getResults(rsToUse)) != null && !list.isEmpty()) {
                                result = list.get(0);
                            }
                            SpringQuery.this.getParameters(cs, false);
                            break block5;
                        }
                        result = SpringQuery.this.getParameters(cs, true);
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.closeResultSet(rs);
                        throw throwable;
                    }
                }
                JdbcUtils.closeResultSet((ResultSet)rs);
                return result;
            }
        };
        try {
            Object result = this.jdbcTemplate.execute(psc, (CallableStatementCallback)csc);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("callFunction, result=" + result);
            }
            return result;
        }
        catch (DataAccessException dae) {
            throw new SqlProcessorException((Throwable)dae);
        }
    }

    public SqlQuery addScalar(String columnAlias) {
        this.scalars.add(columnAlias);
        return this;
    }

    public SqlQuery addScalar(String columnAlias, Object type) {
        this.scalars.add(columnAlias);
        this.scalarTypes.put(columnAlias, type);
        return this;
    }

    public SqlQuery setParameter(String name, Object val) throws SqlProcessorException {
        this.parameters.add(name);
        this.parameterValues.put(name, val);
        return this;
    }

    public SqlQuery setParameter(String name, Object val, Object type) throws SqlProcessorException {
        if (val != null && val instanceof IdentitySetter) {
            this.identities.add(name);
            this.identitySetters.put(name, (IdentitySetter)val);
            this.identityTypes.put(name, type);
        } else if (val != null && val instanceof OutValueSetter) {
            if (!this.parameterTypes.containsKey(name)) {
                this.parameters.add(name);
                this.parameterTypes.put(name, type);
            }
            this.parameterOutValueTypes.put(name, type);
            this.parameterOutValueSetters.put(name, (OutValueSetter)val);
        } else {
            this.parameters.add(name);
            this.parameterValues.put(name, val);
            this.parameterTypes.put(name, type);
        }
        return this;
    }

    public SqlQuery setParameterList(String name, Object[] vals) throws SqlProcessorException {
        throw new UnsupportedOperationException();
    }

    public SqlQuery setParameterList(String name, Object[] vals, Object type) throws SqlProcessorException {
        throw new UnsupportedOperationException();
    }

    protected void setParameters(PreparedStatement ps, SqlFromToPlugin.LimitType limitType, int start) throws SQLException {
        int ix = start;
        ix = this.setLimits(ps, limitType, ix, false);
        int n = this.parameters.size();
        for (int i = 0; i < n; ++i) {
            String name = this.parameters.get(i);
            Object type = this.parameterTypes.get(name);
            if (this.parameterValues.containsKey(name)) {
                Object value = this.parameterValues.get(name);
                if (type != null) {
                    if (type instanceof JdbcSqlType) {
                        ((JdbcSqlType)type).set(ps, ix + i, value);
                    } else if (value == null) {
                        ps.setNull(ix + i, (Integer)type);
                    } else {
                        ps.setObject(ix + i, value, (Integer)type);
                    }
                } else {
                    ps.setObject(ix + i, value);
                }
            }
            if (!this.parameterOutValueSetters.containsKey(name)) continue;
            CallableStatement cs = (CallableStatement)ps;
            if (type != null) {
                if (type instanceof SqlProviderType) {
                    cs.registerOutParameter(ix + i, (int)((Integer)((SqlProviderType)type).getProviderSqlNullType()));
                } else {
                    cs.registerOutParameter(ix + i, (int)((Integer)type));
                }
            } else {
                throw new SqlProcessorException("OUT parameter type for callable statement is null");
            }
            this.parameterOutValuesToPickup.put(i, ix + i);
        }
        ix = this.setLimits(ps, limitType, ix + this.parameters.size(), true);
    }

    protected int setLimits(PreparedStatement ps, SqlFromToPlugin.LimitType limitType, int ix, boolean afterSql) throws SQLException {
        if (limitType == null) {
            return ix;
        }
        if (afterSql && !limitType.afterSql) {
            return ix;
        }
        if (!afterSql && limitType.afterSql) {
            return ix;
        }
        if (limitType.maxBeforeFirst) {
            if (limitType.rowidBasedMax && limitType.alsoFirst) {
                ps.setInt(ix++, this.firstResult + this.maxResults);
            } else {
                ps.setInt(ix++, this.maxResults);
            }
        }
        if (limitType.alsoFirst) {
            if (limitType.zeroBasedFirst) {
                ps.setInt(ix++, this.firstResult);
            } else {
                ps.setInt(ix++, this.firstResult);
            }
        }
        if (!limitType.maxBeforeFirst) {
            if (limitType.rowidBasedMax && limitType.alsoFirst) {
                ps.setInt(ix++, this.firstResult + this.maxResults);
            } else {
                ps.setInt(ix++, this.maxResults);
            }
        }
        return ix;
    }

    protected Object getParameters(CallableStatement cs, boolean isFunction) throws SQLException {
        Object result = null;
        boolean resultInited = false;
        for (int i : this.parameterOutValuesToPickup.keySet()) {
            int ix = this.parameterOutValuesToPickup.get(i);
            String name = this.parameters.get(i);
            Object type = this.parameterOutValueTypes.get(name);
            if (type == null) {
                type = this.parameterTypes.get(name);
            }
            OutValueSetter outValueSetter = this.parameterOutValueSetters.get(name);
            Object outValue = null;
            outValue = type != null && type instanceof JdbcSqlType ? ((JdbcSqlType)type).get(cs, ix) : cs.getObject(ix);
            outValueSetter.setOutValue(outValue);
            if (resultInited) continue;
            result = outValue;
            resultInited = true;
        }
        return result;
    }

    protected List getResults(ResultSet rs) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        if (rs == null) {
            return result;
        }
        while (rs.next()) {
            ArrayList<Object> row = new ArrayList<Object>();
            int n = this.scalars.size();
            for (int i = 0; i < n; ++i) {
                String name = this.scalars.get(i);
                Object type = this.scalarTypes.get(name);
                Object value = null;
                value = type != null && type instanceof JdbcSqlType ? ((JdbcSqlType)type).get(rs, name) : rs.getObject(name);
                if (rs.wasNull()) {
                    value = null;
                }
                row.add(value);
            }
            Object[] oo = row.toArray();
            if (oo.length == 1) {
                result.add(oo[0]);
                continue;
            }
            result.add(oo);
        }
        return result;
    }

    public int[] executeBatch(String[] statements) throws SqlProcessorException {
        try {
            int[] result = this.jdbcTemplate.batchUpdate(statements);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeBatch, result " + SqlUtils.asList((int[])result));
            }
            return result;
        }
        catch (DataAccessException dae) {
            throw new SqlProcessorException((Throwable)dae);
        }
    }
}

