/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlCrudEngine;
import org.sqlproc.engine.SqlEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlEngineFactory;
import org.sqlproc.engine.SqlMonitor;
import org.sqlproc.engine.SqlMonitorFactory;
import org.sqlproc.engine.SqlProcedureEngine;
import org.sqlproc.engine.SqlQueryEngine;
import org.sqlproc.engine.impl.SqlMappingRule;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlProcessor;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.type.SqlComposedTypeFactory;
import org.sqlproc.engine.type.SqlInternalType;
import org.sqlproc.engine.type.SqlTypeFactory;

public class SqlProcessorLoader
implements SqlEngineFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SqlTypeFactory composedTypeFactory;
    private Map<String, SqlEngine> engines = new HashMap<String, SqlEngine>();
    private Map<String, SqlMetaStatement> sqls;
    private Map<String, SqlMetaStatement> cruds;
    private Map<String, SqlMetaStatement> calls;
    private Map<String, SqlMappingRule> outs;
    private Map<String, Object> features;

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory) throws SqlEngineException {
        this(sbStatements, typeFactory, (String)null, (SqlMonitorFactory)null, (List<SqlInternalType>)null, (String[])null);
    }

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, String filter) throws SqlEngineException {
        this(sbStatements, typeFactory, filter, (SqlMonitorFactory)null, (List<SqlInternalType>)null, (String[])null);
    }

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, String filter, SqlMonitorFactory monitorFactory) throws SqlEngineException {
        this(sbStatements, typeFactory, filter, monitorFactory, (List<SqlInternalType>)null, (String[])null);
    }

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, String filter, SqlMonitorFactory monitorFactory, String ... onlyStatements) {
        this(sbStatements, typeFactory, filter, monitorFactory, (List<SqlInternalType>)null, onlyStatements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, String filter, SqlMonitorFactory monitorFactory, List<SqlInternalType> customTypes, String ... onlyStatements) throws SqlEngineException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">> SqlProcessorLoader, sbStatements=" + sbStatements + ", typeFactory=" + typeFactory + ", monitorFactory=" + monitorFactory + ", filter=" + filter + ", customTypes=" + customTypes + ", onlyStatements=" + onlyStatements);
        }
        if (sbStatements == null) {
            throw new SqlEngineException("Missing SQL META queries/statements/output mappings");
        }
        if (typeFactory == null) {
            throw new SqlEngineException("Missing the META types factory");
        }
        this.composedTypeFactory = new SqlComposedTypeFactory(typeFactory, customTypes);
        try {
            SqlMonitor monitor;
            SqlMappingRule mapping;
            SqlMetaStatement stmt;
            HashSet<String> setSelectQueries = onlyStatements != null && onlyStatements.length > 0 ? new HashSet<String>(Arrays.asList(onlyStatements)) : null;
            filter = filter != null ? filter.toUpperCase() : null;
            Map<String, Object> defaultFeatures = SqlUtils.getDefaultFeatures(filter);
            StringBuilder errors = new StringBuilder();
            SqlProcessor processor = null;
            try {
                processor = SqlProcessor.getInstance(sbStatements, this.composedTypeFactory, defaultFeatures, setSelectQueries, filter);
            }
            catch (SqlEngineException see) {
                errors.append(see.getMessage());
            }
            if (errors.length() > 0) {
                throw new SqlEngineException(errors.toString());
            }
            if (!processor.getWarnings().isEmpty()) {
                this.logger.warn("There're warnings in the process of statements parsing: " + processor.getWarnings());
            }
            this.sqls = processor.getMetaStatements(SqlProcessor.StatementType.QRY);
            this.cruds = processor.getMetaStatements(SqlProcessor.StatementType.CRUD);
            this.calls = processor.getMetaStatements(SqlProcessor.StatementType.CALL);
            this.outs = processor.getMappingRules(SqlProcessor.MappingType.OUT);
            this.features = processor.getFeatures();
            for (String name : this.outs.keySet()) {
                if (this.sqls.containsKey(name) || this.calls.containsKey(name) || this.cruds.containsKey(name)) continue;
                errors.append("For the OUT/FIELDS there's no QRY: ").append(name).append("\n");
            }
            if (errors.length() > 0) {
                throw new SqlEngineException(errors.toString());
            }
            for (String name : this.sqls.keySet()) {
                stmt = this.sqls.get(name);
                mapping = null;
                if (!stmt.isHasOutputMapping() && !this.outs.containsKey(name)) {
                    errors.append("For the QRY there's no OUT: ").append(name).append("\n");
                } else {
                    mapping = this.outs.containsKey(name) ? this.outs.get(name) : new SqlMappingRule();
                }
                SqlMonitor sqlMonitor = monitor = monitorFactory != null ? monitorFactory.getSqlMonitor(name, this.features) : null;
                if (stmt == null) continue;
                this.engines.put(name, new SqlQueryEngine(name, stmt, mapping, monitor, this.features, this.composedTypeFactory));
            }
            for (String name : this.cruds.keySet()) {
                stmt = this.cruds.get(name);
                mapping = null;
                if (this.outs.containsKey(name)) {
                    mapping = this.outs.get(name);
                }
                SqlMonitor sqlMonitor = monitor = monitorFactory != null ? monitorFactory.getSqlMonitor(name, this.features) : null;
                if (stmt == null) continue;
                this.engines.put(name, new SqlCrudEngine(name, stmt, mapping, monitor, this.features, this.composedTypeFactory));
            }
            for (String name : this.calls.keySet()) {
                stmt = this.calls.get(name);
                mapping = null;
                mapping = this.outs.containsKey(name) ? this.outs.get(name) : new SqlMappingRule();
                SqlMonitor sqlMonitor = monitor = monitorFactory != null ? monitorFactory.getSqlMonitor(name, this.features) : null;
                if (stmt == null) continue;
                this.engines.put(name, new SqlProcedureEngine(name, stmt, mapping, monitor, this.features, this.composedTypeFactory));
            }
            if (errors.length() > 0) {
                throw new SqlEngineException(errors.toString());
            }
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< SqlProcessorLoader, engines=" + this.engines + ", sqls=" + this.sqls + ", cruds=" + this.cruds + ", fields=" + this.outs + ", features=" + this.features);
            }
        }
    }

    public Collection<String> getNames() {
        return this.engines.keySet();
    }

    @Override
    public SqlQueryEngine getQueryEngine(String name) {
        SqlEngine o = this.engines.get(name);
        if (o != null && o instanceof SqlQueryEngine) {
            return (SqlQueryEngine)o;
        }
        return null;
    }

    @Override
    public SqlCrudEngine getCrudEngine(String name) {
        SqlEngine o = this.engines.get(name);
        if (o != null && o instanceof SqlCrudEngine) {
            return (SqlCrudEngine)o;
        }
        return null;
    }

    @Override
    public SqlProcedureEngine getProcedureEngine(String name) {
        SqlEngine o = this.engines.get(name);
        if (o != null && o instanceof SqlProcedureEngine) {
            return (SqlProcedureEngine)o;
        }
        return null;
    }
}

