/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.MethodUtils;
import org.sqlproc.engine.SqlFeature;
import org.sqlproc.engine.impl.SqlInputValue;
import org.sqlproc.engine.impl.SqlMappingIdentity;
import org.sqlproc.engine.impl.SqlProcessContext;

public class SqlUtils {
    static final Pattern patternInsert = Pattern.compile("[^\\(]*\\(\\s*([^\\)]*)\\s*\\).*");

    public static Object getEnumToValue(Object obj) {
        if (obj == null) {
            return null;
        }
        for (String methodName : SqlProcessContext.getFeatures("METHODS_ENUM_IN")) {
            try {
                return MethodUtils.invokeMethod((Object)obj, (String)methodName, null);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Class getEnumToClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        for (String methodName : SqlProcessContext.getFeatures("METHODS_ENUM_IN")) {
            Method m = MethodUtils.getMatchingAccessibleMethod((Class)clazz, (String)methodName, (Class[])new Class[0]);
            if (m == null) continue;
            return m.getReturnType();
        }
        return null;
    }

    public static Object getValueToEnum(Class<?> objClass, Object val) {
        if (val == null) {
            return null;
        }
        for (String methodName : SqlProcessContext.getFeatures("METHODS_ENUM_OUT")) {
            try {
                return MethodUtils.invokeStaticMethod(objClass, (String)methodName, (Object)val);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Object convertBigDecimal(Class<?> attributeType, Object resultValue) {
        if (resultValue == null || !(resultValue instanceof BigDecimal)) {
            return resultValue;
        }
        BigDecimal result = (BigDecimal)resultValue;
        if (attributeType == Byte.class || attributeType == Byte.TYPE) {
            return result.byteValue();
        }
        if (attributeType == Integer.class || attributeType == Integer.TYPE) {
            return result.intValue();
        }
        if (attributeType == Long.class || attributeType == Long.TYPE) {
            return result.longValue();
        }
        if (attributeType == Short.class || attributeType == Short.TYPE) {
            return result.shortValue();
        }
        if (attributeType == BigInteger.class) {
            return result.toBigInteger();
        }
        return result;
    }

    public static Object convertBigInteger(Class<?> attributeType, Object resultValue) {
        if (resultValue == null || !(resultValue instanceof BigInteger)) {
            return resultValue;
        }
        BigInteger result = (BigInteger)resultValue;
        if (attributeType == Byte.class || attributeType == Byte.TYPE) {
            return result.byteValue();
        }
        if (attributeType == Integer.class || attributeType == Integer.TYPE) {
            return result.intValue();
        }
        if (attributeType == Long.class || attributeType == Long.TYPE) {
            return result.longValue();
        }
        if (attributeType == Short.class || attributeType == Short.TYPE) {
            return result.shortValue();
        }
        return result;
    }

    public static Byte[] toBytes(byte[] barr) {
        if (barr == null) {
            return null;
        }
        Byte[] res = new Byte[barr.length];
        for (int i = 0; i < barr.length; ++i) {
            res[i] = new Byte(barr[i]);
        }
        return res;
    }

    public static byte[] toBytes(Byte[] barr) {
        if (barr == null) {
            return null;
        }
        byte[] res = new byte[barr.length];
        for (int i = 0; i < barr.length; ++i) {
            res[i] = barr[i] != null ? barr[i] : (byte)0;
        }
        return res;
    }

    public static boolean isEmpty(StringBuilder sb) {
        if (sb == null) {
            return true;
        }
        String s = sb.toString().trim();
        return s.length() == 0;
    }

    public static String beforeChar(String s, char c) {
        int ix = s.indexOf(c);
        if (ix < 0) {
            return s;
        }
        return s.substring(0, ix);
    }

    public static String afterChar(String s, char c) {
        int ix = s.indexOf(c);
        if (ix < 0) {
            return null;
        }
        return s.substring(ix + 1);
    }

    public static Date getDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        return new Date(cal.getTime().getTime());
    }

    public static Time getTime(int hour, int minute, int second) {
        Calendar cal = Calendar.getInstance();
        cal.clear(1);
        cal.clear(2);
        cal.clear(5);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        return new Time(cal.getTime().getTime());
    }

    public static java.util.Date getDateTime(int year, int month, int day, int hour, int minute, int second) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        return cal.getTime();
    }

    public static Map<String, Object> getDefaultFeatures(String filterPrefix) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        if (filterPrefix != null && !filterPrefix.endsWith("_")) {
            filterPrefix = filterPrefix + "_";
        }
        String fullPrefix = filterPrefix != null ? filterPrefix + "DEFAULT_" : null;
        int fullPrefixLength = fullPrefix != null ? fullPrefix.length() : 0;
        String shortPrefix = "DEFAULT_";
        int shortPrefixLength = shortPrefix.length();
        for (Field f : SqlFeature.class.getDeclaredFields()) {
            String featureName;
            if (fullPrefix != null && f.getName().startsWith(fullPrefix) && features.get(featureName = f.getName().substring(fullPrefixLength)) == null) {
                try {
                    features.put(featureName, f.get(null));
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
            if (!f.getName().startsWith(shortPrefix) || features.get(featureName = f.getName().substring(shortPrefixLength)) != null) continue;
            try {
                features.put(featureName, f.get(null));
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return features;
    }

    public static String getIdsKey(Object[] resultValues, Map<String, SqlMappingIdentity> identities, String fullName) {
        String idsKey = "";
        int i = 0;
        SqlMappingIdentity ident = identities.get(fullName);
        for (List<Integer> identityIndexes : ident.allIdentityIndexes) {
            for (Integer identityIndex : identityIndexes) {
                Object o = resultValues[identityIndex];
                if (o == null) continue;
                if (i > 0) {
                    idsKey = idsKey + '-';
                }
                idsKey = idsKey + identityIndex;
                idsKey = idsKey + '-';
                idsKey = idsKey + o;
                break;
            }
            ++i;
        }
        return idsKey;
    }

    public static String getIdsKey(Object[] resultValues, Integer mainIdentityIndex) {
        String idsKey = "" + mainIdentityIndex + "-" + resultValues[mainIdentityIndex];
        return idsKey;
    }

    public static String handleInsertSql(Map<String, SqlInputValue> identities, String sql) {
        if (identities == null || identities.isEmpty()) {
            return sql;
        }
        HashMap<String, SqlInputValue> ids1 = new HashMap<String, SqlInputValue>();
        HashMap<String, SqlInputValue> ids2 = new HashMap<String, SqlInputValue>();
        for (Map.Entry<String, SqlInputValue> e : identities.entrySet()) {
            if (e.getValue().getValueType() != SqlInputValue.Type.IDENTITY_SELECT) continue;
            ids1.put(e.getKey(), e.getValue());
            if (e.getValue().getDbIdentityName() == null) continue;
            ids2.put(e.getValue().getDbIdentityName(), e.getValue());
        }
        if (ids1.isEmpty()) {
            return sql;
        }
        Matcher matcher = patternInsert.matcher(sql);
        if (!matcher.matches()) {
            return sql;
        }
        String fragment = matcher.group(1);
        String[] cols = fragment.split(",");
        int icol = -1;
        for (int i = 0; i < cols.length; ++i) {
            String c = cols[i].trim();
            if (c.startsWith("%")) {
                c = c.substring(1);
            }
            if (ids2.containsKey(c)) {
                icol = i;
            } else if (ids2.containsKey(c.toLowerCase())) {
                icol = i;
            } else if (ids2.containsKey(c.toUpperCase())) {
                icol = i;
            } else if (ids1.containsKey(c)) {
                icol = i;
            } else if (ids1.containsKey(c.toLowerCase())) {
                icol = i;
            } else if (ids1.containsKey(c.toUpperCase())) {
                icol = i;
            }
            if (icol >= 0) break;
        }
        if (icol < 0) {
            return sql;
        }
        int ix = sql.indexOf(cols[icol]);
        if (ix < 0) {
            return sql;
        }
        String sql1 = sql.substring(0, ix);
        String sql2 = sql.substring(ix + cols[icol].length());
        if (sql1.trim().endsWith(",")) {
            ix = sql1.lastIndexOf(",");
            sql = sql.substring(0, ix) + sql2;
        } else if (sql2.trim().startsWith(",")) {
            ix = sql2.indexOf(",");
            sql = sql1 + sql2.substring(ix + 1);
        } else {
            sql = sql1 + sql2;
        }
        return sql;
    }

    public static List<Integer> asList(int[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (array == null) {
            return list;
        }
        for (int item : array) {
            list.add(item);
        }
        return list;
    }

    public static String firstLowerCase(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 1) {
            return s.toLowerCase();
        }
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public static Set<String> oppositeFeatures(String featureName) {
        HashSet<String> oppositeFeatures = new HashSet<String>();
        if ("SURROUND_QUERY_LIKE_FULL".equals(featureName)) {
            oppositeFeatures.add("SURROUND_QUERY_LIKE_PARTIAL");
            oppositeFeatures.add("REPLACE_LIKE_CHARS");
        } else if ("SURROUND_QUERY_LIKE_PARTIAL".equals(featureName)) {
            oppositeFeatures.add("SURROUND_QUERY_LIKE_FULL");
            oppositeFeatures.add("REPLACE_LIKE_CHARS");
        } else if ("REPLACE_LIKE_CHARS".equals(featureName)) {
            oppositeFeatures.add("SURROUND_QUERY_LIKE_FULL");
            oppositeFeatures.add("SURROUND_QUERY_LIKE_PARTIAL");
        } else if ("EMPTY_FOR_NULL".equals(featureName)) {
            oppositeFeatures.add("EMPTY_USE_METHOD_IS_NULL");
        } else if ("EMPTY_USE_METHOD_IS_NULL".equals(featureName)) {
            oppositeFeatures.add("EMPTY_FOR_NULL");
        }
        return oppositeFeatures;
    }
}

