/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.type;

import java.lang.reflect.Method;
import java.util.Collection;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.type.SqlProviderType;

public abstract class SqlShortType
extends SqlProviderType {
    @Override
    public Class<?>[] getClassTypes() {
        return new Class[]{Short.class, Short.TYPE};
    }

    @Override
    public String[] getMetaTypes() {
        return new String[]{"SHORT"};
    }

    @Override
    public void addScalar(SqlQuery query, String dbName, Class<?> attributeType) {
        query.addScalar(dbName, this.getProviderSqlType());
    }

    @Override
    public void setResult(SqlRuntimeContext runtimeCtx, Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        Method m;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setResult " + this.getMetaTypes()[0] + ": resultInstance=" + resultInstance + ", attributeName=" + attributeName + ", resultValue=" + resultValue + ", resultType" + (resultValue != null ? resultValue.getClass() : null));
        }
        if ((m = BeanUtils.getSetter(resultInstance, attributeName, this.getClassTypes())) != null) {
            BeanUtils.simpleInvokeMethod(m, resultInstance, resultValue);
        } else if (ingoreError) {
            this.logger.error("There's no getter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
        } else {
            throw new SqlRuntimeException("There's no setter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
        }
    }

    @Override
    public void setParameter(SqlRuntimeContext runtimeCtx, SqlQuery query, String paramName, Object inputValue, Class<?> inputType, boolean ingoreError) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setParameter " + this.getMetaTypes()[0] + ": paramName=" + paramName + ", inputValue=" + inputValue + ", inputType=" + inputType);
        }
        if (inputValue == null) {
            query.setParameter(paramName, inputValue, this.getProviderSqlNullType());
        } else if (inputValue instanceof Collection) {
            query.setParameterList(paramName, ((Collection)inputValue).toArray(), this.getProviderSqlType());
        } else {
            query.setParameter(paramName, inputValue, this.getProviderSqlType());
        }
    }
}

