/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlCrudEngine;
import org.sqlproc.engine.SqlEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlMonitor;
import org.sqlproc.engine.SqlMonitorFactory;
import org.sqlproc.engine.SqlProcedureEngine;
import org.sqlproc.engine.SqlQueryEngine;
import org.sqlproc.engine.annotation.Beta;
import org.sqlproc.engine.impl.SqlDefaultFeatures;
import org.sqlproc.engine.impl.SqlMappingRule;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlProcessor;
import org.sqlproc.engine.plugin.SqlPluginFactory;
import org.sqlproc.engine.type.SqlComposedTypeFactory;
import org.sqlproc.engine.type.SqlInternalType;
import org.sqlproc.engine.type.SqlTypeFactory;
import org.sqlproc.engine.validation.SqlValidatorFactory;

public class SqlProcessorLoader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SqlTypeFactory composedTypeFactory;
    private SqlPluginFactory pluginFactory;
    private SqlMonitorFactory monitorFactory;
    private SqlValidatorFactory validatorFactory;
    private Engine engines = new Engine();
    private Engine dynamicEngines = new Engine();
    private Map<String, SqlMetaStatement> sqls;
    private Map<String, SqlMetaStatement> cruds;
    private Map<String, SqlMetaStatement> calls;
    private Map<String, SqlMappingRule> outs;
    private Map<String, Object> features;
    private Map<String, Map<String, Object>> statementsFeatures;
    private Map<String, Set<String>> statementsFeaturesUnset;
    private Boolean lazyInit;
    private Cache processingCache = new Cache();
    private ConcurrentHashMap<String, String> enginesInitErrors = new ConcurrentHashMap();

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) throws SqlEngineException {
        this(sbStatements, typeFactory, pluginFactory, (String)null, (SqlMonitorFactory)null, (List<SqlInternalType>)null, (String[])null);
    }

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, String filter) throws SqlEngineException {
        this(sbStatements, typeFactory, pluginFactory, filter, (SqlMonitorFactory)null, (List<SqlInternalType>)null, (String[])null);
    }

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, String filter, SqlMonitorFactory monitorFactory) throws SqlEngineException {
        this(sbStatements, typeFactory, pluginFactory, filter, monitorFactory, (List<SqlInternalType>)null, (String[])null);
    }

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, String filter, SqlMonitorFactory monitorFactory, String ... onlyStatements) {
        this(sbStatements, typeFactory, pluginFactory, filter, monitorFactory, (List<SqlInternalType>)null, onlyStatements);
    }

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, String filter, SqlMonitorFactory monitorFactory, List<SqlInternalType> customTypes, String ... onlyStatements) throws SqlEngineException {
        this(sbStatements, typeFactory, pluginFactory, filter, monitorFactory, null, customTypes, onlyStatements);
    }

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, String filter, SqlMonitorFactory monitorFactory, SqlValidatorFactory validatorFactory, List<SqlInternalType> customTypes, String ... onlyStatements) throws SqlEngineException {
        this(sbStatements, typeFactory, pluginFactory, filter, monitorFactory, validatorFactory, customTypes, false, onlyStatements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, String filter, SqlMonitorFactory monitorFactory, SqlValidatorFactory validatorFactory, List<SqlInternalType> customTypes, Boolean lazyInit, String ... onlyStatements) throws SqlEngineException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">> SqlProcessorLoader, sbStatements=" + sbStatements + ", typeFactory=" + typeFactory + ", pluginFactory=" + pluginFactory + ", monitorFactory=" + monitorFactory + ", validatorFactory=" + validatorFactory + ", filter=" + filter + ", customTypes=" + customTypes + ", lazyInit=" + lazyInit + ", onlyStatements=" + onlyStatements);
        }
        long start = System.currentTimeMillis();
        if (sbStatements == null) {
            throw new SqlEngineException("Missing SQL META queries/statements/output mappings");
        }
        if (typeFactory == null) {
            throw new SqlEngineException("Missing the META types factory");
        }
        this.composedTypeFactory = new SqlComposedTypeFactory(typeFactory, customTypes);
        this.pluginFactory = pluginFactory;
        this.validatorFactory = validatorFactory;
        this.monitorFactory = monitorFactory;
        this.lazyInit = lazyInit;
        try {
            HashSet<String> setSelectQueries = onlyStatements != null && onlyStatements.length > 0 ? new HashSet<String>(Arrays.asList(onlyStatements)) : null;
            filter = filter != null ? filter.toUpperCase() : null;
            Map<String, Object> defaultFeatures = SqlDefaultFeatures.getFilteredFeatures(filter);
            StringBuilder errors = new StringBuilder();
            SqlProcessor processor = null;
            try {
                processor = this.isLazyInit() ? SqlProcessor.getLazyInstance(sbStatements, this.composedTypeFactory, defaultFeatures, setSelectQueries, filter) : SqlProcessor.getInstance(sbStatements, this.composedTypeFactory, defaultFeatures, setSelectQueries, filter);
            }
            catch (SqlEngineException see) {
                errors.append(see.getMessage());
            }
            if (errors.length() > 0) {
                throw new SqlEngineException(errors.toString());
            }
            if (!processor.getWarnings().isEmpty()) {
                this.logger.warn("There're warnings in the process of statements parsing: " + processor.getWarnings());
            }
            this.sqls = processor.getMetaStatements(SqlProcessor.StatementType.QRY);
            this.cruds = processor.getMetaStatements(SqlProcessor.StatementType.CRUD);
            this.calls = processor.getMetaStatements(SqlProcessor.StatementType.CALL);
            this.outs = processor.getMappingRules(SqlProcessor.MappingType.OUT);
            this.features = processor.getFeatures();
            this.statementsFeatures = processor.getStatementsFeatures();
            this.statementsFeaturesUnset = processor.getStatementsFeaturesUnset();
            for (String name : this.outs.keySet()) {
                if (this.sqls.containsKey(name) || this.calls.containsKey(name) || this.cruds.containsKey(name)) continue;
                errors.append("For the OUT/FIELDS there's no QRY: ").append(name).append("\n");
            }
            if (errors.length() > 0) {
                throw new SqlEngineException(errors.toString());
            }
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                this.logger.debug("== SqlProcessorLoader, lazyInit=" + lazyInit + ", duration in ms=" + (end - start));
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("<< SqlProcessorLoader, engines=" + this.engines + ", sqls=" + this.sqls + ", cruds=" + this.cruds + ", fields=" + this.outs + ", features=" + this.features);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Executor executor, Set<String> sqlsToInit, Set<String> crudsToInit, Set<String> callsToInit) {
        if (executor != null) {
            this.logger.warn(">> init, executor {}", (Object)executor);
        } else {
            this.logger.trace(">> init");
        }
        long start = System.currentTimeMillis();
        try {
            Set<String> names;
            if (executor != null) {
                AsyncEngineInit aei;
                names = sqlsToInit != null ? sqlsToInit : this.sqls.keySet();
                for (String name : names) {
                    aei = new AsyncEngineInit(name, EngineType.Query, this.enginesInitErrors);
                    executor.execute(aei);
                }
                names = crudsToInit != null ? crudsToInit : this.cruds.keySet();
                for (String name : names) {
                    aei = new AsyncEngineInit(name, EngineType.Crud, this.enginesInitErrors);
                    executor.execute(aei);
                }
                names = callsToInit != null ? callsToInit : this.calls.keySet();
                for (String name : names) {
                    aei = new AsyncEngineInit(name, EngineType.Procedure, this.enginesInitErrors);
                    executor.execute(aei);
                }
            } else {
                String msg;
                names = sqlsToInit != null ? sqlsToInit : this.sqls.keySet();
                for (String name : names) {
                    try {
                        this.logger.info("== sync init, name={}, type={} in {}", new Object[]{name, EngineType.Query, Thread.currentThread().getName()});
                        this.getEngine(name, EngineType.Query);
                    }
                    catch (SqlEngineException ex) {
                        msg = ex.getMessage();
                        this.enginesInitErrors.put(EngineType.Query.name() + ":" + name, msg);
                        this.logger.warn("!! init, name={}, error={}", (Object)name, (Object)msg);
                    }
                }
                names = crudsToInit != null ? crudsToInit : this.cruds.keySet();
                for (String name : names) {
                    try {
                        this.logger.info("== sync init, name={}, type={} in {}", new Object[]{name, EngineType.Crud, Thread.currentThread().getName()});
                        this.getEngine(name, EngineType.Crud);
                    }
                    catch (SqlEngineException ex) {
                        msg = ex.getMessage();
                        this.enginesInitErrors.put(EngineType.Crud.name() + ":" + name, msg);
                        this.logger.warn("!! init, name={}, error={}", (Object)name, (Object)msg);
                    }
                }
                names = callsToInit != null ? callsToInit : this.calls.keySet();
                for (String name : names) {
                    try {
                        this.logger.info("== sync init, name={}, type={} in {}", new Object[]{name, EngineType.Procedure, Thread.currentThread().getName()});
                        this.getEngine(name, EngineType.Procedure);
                    }
                    catch (SqlEngineException ex) {
                        msg = ex.getMessage();
                        this.enginesInitErrors.put(EngineType.Procedure.name() + ":" + name, msg);
                        this.logger.warn("!! init, name={}, error={}", (Object)name, (Object)msg);
                    }
                }
            }
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                this.logger.debug("== init, duration in ms=" + (end - start));
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("<< init");
            }
        }
    }

    public ConcurrentHashMap<String, String> getEnginesInitErrors() {
        return this.enginesInitErrors;
    }

    public String getEnginesInitErrorsMsg() {
        StringBuilder sb = new StringBuilder();
        boolean isError = false;
        for (Map.Entry<String, String> e : this.enginesInitErrors.entrySet()) {
            if (e.getValue() == null) continue;
            if (isError) {
                sb.append("\n");
            }
            sb.append(e.getKey() + ": " + e.getValue());
            isError = true;
        }
        if (isError) {
            return sb.toString();
        }
        return null;
    }

    private void loadStatementFeatures(String name, SqlEngine sqlEngine) {
        Set<String> statementFeaturesUnset;
        Map<String, Object> statementFeatures = this.statementsFeatures.get(name);
        if (statementFeatures != null) {
            for (Map.Entry<String, Object> entry : statementFeatures.entrySet()) {
                sqlEngine.setFeature(entry.getKey(), entry.getValue());
            }
        }
        if ((statementFeaturesUnset = this.statementsFeaturesUnset.get(name)) != null) {
            sqlEngine.unsetFeatures(statementFeaturesUnset);
        }
    }

    public Map<String, SqlEngine> getEngines(EngineType engineType) {
        return this.engines.get(engineType);
    }

    public Map<String, SqlEngine> getDynamicEngines(EngineType engineType) {
        return this.dynamicEngines.get(engineType);
    }

    private SqlEngine createEngine(String name, EngineType engineType, SqlMetaStatement stmt, String sqlStatement) {
        SqlMonitor monitor;
        SqlMetaStatement stmt2 = null;
        stmt2 = sqlStatement != null ? SqlMetaStatement.getInstance(name, sqlStatement, this.composedTypeFactory) : (this.isLazyInit() ? SqlMetaStatement.getInstance(name, stmt.getRaw(), this.composedTypeFactory) : stmt);
        if (engineType == EngineType.Query && !stmt2.isHasOutputMapping() && !this.outs.containsKey(name)) {
            throw new SqlEngineException("For the QRY there's no OUT: " + name);
        }
        SqlMappingRule mapping = null;
        if (this.outs.containsKey(name)) {
            mapping = this.outs.get(name);
            if (this.isLazyInit()) {
                mapping = SqlMappingRule.getInstance(name, mapping.getRaw(), this.composedTypeFactory);
            }
        } else {
            mapping = new SqlMappingRule();
        }
        SqlMonitor sqlMonitor = monitor = this.monitorFactory != null ? this.monitorFactory.getSqlMonitor(name, this.features) : null;
        SqlEngine sqlEngine = engineType == EngineType.Query ? new SqlQueryEngine(name, stmt2, mapping, monitor, this.features, this.composedTypeFactory, this.pluginFactory) : (engineType == EngineType.Crud ? new SqlCrudEngine(name, stmt2, mapping, monitor, this.features, this.composedTypeFactory, this.pluginFactory) : new SqlProcedureEngine(name, stmt2, mapping, monitor, this.features, this.composedTypeFactory, this.pluginFactory));
        sqlEngine.setValidator(this.validatorFactory != null ? this.validatorFactory.getSqlValidator() : null);
        this.loadStatementFeatures(name, sqlEngine);
        return sqlEngine;
    }

    public SqlEngine getStaticEngine(String name, EngineType engineType) {
        SqlMetaStatement stmt;
        this.dynamicEngines.get(engineType).remove(name);
        SqlEngine sqlEngine = this.engines.get(engineType).get(name);
        if (sqlEngine == null && (stmt = this.getStatements(engineType).get(name)) != null) {
            sqlEngine = this.createEngine(name, engineType, stmt, null);
            SqlEngine sqlEnginePrev = this.engines.get(engineType).putIfAbsent(name, sqlEngine);
            if (sqlEnginePrev != null) {
                sqlEngine = sqlEnginePrev;
            } else {
                ConcurrentHashMap<String, SqlProcessResult> _processingCache = new ConcurrentHashMap<String, SqlProcessResult>();
                this.processingCache.get(engineType).put(name, _processingCache);
                sqlEngine.setProcessingCache(_processingCache);
            }
        }
        return sqlEngine;
    }

    public SqlEngine getDynamicEngine(String name, EngineType engineType, String sqlStatement) {
        Map<String, SqlMetaStatement> stmts = this.getStatements(engineType);
        if (!stmts.containsKey(name)) {
            throw new SqlEngineException("Missing SQL Engine " + name);
        }
        if (sqlStatement == null) {
            throw new SqlEngineException("SQL statement for SQL Engine " + name + " is null");
        }
        SqlEngine sqlEngine = this.createEngine(name, engineType, null, sqlStatement);
        this.dynamicEngines.get(engineType).put(name, sqlEngine);
        this.processingCache.get(engineType).put(name, new ConcurrentHashMap());
        sqlEngine.setProcessingCache(this.processingCache.get(engineType).get(name));
        return sqlEngine;
    }

    public SqlEngine getEngine(String name, EngineType engineType) {
        SqlEngine sqlEngine = this.dynamicEngines.get(engineType).get(name);
        if (sqlEngine != null) {
            return sqlEngine;
        }
        return this.getStaticEngine(name, engineType);
    }

    private Map<String, SqlMetaStatement> getStatements(EngineType engineType) {
        if (engineType == EngineType.Query) {
            return this.sqls;
        }
        if (engineType == EngineType.Crud) {
            return this.cruds;
        }
        return this.calls;
    }

    public boolean isLazyInit() {
        return this.lazyInit != null && this.lazyInit != false;
    }

    @Beta
    private class AsyncEngineInit
    implements Runnable {
        private String name;
        private EngineType engineType;
        private ConcurrentHashMap<String, String> enginesInitErrors;

        public AsyncEngineInit(String name, EngineType engineType, ConcurrentHashMap<String, String> enginesInitErrors) {
            this.name = name;
            this.engineType = engineType;
            this.enginesInitErrors = enginesInitErrors;
        }

        @Override
        public void run() {
            SqlProcessorLoader.this.logger.info("== async init, name={}, type={} in {}", new Object[]{this.name, this.engineType, Thread.currentThread().getName()});
            try {
                SqlProcessorLoader.this.getEngine(this.name, this.engineType);
            }
            catch (SqlEngineException ex) {
                String msg = ex.getMessage();
                this.enginesInitErrors.put(this.engineType.name() + ":" + this.name, msg);
                SqlProcessorLoader.this.logger.warn("!! init, name={}, error={}", (Object)this.name, (Object)msg);
            }
        }
    }

    static class Cache {
        ConcurrentHashMap<String, Map<String, SqlProcessResult>> sqls = new ConcurrentHashMap();
        ConcurrentHashMap<String, Map<String, SqlProcessResult>> cruds = new ConcurrentHashMap();
        ConcurrentHashMap<String, Map<String, SqlProcessResult>> calls = new ConcurrentHashMap();

        Cache() {
        }

        ConcurrentHashMap<String, Map<String, SqlProcessResult>> get(EngineType type) {
            if (type == EngineType.Query) {
                return this.sqls;
            }
            if (type == EngineType.Crud) {
                return this.cruds;
            }
            return this.calls;
        }
    }

    static class Engine {
        ConcurrentHashMap<String, SqlEngine> sqls = new ConcurrentHashMap();
        ConcurrentHashMap<String, SqlEngine> cruds = new ConcurrentHashMap();
        ConcurrentHashMap<String, SqlEngine> calls = new ConcurrentHashMap();

        Engine() {
        }

        ConcurrentHashMap<String, SqlEngine> get(EngineType type) {
            if (type == EngineType.Query) {
                return this.sqls;
            }
            if (type == EngineType.Crud) {
                return this.cruds;
            }
            return this.calls;
        }
    }

    public static enum EngineType {
        Query,
        Crud,
        Procedure;

    }
}

