/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sqlproc.engine.SqlControl;
import org.sqlproc.engine.SqlEngine;
import org.sqlproc.engine.SqlFeature;
import org.sqlproc.engine.SqlOrder;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.impl.SqlMetaSqlFragment;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.plugin.BeanUtilsPlugin;
import org.sqlproc.engine.plugin.SqlPluginFactory;
import org.sqlproc.engine.type.SqlTypeFactory;

public class SqlProcessContext
implements SqlRuntimeContext {
    private SqlMetaStatement.Type sqlStatementType;
    private Object dynamicInputValues;
    private SqlControl sqlControl;
    private SqlEngine sqlEngine;
    private SqlMetaSqlFragment.Type sqlFragmentType;
    private Set<String> oppositeNames = new HashSet<String>();

    SqlProcessContext(SqlMetaStatement.Type sqlStatementType, Object dynamicInputValues, SqlControl sqlControl, SqlEngine sqlEngine) {
        this.sqlStatementType = sqlStatementType;
        this.dynamicInputValues = dynamicInputValues;
        this.sqlControl = sqlControl;
        this.sqlEngine = sqlEngine;
        this.initFeatures();
    }

    SqlProcessContext(SqlProcessContext ctx, Object dynamicInputValues, SqlControl sqlControl) {
        this.sqlStatementType = ctx.sqlStatementType;
        this.dynamicInputValues = dynamicInputValues;
        this.sqlControl = sqlControl;
        this.sqlEngine = ctx.sqlEngine;
        this.initFeatures();
    }

    private void initFeatures() {
        Map<String, Object> runtimeFeatures = SqlEngine.getFeatures(this.sqlControl);
        if (runtimeFeatures != null) {
            for (Map.Entry<String, Object> entry : runtimeFeatures.entrySet()) {
                Set<String> oppositeNames = SqlUtils.oppositeFeatures(entry.getKey());
                if (oppositeNames == null) continue;
                this.oppositeNames.addAll(oppositeNames);
            }
        }
    }

    SqlMetaStatement.Type getSqlStatementType() {
        return this.sqlStatementType;
    }

    public Object getDynamicInputValues() {
        if (this.sqlFragmentType != SqlMetaSqlFragment.Type.SET) {
            return this.dynamicInputValues;
        }
        Object dynamicUpdateValues = SqlEngine.getDynamicUpdateValues(this.sqlControl);
        if (dynamicUpdateValues != null) {
            return dynamicUpdateValues;
        }
        return this.dynamicInputValues;
    }

    public Object getStaticInputValues() {
        return SqlEngine.getStaticInputValues(this.sqlControl);
    }

    public void setSqlFragmentType(SqlMetaSqlFragment.Type sqlFragmentType) {
        this.sqlFragmentType = sqlFragmentType;
    }

    public boolean isInSetOrInsert() {
        return this.sqlFragmentType == SqlMetaSqlFragment.Type.SET || this.sqlFragmentType == SqlMetaSqlFragment.Type.VALUES;
    }

    @Override
    public String getFeature(String name) {
        Object o = this.getRawFeature(name);
        return o != null && o instanceof String ? (String)o : null;
    }

    @Override
    public String getFeature(SqlFeature feature) {
        Object o = this.getRawFeature(feature);
        return o != null && o instanceof String ? (String)o : null;
    }

    @Override
    public String getFeature(SqlFeature feature, String specName) {
        Object o = this.getRawFeature(feature.name() + "###" + specName);
        return o != null && o instanceof String ? (String)o : null;
    }

    @Override
    public String[] getFeatures(String name) {
        Object o = this.getRawFeature(name);
        if (o != null && o instanceof String[]) {
            return (String[])o;
        }
        if (o != null && o instanceof String) {
            return new String[]{(String)o};
        }
        return null;
    }

    @Override
    public boolean isFeature(SqlFeature feature) {
        Object o = this.getRawFeature(feature.name());
        return o != null && o instanceof Boolean && (Boolean)o != false;
    }

    @Override
    public Integer getFeatureAsInt(SqlFeature feature) {
        Object o = this.getRawFeature(feature.name());
        if (o == null || !(o instanceof String)) {
            return null;
        }
        try {
            return Integer.parseInt((String)o);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    @Override
    public Object getFeatureAsObject(SqlFeature feature) {
        Object o = this.getRawFeature(feature.name());
        return o;
    }

    protected Object getRawFeature(SqlFeature feature) {
        return this.getRawFeature(feature.name());
    }

    protected Object getRawFeature(String name) {
        Map<String, Object> runtimeFeatures = SqlEngine.getFeatures(this.sqlControl);
        if (runtimeFeatures != null && runtimeFeatures.containsKey(name)) {
            return runtimeFeatures.get(name);
        }
        if (this.oppositeNames.contains(name)) {
            return null;
        }
        return this.sqlEngine.getFeatures().get(name);
    }

    List<SqlOrder> getOrder() {
        return SqlEngine.getOrder(this.sqlControl).getOrders();
    }

    int getOrderIndex(String orderId) {
        List<SqlOrder> order = this.getOrder();
        if (order == null || order.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < order.size(); ++i) {
            SqlOrder sqlOrder = order.get(i);
            if (!sqlOrder.getOrderId().equals(orderId)) continue;
            return i;
        }
        return -1;
    }

    SqlOrder.Order getOrder(int orderIndex) {
        List<SqlOrder> order = this.getOrder();
        if (orderIndex < 0 || orderIndex >= order.size()) {
            return SqlOrder.Order.NONE;
        }
        return order.get(orderIndex).getOrderDirection();
    }

    @Override
    public SqlTypeFactory getTypeFactory() {
        return this.sqlEngine.getTypeFactory();
    }

    @Override
    public SqlPluginFactory getPluginFactory() {
        return this.sqlEngine.getPluginFactory();
    }

    @Override
    public Object getInstance(Class<?> clazz) {
        return this.getPluginFactory().getSqlBeansPlugin().getInstance(this, clazz);
    }

    @Override
    public Class<?> getAttributeType(Class<?> clazz, String attrName) {
        return this.getPluginFactory().getSqlBeansPlugin().getAttributeType(this, clazz, attrName);
    }

    @Override
    public BeanUtilsPlugin.GetterType getGetterType(Class<?> clazz, String attrName) {
        return this.getPluginFactory().getSqlBeansPlugin().getGetterType((SqlRuntimeContext)this, clazz, attrName);
    }

    @Override
    public BeanUtilsPlugin.GetterType getGetterType(Object bean, String attrName) {
        return this.getPluginFactory().getSqlBeansPlugin().getGetterType((SqlRuntimeContext)this, bean, attrName);
    }

    @Override
    public boolean checkAttribute(Object bean, String attrName) {
        return this.getPluginFactory().getSqlBeansPlugin().checkAttribute(this, bean, attrName);
    }

    @Override
    public Object getAttribute(Object bean, String attrName) {
        return this.getPluginFactory().getSqlBeansPlugin().getAttribute(this, bean, attrName);
    }

    @Override
    public boolean simpleSetAttribute(Object bean, String attrName, Object attrValue, Class<?> ... attrTypes) {
        return this.getPluginFactory().getSqlBeansPlugin().simpleSetAttribute(this, bean, attrName, attrValue, attrTypes);
    }

    @Override
    public void setAttribute(Object bean, String attrName, Object attrValue) {
        this.getPluginFactory().getSqlBeansPlugin().setAttribute(this, bean, attrName, attrValue);
    }

    @Override
    public boolean checkMethod(Class<?> clazz, String methodName, Class<?> ... args) {
        return this.getPluginFactory().getSqlBeansPlugin().checkMethod((SqlRuntimeContext)this, clazz, methodName, args);
    }

    @Override
    public boolean checkMethod(Object bean, String methodName, Object ... args) {
        return this.getPluginFactory().getSqlBeansPlugin().checkMethod((SqlRuntimeContext)this, bean, methodName, args);
    }

    @Override
    public Object invokeMethod(Class<?> clazz, String methodName, Object ... args) {
        return this.getPluginFactory().getSqlBeansPlugin().invokeMethod((SqlRuntimeContext)this, clazz, methodName, args);
    }

    @Override
    public Object invokeMethod(Object bean, String methodName, Object ... args) {
        return this.getPluginFactory().getSqlBeansPlugin().invokeMethod((SqlRuntimeContext)this, bean, methodName, args);
    }

    @Override
    public Object getEnumToValue(Object bean) {
        return this.getPluginFactory().getSqlBeansPlugin().getEnumToValue(this, bean);
    }

    @Override
    public Class<?> getEnumToClass(Class<?> clazz) {
        return this.getPluginFactory().getSqlBeansPlugin().getEnumToClass(this, clazz);
    }

    @Override
    public Object getValueToEnum(Class<?> objClass, Object val) {
        return this.getPluginFactory().getSqlBeansPlugin().getValueToEnum(this, objClass, val);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SqlProcessContext[");
        sb.append(" sqlStatementType=").append((Object)this.sqlStatementType);
        sb.append(", dynamicInputValues=").append(this.dynamicInputValues);
        sb.append(", sqlControl=").append(this.sqlControl != null ? this.sqlControl.toString() : null);
        sb.append(", sqlEngine=").append(this.sqlEngine);
        return sb.append("]").toString();
    }
}

