/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlFeature;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.SqlInputValue;
import org.sqlproc.engine.impl.SqlMetaLogOperand;
import org.sqlproc.engine.impl.SqlMetaSimple;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlType;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.type.SqlMetaType;

class SqlMetaIdent
implements SqlMetaSimple,
SqlMetaLogOperand {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SqlInputValue.Code caseConversion;
    private SqlInputValue.Mode inOutMode;
    private boolean not;
    private List<String> elements;
    private SqlType sqlType;
    Map<String, String> values = new HashMap<String, String>();

    SqlMetaIdent(SqlInputValue.Code caseConversion, SqlInputValue.Mode inOutMode) {
        this(caseConversion, inOutMode, false);
    }

    SqlMetaIdent(SqlInputValue.Code caseConversion, SqlInputValue.Mode inOutMode, boolean not) {
        this(caseConversion, inOutMode, false, new SqlType());
    }

    SqlMetaIdent(SqlInputValue.Code caseConversion, SqlInputValue.Mode inOutMode, boolean not, SqlType type) {
        this.elements = new ArrayList<String>();
        this.caseConversion = caseConversion;
        this.inOutMode = inOutMode;
        this.not = not;
        this.sqlType = type;
    }

    void addIdent(String name) {
        String[] names = name.split("=");
        this.elements.add(names[0]);
    }

    void setMetaType(String metaTypeName, SqlMetaType metaType) {
        this.sqlType = new SqlType(metaTypeName, metaType);
    }

    public void setValues(String value, String value2) {
        int ix = -1;
        if (value2 == null && (ix = value.indexOf(61)) >= 0) {
            value2 = value.substring(ix + 1);
            value = value.substring(0, ix);
        }
        if (value2 == null) {
            if (value.equals("idsel")) {
                this.values.put(value, "idsel");
            } else if (value.equals("seq")) {
                this.values.put(value, "seq");
            } else if (value.equals("anyset")) {
                this.values.put(value, null);
            } else {
                this.sqlType.setValue(value);
            }
        } else {
            this.values.put(value, value2);
        }
    }

    SqlType getSqlType() {
        return this.sqlType;
    }

    void setNot(boolean not) {
        this.not = not;
    }

    boolean isNot() {
        return this.not;
    }

    public List<String> getElements() {
        return this.elements;
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        SqlInputValue identityInputValue;
        String identityGeneratorValue;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> process : dynamicInputValues=" + ctx.getDynamicInputValues() + ", class=" + (ctx.getDynamicInputValues() != null ? ctx.getDynamicInputValues().getClass() : null) + ", sqlType=" + this.sqlType);
        }
        SqlProcessResult result = new SqlProcessResult(ctx);
        Object obj = ctx.getDynamicInputValues();
        Object parentObj = null;
        StringBuilder sname = new StringBuilder(this.elements.size() * 32);
        StringBuilder fname = new StringBuilder(this.elements.size() * 32);
        sname.append(':');
        String sequenceName = this.values.get("seq");
        String identitySelectName = this.values.get("idsel");
        String identityGenerator = this.values.get("idgen");
        String string = identityGeneratorValue = identityGenerator != null ? ctx.getFeature(SqlFeature.IDGEN, identityGenerator) : null;
        if (identityGeneratorValue != null) {
            int ix = identityGeneratorValue.indexOf("=");
            if (ix >= 0) {
                String value = identityGeneratorValue.substring(0, ix);
                if (value.equals("seq")) {
                    sequenceName = identityGeneratorValue.substring(ix + 1);
                    identityGenerator = null;
                } else if (value.equals("idsel")) {
                    identitySelectName = identityGeneratorValue.substring(ix + 1);
                    identityGenerator = null;
                }
            } else if (identityGeneratorValue.equals("seq")) {
                sequenceName = "seq";
                identityGenerator = null;
            } else if (identityGeneratorValue.equals("idsel")) {
                identitySelectName = "idsel";
                identityGenerator = null;
            }
        }
        int count = 1;
        String attributeName = null;
        String lastAttributeName = null;
        Class<?> attributeType = obj != null ? obj.getClass() : null;
        for (String item : this.elements) {
            attributeName = item;
            if (Character.isDigit(attributeName.charAt(0))) {
                sname.append(attributeName);
                fname.append(attributeName);
                if (obj == null) break;
                parentObj = obj;
                obj = null;
                break;
            }
            if (attributeType != null) {
                Class<?> origAttributeType = attributeType;
                if ((attributeType = ctx.getAttributeType(attributeType, attributeName)) == null) {
                    if (ctx.isFeature(SqlFeature.IGNORE_INPROPER_IN)) {
                        this.logger.error("There's no attribute '" + attributeName + "' for " + origAttributeType);
                    } else {
                        throw new SqlRuntimeException("There's no attribute '" + attributeName + "' for " + origAttributeType);
                    }
                }
            }
            if (count > 1) {
                sname.append('_');
                fname.append(",");
            }
            sname.append(attributeName);
            fname.append(attributeName);
            if (obj != null) {
                parentObj = obj;
                obj = ctx.getAttribute(obj, item);
            }
            if (obj == null && lastAttributeName == null) {
                lastAttributeName = attributeName;
            }
            ++count;
        }
        if (lastAttributeName == null) {
            lastAttributeName = attributeName;
        }
        String sequence = null;
        String identitySelect = null;
        if (identityGenerator != null) {
            identitySelect = ctx.getPluginFactory().getSqlIdentityPlugin().identitySelect(ctx, identityGenerator, attributeType);
            if (identitySelect == null) {
                sequence = ctx.getPluginFactory().getSqlSequencePlugin().sequenceSelect(ctx, identityGenerator);
            }
            if (sequence == null && identitySelect == null) {
                throw new SqlRuntimeException("Missing identity generator " + identityGenerator);
            }
        } else if (sequenceName != null) {
            sequence = ctx.getPluginFactory().getSqlSequencePlugin().sequenceSelect(ctx, sequenceName);
            if (sequence == null) {
                throw new SqlRuntimeException("Missing sequence " + sequenceName);
            }
        } else if (identitySelectName != null && (identitySelect = ctx.getPluginFactory().getSqlIdentityPlugin().identitySelect(ctx, identitySelectName, attributeType)) == null) {
            throw new SqlRuntimeException("Missing identity select " + identitySelectName);
        }
        if (sequence != null) {
            result.add(true);
            identityInputValue = new SqlInputValue(ctx, SqlInputValue.Type.SEQUENCE_BASED, obj, parentObj, sequence, this.sqlType, this.values.get("id"), attributeType);
            result.addInputValue(sname.substring(1), identityInputValue);
            result.addIdentity(attributeName, identityInputValue);
            result.setSql(new StringBuilder(ctx.isFeature(SqlFeature.JDBC) ? "?" : sname.toString()));
        } else if (identitySelect != null) {
            result.add(true);
            identityInputValue = new SqlInputValue(ctx, SqlInputValue.Type.IDENTITY_SELECT, obj, parentObj, identitySelect, this.sqlType, this.values.get("id"), attributeType);
            result.addInputValue(sname.substring(1), identityInputValue);
            result.addIdentity(attributeName, identityInputValue);
            result.setSkipNextText(true);
        } else {
            try {
                result.add(ctx.getPluginFactory().getIsEmptyPlugin().isNotEmpty(ctx, lastAttributeName, obj, parentObj, this.sqlType == null ? null : this.sqlType.getMetaType(ctx), this.sqlType == null ? null : this.sqlType.getValue(), ctx.isInSetOrInsert() || ctx.getSqlStatementType() == SqlMetaStatement.Type.CALL, this.values));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Input value " + attributeName + ", failed reason" + e.getMessage());
            }
            if (obj != null && obj instanceof Collection && !ctx.isFeature(SqlFeature.COLLECTIONS_ARE_STANDARD_TYPES)) {
                boolean notEmpty;
                boolean bl = notEmpty = !((Collection)obj).isEmpty();
                if (!notEmpty && this.values.containsKey("anyset")) {
                    result.setSql(new StringBuilder("(null)"));
                } else {
                    StringBuilder ss = new StringBuilder(notEmpty ? "(" : "");
                    int i = 1;
                    Iterator iter = ((Collection)obj).iterator();
                    while (iter.hasNext()) {
                        Object objItem = iter.next();
                        if (objItem != null) {
                            String attributeNameItem = sname.toString() + "_" + i++;
                            ss.append((String)(ctx.isFeature(SqlFeature.JDBC) ? "?" : attributeNameItem));
                            result.addInputValue(attributeNameItem.substring(1), new SqlInputValue(ctx, SqlInputValue.Type.PROVIDED, objItem, parentObj, this.caseConversion, this.inOutMode, this.sqlType, null, null, ctx.isInSetOrInsert(), objItem.getClass()));
                        } else {
                            ss.append("null");
                        }
                        if (!iter.hasNext()) continue;
                        ss.append(',');
                    }
                    if (notEmpty) {
                        ss.append(')');
                    }
                    result.setSql(ss);
                }
            } else {
                Class<?>[] attributeParameterizedTypes = null;
                Class<?> attributeParameterizedType = null;
                if (SqlUtils.isCollection(attributeType) && ctx.isFeature(SqlFeature.COLLECTIONS_ARE_STANDARD_TYPES)) {
                    String typeName = this.values.get(fname.toString() + "gtype");
                    if (typeName != null && ctx.getMoreResultClasses() != null) {
                        attributeParameterizedType = ctx.getMoreResultClasses().get(typeName);
                    }
                    if (attributeParameterizedType == null) {
                        attributeParameterizedTypes = ctx.getAttributeParameterizedTypes(parentObj.getClass(), attributeName);
                    }
                    if (attributeParameterizedTypes == null && typeName != null) {
                        attributeParameterizedType = SqlUtils.getStandardModeResultClass(typeName);
                    }
                }
                SqlInputValue sqlInputValue = new SqlInputValue(ctx, SqlInputValue.Type.PROVIDED, obj, parentObj, this.caseConversion, this.inOutMode, this.sqlType, lastAttributeName, fname.toString(), ctx.isInSetOrInsert(), SqlUtils.getAllAttributeTypes(attributeType, attributeParameterizedTypes, attributeParameterizedType));
                result.addInputValue(sname.substring(1), sqlInputValue);
                if (this.inOutMode == SqlInputValue.Mode.OUT || this.inOutMode == SqlInputValue.Mode.INOUT) {
                    result.addOutValue(attributeName, sqlInputValue);
                }
                result.setSql(new StringBuilder(ctx.isFeature(SqlFeature.JDBC) ? "?" : sname.toString()));
            }
        }
        return result;
    }

    @Override
    public boolean processExpression(SqlProcessContext ctx) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> processExpression : dynamicInputValues=" + ctx.getDynamicInputValues() + ", class=" + (ctx.getDynamicInputValues() != null ? ctx.getDynamicInputValues().getClass() : null) + ", sqlType=" + this.sqlType);
        }
        Object parentObj = null;
        Object obj = ctx.getDynamicInputValues();
        String attributeName = null;
        Iterator<String> iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            String item;
            attributeName = item = iterator.next();
            if (obj == null) continue;
            parentObj = obj;
            obj = ctx.getAttribute(obj, item);
        }
        boolean result = ctx.getPluginFactory().getIsTruePlugin().isTrue(ctx, attributeName, obj, parentObj, this.sqlType == null ? null : this.sqlType.getMetaType(ctx), this.sqlType == null ? null : this.sqlType.getValue(), this.values);
        return this.not ? !result : result;
    }
}

