/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sqlproc.engine.SqlControl;
import org.sqlproc.engine.SqlEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlExtendedMonitor;
import org.sqlproc.engine.SqlMonitor;
import org.sqlproc.engine.SqlProcessorException;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.SqlSession;
import org.sqlproc.engine.config.SqlEngineConfiguration;
import org.sqlproc.engine.impl.SqlMappingResult;
import org.sqlproc.engine.impl.SqlMappingRule;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlStandardControl;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.plugin.SqlPluginFactory;
import org.sqlproc.engine.type.SqlTypeFactory;

public class SqlProcedureEngine
extends SqlEngine {
    public SqlProcedureEngine(String name, String statement, String mapping, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) throws SqlEngineException {
        super(name, SqlMetaStatement.getInstance(name, statement, typeFactory), mapping != null ? SqlMappingRule.getInstance(name, mapping, typeFactory) : null, null, null, typeFactory, pluginFactory, null);
    }

    public SqlProcedureEngine(String name, String statement, String mapping, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) throws SqlEngineException {
        super(name, SqlMetaStatement.getInstance(name, statement, typeFactory), mapping != null ? SqlMappingRule.getInstance(name, mapping, typeFactory) : null, monitor, features, typeFactory, pluginFactory, null);
    }

    public SqlProcedureEngine(String name, SqlMetaStatement statement, SqlMappingRule mapping, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) {
        super(name, statement, mapping, null, null, typeFactory, pluginFactory, null);
    }

    public SqlProcedureEngine(String name, SqlMetaStatement statement, SqlMappingRule mapping, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) {
        super(name, statement, mapping, monitor, features, typeFactory, pluginFactory, null);
    }

    public SqlProcedureEngine(String name, SqlMetaStatement statement, SqlMappingRule mapping, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, SqlEngineConfiguration configuration) {
        super(name, statement, mapping, monitor, features, typeFactory, pluginFactory, configuration);
    }

    public <E> List<E> callQuery(SqlSession session, Class<E> resultClass, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.callQuery(session, resultClass, dynamicInputValues, null);
    }

    public <E> List<E> callQuery(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, int maxTimeout) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.callQuery(session, resultClass, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setMaxTimeout(maxTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> List<E> callQuery(final SqlSession session, final Class<E> resultClass, final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> callQuery, session=" + String.valueOf(session) + ", resultClass=" + String.valueOf(resultClass) + ", dynamicInputValues=" + String.valueOf(dynamicInputValues) + ", sqlControl=" + String.valueOf(sqlControl));
        }
        this.checkDynamicInputValues(dynamicInputValues);
        List<E> result = null;
        try {
            List<E> list = result = this.monitor.runList(new SqlMonitor.Runner(){

                @Override
                public List<E> run() {
                    SqlProcessResult processResult = SqlProcedureEngine.this.process(SqlMetaStatement.Type.CALL, dynamicInputValues, sqlControl);
                    String sql = SqlProcedureEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlProcedureEngine.this.name, processResult.getSql().toString());
                    final SqlQuery query = session.createSqlQuery(sql);
                    query.setLogError(processResult.isLogError());
                    query.setSqlControl(sqlControl);
                    processResult.setQueryParams(session, query);
                    final SqlMappingResult mappingResult = SqlMappingRule.merge(SqlProcedureEngine.this.mapping, processResult);
                    mappingResult.setQueryResultMapping(resultClass, null, query);
                    if (SqlProcedureEngine.this.monitor instanceof SqlExtendedMonitor) {
                        SqlExtendedMonitor monitorExt = (SqlExtendedMonitor)SqlProcedureEngine.this.monitor;
                        return monitorExt.runListSql(new SqlMonitor.Runner(){

                            @Override
                            public List<E> run() {
                                return SqlProcedureEngine.this.callQuery(query, mappingResult, resultClass);
                            }
                        }, resultClass);
                    }
                    return SqlProcedureEngine.this.callQuery(query, mappingResult, resultClass);
                }
            }, resultClass);
            return list;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< callQuery, result=" + String.valueOf(result));
            }
        }
    }

    private <E> List<E> callQuery(SqlQuery query, SqlMappingResult mappingResult, Class<E> resultClass) {
        List<Map<String, Object>> resultRows = query.callList(mappingResult.getRuntimeContext());
        boolean isPrimitiveWrapper = SqlUtils.isPrimitiveWrapper(resultClass);
        ArrayList<Object> result = new ArrayList<Object>();
        Object resultInstance = null;
        for (Map<String, Object> resultRow : resultRows) {
            Object[] resultValues = SqlUtils.getResultValues(resultRow);
            if (!isPrimitiveWrapper) {
                resultInstance = mappingResult.getRuntimeContext().getInstance(resultClass);
                if (resultInstance == null) {
                    throw new SqlRuntimeException("There's problem to instantiate " + String.valueOf(resultClass));
                }
            } else {
                resultInstance = resultValues[0];
            }
            mappingResult.setQueryResultData(resultInstance, resultValues, null, null);
            result.add(resultInstance);
        }
        return result;
    }

    public int callUpdate(SqlSession session, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.callUpdate(session, dynamicInputValues, null);
    }

    public int callUpdate(SqlSession session, Object dynamicInputValues, Object staticInputValues, int maxTimeout) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.callUpdate(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setMaxTimeout(maxTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int callUpdate(final SqlSession session, final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException {
        int n;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> callUpdate, session=" + String.valueOf(session) + ", dynamicInputValues=" + String.valueOf(dynamicInputValues) + ", sqlControl=" + String.valueOf(sqlControl));
        }
        this.checkDynamicInputValues(dynamicInputValues);
        Integer count = null;
        try {
            count = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public Integer run() {
                    final SqlProcessResult processResult = SqlProcedureEngine.this.process(SqlMetaStatement.Type.CALL, dynamicInputValues, sqlControl);
                    String sql = SqlProcedureEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlProcedureEngine.this.name, processResult.getSql().toString());
                    final SqlQuery query = session.createSqlQuery(sql);
                    query.setLogError(processResult.isLogError());
                    query.setSqlControl(sqlControl);
                    processResult.setQueryParams(session, query);
                    if (SqlProcedureEngine.this.monitor instanceof SqlExtendedMonitor) {
                        SqlExtendedMonitor monitorExt = (SqlExtendedMonitor)SqlProcedureEngine.this.monitor;
                        return monitorExt.runSql(new SqlMonitor.Runner(){

                            @Override
                            public Integer run() {
                                return SqlProcedureEngine.this.callUpdate(query, processResult);
                            }
                        }, Integer.class);
                    }
                    return SqlProcedureEngine.this.callUpdate(query, processResult);
                }
            }, Integer.class);
            n = count;
        }
        catch (Throwable throwable) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< callUpdate, result=" + count);
            }
            throw throwable;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("<< callUpdate, result=" + count);
        }
        return n;
    }

    private Integer callUpdate(SqlQuery query, SqlProcessResult processResult) {
        Integer count = query.callUpdate(processResult.getRuntimeContext());
        processResult.postProcess();
        return count;
    }

    public Object callFunction(SqlSession session, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.callFunction(session, dynamicInputValues, (SqlControl)null);
    }

    public Object callFunction(SqlSession session, Object dynamicInputValues, Object staticInputValues, int maxTimeout) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.callFunction(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setMaxTimeout(maxTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callFunction(final SqlSession session, final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException {
        Object object;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> callFunction, session=" + String.valueOf(session) + ", dynamicInputValues=" + String.valueOf(dynamicInputValues) + ", sqlControl=" + String.valueOf(sqlControl));
        }
        this.checkDynamicInputValues(dynamicInputValues);
        Object result = null;
        try {
            object = result = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public Object run() {
                    SqlMappingResult mappingResult;
                    final SqlProcessResult processResult = SqlProcedureEngine.this.process(SqlMetaStatement.Type.CALL, dynamicInputValues, sqlControl);
                    String sql = SqlProcedureEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlProcedureEngine.this.name, processResult.getSql().toString());
                    final SqlQuery query = session.createSqlQuery(sql);
                    query.setLogError(processResult.isLogError());
                    query.setSqlControl(sqlControl);
                    processResult.setQueryParams(session, query);
                    SqlMappingResult sqlMappingResult = mappingResult = SqlProcedureEngine.this.mapping != null ? SqlMappingRule.merge(SqlProcedureEngine.this.mapping, processResult) : null;
                    if (SqlProcedureEngine.this.mapping != null) {
                        mappingResult.setQueryResultMapping(Object.class, null, query);
                    }
                    if (SqlProcedureEngine.this.monitor instanceof SqlExtendedMonitor) {
                        SqlExtendedMonitor monitorExt = (SqlExtendedMonitor)SqlProcedureEngine.this.monitor;
                        return monitorExt.runSql(new SqlMonitor.Runner(){

                            @Override
                            public Object run() {
                                return SqlProcedureEngine.this.callFunction(query, processResult, mappingResult);
                            }
                        }, Object.class);
                    }
                    return SqlProcedureEngine.this.callFunction(query, processResult, mappingResult);
                }
            }, Object.class);
        }
        catch (Throwable throwable) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< callFunction, result=" + String.valueOf(result));
            }
            throw throwable;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("<< callFunction, result=" + String.valueOf(result));
        }
        return object;
    }

    private Object callFunction(SqlQuery query, SqlProcessResult processResult, SqlMappingResult mappingResult) {
        Map<String, Object> result = query.callFunction();
        processResult.postProcess();
        if (mappingResult != null) {
            return mappingResult.getFunctionResultData(result);
        }
        return result.values().toArray()[0];
    }

    public String getCallSql(Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.getSql(dynamicInputValues, staticInputValues, SqlMetaStatement.Type.CALL);
    }

    public String getSql(Object dynamicInputValues, Object staticInputValues, SqlMetaStatement.Type statementType) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.getSql(dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues), statementType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSql(final Object dynamicInputValues, final SqlControl sqlControl, final SqlMetaStatement.Type statementType) throws SqlProcessorException, SqlRuntimeException {
        String string;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> getSql, dynamicInputValues=" + String.valueOf(dynamicInputValues) + ", sqlControl=" + String.valueOf(sqlControl));
        }
        this.checkDynamicInputValues(dynamicInputValues);
        String sql = null;
        try {
            string = sql = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public String run() {
                    SqlProcessResult processResult = SqlProcedureEngine.this.process(statementType, dynamicInputValues, sqlControl);
                    String sql = SqlProcedureEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlProcedureEngine.this.name, processResult.getSql().toString());
                    return sql;
                }
            }, String.class);
        }
        catch (Throwable throwable) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< getSql, sql=" + sql);
            }
            throw throwable;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("<< getSql, sql=" + sql);
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    public SqlMonitor getMonitor() {
        return this.monitor;
    }
}

