/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlFilesLoader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private StringBuilder sbStatements;

    public SqlFilesLoader(String fileName, Class<?> loaderClass) {
        this.sbStatements = this.load(fileName, loaderClass);
    }

    public static StringBuilder getStatements(Class<?> loaderClass, String fileName) {
        SqlFilesLoader loader = new SqlFilesLoader(fileName, loaderClass);
        return loader.getStatements();
    }

    public SqlFilesLoader(List<String> fileNames, Class<?> loaderClass) {
        this.sbStatements = new StringBuilder();
        if (fileNames == null || fileNames.isEmpty()) {
            return;
        }
        for (String fileName : fileNames) {
            StringBuilder statements = this.load(fileName, loaderClass);
            this.sbStatements.append((CharSequence)statements);
        }
    }

    public static StringBuilder getStatements(Class<?> loaderClass, String ... fileNames) {
        ArrayList<String> propsNames = new ArrayList<String>();
        Collections.addAll(propsNames, fileNames);
        SqlFilesLoader loader = new SqlFilesLoader(propsNames, loaderClass);
        return loader.getStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder load(String fileName, Class<?> loaderClass) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">> load, fileName=" + fileName + ", loaderClass=" + String.valueOf(loaderClass));
        }
        StringBuilder statements = new StringBuilder();
        try {
            Object configFile = "/" + fileName;
            InputStream is = loaderClass.getResourceAsStream((String)configFile);
            if (is == null) {
                configFile = fileName;
                is = loaderClass.getResourceAsStream((String)configFile);
            }
            if (is == null) {
                try {
                    configFile = "/" + fileName;
                    is = new FileInputStream((String)configFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (is == null) {
                try {
                    configFile = System.getProperty("user.home") + (String)configFile;
                    is = new FileInputStream((String)configFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (is != null) {
                try {
                    BufferedReader input = new BufferedReader(new InputStreamReader(is));
                    String line = null;
                    while ((line = input.readLine()) != null) {
                        statements.append(line);
                        statements.append(System.getProperty("line.separator"));
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            StringBuilder stringBuilder = statements;
            return stringBuilder;
        }
        finally {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("<< load, properties=" + String.valueOf(statements));
            }
        }
    }

    public StringBuilder getStatements() {
        return this.sbStatements;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Statements: ");
        sb.append((CharSequence)this.sbStatements);
        return sb.toString();
    }
}

