/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.codegen;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicStruct;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.StaticArray;
import org.web3j.abi.datatypes.StaticStruct;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.primitive.Byte;
import org.web3j.abi.datatypes.primitive.Char;
import org.web3j.abi.datatypes.primitive.Int;
import org.web3j.abi.datatypes.primitive.Short;
import org.web3j.codegen.GenerationReporter;
import org.web3j.codegen.Generator;
import org.web3j.codegen.LogGenerationReporter;
import org.web3j.codegen.SolidityFunctionWrapperGenerator;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.AbiDefinition;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.utils.Strings;
import org.web3j.utils.Version;

public class SolidityFunctionWrapper
extends Generator {
    private static final String BINARY = "BINARY";
    private static final String WEB3J = "web3j";
    private static final String CREDENTIALS = "credentials";
    private static final String CONTRACT_GAS_PROVIDER = "contractGasProvider";
    private static final String TRANSACTION_MANAGER = "transactionManager";
    private static final String INITIAL_VALUE = "initialWeiValue";
    private static final String CONTRACT_ADDRESS = "contractAddress";
    private static final String GAS_PRICE = "gasPrice";
    private static final String GAS_LIMIT = "gasLimit";
    private static final String FILTER = "filter";
    private static final String START_BLOCK = "startBlock";
    private static final String END_BLOCK = "endBlock";
    private static final String WEI_VALUE = "weiValue";
    private static final String FUNC_NAME_PREFIX = "FUNC_";
    private static final String TYPE_FUNCTION = "function";
    private static final String TYPE_EVENT = "event";
    private static final String TYPE_CONSTRUCTOR = "constructor";
    private static final ClassName LOG = ClassName.get(Log.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(SolidityFunctionWrapper.class);
    private static final String CODEGEN_WARNING = "<p>Auto generated code.\n<p><strong>Do not modify!</strong>\n<p>Please use the <a href=\"https://docs.web3j.io/command_line.html\">web3j command line tools</a>,\nor the " + SolidityFunctionWrapperGenerator.class.getName() + " in the \n<a href=\"https://github.com/web3j/web3j/tree/master/codegen\">codegen module</a> to update.\n";
    private final boolean useNativeJavaTypes;
    private final boolean useJavaPrimitiveTypes;
    private final boolean generateSendTxForCalls;
    private final int addressLength;
    private final HashMap<Integer, ClassName> structClassNameMap = new HashMap();
    private final List<AbiDefinition.NamedType> structsNamedTypeList = new ArrayList<AbiDefinition.NamedType>();
    private static final String regex = "(\\w+)(?:\\[(.*?)\\])(?:\\[(.*?)\\])?";
    private static final Pattern pattern = Pattern.compile("(\\w+)(?:\\[(.*?)\\])(?:\\[(.*?)\\])?");
    private final GenerationReporter reporter;

    public SolidityFunctionWrapper(boolean useNativeJavaTypes) {
        this(useNativeJavaTypes, 160);
    }

    public SolidityFunctionWrapper(boolean useNativeJavaTypes, int addressLength) {
        this(useNativeJavaTypes, false, false, addressLength);
    }

    public SolidityFunctionWrapper(boolean useNativeJavaTypes, int addressLength, boolean generateSendTxForCalls) {
        this(useNativeJavaTypes, generateSendTxForCalls, false, addressLength);
    }

    public SolidityFunctionWrapper(boolean useNativeJavaTypes, boolean useJavaPrimitiveTypes, boolean generateSendTxForCalls, int addressLength) {
        this(useNativeJavaTypes, useJavaPrimitiveTypes, generateSendTxForCalls, addressLength, new LogGenerationReporter(LOGGER));
    }

    public SolidityFunctionWrapper(boolean useNativeJavaTypes, boolean useJavaPrimitiveTypes, boolean generateSendTxForCalls, int addressLength, GenerationReporter reporter) {
        this.useNativeJavaTypes = useNativeJavaTypes;
        this.useJavaPrimitiveTypes = useJavaPrimitiveTypes;
        this.addressLength = addressLength;
        this.reporter = reporter;
        this.generateSendTxForCalls = generateSendTxForCalls;
    }

    public void generateJavaFiles(String contractName, String bin, List<AbiDefinition> abi, String destinationDir, String basePackageName, Map<String, String> addresses) throws IOException, ClassNotFoundException {
        this.generateJavaFiles(Contract.class, contractName, bin, abi, destinationDir, basePackageName, addresses);
    }

    public void generateJavaFiles(Class<? extends Contract> contractClass, String contractName, String bin, List<AbiDefinition> abi, String destinationDir, String basePackageName, Map<String, String> addresses) throws IOException, ClassNotFoundException {
        if (!Modifier.isAbstract(contractClass.getModifiers())) {
            throw new IllegalArgumentException("Contract base class must be abstract");
        }
        String className = Strings.capitaliseFirstLetter((String)contractName);
        TypeSpec.Builder classBuilder = this.createClassBuilder(contractClass, className, bin);
        classBuilder.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "\"rawtypes\"", new Object[0]).build());
        classBuilder.addMethod(SolidityFunctionWrapper.buildConstructor(Credentials.class, CREDENTIALS, false));
        classBuilder.addMethod(SolidityFunctionWrapper.buildConstructor(Credentials.class, CREDENTIALS, true));
        classBuilder.addMethod(SolidityFunctionWrapper.buildConstructor(TransactionManager.class, TRANSACTION_MANAGER, false));
        classBuilder.addMethod(SolidityFunctionWrapper.buildConstructor(TransactionManager.class, TRANSACTION_MANAGER, true));
        classBuilder.addFields(this.buildFuncNameConstants(abi));
        classBuilder.addTypes(this.buildStructTypes(abi));
        this.buildStructsNamedTypesList(abi);
        classBuilder.addMethods(this.buildFunctionDefinitions(className, classBuilder, abi));
        classBuilder.addMethod(SolidityFunctionWrapper.buildLoad(className, Credentials.class, CREDENTIALS, false));
        classBuilder.addMethod(SolidityFunctionWrapper.buildLoad(className, TransactionManager.class, TRANSACTION_MANAGER, false));
        classBuilder.addMethod(SolidityFunctionWrapper.buildLoad(className, Credentials.class, CREDENTIALS, true));
        classBuilder.addMethod(SolidityFunctionWrapper.buildLoad(className, TransactionManager.class, TRANSACTION_MANAGER, true));
        if (!bin.equals("Bin file was not provided")) {
            classBuilder.addMethods(this.buildDeployMethods(className, classBuilder, abi));
        }
        this.addAddressesSupport(classBuilder, addresses);
        this.write(basePackageName, classBuilder.build(), destinationDir);
    }

    private void buildStructsNamedTypesList(List<AbiDefinition> abi) {
        this.structsNamedTypeList.addAll(abi.stream().flatMap(definition -> {
            ArrayList parameters = new ArrayList();
            parameters.addAll(definition.getInputs());
            parameters.addAll(definition.getOutputs());
            return parameters.stream().filter(namedType -> namedType.getType().equals("tuple"));
        }).collect(Collectors.toList()));
    }

    private boolean isSameStruct(AbiDefinition.NamedType base, AbiDefinition.NamedType target) {
        for (AbiDefinition.NamedType baseField : base.getComponents()) {
            if (target.getComponents().stream().anyMatch(targetField -> baseField.getType().equals(targetField.getType()) && baseField.getName().equals(targetField.getName()))) continue;
            return false;
        }
        return true;
    }

    private void addAddressesSupport(TypeSpec.Builder classBuilder, Map<String, String> addresses) {
        if (addresses != null) {
            ClassName stringType = ClassName.get(String.class);
            ClassName mapType = ClassName.get(HashMap.class);
            ParameterizedTypeName mapStringString = ParameterizedTypeName.get((ClassName)mapType, (TypeName[])new TypeName[]{stringType, stringType});
            FieldSpec addressesStaticField = FieldSpec.builder((TypeName)mapStringString, (String)"_addresses", (javax.lang.model.element.Modifier[])new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PROTECTED, javax.lang.model.element.Modifier.STATIC, javax.lang.model.element.Modifier.FINAL}).build();
            classBuilder.addField(addressesStaticField);
            CodeBlock.Builder staticInit = CodeBlock.builder();
            staticInit.addStatement("_addresses = new HashMap<String, String>()", new Object[0]);
            addresses.forEach((k, v) -> staticInit.addStatement(String.format("_addresses.put(\"%1s\", \"%2s\")", k, v), new Object[0]));
            classBuilder.addStaticBlock(staticInit.build());
            MethodSpec getAddress = MethodSpec.methodBuilder((String)"getStaticDeployedAddress").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PROTECTED}).returns((TypeName)stringType).addParameter((TypeName)stringType, "networkId", new javax.lang.model.element.Modifier[0]).addCode(CodeBlock.builder().addStatement("return _addresses.get(networkId)", new Object[0]).build()).build();
            classBuilder.addMethod(getAddress);
            MethodSpec getPreviousAddress = MethodSpec.methodBuilder((String)"getPreviouslyDeployedAddress").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.STATIC}).returns((TypeName)stringType).addParameter((TypeName)stringType, "networkId", new javax.lang.model.element.Modifier[0]).addCode(CodeBlock.builder().addStatement("return _addresses.get(networkId)", new Object[0]).build()).build();
            classBuilder.addMethod(getPreviousAddress);
        }
    }

    private TypeSpec.Builder createClassBuilder(Class<? extends Contract> contractClass, String className, String binary) {
        String javadoc = CODEGEN_WARNING + this.getWeb3jVersion();
        return TypeSpec.classBuilder((String)className).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addJavadoc(javadoc, new Object[0]).superclass(contractClass).addField(this.createBinaryDefinition(binary));
    }

    private String getWeb3jVersion() {
        String version;
        try {
            version = Version.getVersion();
        }
        catch (IOException | NullPointerException e) {
            version = "none";
        }
        return "\n<p>Generated with web3j version " + version + ".\n";
    }

    private FieldSpec createBinaryDefinition(String binary) {
        return FieldSpec.builder(String.class, (String)BINARY, (javax.lang.model.element.Modifier[])new javax.lang.model.element.Modifier[0]).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.FINAL, javax.lang.model.element.Modifier.STATIC}).initializer("$S", new Object[]{binary}).build();
    }

    private FieldSpec createEventDefinition(String name, List<NamedTypeName> parameters) {
        CodeBlock initializer = SolidityFunctionWrapper.buildVariableLengthEventInitializer(name, parameters);
        return FieldSpec.builder(Event.class, (String)this.buildEventDefinitionName(name), (javax.lang.model.element.Modifier[])new javax.lang.model.element.Modifier[0]).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC, javax.lang.model.element.Modifier.FINAL}).initializer(initializer).build();
    }

    private String buildEventDefinitionName(String eventName) {
        return eventName.toUpperCase() + "_EVENT";
    }

    private List<MethodSpec> buildFunctionDefinitions(String className, TypeSpec.Builder classBuilder, List<AbiDefinition> functionDefinitions) throws ClassNotFoundException {
        Set<String> duplicateFunctionNames = this.getDuplicateFunctionNames(functionDefinitions);
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        for (AbiDefinition functionDefinition : functionDefinitions) {
            if (functionDefinition.getType().equals(TYPE_FUNCTION)) {
                String functionName = SolidityFunctionWrapper.funcNameToConst(functionDefinition.getName(), true);
                boolean useUpperCase = !duplicateFunctionNames.contains(functionName);
                methodSpecs.addAll(this.buildFunctions(functionDefinition, useUpperCase));
                continue;
            }
            if (!functionDefinition.getType().equals(TYPE_EVENT)) continue;
            methodSpecs.addAll(this.buildEventFunctions(functionDefinition, classBuilder));
        }
        return methodSpecs;
    }

    private List<TypeSpec> buildStructTypes(List<AbiDefinition> functionDefinitions) throws ClassNotFoundException {
        List<AbiDefinition.NamedType> orderedKeys = this.extractStructs(functionDefinitions);
        int structCounter = 0;
        ArrayList<TypeSpec> structs = new ArrayList<TypeSpec>();
        for (AbiDefinition.NamedType namedType : orderedKeys) {
            String internalType = namedType.getInternalType();
            String structName = internalType == null || internalType.isEmpty() ? "Struct" + structCounter : internalType.substring(internalType.lastIndexOf(".") + 1);
            TypeSpec.Builder builder = TypeSpec.classBuilder((String)structName).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC});
            MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addStatement("super(" + this.buildStructConstructorParameterDefinition(namedType.getComponents(), this.useNativeJavaTypes) + ")", new Object[0]);
            MethodSpec.Builder nativeConstructorBuilder = MethodSpec.constructorBuilder().addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addStatement("super(" + this.buildStructConstructorParameterDefinition(namedType.getComponents(), false) + ")", new Object[0]);
            for (AbiDefinition.NamedType component2 : namedType.getComponents()) {
                if (component2.getType().equals("tuple")) {
                    ClassName typeName = this.structClassNameMap.get(component2.structIdentifier());
                    builder.addField((TypeName)typeName, component2.getName(), new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC});
                    constructorBuilder.addParameter((TypeName)typeName, component2.getName(), new javax.lang.model.element.Modifier[0]);
                    nativeConstructorBuilder.addParameter((TypeName)typeName, component2.getName(), new javax.lang.model.element.Modifier[0]);
                } else {
                    TypeName nativeTypeName = SolidityFunctionWrapper.buildTypeName(component2.getType(), this.useJavaPrimitiveTypes);
                    TypeName wrappedTypeName = this.getWrapperType(nativeTypeName);
                    builder.addField(wrappedTypeName, component2.getName(), new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC});
                    constructorBuilder.addParameter(wrappedTypeName, component2.getName(), new javax.lang.model.element.Modifier[0]);
                    nativeConstructorBuilder.addParameter(nativeTypeName, component2.getName(), new javax.lang.model.element.Modifier[0]);
                }
                constructorBuilder.addStatement("this." + component2.getName() + " = " + component2.getName(), new Object[0]);
                nativeConstructorBuilder.addStatement("this." + component2.getName() + " = " + component2.getName() + (this.useNativeJavaTypes && this.structClassNameMap.keySet().stream().noneMatch(i -> i.intValue() == component2.structIdentifier()) ? ".getValue()" : ""), new Object[0]);
            }
            builder.superclass(namedType.isDynamic() ? DynamicStruct.class : StaticStruct.class);
            builder.addMethod(constructorBuilder.build());
            if (this.useNativeJavaTypes && !namedType.getComponents().isEmpty() && namedType.getComponents().stream().anyMatch(component -> this.structClassNameMap.keySet().stream().noneMatch(i -> i.intValue() == component.structIdentifier()))) {
                builder.addMethod(nativeConstructorBuilder.build());
            }
            this.structClassNameMap.put(namedType.structIdentifier(), ClassName.get((String)"", (String)structName, (String[])new String[0]));
            structs.add(builder.build());
            ++structCounter;
        }
        return structs;
    }

    private AbiDefinition.NamedType normalizeNamedType(AbiDefinition.NamedType namedType) {
        if (namedType.getType().endsWith("[]") && namedType.getInternalType().endsWith("[]")) {
            return new AbiDefinition.NamedType(namedType.getName(), namedType.getType().substring(0, namedType.getType().length() - 2), namedType.getComponents(), namedType.getInternalType().substring(0, namedType.getInternalType().length() - 2), namedType.isIndexed());
        }
        return namedType;
    }

    @NotNull
    private List<AbiDefinition.NamedType> extractStructs(List<AbiDefinition> functionDefinitions) {
        LinkedHashMap structMap = new LinkedHashMap();
        functionDefinitions.stream().flatMap(definition -> {
            ArrayList parameters = new ArrayList();
            parameters.addAll(definition.getInputs());
            parameters.addAll(definition.getOutputs());
            return parameters.stream().map(this::normalizeNamedType).filter(namedType -> namedType.getType().equals("tuple"));
        }).forEach(namedType -> {
            structMap.put(namedType.structIdentifier(), namedType);
            this.extractNested((AbiDefinition.NamedType)namedType).stream().filter(nestedNamedStruct -> nestedNamedStruct.getType().equals("tuple")).forEach(nestedNamedType -> structMap.put(nestedNamedType.structIdentifier(), nestedNamedType));
        });
        return ((HashMap)structMap).values().stream().sorted(Comparator.comparingInt(AbiDefinition.NamedType::nestedness)).collect(Collectors.toList());
    }

    private String buildStructConstructorParameterDefinition(List<AbiDefinition.NamedType> components, boolean useNativeJavaTypes) throws ClassNotFoundException {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < components.size(); ++i) {
            AbiDefinition.NamedType component = components.get(i);
            stringBuilder.append(i > 0 ? "," : "");
            stringBuilder.append(!component.getType().equals("tuple") && useNativeJavaTypes ? "new " + SolidityFunctionWrapper.buildTypeName(component.getType(), false) + "(" : "");
            stringBuilder.append(component.getType().equals("tuple") ? component.getName() : (useNativeJavaTypes ? component.getName() + ")" : component.getName()));
        }
        return stringBuilder.toString();
    }

    private Collection<? extends AbiDefinition.NamedType> extractNested(AbiDefinition.NamedType namedType) {
        if (namedType.getComponents().size() == 0) {
            return new ArrayList();
        }
        ArrayList nestedStructs = new ArrayList();
        namedType.getComponents().forEach(nestedNamedStruct -> {
            nestedStructs.add(nestedNamedStruct);
            nestedStructs.addAll(this.extractNested((AbiDefinition.NamedType)nestedNamedStruct));
        });
        return nestedStructs;
    }

    private Set<String> getDuplicateFunctionNames(List<AbiDefinition> functionDefinitions) {
        HashSet<String> duplicateNames = new HashSet<String>();
        HashSet<String> functionNames = new HashSet<String>();
        for (AbiDefinition functionDefinition : functionDefinitions) {
            String functionName;
            if (functionDefinition.getName() == null || !TYPE_FUNCTION.equals(functionDefinition.getType()) || functionNames.add(functionName = SolidityFunctionWrapper.funcNameToConst(functionDefinition.getName(), true))) continue;
            duplicateNames.add(functionName);
        }
        return duplicateNames;
    }

    List<MethodSpec> buildDeployMethods(String className, TypeSpec.Builder classBuilder, List<AbiDefinition> functionDefinitions) throws ClassNotFoundException {
        boolean constructor = false;
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        for (AbiDefinition functionDefinition : functionDefinitions) {
            if (!functionDefinition.getType().equals(TYPE_CONSTRUCTOR)) continue;
            constructor = true;
            methodSpecs.add(this.buildDeploy(className, functionDefinition, Credentials.class, CREDENTIALS, true));
            methodSpecs.add(this.buildDeploy(className, functionDefinition, TransactionManager.class, TRANSACTION_MANAGER, true));
            methodSpecs.add(this.buildDeploy(className, functionDefinition, Credentials.class, CREDENTIALS, false));
            methodSpecs.add(this.buildDeploy(className, functionDefinition, TransactionManager.class, TRANSACTION_MANAGER, false));
        }
        if (!constructor) {
            MethodSpec.Builder credentialsMethodBuilder = SolidityFunctionWrapper.getDeployMethodSpec(className, Credentials.class, CREDENTIALS, false, true);
            methodSpecs.add(SolidityFunctionWrapper.buildDeployNoParams(credentialsMethodBuilder, className, CREDENTIALS, false, true));
            MethodSpec.Builder credentialsMethodBuilderNoGasProvider = SolidityFunctionWrapper.getDeployMethodSpec(className, Credentials.class, CREDENTIALS, false, false);
            methodSpecs.add(SolidityFunctionWrapper.buildDeployNoParams(credentialsMethodBuilderNoGasProvider, className, CREDENTIALS, false, false));
            MethodSpec.Builder transactionManagerMethodBuilder = SolidityFunctionWrapper.getDeployMethodSpec(className, TransactionManager.class, TRANSACTION_MANAGER, false, true);
            methodSpecs.add(SolidityFunctionWrapper.buildDeployNoParams(transactionManagerMethodBuilder, className, TRANSACTION_MANAGER, false, true));
            MethodSpec.Builder transactionManagerMethodBuilderNoGasProvider = SolidityFunctionWrapper.getDeployMethodSpec(className, TransactionManager.class, TRANSACTION_MANAGER, false, false);
            methodSpecs.add(SolidityFunctionWrapper.buildDeployNoParams(transactionManagerMethodBuilderNoGasProvider, className, TRANSACTION_MANAGER, false, false));
        }
        return methodSpecs;
    }

    Iterable<FieldSpec> buildFuncNameConstants(List<AbiDefinition> functionDefinitions) {
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        HashSet<String> fieldNames = new HashSet<String>();
        fieldNames.add("deploy");
        Set<String> duplicateFunctionNames = this.getDuplicateFunctionNames(functionDefinitions);
        if (!duplicateFunctionNames.isEmpty()) {
            System.out.println("\nWarning: Duplicate field(s) found: " + duplicateFunctionNames + ". Please don't use names which will be the same in uppercase.");
        }
        for (AbiDefinition functionDefinition : functionDefinitions) {
            String funcName;
            if (!functionDefinition.getType().equals(TYPE_FUNCTION) || fieldNames.contains(funcName = functionDefinition.getName())) continue;
            boolean useUpperCase = !duplicateFunctionNames.contains(SolidityFunctionWrapper.funcNameToConst(funcName, true));
            FieldSpec field = FieldSpec.builder(String.class, (String)SolidityFunctionWrapper.funcNameToConst(funcName, useUpperCase), (javax.lang.model.element.Modifier[])new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC, javax.lang.model.element.Modifier.FINAL}).initializer("$S", new Object[]{funcName}).build();
            fields.add(field);
            fieldNames.add(funcName);
        }
        return fields;
    }

    private static MethodSpec buildConstructor(Class authType, String authName, boolean withGasProvider) {
        MethodSpec.Builder toReturn = MethodSpec.constructorBuilder().addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PROTECTED}).addParameter(String.class, CONTRACT_ADDRESS, new javax.lang.model.element.Modifier[0]).addParameter(Web3j.class, WEB3J, new javax.lang.model.element.Modifier[0]).addParameter((Type)authType, authName, new javax.lang.model.element.Modifier[0]);
        if (withGasProvider) {
            toReturn.addParameter(ContractGasProvider.class, CONTRACT_GAS_PROVIDER, new javax.lang.model.element.Modifier[0]).addStatement("super($N, $N, $N, $N, $N)", new Object[]{BINARY, CONTRACT_ADDRESS, WEB3J, authName, CONTRACT_GAS_PROVIDER});
        } else {
            toReturn.addParameter(BigInteger.class, GAS_PRICE, new javax.lang.model.element.Modifier[0]).addParameter(BigInteger.class, GAS_LIMIT, new javax.lang.model.element.Modifier[0]).addStatement("super($N, $N, $N, $N, $N, $N)", new Object[]{BINARY, CONTRACT_ADDRESS, WEB3J, authName, GAS_PRICE, GAS_LIMIT}).addAnnotation(Deprecated.class);
        }
        return toReturn.build();
    }

    private MethodSpec buildDeploy(String className, AbiDefinition functionDefinition, Class authType, String authName, boolean withGasProvider) throws ClassNotFoundException {
        boolean isPayable = functionDefinition.isPayable();
        MethodSpec.Builder methodBuilder = SolidityFunctionWrapper.getDeployMethodSpec(className, authType, authName, isPayable, withGasProvider);
        String inputParams = this.addParameters(methodBuilder, functionDefinition.getInputs());
        if (!inputParams.isEmpty()) {
            return SolidityFunctionWrapper.buildDeployWithParams(methodBuilder, className, inputParams, authName, isPayable, withGasProvider);
        }
        return SolidityFunctionWrapper.buildDeployNoParams(methodBuilder, className, authName, isPayable, withGasProvider);
    }

    private static MethodSpec buildDeployWithParams(MethodSpec.Builder methodBuilder, String className, String inputParams, String authName, boolean isPayable, boolean withGasProvider) {
        methodBuilder.addStatement("$T encodedConstructor = $T.encodeConstructor($T.<$T>asList($L))", new Object[]{String.class, FunctionEncoder.class, Arrays.class, org.web3j.abi.datatypes.Type.class, inputParams});
        if (isPayable && !withGasProvider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, $L, encodedConstructor, $L)", new Object[]{className, WEB3J, authName, GAS_PRICE, GAS_LIMIT, BINARY, INITIAL_VALUE});
            methodBuilder.addAnnotation(Deprecated.class);
        } else if (isPayable && withGasProvider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, encodedConstructor, $L)", new Object[]{className, WEB3J, authName, CONTRACT_GAS_PROVIDER, BINARY, INITIAL_VALUE});
        } else if (!isPayable && !withGasProvider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, $L, encodedConstructor)", new Object[]{className, WEB3J, authName, GAS_PRICE, GAS_LIMIT, BINARY});
            methodBuilder.addAnnotation(Deprecated.class);
        } else {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, encodedConstructor)", new Object[]{className, WEB3J, authName, CONTRACT_GAS_PROVIDER, BINARY});
        }
        return methodBuilder.build();
    }

    private static MethodSpec buildDeployNoParams(MethodSpec.Builder methodBuilder, String className, String authName, boolean isPayable, boolean withGasPRovider) {
        if (isPayable && !withGasPRovider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, $L, \"\", $L)", new Object[]{className, WEB3J, authName, GAS_PRICE, GAS_LIMIT, BINARY, INITIAL_VALUE});
            methodBuilder.addAnnotation(Deprecated.class);
        } else if (isPayable && withGasPRovider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, \"\", $L)", new Object[]{className, WEB3J, authName, CONTRACT_GAS_PROVIDER, BINARY, INITIAL_VALUE});
        } else if (!isPayable && !withGasPRovider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, $L, \"\")", new Object[]{className, WEB3J, authName, GAS_PRICE, GAS_LIMIT, BINARY});
            methodBuilder.addAnnotation(Deprecated.class);
        } else {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, \"\")", new Object[]{className, WEB3J, authName, CONTRACT_GAS_PROVIDER, BINARY});
        }
        return methodBuilder.build();
    }

    private static MethodSpec.Builder getDeployMethodSpec(String className, Class authType, String authName, boolean isPayable, boolean withGasProvider) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"deploy").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC}).returns((TypeName)SolidityFunctionWrapper.buildRemoteCall((TypeName)TypeVariableName.get((String)className, (Type[])new Type[]{org.web3j.abi.datatypes.Type.class}))).addParameter(Web3j.class, WEB3J, new javax.lang.model.element.Modifier[0]).addParameter((Type)authType, authName, new javax.lang.model.element.Modifier[0]);
        if (isPayable && !withGasProvider) {
            return builder.addParameter(BigInteger.class, GAS_PRICE, new javax.lang.model.element.Modifier[0]).addParameter(BigInteger.class, GAS_LIMIT, new javax.lang.model.element.Modifier[0]).addParameter(BigInteger.class, INITIAL_VALUE, new javax.lang.model.element.Modifier[0]);
        }
        if (isPayable && withGasProvider) {
            return builder.addParameter(ContractGasProvider.class, CONTRACT_GAS_PROVIDER, new javax.lang.model.element.Modifier[0]).addParameter(BigInteger.class, INITIAL_VALUE, new javax.lang.model.element.Modifier[0]);
        }
        if (!isPayable && withGasProvider) {
            return builder.addParameter(ContractGasProvider.class, CONTRACT_GAS_PROVIDER, new javax.lang.model.element.Modifier[0]);
        }
        return builder.addParameter(BigInteger.class, GAS_PRICE, new javax.lang.model.element.Modifier[0]).addParameter(BigInteger.class, GAS_LIMIT, new javax.lang.model.element.Modifier[0]);
    }

    private static MethodSpec buildLoad(String className, Class authType, String authName, boolean withGasProvider) {
        MethodSpec.Builder toReturn = MethodSpec.methodBuilder((String)"load").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC}).returns((TypeName)TypeVariableName.get((String)className, (Type[])new Type[]{org.web3j.abi.datatypes.Type.class})).addParameter(String.class, CONTRACT_ADDRESS, new javax.lang.model.element.Modifier[0]).addParameter(Web3j.class, WEB3J, new javax.lang.model.element.Modifier[0]).addParameter((Type)authType, authName, new javax.lang.model.element.Modifier[0]);
        if (withGasProvider) {
            toReturn.addParameter(ContractGasProvider.class, CONTRACT_GAS_PROVIDER, new javax.lang.model.element.Modifier[0]).addStatement("return new $L($L, $L, $L, $L)", new Object[]{className, CONTRACT_ADDRESS, WEB3J, authName, CONTRACT_GAS_PROVIDER});
        } else {
            toReturn.addParameter(BigInteger.class, GAS_PRICE, new javax.lang.model.element.Modifier[0]).addParameter(BigInteger.class, GAS_LIMIT, new javax.lang.model.element.Modifier[0]).addStatement("return new $L($L, $L, $L, $L, $L)", new Object[]{className, CONTRACT_ADDRESS, WEB3J, authName, GAS_PRICE, GAS_LIMIT}).addAnnotation(Deprecated.class);
        }
        return toReturn.build();
    }

    String addParameters(MethodSpec.Builder methodBuilder, List<AbiDefinition.NamedType> namedTypes) throws ClassNotFoundException {
        List<ParameterSpec> inputParameterTypes = this.buildParameterTypes(namedTypes, this.useJavaPrimitiveTypes);
        ArrayList<ParameterSpec> nativeInputParameterTypes = new ArrayList<ParameterSpec>(inputParameterTypes.size());
        for (int i = 0; i < inputParameterTypes.size(); ++i) {
            TypeName typeName = namedTypes.get(i).getType().equals("tuple") ? (TypeName)this.structClassNameMap.get(namedTypes.get(i).structIdentifier()) : (namedTypes.get(i).getType().startsWith("tuple") && namedTypes.get(i).getType().contains("[") ? this.buildStructArrayTypeName(namedTypes.get(i), true) : this.getWrapperType(inputParameterTypes.get((int)i).type));
            nativeInputParameterTypes.add(ParameterSpec.builder((TypeName)typeName, (String)inputParameterTypes.get((int)i).name, (javax.lang.model.element.Modifier[])new javax.lang.model.element.Modifier[0]).build());
        }
        methodBuilder.addParameters(nativeInputParameterTypes);
        if (this.useNativeJavaTypes) {
            return org.web3j.utils.Collection.join(inputParameterTypes, (String)", \n", this::createMappedParameterTypes);
        }
        return org.web3j.utils.Collection.join(inputParameterTypes, (String)", ", parameterSpec -> parameterSpec.name);
    }

    private String createMappedParameterTypes(ParameterSpec parameterSpec) {
        if (parameterSpec.type instanceof ParameterizedTypeName) {
            List typeNames = ((ParameterizedTypeName)parameterSpec.type).typeArguments;
            if (typeNames.size() != 1) {
                throw new UnsupportedOperationException("Only a single parameterized type is supported");
            }
            if (this.structClassNameMap.values().stream().map(ClassName::simpleName).anyMatch(name -> name.equals(((ClassName)((ParameterizedTypeName)parameterSpec.type).typeArguments.get(0)).simpleName()))) {
                String structName = (String)this.structClassNameMap.values().stream().map(ClassName::simpleName).filter(name -> name.equals(((ClassName)((ParameterizedTypeName)parameterSpec.type).typeArguments.get(0)).simpleName())).collect(Collectors.toList()).get(0);
                return "new " + parameterSpec.type + "(" + structName + ".class, " + parameterSpec.name + ")";
            }
            String parameterSpecType = parameterSpec.type.toString();
            TypeName typeName = (TypeName)typeNames.get(0);
            String typeMapInput = typeName + ".class";
            String componentType = typeName.toString();
            if (typeName instanceof ParameterizedTypeName) {
                List typeArguments = ((ParameterizedTypeName)typeName).typeArguments;
                if (typeArguments.size() != 1) {
                    throw new UnsupportedOperationException("Only a single parameterized type is supported");
                }
                TypeName innerTypeName = (TypeName)typeArguments.get(0);
                componentType = ((ParameterizedTypeName)typeName).rawType.toString();
                parameterSpecType = ((ParameterizedTypeName)parameterSpec.type).rawType + "<" + componentType + ">";
                typeMapInput = componentType + ".class,\n" + innerTypeName + ".class";
            }
            return "new " + parameterSpecType + "(\n        " + componentType + ".class,\n        org.web3j.abi.Utils.typeMap(" + parameterSpec.name + ", " + typeMapInput + "))";
        }
        if (this.structClassNameMap.values().stream().map(ClassName::simpleName).noneMatch(name -> name.equals(parameterSpec.type.toString()))) {
            String constructor = "new " + parameterSpec.type + "(";
            if (Address.class.getCanonicalName().equals(parameterSpec.type.toString()) && this.addressLength != 160) {
                constructor = constructor + this.addressLength * 8 + ", ";
            }
            return constructor + parameterSpec.name + ")";
        }
        return parameterSpec.name;
    }

    private TypeName getWrapperType(TypeName typeName) {
        if (this.useNativeJavaTypes) {
            return SolidityFunctionWrapper.getNativeType(typeName);
        }
        return typeName;
    }

    private TypeName getWrapperRawType(TypeName typeName) {
        if (this.useNativeJavaTypes) {
            if (typeName instanceof ParameterizedTypeName) {
                return ClassName.get(List.class);
            }
            return SolidityFunctionWrapper.getNativeType(typeName);
        }
        return typeName;
    }

    private TypeName getIndexedEventWrapperType(TypeName typeName) {
        if (this.useNativeJavaTypes) {
            return SolidityFunctionWrapper.getEventNativeType(typeName);
        }
        return typeName;
    }

    static TypeName getNativeType(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            return SolidityFunctionWrapper.getNativeType((ParameterizedTypeName)typeName);
        }
        String simpleName = ((ClassName)typeName).simpleName();
        if (simpleName.equals(Address.class.getSimpleName())) {
            return TypeName.get(String.class);
        }
        if (simpleName.startsWith("Uint")) {
            return TypeName.get(BigInteger.class);
        }
        if (simpleName.equals(Utf8String.class.getSimpleName())) {
            return TypeName.get(String.class);
        }
        if (simpleName.startsWith("Bytes") || simpleName.equals("DynamicBytes")) {
            return TypeName.get(byte[].class);
        }
        if (simpleName.startsWith("Bool")) {
            return TypeName.get(Boolean.class);
        }
        if (simpleName.equals(Byte.class.getSimpleName())) {
            return TypeName.get(java.lang.Byte.class);
        }
        if (simpleName.equals(Char.class.getSimpleName())) {
            return TypeName.get(Character.class);
        }
        if (simpleName.equals(org.web3j.abi.datatypes.primitive.Double.class.getSimpleName())) {
            return TypeName.get(Double.class);
        }
        if (simpleName.equals(org.web3j.abi.datatypes.primitive.Float.class.getSimpleName())) {
            return TypeName.get(Float.class);
        }
        if (simpleName.equals(Int.class.getSimpleName())) {
            return TypeName.get(Integer.class);
        }
        if (simpleName.equals(org.web3j.abi.datatypes.primitive.Long.class.getSimpleName())) {
            return TypeName.get(Long.class);
        }
        if (simpleName.equals(Short.class.getSimpleName())) {
            return TypeName.get(java.lang.Short.class);
        }
        if (simpleName.startsWith("Int")) {
            return TypeName.get(BigInteger.class);
        }
        throw new UnsupportedOperationException("Unsupported type: " + typeName + ", no native type mapping exists.");
    }

    static TypeName getNativeType(ParameterizedTypeName parameterizedTypeName) {
        List typeNames = parameterizedTypeName.typeArguments;
        ArrayList<TypeName> nativeTypeNames = new ArrayList<TypeName>(typeNames.size());
        for (TypeName enclosedTypeName : typeNames) {
            nativeTypeNames.add(SolidityFunctionWrapper.getNativeType(enclosedTypeName));
        }
        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])nativeTypeNames.toArray(new TypeName[nativeTypeNames.size()]));
    }

    static TypeName getEventNativeType(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            return TypeName.get(byte[].class);
        }
        String simpleName = ((ClassName)typeName).simpleName();
        if (simpleName.equals(Utf8String.class.getSimpleName())) {
            return TypeName.get(byte[].class);
        }
        return SolidityFunctionWrapper.getNativeType(typeName);
    }

    private List<ParameterSpec> buildParameterTypes(List<AbiDefinition.NamedType> namedTypes, boolean primitives) throws ClassNotFoundException {
        ArrayList<ParameterSpec> result = new ArrayList<ParameterSpec>(namedTypes.size());
        for (int i = 0; i < namedTypes.size(); ++i) {
            AbiDefinition.NamedType namedType = namedTypes.get(i);
            String name = SolidityFunctionWrapper.createValidParamName(namedType.getName(), i);
            String type = namedTypes.get(i).getType();
            if (type.equals("tuple")) {
                result.add(ParameterSpec.builder((TypeName)((TypeName)this.structClassNameMap.get(namedType.structIdentifier())), (String)name, (javax.lang.model.element.Modifier[])new javax.lang.model.element.Modifier[0]).build());
                continue;
            }
            if (type.startsWith("tuple") && type.contains("[")) {
                result.add(ParameterSpec.builder((TypeName)this.buildStructArrayTypeName(namedType, primitives), (String)name, (javax.lang.model.element.Modifier[])new javax.lang.model.element.Modifier[0]).build());
                continue;
            }
            result.add(ParameterSpec.builder((TypeName)SolidityFunctionWrapper.buildTypeName(type, primitives), (String)name, (javax.lang.model.element.Modifier[])new javax.lang.model.element.Modifier[0]).build());
        }
        return result;
    }

    static String createValidParamName(String name, int idx) {
        if (name == null || name.equals("")) {
            return "param" + idx;
        }
        return name;
    }

    private List<TypeName> buildTypeNames(List<AbiDefinition.NamedType> namedTypes, boolean primitives) throws ClassNotFoundException {
        ArrayList<TypeName> result = new ArrayList<TypeName>(namedTypes.size());
        for (AbiDefinition.NamedType namedType : namedTypes) {
            if (namedType.getType().equals("tuple")) {
                result.add((TypeName)this.structClassNameMap.get(namedType.structIdentifier()));
                continue;
            }
            if (namedType.getType().startsWith("tuple") && namedType.getType().contains("[")) {
                result.add(this.buildStructArrayTypeName(namedType, primitives));
                continue;
            }
            result.add(SolidityFunctionWrapper.buildTypeName(namedType.getType(), primitives));
        }
        return result;
    }

    private TypeName buildStructArrayTypeName(AbiDefinition.NamedType namedType, Boolean useNativeJavaTypes) {
        String structName = namedType.getInternalType().isEmpty() ? this.structClassNameMap.get(((AbiDefinition.NamedType)this.structsNamedTypeList.stream().filter(struct -> this.isSameStruct(namedType, (AbiDefinition.NamedType)struct)).collect(Collectors.toList()).get(0)).structIdentifier()).simpleName() : namedType.getInternalType().substring(namedType.getInternalType().lastIndexOf(".") + 1, namedType.getInternalType().indexOf("["));
        if (useNativeJavaTypes.booleanValue()) {
            return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)structName, (String[])new String[0])});
        }
        String arrayLength = namedType.getType().substring(namedType.getType().indexOf(91) + 1, namedType.getType().indexOf(93));
        if (!arrayLength.isEmpty() && Integer.parseInt(arrayLength) > 0) {
            return ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.web3j.abi.datatypes.generated", (String)("StaticArray" + arrayLength), (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)structName, (String[])new String[0])});
        }
        return ParameterizedTypeName.get((ClassName)ClassName.get(DynamicArray.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)structName, (String[])new String[0])});
    }

    MethodSpec buildFunction(AbiDefinition functionDefinition) throws ClassNotFoundException {
        return this.buildFunction(functionDefinition, true);
    }

    MethodSpec buildFunction(AbiDefinition functionDefinition, boolean useUpperCase) throws ClassNotFoundException {
        return this.buildFunctions(functionDefinition, useUpperCase).get(0);
    }

    List<MethodSpec> buildFunctions(AbiDefinition functionDefinition) throws ClassNotFoundException {
        return this.buildFunctions(functionDefinition, true);
    }

    List<MethodSpec> buildFunctions(AbiDefinition functionDefinition, boolean useUpperCase) throws ClassNotFoundException {
        boolean isFunctionDefinitionConstant;
        ArrayList<MethodSpec> results = new ArrayList<MethodSpec>(2);
        String functionName = functionDefinition.getName();
        String stateMutability = functionDefinition.getStateMutability();
        boolean pureOrView = "pure".equals(stateMutability) || "view".equals(stateMutability);
        boolean bl = isFunctionDefinitionConstant = functionDefinition.isConstant() || pureOrView;
        if (this.generateSendTxForCalls) {
            String funcNamePrefix = isFunctionDefinitionConstant ? "call" : "send";
            functionName = funcNamePrefix + "_" + functionName;
        } else if (!SourceVersion.isName(functionName)) {
            functionName = "_" + functionName;
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)functionName).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC});
        String inputParams = this.addParameters(methodBuilder, functionDefinition.getInputs());
        List<TypeName> outputParameterTypes = this.buildTypeNames(functionDefinition.getOutputs(), this.useJavaPrimitiveTypes);
        if (isFunctionDefinitionConstant) {
            if (functionDefinition.hasOutputs()) {
                this.buildConstantFunction(functionDefinition, methodBuilder, outputParameterTypes, inputParams, useUpperCase);
                results.add(methodBuilder.build());
            }
            if (this.generateSendTxForCalls) {
                AbiDefinition sendFuncDefinition = new AbiDefinition(functionDefinition);
                sendFuncDefinition.setConstant(false);
                results.addAll(this.buildFunctions(sendFuncDefinition));
            }
        }
        if (!isFunctionDefinitionConstant) {
            this.buildTransactionFunction(functionDefinition, methodBuilder, inputParams, useUpperCase);
            results.add(methodBuilder.build());
        }
        return results;
    }

    private void buildConstantFunction(AbiDefinition functionDefinition, MethodSpec.Builder methodBuilder, List<TypeName> outputParameterTypes, String inputParams, boolean useUpperCase) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        if (outputParameterTypes.isEmpty()) {
            methodBuilder.addStatement("throw new RuntimeException(\"cannot call constant function with void return type\")", new Object[0]);
        } else if (outputParameterTypes.size() == 1) {
            TypeName typeName = outputParameterTypes.get(0);
            Object nativeReturnTypeName = ((AbiDefinition.NamedType)functionDefinition.getOutputs().get(0)).getType().equals("tuple") ? (TypeName)this.structClassNameMap.get(((AbiDefinition.NamedType)functionDefinition.getOutputs().get(0)).structIdentifier()) : (((AbiDefinition.NamedType)functionDefinition.getOutputs().get(0)).getType().startsWith("tuple") && ((AbiDefinition.NamedType)functionDefinition.getOutputs().get(0)).getType().contains("[") ? ClassName.get(List.class) : (this.useNativeJavaTypes ? this.getWrapperRawType(typeName) : this.getWrapperType(typeName)));
            methodBuilder.returns((TypeName)SolidityFunctionWrapper.buildRemoteFunctionCall(nativeReturnTypeName));
            methodBuilder.addStatement("final $T function = new $T($N, \n$T.<$T>asList($L), \n$T.<$T<?>>asList(new $T<$T>() {}))", new Object[]{org.web3j.abi.datatypes.Function.class, org.web3j.abi.datatypes.Function.class, SolidityFunctionWrapper.funcNameToConst(functionName, useUpperCase), Arrays.class, org.web3j.abi.datatypes.Type.class, inputParams, Arrays.class, TypeReference.class, TypeReference.class, typeName});
            if (this.useNativeJavaTypes) {
                if (nativeReturnTypeName.equals((Object)ClassName.get(List.class))) {
                    ParameterizedTypeName listType = ParameterizedTypeName.get(List.class, (Type[])new Type[]{org.web3j.abi.datatypes.Type.class});
                    CodeBlock.Builder callCode = CodeBlock.builder();
                    callCode.addStatement("$T result = ($T) executeCallSingleValueReturn(function, $T.class)", new Object[]{listType, listType, nativeReturnTypeName});
                    callCode.addStatement("return convertToNative(result)", new Object[0]);
                    TypeSpec callableType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Callable.class), (TypeName[])new TypeName[]{nativeReturnTypeName})).addMethod(MethodSpec.methodBuilder((String)"call").addAnnotation(Override.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addException(Exception.class).returns(nativeReturnTypeName).addCode(callCode.build()).build()).build();
                    methodBuilder.addStatement("return new $T(function,\n$L)", new Object[]{SolidityFunctionWrapper.buildRemoteFunctionCall(nativeReturnTypeName), callableType});
                } else {
                    methodBuilder.addStatement("return executeRemoteCallSingleValueReturn(function, $T.class)", new Object[]{nativeReturnTypeName});
                }
            } else {
                methodBuilder.addStatement("return executeRemoteCallSingleValueReturn(function)", new Object[0]);
            }
        } else {
            ArrayList<Object> returnTypes = new ArrayList<Object>();
            for (int i = 0; i < functionDefinition.getOutputs().size(); ++i) {
                if (((AbiDefinition.NamedType)functionDefinition.getOutputs().get(i)).getType().equals("tuple")) {
                    returnTypes.add(this.structClassNameMap.get(((AbiDefinition.NamedType)functionDefinition.getOutputs().get(i)).structIdentifier()));
                    continue;
                }
                if (((AbiDefinition.NamedType)functionDefinition.getOutputs().get(i)).getType().startsWith("tuple") && ((AbiDefinition.NamedType)functionDefinition.getOutputs().get(i)).getType().contains("[")) {
                    returnTypes.add(this.buildStructArrayTypeName((AbiDefinition.NamedType)functionDefinition.getOutputs().get(i), true));
                    continue;
                }
                returnTypes.add(this.getWrapperType(outputParameterTypes.get(i)));
            }
            ParameterizedTypeName parameterizedTupleType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.web3j.tuples.generated", (String)("Tuple" + returnTypes.size()), (String[])new String[0]), (TypeName[])returnTypes.toArray(new TypeName[0]));
            methodBuilder.returns((TypeName)SolidityFunctionWrapper.buildRemoteFunctionCall((TypeName)parameterizedTupleType));
            SolidityFunctionWrapper.buildVariableLengthReturnFunctionConstructor(methodBuilder, functionName, inputParams, outputParameterTypes, useUpperCase);
            this.buildTupleResultContainer(methodBuilder, parameterizedTupleType, outputParameterTypes);
        }
    }

    private static ParameterizedTypeName buildRemoteCall(TypeName typeName) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(RemoteCall.class), (TypeName[])new TypeName[]{typeName});
    }

    private static ParameterizedTypeName buildRemoteFunctionCall(TypeName typeName) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(RemoteFunctionCall.class), (TypeName[])new TypeName[]{typeName});
    }

    private void buildTransactionFunction(AbiDefinition functionDefinition, MethodSpec.Builder methodBuilder, String inputParams, boolean useUpperCase) throws ClassNotFoundException {
        if (functionDefinition.hasOutputs()) {
            this.reporter.report(String.format("Definition of the function %s returns a value but is not defined as a view function. Please ensure it contains the view modifier if you want to read the return value", functionDefinition.getName()));
        }
        if (functionDefinition.isPayable()) {
            methodBuilder.addParameter(BigInteger.class, WEI_VALUE, new javax.lang.model.element.Modifier[0]);
        }
        String functionName = functionDefinition.getName();
        methodBuilder.returns((TypeName)SolidityFunctionWrapper.buildRemoteFunctionCall(TypeName.get(TransactionReceipt.class)));
        methodBuilder.addStatement("final $T function = new $T(\n$N, \n$T.<$T>asList($L), \n$T.<$T<?>>emptyList())", new Object[]{org.web3j.abi.datatypes.Function.class, org.web3j.abi.datatypes.Function.class, SolidityFunctionWrapper.funcNameToConst(functionName, useUpperCase), Arrays.class, org.web3j.abi.datatypes.Type.class, inputParams, Collections.class, TypeReference.class});
        if (functionDefinition.isPayable()) {
            methodBuilder.addStatement("return executeRemoteCallTransaction(function, $N)", new Object[]{WEI_VALUE});
        } else {
            methodBuilder.addStatement("return executeRemoteCallTransaction(function)", new Object[0]);
        }
    }

    TypeSpec buildEventResponseObject(String className, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) {
        TypeName typeName;
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)className).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC});
        builder.superclass(BaseEventResponse.class);
        for (NamedTypeName namedType : indexedParameters) {
            typeName = namedType.getType().equals("tuple") ? (TypeName)this.structClassNameMap.get(namedType.structIdentifier()) : (namedType.getType().startsWith("tuple") && namedType.getType().contains("[") ? this.buildStructArrayTypeName(namedType.namedType, true) : this.getIndexedEventWrapperType(namedType.typeName));
            builder.addField(typeName, namedType.getName(), new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC});
        }
        for (NamedTypeName namedType : nonIndexedParameters) {
            typeName = namedType.getType().equals("tuple") ? (TypeName)this.structClassNameMap.get(namedType.structIdentifier()) : (namedType.getType().startsWith("tuple") && namedType.getType().contains("[") ? this.buildStructArrayTypeName(namedType.namedType, true) : this.getWrapperType(namedType.typeName));
            builder.addField(typeName, namedType.getName(), new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC});
        }
        return builder.build();
    }

    MethodSpec buildEventFlowableFunction(String responseClassName, String functionName, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) throws ClassNotFoundException {
        String generatedFunctionName = Strings.lowercaseFirstLetter((String)functionName) + "EventFlowable";
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Flowable.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])});
        MethodSpec.Builder flowableMethodBuilder = MethodSpec.methodBuilder((String)generatedFunctionName).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addParameter(EthFilter.class, FILTER, new javax.lang.model.element.Modifier[0]).returns((TypeName)parameterizedTypeName);
        TypeSpec converter = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(Log.class), ClassName.get((String)"", (String)responseClassName, (String[])new String[0])})).addMethod(MethodSpec.methodBuilder((String)"apply").addAnnotation(Override.class).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addParameter(Log.class, "log", new javax.lang.model.element.Modifier[0]).returns((TypeName)ClassName.get((String)"", (String)responseClassName, (String[])new String[0])).addStatement("$T eventValues = extractEventParametersWithLog(" + this.buildEventDefinitionName(functionName) + ", log)", new Object[]{Contract.EventValuesWithLog.class}).addStatement("$1T typedResponse = new $1T()", new Object[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])}).addCode(this.buildTypedResponse("typedResponse", indexedParameters, nonIndexedParameters, true)).addStatement("return typedResponse", new Object[0]).build()).build();
        flowableMethodBuilder.addStatement("return web3j.ethLogFlowable(filter).map($L)", new Object[]{converter});
        return flowableMethodBuilder.build();
    }

    MethodSpec buildDefaultEventFlowableFunction(String responseClassName, String functionName) {
        String generatedFunctionName = Strings.lowercaseFirstLetter((String)functionName) + "EventFlowable";
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Flowable.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])});
        MethodSpec.Builder flowableMethodBuilder = MethodSpec.methodBuilder((String)generatedFunctionName).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addParameter(DefaultBlockParameter.class, START_BLOCK, new javax.lang.model.element.Modifier[0]).addParameter(DefaultBlockParameter.class, END_BLOCK, new javax.lang.model.element.Modifier[0]).returns((TypeName)parameterizedTypeName);
        flowableMethodBuilder.addStatement("$1T filter = new $1T($2L, $3L, getContractAddress())", new Object[]{EthFilter.class, START_BLOCK, END_BLOCK}).addStatement("filter.addSingleTopic($T.encode(" + this.buildEventDefinitionName(functionName) + "))", new Object[]{EventEncoder.class}).addStatement("return " + generatedFunctionName + "(filter)", new Object[0]);
        return flowableMethodBuilder.build();
    }

    MethodSpec buildEventTransactionReceiptFunction(String responseClassName, String functionName, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) {
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])});
        String generatedFunctionName = "get" + Strings.capitaliseFirstLetter((String)functionName) + "Events";
        MethodSpec.Builder transactionMethodBuilder = MethodSpec.methodBuilder((String)generatedFunctionName).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addParameter(TransactionReceipt.class, "transactionReceipt", new javax.lang.model.element.Modifier[0]).returns((TypeName)parameterizedTypeName);
        transactionMethodBuilder.addStatement("$T valueList = extractEventParametersWithLog(" + this.buildEventDefinitionName(functionName) + ", transactionReceipt)", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{Contract.EventValuesWithLog.class})}).addStatement("$1T responses = new $1T(valueList.size())", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(ArrayList.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])})}).beginControlFlow("for ($T eventValues : valueList)", new Object[]{Contract.EventValuesWithLog.class}).addStatement("$1T typedResponse = new $1T()", new Object[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])}).addCode(this.buildTypedResponse("typedResponse", indexedParameters, nonIndexedParameters, false)).addStatement("responses.add(typedResponse)", new Object[0]).endControlFlow();
        transactionMethodBuilder.addStatement("return responses", new Object[0]);
        return transactionMethodBuilder.build();
    }

    List<MethodSpec> buildEventFunctions(AbiDefinition functionDefinition, TypeSpec.Builder classBuilder) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        List inputs = functionDefinition.getInputs();
        String responseClassName = Strings.capitaliseFirstLetter((String)functionName) + "EventResponse";
        ArrayList<NamedTypeName> parameters = new ArrayList<NamedTypeName>();
        ArrayList<NamedTypeName> indexedParameters = new ArrayList<NamedTypeName>();
        ArrayList<NamedTypeName> nonIndexedParameters = new ArrayList<NamedTypeName>();
        for (AbiDefinition.NamedType namedType : inputs) {
            TypeName typeName = namedType.getType().equals("tuple") ? (TypeName)this.structClassNameMap.get(namedType.structIdentifier()) : (namedType.getType().startsWith("tuple") && namedType.getType().contains("[") ? this.buildStructArrayTypeName(namedType, true) : SolidityFunctionWrapper.buildTypeName(namedType.getType(), this.useJavaPrimitiveTypes));
            NamedTypeName parameter = new NamedTypeName(namedType, typeName);
            if (namedType.isIndexed()) {
                indexedParameters.add(parameter);
            } else {
                nonIndexedParameters.add(parameter);
            }
            parameters.add(parameter);
        }
        classBuilder.addField(this.createEventDefinition(functionName, parameters));
        classBuilder.addType(this.buildEventResponseObject(responseClassName, indexedParameters, nonIndexedParameters));
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.add(this.buildEventTransactionReceiptFunction(responseClassName, functionName, indexedParameters, nonIndexedParameters));
        methods.add(this.buildEventFlowableFunction(responseClassName, functionName, indexedParameters, nonIndexedParameters));
        methods.add(this.buildDefaultEventFlowableFunction(responseClassName, functionName));
        return methods;
    }

    CodeBlock buildTypedResponse(String objectName, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters, boolean flowable) {
        String nativeConversion;
        NamedTypeName namedTypeName;
        int i;
        CodeBlock.Builder builder = CodeBlock.builder();
        if (flowable) {
            builder.addStatement("$L.log = log", new Object[]{objectName});
        } else {
            builder.addStatement("$L.log = eventValues.getLog()", new Object[]{objectName});
        }
        for (i = 0; i < indexedParameters.size(); ++i) {
            namedTypeName = indexedParameters.get(i);
            nativeConversion = this.useNativeJavaTypes && this.structClassNameMap.values().stream().map(ClassName::simpleName).noneMatch(name -> name.equals(namedTypeName.getTypeName().toString())) ? ".getValue()" : "";
            TypeName indexedEventWrapperType = namedTypeName.getType().equals("tuple") ? (TypeName)this.structClassNameMap.get(namedTypeName.structIdentifier()) : (namedTypeName.getType().startsWith("tuple") && namedTypeName.getType().contains("[") ? this.buildStructArrayTypeName(namedTypeName.namedType, true) : this.getIndexedEventWrapperType(namedTypeName.getTypeName()));
            builder.addStatement("$L.$L = ($T) eventValues.getIndexedValues().get($L)" + nativeConversion, new Object[]{objectName, namedTypeName.getName(), indexedEventWrapperType, i});
        }
        for (i = 0; i < nonIndexedParameters.size(); ++i) {
            namedTypeName = nonIndexedParameters.get(i);
            nativeConversion = this.useNativeJavaTypes && this.structClassNameMap.values().stream().map(ClassName::simpleName).noneMatch(name -> name.equals(namedTypeName.getTypeName().toString())) ? ".getValue()" : "";
            TypeName nonIndexedEventWrapperType = nonIndexedParameters.get(i).getType().equals("tuple") ? (TypeName)this.structClassNameMap.get(namedTypeName.structIdentifier()) : (nonIndexedParameters.get(i).getType().startsWith("tuple") && nonIndexedParameters.get(i).getType().contains("[") ? this.buildStructArrayTypeName(namedTypeName.namedType, true) : this.getWrapperType(nonIndexedParameters.get(i).getTypeName()));
            builder.addStatement("$L.$L = ($T) eventValues.getNonIndexedValues().get($L)" + nativeConversion, new Object[]{objectName, namedTypeName.getName(), nonIndexedEventWrapperType, i});
        }
        return builder.build();
    }

    static TypeName buildTypeName(String typeDeclaration) throws ClassNotFoundException {
        return SolidityFunctionWrapper.buildTypeName(typeDeclaration, false);
    }

    static TypeName buildTypeName(String typeDeclaration, boolean primitives) throws ClassNotFoundException {
        String solidityType = SolidityFunctionWrapper.trimStorageDeclaration(typeDeclaration);
        TypeReference typeReference = TypeReference.makeTypeReference((String)solidityType, (boolean)false, (boolean)primitives);
        return TypeName.get((Type)typeReference.getType());
    }

    private static Class<?> getStaticArrayTypeReferenceClass(String type) {
        try {
            return Class.forName("org.web3j.abi.datatypes.generated.StaticArray" + type);
        }
        catch (ClassNotFoundException e) {
            return StaticArray.class;
        }
    }

    private static String trimStorageDeclaration(String type) {
        if (type.endsWith(" storage") || type.endsWith(" memory")) {
            return type.split(" ")[0];
        }
        return type;
    }

    private static void buildVariableLengthReturnFunctionConstructor(MethodSpec.Builder methodBuilder, String functionName, String inputParameters, List<TypeName> outputParameterTypes, boolean useUpperCase) throws ClassNotFoundException {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(org.web3j.abi.datatypes.Function.class);
        objects.add(org.web3j.abi.datatypes.Function.class);
        objects.add(SolidityFunctionWrapper.funcNameToConst(functionName, useUpperCase));
        objects.add(Arrays.class);
        objects.add(org.web3j.abi.datatypes.Type.class);
        objects.add(inputParameters);
        objects.add(Arrays.class);
        objects.add(TypeReference.class);
        for (TypeName outputParameterType : outputParameterTypes) {
            objects.add(TypeReference.class);
            objects.add(outputParameterType);
        }
        String asListParams = org.web3j.utils.Collection.join(outputParameterTypes, (String)", ", typeName -> "new $T<$T>() {}");
        methodBuilder.addStatement("final $T function = new $T($N, \n$T.<$T>asList($L), \n$T.<$T<?>>asList(" + asListParams + "))", objects.toArray());
    }

    private void buildTupleResultContainer(MethodSpec.Builder methodBuilder, ParameterizedTypeName tupleType, List<TypeName> outputParameterTypes) throws ClassNotFoundException {
        List typeArguments = tupleType.typeArguments;
        CodeBlock.Builder tupleConstructor = CodeBlock.builder();
        tupleConstructor.addStatement("$T results = executeCallMultipleValueReturn(function)", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{org.web3j.abi.datatypes.Type.class})}).add("return new $T(", new Object[]{tupleType}).add("$>$>", new Object[0]);
        String resultStringNativeList = "\nconvertToNative(($T) results.get($L).getValue())";
        int size = typeArguments.size();
        ClassName classList = ClassName.get(List.class);
        for (int i = 0; i < size; ++i) {
            TypeName param = outputParameterTypes.get(i);
            TypeName convertTo = (TypeName)typeArguments.get(i);
            String resultStringSimple = "\n($T) results.get($L)";
            TypeName finalConvertTo = convertTo;
            if (this.useNativeJavaTypes && this.structClassNameMap.values().stream().map(ClassName::simpleName).noneMatch(name -> name.equals(finalConvertTo.toString()))) {
                resultStringSimple = resultStringSimple + ".getValue()";
            }
            String resultString = resultStringSimple;
            if (this.useNativeJavaTypes && param instanceof ParameterizedTypeName) {
                ParameterizedTypeName oldContainer = (ParameterizedTypeName)param;
                ParameterizedTypeName newContainer = (ParameterizedTypeName)convertTo;
                if (newContainer.rawType.compareTo(classList) == 0 && newContainer.typeArguments.size() == 1) {
                    convertTo = ParameterizedTypeName.get((ClassName)classList, (TypeName[])new TypeName[]{(TypeName)oldContainer.typeArguments.get(0)});
                    resultString = resultStringNativeList;
                }
            }
            tupleConstructor.add(resultString, new Object[]{convertTo, i});
            tupleConstructor.add(i < size - 1 ? ", " : ");\n", new Object[0]);
        }
        tupleConstructor.add("$<$<", new Object[0]);
        TypeSpec callableType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Callable.class), (TypeName[])new TypeName[]{tupleType})).addMethod(MethodSpec.methodBuilder((String)"call").addAnnotation(Override.class).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addException(Exception.class).returns((TypeName)tupleType).addCode(tupleConstructor.build()).build()).build();
        methodBuilder.addStatement("return new $T(function,\n$L)", new Object[]{SolidityFunctionWrapper.buildRemoteFunctionCall((TypeName)tupleType), callableType});
    }

    private static CodeBlock buildVariableLengthEventInitializer(String eventName, List<NamedTypeName> parameterTypes) {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(Event.class);
        objects.add(eventName);
        objects.add(Arrays.class);
        objects.add(TypeReference.class);
        for (NamedTypeName parameterType : parameterTypes) {
            objects.add(TypeReference.class);
            objects.add(parameterType.getTypeName());
        }
        String asListParams = parameterTypes.stream().map(type -> {
            if (type.isIndexed()) {
                return "new $T<$T>(true) {}";
            }
            return "new $T<$T>() {}";
        }).collect(Collectors.joining(", "));
        return CodeBlock.builder().addStatement("new $T($S, \n$T.<$T<?>>asList(" + asListParams + "))", objects.toArray()).build();
    }

    private List<AbiDefinition> loadContractDefinition(String abi) throws IOException {
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        AbiDefinition[] abiDefinition = (AbiDefinition[])objectMapper.readValue(abi, AbiDefinition[].class);
        return Arrays.asList(abiDefinition);
    }

    private static String funcNameToConst(String funcName, boolean useUpperCase) {
        if (useUpperCase) {
            return FUNC_NAME_PREFIX + funcName.toUpperCase();
        }
        return FUNC_NAME_PREFIX + funcName;
    }

    private static class NamedTypeName {
        private final TypeName typeName;
        private final AbiDefinition.NamedType namedType;

        NamedTypeName(AbiDefinition.NamedType namedType, TypeName typeName) {
            this.namedType = namedType;
            this.typeName = typeName;
        }

        public String getName() {
            return this.namedType.getName();
        }

        public String getType() {
            return this.namedType.getType();
        }

        public TypeName getTypeName() {
            return this.typeName;
        }

        public boolean isIndexed() {
            return this.namedType.isIndexed();
        }

        public int structIdentifier() {
            return this.namedType.structIdentifier();
        }
    }
}

