/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.codegen;

import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.util.ArrayList;
import javax.lang.model.element.Modifier;
import org.web3j.codegen.Generator;
import org.web3j.tuples.Tuple;
import org.web3j.utils.Strings;

public class TupleGenerator
extends Generator {
    static final int LIMIT = 20;
    static final String PACKAGE_NAME = "org.web3j.tuples.generated";
    static final String CLASS_NAME = "Tuple";
    private static final String SIZE = "SIZE";
    private static final String RESULT = "result";
    private static final String VALUE = "value";

    public static void main(String[] args) throws IOException {
        TupleGenerator tupleGenerator = new TupleGenerator();
        if (args.length == 1) {
            tupleGenerator.generate(args[0]);
        } else {
            tupleGenerator.generate(System.getProperty("user.dir") + "/tuples/src/main/java/");
        }
    }

    private void generate(String destinationDir) throws IOException {
        for (int i = 1; i <= 20; ++i) {
            TypeSpec typeSpec = this.createTuple(i);
            this.write(PACKAGE_NAME, typeSpec, destinationDir);
        }
    }

    private TypeSpec createTuple(int size) {
        String javadoc = "@deprecated use 'component$L' method instead \n @return returns a value";
        String className = CLASS_NAME + size;
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder((String)className).addSuperinterface(Tuple.class).addField(FieldSpec.builder(Integer.TYPE, (String)SIZE, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$L", new Object[]{size}).build());
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>(size);
        for (int i = 1; i <= size; ++i) {
            String value = VALUE + i;
            TypeVariableName typeVariableName = TypeVariableName.get((String)("T" + i));
            typeSpecBuilder.addTypeVariable(typeVariableName).addField((TypeName)typeVariableName, value, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            constructorBuilder.addParameter((TypeName)typeVariableName, value, new Modifier[0]).addStatement("this.$N = $N", new Object[]{value, value});
            MethodSpec getterSpec = MethodSpec.methodBuilder((String)("get" + Strings.capitaliseFirstLetter((String)value))).addAnnotation(Deprecated.class).addJavadoc(javadoc, new Object[]{i}).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)typeVariableName).addStatement("return $N", new Object[]{value}).build();
            methodSpecs.add(getterSpec);
            MethodSpec getterSpec2 = MethodSpec.methodBuilder((String)("component" + i)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)typeVariableName).addStatement("return $N", new Object[]{value}).build();
            methodSpecs.add(getterSpec2);
        }
        MethodSpec constructorSpec = constructorBuilder.build();
        MethodSpec sizeSpec = this.generateSizeSpec();
        MethodSpec equalsSpec = this.generateEqualsSpec(className, size);
        MethodSpec hashCodeSpec = this.generateHashCodeSpec(size);
        MethodSpec toStringSpec = this.generateToStringSpec(size);
        return typeSpecBuilder.addJavadoc(TupleGenerator.buildWarning(TupleGenerator.class), new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(constructorSpec).addMethods(methodSpecs).addMethod(sizeSpec).addMethod(equalsSpec).addMethod(hashCodeSpec).addMethod(toStringSpec).build();
    }

    private MethodSpec generateSizeSpec() {
        return MethodSpec.methodBuilder((String)"getSize").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return $L", new Object[]{SIZE}).build();
    }

    private MethodSpec generateEqualsSpec(String className, int size) {
        MethodSpec.Builder equalsSpecBuilder = MethodSpec.methodBuilder((String)"equals").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Object.class, "o", new Modifier[0]).returns(Boolean.TYPE).beginControlFlow("if (this == o)", new Object[0]).addStatement("return true", new Object[0]).endControlFlow().beginControlFlow("if (o == null || getClass() != o.getClass())", new Object[0]).addStatement("return false", new Object[0]).endControlFlow();
        String typeParams = Strings.repeat((char)'?', (int)size).replaceAll("\\?", "?, ");
        typeParams = typeParams.substring(0, typeParams.length() - 2);
        String wildcardClassName = className + "<" + typeParams + ">";
        String name = "tuple" + size;
        equalsSpecBuilder.addStatement("$L $L = ($L) o", new Object[]{wildcardClassName, name, wildcardClassName});
        for (int i = 1; i < size; ++i) {
            String value = VALUE + i;
            equalsSpecBuilder.beginControlFlow("if ($L != null ? !$L.equals($L.$L) : $L.$L != null)", new Object[]{value, value, name, value, name, value}).addStatement("return false", new Object[0]).endControlFlow();
        }
        String lastValue = VALUE + size;
        equalsSpecBuilder.addStatement("return $L != null ? $L.equals($L.$L) : $L.$L == null", new Object[]{lastValue, lastValue, name, lastValue, name, lastValue});
        return equalsSpecBuilder.build();
    }

    private MethodSpec generateHashCodeSpec(int size) {
        MethodSpec.Builder hashCodeSpec = MethodSpec.methodBuilder((String)"hashCode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("int $L = $L.hashCode()", new Object[]{RESULT, "value1"});
        for (int i = 2; i <= size; ++i) {
            String value = VALUE + i;
            hashCodeSpec.addStatement("$L = 31 * $L + ($L != null ? $L.hashCode() : 0)", new Object[]{RESULT, RESULT, value, value});
        }
        hashCodeSpec.addStatement("return $L", new Object[]{RESULT});
        return hashCodeSpec.build();
    }

    private MethodSpec generateToStringSpec(int size) {
        String toString = "return \"Tuple" + size + "{\" +\n";
        String firstValue = "value1";
        toString = toString + "\"" + firstValue + "=\" + " + firstValue + " +\n";
        for (int i = 2; i <= size; ++i) {
            String value = VALUE + i;
            toString = toString + "\", " + value + "=\" + " + value + " +\n";
        }
        toString = toString + "\"}\"";
        return MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement(toString, new Object[0]).build();
    }
}

