/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awsconstructs.services.lambdaopensearch;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.cloudwatch.Alarm;
import software.amazon.awscdk.services.cognito.CfnIdentityPool;
import software.amazon.awscdk.services.cognito.UserPool;
import software.amazon.awscdk.services.cognito.UserPoolClient;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.VpcProps;
import software.amazon.awscdk.services.iam.Role;
import software.amazon.awscdk.services.lambda.Function;
import software.amazon.awscdk.services.lambda.FunctionProps;
import software.amazon.awscdk.services.opensearchservice.CfnDomain;
import software.amazon.awscdk.services.opensearchservice.CfnDomainProps;
import software.amazon.awsconstructs.services.lambdaopensearch.;
import software.amazon.awsconstructs.services.lambdaopensearch.LambdaToOpenSearchProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-solutions-constructs/aws-lambda-opensearch.LambdaToOpenSearch")
public class LambdaToOpenSearch
extends Construct {
    protected LambdaToOpenSearch(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaToOpenSearch(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public LambdaToOpenSearch(@NotNull Construct scope, @NotNull String id, @NotNull LambdaToOpenSearchProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public CfnIdentityPool getIdentityPool() {
        return (CfnIdentityPool)Kernel.get((Object)((Object)this), (String)"identityPool", (NativeType)NativeType.forClass(CfnIdentityPool.class));
    }

    @NotNull
    public Function getLambdaFunction() {
        return (Function)Kernel.get((Object)((Object)this), (String)"lambdaFunction", (NativeType)NativeType.forClass(Function.class));
    }

    @NotNull
    public CfnDomain getOpenSearchDomain() {
        return (CfnDomain)Kernel.get((Object)((Object)this), (String)"openSearchDomain", (NativeType)NativeType.forClass(CfnDomain.class));
    }

    @NotNull
    public Role getOpenSearchRole() {
        return (Role)Kernel.get((Object)((Object)this), (String)"openSearchRole", (NativeType)NativeType.forClass(Role.class));
    }

    @NotNull
    public UserPool getUserPool() {
        return (UserPool)Kernel.get((Object)((Object)this), (String)"userPool", (NativeType)NativeType.forClass(UserPool.class));
    }

    @NotNull
    public UserPoolClient getUserPoolClient() {
        return (UserPoolClient)Kernel.get((Object)((Object)this), (String)"userPoolClient", (NativeType)NativeType.forClass(UserPoolClient.class));
    }

    @Nullable
    public List<Alarm> getCloudWatchAlarms() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"cloudWatchAlarms", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Alarm.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public IVpc getVpc() {
        return (IVpc)Kernel.get((Object)((Object)this), (String)"vpc", (NativeType)NativeType.forClass(IVpc.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<LambdaToOpenSearch> {
        private final Construct scope;
        private final String id;
        private final LambdaToOpenSearchProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new LambdaToOpenSearchProps.Builder();
        }

        public Builder openSearchDomainName(String openSearchDomainName) {
            this.props.openSearchDomainName(openSearchDomainName);
            return this;
        }

        public Builder cognitoDomainName(String cognitoDomainName) {
            this.props.cognitoDomainName(cognitoDomainName);
            return this;
        }

        public Builder createCloudWatchAlarms(Boolean createCloudWatchAlarms) {
            this.props.createCloudWatchAlarms(createCloudWatchAlarms);
            return this;
        }

        public Builder deployVpc(Boolean deployVpc) {
            this.props.deployVpc(deployVpc);
            return this;
        }

        public Builder domainEndpointEnvironmentVariableName(String domainEndpointEnvironmentVariableName) {
            this.props.domainEndpointEnvironmentVariableName(domainEndpointEnvironmentVariableName);
            return this;
        }

        public Builder existingLambdaObj(Function existingLambdaObj) {
            this.props.existingLambdaObj(existingLambdaObj);
            return this;
        }

        public Builder existingVpc(IVpc existingVpc) {
            this.props.existingVpc(existingVpc);
            return this;
        }

        public Builder lambdaFunctionProps(FunctionProps lambdaFunctionProps) {
            this.props.lambdaFunctionProps(lambdaFunctionProps);
            return this;
        }

        public Builder openSearchDomainProps(CfnDomainProps openSearchDomainProps) {
            this.props.openSearchDomainProps(openSearchDomainProps);
            return this;
        }

        public Builder vpcProps(VpcProps vpcProps) {
            this.props.vpcProps(vpcProps);
            return this;
        }

        public LambdaToOpenSearch build() {
            return new LambdaToOpenSearch(this.scope, this.id, this.props.build());
        }
    }
}

