package software.amazon.awsconstructs.services.openapigatewaylambda;

/**
 * Helper object to map an ApiIntegration id to its resolved lambda.Function. This type is exposed as a property on the instantiated construct.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.111.0 (build cc021d6)", date = "2025-05-01T20:29:22.157Z")
@software.amazon.jsii.Jsii(module = software.amazon.awsconstructs.services.openapigatewaylambda.$Module.class, fqn = "@aws-solutions-constructs/aws-openapigateway-lambda.ApiLambdaFunction")
@software.amazon.jsii.Jsii.Proxy(ApiLambdaFunction.Jsii$Proxy.class)
public interface ApiLambdaFunction extends software.amazon.jsii.JsiiSerializable {

    /**
     * Id of the ApiIntegration, used to correlate this lambda function to the api integration in the open api definition.
     */
    @org.jetbrains.annotations.NotNull java.lang.String getId();

    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.Alias getFunctionAlias() {
        return null;
    }

    /**
     * The function the API method will integrate with - Must be defined in lambdaFunction or functionAlias (but not both).
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.Function getLambdaFunction() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApiLambdaFunction}
     */
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApiLambdaFunction}
     */
    public static final class Builder implements software.amazon.jsii.Builder<ApiLambdaFunction> {
        java.lang.String id;
        software.amazon.awscdk.services.lambda.Alias functionAlias;
        software.amazon.awscdk.services.lambda.Function lambdaFunction;

        /**
         * Sets the value of {@link ApiLambdaFunction#getId}
         * @param id Id of the ApiIntegration, used to correlate this lambda function to the api integration in the open api definition. This parameter is required.
         * @return {@code this}
         */
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link ApiLambdaFunction#getFunctionAlias}
         * @param functionAlias the value to be set.
         * @return {@code this}
         */
        public Builder functionAlias(software.amazon.awscdk.services.lambda.Alias functionAlias) {
            this.functionAlias = functionAlias;
            return this;
        }

        /**
         * Sets the value of {@link ApiLambdaFunction#getLambdaFunction}
         * @param lambdaFunction The function the API method will integrate with - Must be defined in lambdaFunction or functionAlias (but not both).
         * @return {@code this}
         */
        public Builder lambdaFunction(software.amazon.awscdk.services.lambda.Function lambdaFunction) {
            this.lambdaFunction = lambdaFunction;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApiLambdaFunction}
         * @throws NullPointerException if any required attribute was not provided
         */
        @Override
        public ApiLambdaFunction build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApiLambdaFunction}
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiLambdaFunction {
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.Alias functionAlias;
        private final software.amazon.awscdk.services.lambda.Function lambdaFunction;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.functionAlias = software.amazon.jsii.Kernel.get(this, "functionAlias", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Alias.class));
            this.lambdaFunction = software.amazon.jsii.Kernel.get(this, "lambdaFunction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Function.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
            this.functionAlias = builder.functionAlias;
            this.lambdaFunction = builder.lambdaFunction;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.Alias getFunctionAlias() {
            return this.functionAlias;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.Function getLambdaFunction() {
            return this.lambdaFunction;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("id", om.valueToTree(this.getId()));
            if (this.getFunctionAlias() != null) {
                data.set("functionAlias", om.valueToTree(this.getFunctionAlias()));
            }
            if (this.getLambdaFunction() != null) {
                data.set("lambdaFunction", om.valueToTree(this.getLambdaFunction()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-solutions-constructs/aws-openapigateway-lambda.ApiLambdaFunction"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApiLambdaFunction.Jsii$Proxy that = (ApiLambdaFunction.Jsii$Proxy) o;

            if (!id.equals(that.id)) return false;
            if (this.functionAlias != null ? !this.functionAlias.equals(that.functionAlias) : that.functionAlias != null) return false;
            return this.lambdaFunction != null ? this.lambdaFunction.equals(that.lambdaFunction) : that.lambdaFunction == null;
        }

        @Override
        public final int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + (this.functionAlias != null ? this.functionAlias.hashCode() : 0);
            result = 31 * result + (this.lambdaFunction != null ? this.lambdaFunction.hashCode() : 0);
            return result;
        }
    }
}
