package software.amazon.awsconstructs.services.openapigatewaylambda;

@javax.annotation.Generated(value = "jsii-pacmak/1.111.0 (build cc021d6)", date = "2025-05-01T20:29:22.162Z")
@software.amazon.jsii.Jsii(module = software.amazon.awsconstructs.services.openapigatewaylambda.$Module.class, fqn = "@aws-solutions-constructs/aws-openapigateway-lambda.OpenApiGatewayToLambdaProps")
@software.amazon.jsii.Jsii.Proxy(OpenApiGatewayToLambdaProps.Jsii$Proxy.class)
public interface OpenApiGatewayToLambdaProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * One or more key-value pairs that contain an id for the api integration and either an existing lambda function or an instance of the LambdaProps.
     * <p>
     * Example:
     * const apiIntegrations: ApiIntegration[] = [
     * {
     * id: 'MessagesHandler',
     * lambdaFunctionProps: {
     * runtime: defaults.COMMERCIAL_REGION_LAMBDA_NODE_RUNTIME,
     * handler: 'index.handler',
     * code: lambda.Code.fromAsset(<code>${__dirname}/messages-lambda</code>),
     * }
     * },
     * {
     * id: 'PhotosHandler',
     * existingLambdaObj: new lambda.Function(this, 'PhotosLambda', {
     * runtime: defaults.COMMERCIAL_REGION_LAMBDA_NODE_RUNTIME,
     * handler: 'index.handler',
     * code: lambda.Code.fromAsset(<code>${__dirname}/photos-lambda</code>),
     * })
     * }
     * ]
     */
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awsconstructs.services.openapigatewaylambda.ApiIntegration> getApiIntegrations();

    /**
     * Local file asset of the OpenAPI spec file.
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.Asset getApiDefinitionAsset() {
        return null;
    }

    /**
     * S3 Bucket where the OpenAPI spec file is located.
     * <p>
     * When specifying this property, apiDefinitionKey must also be specified.
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getApiDefinitionBucket() {
        return null;
    }

    /**
     * OpenAPI specification represented in a JSON object to be embedded in the CloudFormation template.
     * <p>
     * IMPORTANT - Including the spec in the template introduces a risk of the template growing too big, but
     * there are some use cases that require an embedded spec. Unless your use case explicitly requires an embedded spec
     * you should pass your spec as an S3 asset.
     */
    default @org.jetbrains.annotations.Nullable java.lang.Object getApiDefinitionJson() {
        return null;
    }

    /**
     * S3 Object name of the OpenAPI spec file.
     * <p>
     * When specifying this property, apiDefinitionBucket must also be specified.
     */
    default @org.jetbrains.annotations.Nullable java.lang.String getApiDefinitionKey() {
        return null;
    }

    /**
     * Optional user-provided props to override the default props for the API.
     * <p>
     * Default: - Default props are used.
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.RestApiBaseProps getApiGatewayProps() {
        return null;
    }

    /**
     * Optional user-defined memory size for the Lambda function custom resource installed to do the OpenAPI definition transformation.
     * <p>
     * This setting does not affect the deployed architecture - only the ability for the Construct to complete its work.
     * <p>
     * Defaults to 1024 MiB, but for larger files (hundreds of megabytes or gigabytes in size) this value may need to be increased.
     * <p>
     * Default: 1024
     */
    default @org.jetbrains.annotations.Nullable java.lang.Number getInternalTransformMemorySize() {
        return null;
    }

    /**
     * Optional user-defined timeout for the Lambda function custom resource installed to do the OpenAPI definition transformation.
     * <p>
     * This setting does not affect the deployed architecture - only the ability for the Construct to complete its work.
     * <p>
     * Defaults to 1 minute, but for larger files (hundreds of megabytes or gigabytes in size) this value may need to be increased.
     * <p>
     * Default: Duration.minutes(1)
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getInternalTransformTimeout() {
        return null;
    }

    /**
     * User provided props to override the default props for the CloudWatchLogs LogGroup.
     * <p>
     * Default: - Default props are used
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.LogGroupProps getLogGroupProps() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OpenApiGatewayToLambdaProps}
     */
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OpenApiGatewayToLambdaProps}
     */
    public static final class Builder implements software.amazon.jsii.Builder<OpenApiGatewayToLambdaProps> {
        java.util.List<software.amazon.awsconstructs.services.openapigatewaylambda.ApiIntegration> apiIntegrations;
        software.amazon.awscdk.services.s3.assets.Asset apiDefinitionAsset;
        software.amazon.awscdk.services.s3.IBucket apiDefinitionBucket;
        java.lang.Object apiDefinitionJson;
        java.lang.String apiDefinitionKey;
        software.amazon.awscdk.services.apigateway.RestApiBaseProps apiGatewayProps;
        java.lang.Number internalTransformMemorySize;
        software.amazon.awscdk.Duration internalTransformTimeout;
        software.amazon.awscdk.services.logs.LogGroupProps logGroupProps;

        /**
         * Sets the value of {@link OpenApiGatewayToLambdaProps#getApiIntegrations}
         * @param apiIntegrations One or more key-value pairs that contain an id for the api integration and either an existing lambda function or an instance of the LambdaProps. This parameter is required.
         *                        Example:
         *                        const apiIntegrations: ApiIntegration[] = [
         *                        {
         *                        id: 'MessagesHandler',
         *                        lambdaFunctionProps: {
         *                        runtime: defaults.COMMERCIAL_REGION_LAMBDA_NODE_RUNTIME,
         *                        handler: 'index.handler',
         *                        code: lambda.Code.fromAsset(<code>${__dirname}/messages-lambda</code>),
         *                        }
         *                        },
         *                        {
         *                        id: 'PhotosHandler',
         *                        existingLambdaObj: new lambda.Function(this, 'PhotosLambda', {
         *                        runtime: defaults.COMMERCIAL_REGION_LAMBDA_NODE_RUNTIME,
         *                        handler: 'index.handler',
         *                        code: lambda.Code.fromAsset(<code>${__dirname}/photos-lambda</code>),
         *                        })
         *                        }
         *                        ]
         * @return {@code this}
         */
        @SuppressWarnings("unchecked")
        public Builder apiIntegrations(java.util.List<? extends software.amazon.awsconstructs.services.openapigatewaylambda.ApiIntegration> apiIntegrations) {
            this.apiIntegrations = (java.util.List<software.amazon.awsconstructs.services.openapigatewaylambda.ApiIntegration>)apiIntegrations;
            return this;
        }

        /**
         * Sets the value of {@link OpenApiGatewayToLambdaProps#getApiDefinitionAsset}
         * @param apiDefinitionAsset Local file asset of the OpenAPI spec file.
         * @return {@code this}
         */
        public Builder apiDefinitionAsset(software.amazon.awscdk.services.s3.assets.Asset apiDefinitionAsset) {
            this.apiDefinitionAsset = apiDefinitionAsset;
            return this;
        }

        /**
         * Sets the value of {@link OpenApiGatewayToLambdaProps#getApiDefinitionBucket}
         * @param apiDefinitionBucket S3 Bucket where the OpenAPI spec file is located.
         *                            When specifying this property, apiDefinitionKey must also be specified.
         * @return {@code this}
         */
        public Builder apiDefinitionBucket(software.amazon.awscdk.services.s3.IBucket apiDefinitionBucket) {
            this.apiDefinitionBucket = apiDefinitionBucket;
            return this;
        }

        /**
         * Sets the value of {@link OpenApiGatewayToLambdaProps#getApiDefinitionJson}
         * @param apiDefinitionJson OpenAPI specification represented in a JSON object to be embedded in the CloudFormation template.
         *                          IMPORTANT - Including the spec in the template introduces a risk of the template growing too big, but
         *                          there are some use cases that require an embedded spec. Unless your use case explicitly requires an embedded spec
         *                          you should pass your spec as an S3 asset.
         * @return {@code this}
         */
        public Builder apiDefinitionJson(java.lang.Object apiDefinitionJson) {
            this.apiDefinitionJson = apiDefinitionJson;
            return this;
        }

        /**
         * Sets the value of {@link OpenApiGatewayToLambdaProps#getApiDefinitionKey}
         * @param apiDefinitionKey S3 Object name of the OpenAPI spec file.
         *                         When specifying this property, apiDefinitionBucket must also be specified.
         * @return {@code this}
         */
        public Builder apiDefinitionKey(java.lang.String apiDefinitionKey) {
            this.apiDefinitionKey = apiDefinitionKey;
            return this;
        }

        /**
         * Sets the value of {@link OpenApiGatewayToLambdaProps#getApiGatewayProps}
         * @param apiGatewayProps Optional user-provided props to override the default props for the API.
         * @return {@code this}
         */
        public Builder apiGatewayProps(software.amazon.awscdk.services.apigateway.RestApiBaseProps apiGatewayProps) {
            this.apiGatewayProps = apiGatewayProps;
            return this;
        }

        /**
         * Sets the value of {@link OpenApiGatewayToLambdaProps#getInternalTransformMemorySize}
         * @param internalTransformMemorySize Optional user-defined memory size for the Lambda function custom resource installed to do the OpenAPI definition transformation.
         *                                    This setting does not affect the deployed architecture - only the ability for the Construct to complete its work.
         *                                    <p>
         *                                    Defaults to 1024 MiB, but for larger files (hundreds of megabytes or gigabytes in size) this value may need to be increased.
         * @return {@code this}
         */
        public Builder internalTransformMemorySize(java.lang.Number internalTransformMemorySize) {
            this.internalTransformMemorySize = internalTransformMemorySize;
            return this;
        }

        /**
         * Sets the value of {@link OpenApiGatewayToLambdaProps#getInternalTransformTimeout}
         * @param internalTransformTimeout Optional user-defined timeout for the Lambda function custom resource installed to do the OpenAPI definition transformation.
         *                                 This setting does not affect the deployed architecture - only the ability for the Construct to complete its work.
         *                                 <p>
         *                                 Defaults to 1 minute, but for larger files (hundreds of megabytes or gigabytes in size) this value may need to be increased.
         * @return {@code this}
         */
        public Builder internalTransformTimeout(software.amazon.awscdk.Duration internalTransformTimeout) {
            this.internalTransformTimeout = internalTransformTimeout;
            return this;
        }

        /**
         * Sets the value of {@link OpenApiGatewayToLambdaProps#getLogGroupProps}
         * @param logGroupProps User provided props to override the default props for the CloudWatchLogs LogGroup.
         * @return {@code this}
         */
        public Builder logGroupProps(software.amazon.awscdk.services.logs.LogGroupProps logGroupProps) {
            this.logGroupProps = logGroupProps;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OpenApiGatewayToLambdaProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @Override
        public OpenApiGatewayToLambdaProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OpenApiGatewayToLambdaProps}
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenApiGatewayToLambdaProps {
        private final java.util.List<software.amazon.awsconstructs.services.openapigatewaylambda.ApiIntegration> apiIntegrations;
        private final software.amazon.awscdk.services.s3.assets.Asset apiDefinitionAsset;
        private final software.amazon.awscdk.services.s3.IBucket apiDefinitionBucket;
        private final java.lang.Object apiDefinitionJson;
        private final java.lang.String apiDefinitionKey;
        private final software.amazon.awscdk.services.apigateway.RestApiBaseProps apiGatewayProps;
        private final java.lang.Number internalTransformMemorySize;
        private final software.amazon.awscdk.Duration internalTransformTimeout;
        private final software.amazon.awscdk.services.logs.LogGroupProps logGroupProps;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiIntegrations = software.amazon.jsii.Kernel.get(this, "apiIntegrations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awsconstructs.services.openapigatewaylambda.ApiIntegration.class)));
            this.apiDefinitionAsset = software.amazon.jsii.Kernel.get(this, "apiDefinitionAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.assets.Asset.class));
            this.apiDefinitionBucket = software.amazon.jsii.Kernel.get(this, "apiDefinitionBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.apiDefinitionJson = software.amazon.jsii.Kernel.get(this, "apiDefinitionJson", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.apiDefinitionKey = software.amazon.jsii.Kernel.get(this, "apiDefinitionKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.apiGatewayProps = software.amazon.jsii.Kernel.get(this, "apiGatewayProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.RestApiBaseProps.class));
            this.internalTransformMemorySize = software.amazon.jsii.Kernel.get(this, "internalTransformMemorySize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.internalTransformTimeout = software.amazon.jsii.Kernel.get(this, "internalTransformTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.logGroupProps = software.amazon.jsii.Kernel.get(this, "logGroupProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.LogGroupProps.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiIntegrations = (java.util.List<software.amazon.awsconstructs.services.openapigatewaylambda.ApiIntegration>)java.util.Objects.requireNonNull(builder.apiIntegrations, "apiIntegrations is required");
            this.apiDefinitionAsset = builder.apiDefinitionAsset;
            this.apiDefinitionBucket = builder.apiDefinitionBucket;
            this.apiDefinitionJson = builder.apiDefinitionJson;
            this.apiDefinitionKey = builder.apiDefinitionKey;
            this.apiGatewayProps = builder.apiGatewayProps;
            this.internalTransformMemorySize = builder.internalTransformMemorySize;
            this.internalTransformTimeout = builder.internalTransformTimeout;
            this.logGroupProps = builder.logGroupProps;
        }

        @Override
        public final java.util.List<software.amazon.awsconstructs.services.openapigatewaylambda.ApiIntegration> getApiIntegrations() {
            return this.apiIntegrations;
        }

        @Override
        public final software.amazon.awscdk.services.s3.assets.Asset getApiDefinitionAsset() {
            return this.apiDefinitionAsset;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getApiDefinitionBucket() {
            return this.apiDefinitionBucket;
        }

        @Override
        public final java.lang.Object getApiDefinitionJson() {
            return this.apiDefinitionJson;
        }

        @Override
        public final java.lang.String getApiDefinitionKey() {
            return this.apiDefinitionKey;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.RestApiBaseProps getApiGatewayProps() {
            return this.apiGatewayProps;
        }

        @Override
        public final java.lang.Number getInternalTransformMemorySize() {
            return this.internalTransformMemorySize;
        }

        @Override
        public final software.amazon.awscdk.Duration getInternalTransformTimeout() {
            return this.internalTransformTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.logs.LogGroupProps getLogGroupProps() {
            return this.logGroupProps;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiIntegrations", om.valueToTree(this.getApiIntegrations()));
            if (this.getApiDefinitionAsset() != null) {
                data.set("apiDefinitionAsset", om.valueToTree(this.getApiDefinitionAsset()));
            }
            if (this.getApiDefinitionBucket() != null) {
                data.set("apiDefinitionBucket", om.valueToTree(this.getApiDefinitionBucket()));
            }
            if (this.getApiDefinitionJson() != null) {
                data.set("apiDefinitionJson", om.valueToTree(this.getApiDefinitionJson()));
            }
            if (this.getApiDefinitionKey() != null) {
                data.set("apiDefinitionKey", om.valueToTree(this.getApiDefinitionKey()));
            }
            if (this.getApiGatewayProps() != null) {
                data.set("apiGatewayProps", om.valueToTree(this.getApiGatewayProps()));
            }
            if (this.getInternalTransformMemorySize() != null) {
                data.set("internalTransformMemorySize", om.valueToTree(this.getInternalTransformMemorySize()));
            }
            if (this.getInternalTransformTimeout() != null) {
                data.set("internalTransformTimeout", om.valueToTree(this.getInternalTransformTimeout()));
            }
            if (this.getLogGroupProps() != null) {
                data.set("logGroupProps", om.valueToTree(this.getLogGroupProps()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-solutions-constructs/aws-openapigateway-lambda.OpenApiGatewayToLambdaProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OpenApiGatewayToLambdaProps.Jsii$Proxy that = (OpenApiGatewayToLambdaProps.Jsii$Proxy) o;

            if (!apiIntegrations.equals(that.apiIntegrations)) return false;
            if (this.apiDefinitionAsset != null ? !this.apiDefinitionAsset.equals(that.apiDefinitionAsset) : that.apiDefinitionAsset != null) return false;
            if (this.apiDefinitionBucket != null ? !this.apiDefinitionBucket.equals(that.apiDefinitionBucket) : that.apiDefinitionBucket != null) return false;
            if (this.apiDefinitionJson != null ? !this.apiDefinitionJson.equals(that.apiDefinitionJson) : that.apiDefinitionJson != null) return false;
            if (this.apiDefinitionKey != null ? !this.apiDefinitionKey.equals(that.apiDefinitionKey) : that.apiDefinitionKey != null) return false;
            if (this.apiGatewayProps != null ? !this.apiGatewayProps.equals(that.apiGatewayProps) : that.apiGatewayProps != null) return false;
            if (this.internalTransformMemorySize != null ? !this.internalTransformMemorySize.equals(that.internalTransformMemorySize) : that.internalTransformMemorySize != null) return false;
            if (this.internalTransformTimeout != null ? !this.internalTransformTimeout.equals(that.internalTransformTimeout) : that.internalTransformTimeout != null) return false;
            return this.logGroupProps != null ? this.logGroupProps.equals(that.logGroupProps) : that.logGroupProps == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiIntegrations.hashCode();
            result = 31 * result + (this.apiDefinitionAsset != null ? this.apiDefinitionAsset.hashCode() : 0);
            result = 31 * result + (this.apiDefinitionBucket != null ? this.apiDefinitionBucket.hashCode() : 0);
            result = 31 * result + (this.apiDefinitionJson != null ? this.apiDefinitionJson.hashCode() : 0);
            result = 31 * result + (this.apiDefinitionKey != null ? this.apiDefinitionKey.hashCode() : 0);
            result = 31 * result + (this.apiGatewayProps != null ? this.apiGatewayProps.hashCode() : 0);
            result = 31 * result + (this.internalTransformMemorySize != null ? this.internalTransformMemorySize.hashCode() : 0);
            result = 31 * result + (this.internalTransformTimeout != null ? this.internalTransformTimeout.hashCode() : 0);
            result = 31 * result + (this.logGroupProps != null ? this.logGroupProps.hashCode() : 0);
            return result;
        }
    }
}
