package software.amazon.awsconstructs.services.openapigatewaylambda;

/**
 * The ApiIntegration interface is used to correlate a user-specified id with either a existing lambda function or set of lambda props.
 * <p>
 * See the 'Overview of how the OpenAPI file transformation works' section of the README.md for more details on its usage.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.111.0 (build cc021d6)", date = "2025-09-10T20:20:36.591Z")
@software.amazon.jsii.Jsii(module = software.amazon.awsconstructs.services.openapigatewaylambda.$Module.class, fqn = "@aws-solutions-constructs/aws-openapigateway-lambda.ApiIntegration")
@software.amazon.jsii.Jsii.Proxy(ApiIntegration.Jsii$Proxy.class)
public interface ApiIntegration extends software.amazon.jsii.JsiiSerializable {

    /**
     * Id of the ApiIntegration, used to correlate this lambda function to the api integration in the open api definition.
     * <p>
     * Note this is not a CDK Construct ID, and is instead a client defined string used to map the resolved lambda resource with the OpenAPI definition.
     */
    @org.jetbrains.annotations.NotNull java.lang.String getId();

    /**
     * The Lambda function to associate with the API method in the OpenAPI file matched by id.
     * <p>
     * One and only one of existingLambdaObj or lambdaFunctionProps must be specified, any other combination will cause an error.
     */
    default @org.jetbrains.annotations.Nullable java.lang.Object getExistingLambdaObj() {
        return null;
    }

    /**
     * Properties for the Lambda function to create and associate with the API method in the OpenAPI file matched by id.
     * <p>
     * One and only one of existingLambdaObj or lambdaFunctionProps must be specified, any other combination will cause an error.
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.FunctionProps getLambdaFunctionProps() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApiIntegration}
     */
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApiIntegration}
     */
    public static final class Builder implements software.amazon.jsii.Builder<ApiIntegration> {
        java.lang.String id;
        java.lang.Object existingLambdaObj;
        software.amazon.awscdk.services.lambda.FunctionProps lambdaFunctionProps;

        /**
         * Sets the value of {@link ApiIntegration#getId}
         * @param id Id of the ApiIntegration, used to correlate this lambda function to the api integration in the open api definition. This parameter is required.
         *           Note this is not a CDK Construct ID, and is instead a client defined string used to map the resolved lambda resource with the OpenAPI definition.
         * @return {@code this}
         */
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link ApiIntegration#getExistingLambdaObj}
         * @param existingLambdaObj The Lambda function to associate with the API method in the OpenAPI file matched by id.
         *                          One and only one of existingLambdaObj or lambdaFunctionProps must be specified, any other combination will cause an error.
         * @return {@code this}
         */
        public Builder existingLambdaObj(software.amazon.awscdk.services.lambda.Function existingLambdaObj) {
            this.existingLambdaObj = existingLambdaObj;
            return this;
        }

        /**
         * Sets the value of {@link ApiIntegration#getExistingLambdaObj}
         * @param existingLambdaObj The Lambda function to associate with the API method in the OpenAPI file matched by id.
         *                          One and only one of existingLambdaObj or lambdaFunctionProps must be specified, any other combination will cause an error.
         * @return {@code this}
         */
        public Builder existingLambdaObj(software.amazon.awscdk.services.lambda.Alias existingLambdaObj) {
            this.existingLambdaObj = existingLambdaObj;
            return this;
        }

        /**
         * Sets the value of {@link ApiIntegration#getLambdaFunctionProps}
         * @param lambdaFunctionProps Properties for the Lambda function to create and associate with the API method in the OpenAPI file matched by id.
         *                            One and only one of existingLambdaObj or lambdaFunctionProps must be specified, any other combination will cause an error.
         * @return {@code this}
         */
        public Builder lambdaFunctionProps(software.amazon.awscdk.services.lambda.FunctionProps lambdaFunctionProps) {
            this.lambdaFunctionProps = lambdaFunctionProps;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApiIntegration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @Override
        public ApiIntegration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApiIntegration}
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiIntegration {
        private final java.lang.String id;
        private final java.lang.Object existingLambdaObj;
        private final software.amazon.awscdk.services.lambda.FunctionProps lambdaFunctionProps;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.existingLambdaObj = software.amazon.jsii.Kernel.get(this, "existingLambdaObj", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.lambdaFunctionProps = software.amazon.jsii.Kernel.get(this, "lambdaFunctionProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FunctionProps.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
            this.existingLambdaObj = builder.existingLambdaObj;
            this.lambdaFunctionProps = builder.lambdaFunctionProps;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final java.lang.Object getExistingLambdaObj() {
            return this.existingLambdaObj;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.FunctionProps getLambdaFunctionProps() {
            return this.lambdaFunctionProps;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("id", om.valueToTree(this.getId()));
            if (this.getExistingLambdaObj() != null) {
                data.set("existingLambdaObj", om.valueToTree(this.getExistingLambdaObj()));
            }
            if (this.getLambdaFunctionProps() != null) {
                data.set("lambdaFunctionProps", om.valueToTree(this.getLambdaFunctionProps()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-solutions-constructs/aws-openapigateway-lambda.ApiIntegration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApiIntegration.Jsii$Proxy that = (ApiIntegration.Jsii$Proxy) o;

            if (!id.equals(that.id)) return false;
            if (this.existingLambdaObj != null ? !this.existingLambdaObj.equals(that.existingLambdaObj) : that.existingLambdaObj != null) return false;
            return this.lambdaFunctionProps != null ? this.lambdaFunctionProps.equals(that.lambdaFunctionProps) : that.lambdaFunctionProps == null;
        }

        @Override
        public final int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + (this.existingLambdaObj != null ? this.existingLambdaObj.hashCode() : 0);
            result = 31 * result + (this.lambdaFunctionProps != null ? this.lambdaFunctionProps.hashCode() : 0);
            return result;
        }
    }
}
