/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awsconstructs.services.s3lambda;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.lambda.Function;
import software.amazon.awscdk.services.lambda.FunctionProps;
import software.amazon.awscdk.services.lambda.eventsources.S3EventSourceProps;
import software.amazon.awscdk.services.s3.Bucket;
import software.amazon.awscdk.services.s3.BucketProps;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awsconstructs.services.s3lambda.$Module;
import software.amazon.awsconstructs.services.s3lambda.S3ToLambdaProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="@aws-solutions-constructs/aws-s3-lambda.S3ToLambda")
public class S3ToLambda
extends Construct {
    protected S3ToLambda(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3ToLambda(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public S3ToLambda(@NotNull Construct scope, @NotNull String id, @NotNull S3ToLambdaProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public Function getLambdaFunction() {
        return (Function)Kernel.get((Object)((Object)this), (String)"lambdaFunction", (NativeType)NativeType.forClass(Function.class));
    }

    @NotNull
    public IBucket getS3BucketInterface() {
        return (IBucket)Kernel.get((Object)((Object)this), (String)"s3BucketInterface", (NativeType)NativeType.forClass(IBucket.class));
    }

    @Nullable
    public Bucket getS3Bucket() {
        return (Bucket)Kernel.get((Object)((Object)this), (String)"s3Bucket", (NativeType)NativeType.forClass(Bucket.class));
    }

    @Nullable
    public Bucket getS3LoggingBucket() {
        return (Bucket)Kernel.get((Object)((Object)this), (String)"s3LoggingBucket", (NativeType)NativeType.forClass(Bucket.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<S3ToLambda> {
        private final Construct scope;
        private final String id;
        private final S3ToLambdaProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new S3ToLambdaProps.Builder();
        }

        public Builder bucketProps(BucketProps bucketProps) {
            this.props.bucketProps(bucketProps);
            return this;
        }

        public Builder existingBucketObj(Bucket existingBucketObj) {
            this.props.existingBucketObj(existingBucketObj);
            return this;
        }

        public Builder existingLambdaObj(Function existingLambdaObj) {
            this.props.existingLambdaObj(existingLambdaObj);
            return this;
        }

        public Builder lambdaFunctionProps(FunctionProps lambdaFunctionProps) {
            this.props.lambdaFunctionProps(lambdaFunctionProps);
            return this;
        }

        public Builder loggingBucketProps(BucketProps loggingBucketProps) {
            this.props.loggingBucketProps(loggingBucketProps);
            return this;
        }

        public Builder logS3AccessLogs(Boolean logS3AccessLogs) {
            this.props.logS3AccessLogs(logS3AccessLogs);
            return this;
        }

        public Builder s3EventSourceProps(S3EventSourceProps s3EventSourceProps) {
            this.props.s3EventSourceProps(s3EventSourceProps);
            return this;
        }

        public S3ToLambda build() {
            return new S3ToLambda(this.scope, this.id, this.props.build());
        }
    }
}

