/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.jvmagent;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.codeguruprofilerjavaagent.ProfilerWithPause;
import software.amazon.codeguruprofilerjavaagent.jvmagent.JvmArgumentParser;

public class LambdaJvmArgumentParser {
    private static final Logger LOG = Logger.getLogger(LambdaJvmArgumentParser.class.getName());
    private final String commandLineArguments;
    private final JvmArgumentParser jvmArgumentParser;

    LambdaJvmArgumentParser(String commandLineArguments, JvmArgumentParser jvmArgumentParser) {
        this.commandLineArguments = commandLineArguments;
        this.jvmArgumentParser = jvmArgumentParser;
    }

    public LambdaJvmArgumentParser(String commandLineArguments) {
        this.commandLineArguments = commandLineArguments;
        this.jvmArgumentParser = new JvmArgumentParser(commandLineArguments);
    }

    void configureProfilerBuilder(ProfilerWithPause.Builder builder) {
        Map<String, String> arguments = this.jvmArgumentParser.parseArguments(this.commandLineArguments);
        LOG.log(Level.INFO, "Configuring CodeGuru Lambda Profiler using the following arguments: " + arguments.toString());
        builder.integrationModeStandalone();
        this.jvmArgumentParser.getProfilingGroupName(arguments).ifPresent(builder::profilingGroupName);
        this.jvmArgumentParser.getRegion(arguments).ifPresent(builder::awsRegionToReportTo);
    }
}

