/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile.metadata;

import com.amazon.ion.IonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Optional;
import software.amazon.codeguruprofilerjavaagent.profile.IonUtils;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.ErrorsMetadata;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.FargateMetadataFetcher;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.FleetInfo;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.FleetInstanceType;

public class AWSFargateTask
implements FleetInfo {
    private final String taskArn;
    private final double cpuLimit;
    private final long memoryLimitInMB;

    public AWSFargateTask(String taskArn, double cpuLimit, long memoryLimitInMB) {
        this.taskArn = taskArn;
        this.cpuLimit = cpuLimit;
        this.memoryLimitInMB = memoryLimitInMB;
    }

    @Override
    public void write(IonWriter out) throws IOException {
        IonUtils.writeStruct(out, () -> {
            IonUtils.writeString(out, "computeType", "aws_fargate_task");
            IonUtils.writeString(out, "taskArn", this.taskArn);
            IonUtils.writeDecimal(out, "cpuLimit", BigDecimal.valueOf(this.cpuLimit));
            IonUtils.writeInt(out, "memoryLimitInMB", this.memoryLimitInMB);
        });
    }

    @Override
    public String getFleetInstanceId() {
        return this.taskArn;
    }

    @Override
    public FleetInstanceType getFleetInstanceType() {
        return FleetInstanceType.AWSFargateTask;
    }

    public String getTaskArn() {
        return this.taskArn;
    }

    public double getCpuLimit() {
        return this.cpuLimit;
    }

    public long getMemoryLimitInMB() {
        return this.memoryLimitInMB;
    }

    public static Optional<FleetInfo> lookUpMetadata(ErrorsMetadata errorsMetadata) {
        return Optional.ofNullable(new FargateMetadataFetcher(errorsMetadata).getMetadata());
    }

    public String toString() {
        return "AWSFargateTask{taskArn=" + this.taskArn + ", cpuLimit=" + this.cpuLimit + ", memoryLimitInMB=" + this.memoryLimitInMB + '}';
    }
}

