/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile.metadata;

import com.amazonaws.services.lambda.runtime.Context;
import software.amazon.codeguruprofilerjavaagent.EnvironmentReader;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.AWSEC2Instance;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.AWSFargateTask;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.AWSLambda;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.AgentMetadata;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.ErrorsMetadata;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.FleetInfo;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.FleetInstance;

public class AgentMetadataProvider {
    public static AgentMetadata buildAgentMetadata(boolean enableFleetInfoLookup, ErrorsMetadata errorsMetadata, String integrationMode) {
        if (enableFleetInfoLookup) {
            return new AgentMetadata(AgentMetadataProvider.lookUpFleetInfo(errorsMetadata), errorsMetadata, integrationMode);
        }
        return new AgentMetadata(errorsMetadata, integrationMode);
    }

    public static AgentMetadata buildLambdaAgentMetadata(Context context, EnvironmentReader environmentReader, ErrorsMetadata errorsMetadata, String integrationMode) {
        FleetInfo fleetInfo = AWSLambda.lookUpMetadata(context, environmentReader).orElseGet(() -> FleetInstance.buildDefault());
        return new AgentMetadata(fleetInfo, errorsMetadata, integrationMode);
    }

    private static FleetInfo lookUpFleetInfo(ErrorsMetadata errorsMetadata) {
        return AWSEC2Instance.lookUpMetadata(errorsMetadata).orElseGet(() -> AWSFargateTask.lookUpMetadata(errorsMetadata).orElseGet(() -> FleetInstance.buildDefault()));
    }
}

