/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import software.amazon.codeguruprofilerjavaagent.GarbageCollectorMonitor;

public class ProfilingCommandUtils {
    private static final Random RANDOM = new Random();

    private ProfilingCommandUtils() {
    }

    static int convertGCTimeToSamples(GarbageCollectorMonitor.GCTimeSpent gcTimeSpent, long numberOfTimesSampled, double threadWeight) {
        double gcSamples = (float)gcTimeSpent.getNumGCThreads() * gcTimeSpent.getFractionOfTime() * (float)numberOfTimesSampled;
        double numSamplesToReport = gcSamples / threadWeight;
        return ProfilingCommandUtils.handleFraction(numSamplesToReport);
    }

    static int convertProfilingTimeToSamples(long profilingTimeNanos, long sampleWeight, long samplingIntervalMillis, double threadWeight) {
        double weightedNanos = (double)profilingTimeNanos / (double)sampleWeight;
        double profilerSamples = weightedNanos / (double)TimeUnit.MILLISECONDS.toNanos(samplingIntervalMillis);
        double numSamplesToReport = profilerSamples / threadWeight;
        return ProfilingCommandUtils.handleFraction(numSamplesToReport);
    }

    private static int handleFraction(double numSamplesToReport) {
        int truncated = (int)numSamplesToReport;
        double fraction = numSamplesToReport - (double)truncated;
        if (RANDOM.nextDouble() < fraction) {
            ++truncated;
        }
        return truncated;
    }
}

