/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.flightrecorder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.jfr.FlightRecorder;
import jdk.jfr.consumer.RecordedEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.EventProcessor;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.RecordingHandler;
import software.amazon.codeguruprofilerjavaagent.profile.ProfileBuilder;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\r\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u000bJ\u0006\u0010\u0013\u001a\u00020\u000bJ\u0006\u0010\u0014\u001a\u00020\u000bJ\u0006\u0010\u0015\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/MemoryProfiler;", "", "enabled", "", "eventProcessors", "", "Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/EventProcessor;", "recordingHandler", "Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/RecordingHandler;", "(ZLjava/util/List;Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/RecordingHandler;)V", "flush", "", "profileBuilder", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileBuilder;", "getLatestFlightRecordingFileSizeBytes", "", "()Ljava/lang/Long;", "isRecording", "notImplementedPause", "notImplementedResume", "startRecording", "stopRecording", "Companion", "SkySailJavaAgent"})
public final class MemoryProfiler {
    private final boolean enabled;
    private final List<EventProcessor> eventProcessors;
    private final RecordingHandler recordingHandler;
    @NotNull
    private static final Logger logger;
    @Deprecated
    public static final Companion Companion;

    public final void startRecording() {
        block0: {
            RecordingHandler recordingHandler = this.recordingHandler;
            if (recordingHandler == null) break block0;
            recordingHandler.startRecording();
        }
    }

    public final void stopRecording() {
        block0: {
            RecordingHandler recordingHandler = this.recordingHandler;
            if (recordingHandler == null) break block0;
            recordingHandler.stopRecording(true);
        }
    }

    public final void notImplementedPause() {
    }

    public final void notImplementedResume() {
    }

    @Nullable
    public final Long getLatestFlightRecordingFileSizeBytes() {
        RecordingHandler recordingHandler = this.recordingHandler;
        return recordingHandler != null ? recordingHandler.getLatestRecordingFileSizeBytes() : null;
    }

    public final boolean isRecording() {
        RecordingHandler recordingHandler = this.recordingHandler;
        return recordingHandler != null ? recordingHandler.isRecording() : false;
    }

    public final void flush(@NotNull ProfileBuilder profileBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)profileBuilder, (String)"profileBuilder");
        if (this.recordingHandler == null) {
            return;
        }
        this.recordingHandler.stopRecording(false);
        List<RecordedEvent> recordedEvents = this.recordingHandler.processRecordedEvents();
        Iterable $this$forEach$iv = this.eventProcessors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventProcessor it = (EventProcessor)element$iv;
            boolean bl = false;
            it.process(profileBuilder, recordedEvents);
        }
    }

    @JvmOverloads
    public MemoryProfiler(boolean enabled, @NotNull List<? extends EventProcessor> eventProcessors, @Nullable RecordingHandler recordingHandler) {
        Intrinsics.checkParameterIsNotNull(eventProcessors, (String)"eventProcessors");
        this.enabled = enabled;
        this.eventProcessors = eventProcessors;
        this.recordingHandler = recordingHandler;
    }

    public /* synthetic */ MemoryProfiler(boolean bl, List list, RecordingHandler recordingHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            recordingHandler = Companion.createRecordingHandler(bl, list);
        }
        this(bl, list, recordingHandler);
    }

    @JvmOverloads
    public MemoryProfiler(boolean enabled, @NotNull List<? extends EventProcessor> eventProcessors) {
        this(enabled, eventProcessors, null, 4, null);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getLogger("javaClass");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getLogger(MemoryProfiler::javaClass.name)");
        MemoryProfiler.logger = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u001e\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0006\u0010\u000f\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/MemoryProfiler$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "canProfileMemory", "", "enabled", "createRecordingHandler", "Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/RecordingHandler;", "eventProcessors", "", "Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/EventProcessor;", "isFlightRecorderAvailable", "SkySailJavaAgent"})
    private static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final RecordingHandler createRecordingHandler(boolean enabled, @NotNull List<? extends EventProcessor> eventProcessors) {
            Intrinsics.checkParameterIsNotNull(eventProcessors, (String)"eventProcessors");
            if (!this.canProfileMemory(enabled) || eventProcessors.isEmpty()) {
                return null;
            }
            try {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Iterable iterable = eventProcessors;
                Function0 function0 = null;
                Function2 function2 = null;
                boolean $i$f$flatMap = false;
                void var5_8 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    EventProcessor it = (EventProcessor)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.getSupportedEvents();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List list = (List)destination$iv$iv;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 3;
                List list2 = list;
                Function0 function02 = function0;
                Function2 function22 = function2;
                return new RecordingHandler(function22, function02, list2, n, defaultConstructorMarker);
            }
            catch (IOException e) {
                this.getLogger().log(Level.FINE, "An instance of RecordingHandler could not be created!", e);
                return null;
            }
        }

        private final boolean canProfileMemory(boolean enabled) {
            String string;
            boolean available = this.isFlightRecorderAvailable();
            if (enabled && available) {
                string = "Memory profiling has been enabled!";
            } else if (enabled && !available) {
                CharSequence charSequence = "\n                    Disabling memory profiling...\n                    Memory profiling had been enabled, but this JVM doesn't have flight recording capabilities!\n                    JDK Flight Recorder is not available in all JDK releases. Known supported JDK versions are: \n                    OpenJDK 8u265+, any version of OpenJDK 11+.\n                    ";
                Regex regex = new Regex("\n\\s*");
                String string2 = "";
                boolean bl = false;
                string = regex.replace(charSequence, string2);
            } else {
                string = "Memory profiling is disabled!";
            }
            String message = string;
            this.getLogger().log(Level.INFO, message);
            return enabled && available;
        }

        public final boolean isFlightRecorderAvailable() {
            boolean bl;
            try {
                Class.forName("jdk.jfr.FlightRecorder");
                bl = true;
            }
            catch (ClassNotFoundException e) {
                bl = false;
            }
            boolean flightRecorderExists = bl;
            return flightRecorderExists && FlightRecorder.isAvailable();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

